/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl.driver;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;

class DriverLogging {
    private static final boolean isEnabled;
    private static final DateTimeFormatter timestampFormat;

    DriverLogging() {
    }

    static void logWithTimestamp(String message) {
        if (!isEnabled) {
            return;
        }
        String timestamp = ZonedDateTime.now().format(timestampFormat);
        System.err.println(timestamp + " " + message);
    }

    static {
        String debug = System.getenv("DEBUG");
        isEnabled = debug != null && debug.contains("pw:install");
        timestampFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ss.SSSXXX").withZone(ZoneId.of("UTC"));
    }
}

