/*
 * Decompiled with CFR 0.152.
 */
package com.mks.api.commands.ide;

import com.mks.api.CmdRunnerCreator;
import com.mks.api.commands.SICommands;
import com.mks.api.commands.ide.SandboxInfo;
import com.mks.api.commands.ide.WorkingDirectory;
import com.mks.api.commands.ide.WorkingFileCache;
import com.mks.api.commands.ide.WorkingFileFactory;
import com.mks.api.response.APIException;
import com.mks.api.response.WorkItem;
import com.mks.api.response.WorkItemIterator;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;

public final class WorkingDirectoryFactory {
    private WorkingDirectoryFactory() {
    }

    public static WorkingDirectory getWorkingDirectory(CmdRunnerCreator session, File directory) throws APIException {
        SICommands si = new SICommands(session, false);
        String directoryPath = directory.getAbsolutePath();
        WorkingDirectory workingDirectory = new WorkingDirectory(directory);
        try {
            SandboxInfo info = SandboxInfo.getSandboxInfo(si, directory);
            if (info != null) {
                workingDirectory.addSandbox(info);
                WorkingFileCache.getInstance().monitorSandbox(si.getCmdRunnerCreator(), info.getSandboxName());
            }
            return workingDirectory;
        }
        catch (APIException ex) {
            String sandboxName;
            if (!"common.AmbiguousParentSandbox".equals(ex.getExceptionId())) {
                throw ex;
            }
            HashSet<String> closestSandboxes = null;
            File closestSandboxDir = null;
            String directoryTestPath = directoryPath;
            if (WorkingDirectoryFactory.isWin32()) {
                directoryTestPath = directoryTestPath.toLowerCase();
            }
            WorkItemIterator wii = si.getSandboxes(true).getWorkItems();
            while (wii.hasNext()) {
                int closestSandboxPathLength;
                WorkItem wi = wii.next();
                sandboxName = wi.getField("sandboxName").getValueAsString();
                File sandboxLocation = new File(sandboxName).getParentFile();
                String testPath = sandboxLocation.getAbsolutePath();
                if (WorkingDirectoryFactory.isWin32()) {
                    testPath = testPath.toLowerCase();
                }
                int n = closestSandboxPathLength = closestSandboxDir != null ? closestSandboxDir.getPath().length() : 0;
                if (testPath.length() > closestSandboxPathLength && directoryTestPath.startsWith(testPath)) {
                    closestSandboxDir = sandboxLocation;
                    closestSandboxes = new HashSet<String>();
                }
                if (!sandboxLocation.equals(closestSandboxDir)) continue;
                closestSandboxes.add(sandboxName);
            }
            if (closestSandboxes != null) {
                Iterator it = closestSandboxes.iterator();
                while (it.hasNext()) {
                    sandboxName = (String)it.next();
                    SandboxInfo info = SandboxInfo.getSandboxInfo(si, new File(sandboxName));
                    if (info == null) continue;
                    workingDirectory.addSandbox(info);
                }
            }
            WorkingFileCache.getInstance().monitorDirectory(si.getCmdRunnerCreator(), workingDirectory);
            return workingDirectory;
        }
    }

    static boolean isWin32() {
        return WorkingFileFactory.isWin32();
    }

    public static void refresh(File directory) {
        WorkingDirectoryFactory.refresh(directory, WorkingFileFactory.getNewOrdinal());
    }

    public static void refresh(File directory, long ordinal) {
        WorkingFileCache.getInstance().invalidate(directory, ordinal);
    }
}

