/*
 * Decompiled with CFR 0.152.
 */
package com.mks.connect;

import com.mks.api.IntegrationPoint;
import com.mks.api.IntegrationPointFactory;
import com.mks.api.Session;
import com.mks.api.VersionNumber;
import com.mks.api.response.APIException;
import com.mks.api.util.APIVersion;
import com.mks.connect.UserApplicationSessionImpl;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class IntegrationPointImpl
implements IntegrationPoint {
    private VersionNumber apiVersion;
    private String host;
    private int port;
    private boolean isClientIP;
    private Set sessions;
    private boolean secure;
    private boolean autoStartIC;
    private IntegrationPointFactory ipf;

    public IntegrationPointImpl(IntegrationPointFactory ipf, String hostname, int port, boolean secure, VersionNumber apiVersion) {
        this.ipf = ipf;
        this.host = hostname;
        this.port = port;
        this.secure = secure;
        this.sessions = new HashSet();
        this.isClientIP = port == 0;
        this.apiVersion = apiVersion;
    }

    public VersionNumber getAPIRequestVersion() {
        return this.apiVersion;
    }

    public String getHostname() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    void setPort(int port) {
        this.port = port;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public Session createSession() throws APIException {
        return this.createSession(null, null);
    }

    public Session createSession(String username, String password) throws APIException {
        return this.createSession(this.getAPIRequestVersion(), false, username, password);
    }

    public Session createSession(String username, String password, int apiMajorVersion, int apiMinorVersion) throws APIException {
        return this.createSession(new APIVersion(apiMajorVersion, apiMinorVersion), false, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Session createSession(VersionNumber apiRequestVersion, boolean anonymous, String username, String password) throws APIException {
        UserApplicationSessionImpl uas = new UserApplicationSessionImpl(this, apiRequestVersion, username, password, anonymous);
        Set set = this.sessions;
        synchronized (set) {
            this.sessions.add(uas);
        }
        return uas;
    }

    public Session getCommonSession() throws APIException {
        return this.getCommonSession(null, null);
    }

    public Session getCommonSession(String username, String password) throws APIException {
        return this.createSession(this.getAPIRequestVersion(), true, username, password);
    }

    public Iterator getSessions() {
        return Collections.unmodifiableSet(new HashSet(this.sessions)).iterator();
    }

    public boolean getAutoStartIntegrityClient() {
        return this.autoStartIC;
    }

    public void setAutoStartIntegrityClient(boolean autoStartIC) {
        this.autoStartIC = autoStartIC;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Set set = this.sessions;
        synchronized (set) {
            Iterator it = this.sessions.iterator();
            while (it.hasNext()) {
                UserApplicationSessionImpl uasi = (UserApplicationSessionImpl)it.next();
                try {
                    uasi.release(true, false);
                }
                catch (IOException ex) {
                    IntegrationPointFactory.getLogger().exception(this, "API", 0, (Throwable)ex);
                }
                catch (APIException ex) {
                    IntegrationPointFactory.getLogger().exception(this, "API", 0, (Throwable)ex);
                }
            }
            this.sessions.removeAll(this.sessions);
        }
        this.ipf.removeIntegrationPoint(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeSession(Session s) {
        Set set = this.sessions;
        synchronized (set) {
            this.sessions.remove(s);
        }
    }

    public boolean isClientIntegrationPoint() {
        return this.isClientIP;
    }
}

