/*
 * Decompiled with CFR 0.152.
 */
package com.mockrunner.servlet;

import com.mockrunner.base.HTMLOutputModule;
import com.mockrunner.base.NestedApplicationException;
import com.mockrunner.mock.web.WebMockObjectFactory;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServlet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServletTestModule
extends HTMLOutputModule {
    private WebMockObjectFactory mockFactory;
    private HttpServlet servlet;
    private boolean doChain;

    public ServletTestModule(WebMockObjectFactory mockFactory) {
        super(mockFactory);
        this.mockFactory = mockFactory;
        this.doChain = false;
    }

    public <T extends HttpServlet> T createServlet(Class<T> servletClass) {
        if (!HttpServlet.class.isAssignableFrom(servletClass)) {
            throw new RuntimeException("servletClass must be an instance of javax.servlet.http.HttpServlet");
        }
        try {
            HttpServlet theServlet = (HttpServlet)servletClass.newInstance();
            this.setServlet(theServlet, true);
            return (T)theServlet;
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void setServlet(HttpServlet servlet) {
        this.setServlet(servlet, false);
    }

    public void setServlet(HttpServlet servlet, boolean doInit) {
        try {
            this.servlet = servlet;
            if (doInit) {
                servlet.init((ServletConfig)this.mockFactory.getMockServletConfig());
            }
            this.mockFactory.getMockFilterChain().setServlet((Servlet)servlet);
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public HttpServlet getServlet() {
        return this.servlet;
    }

    public <T extends Filter> T createFilter(Class<T> filterClass) {
        if (!Filter.class.isAssignableFrom(filterClass)) {
            throw new RuntimeException("filterClass must be an instance of javax.servlet.Filter");
        }
        try {
            Filter theFilter = (Filter)filterClass.newInstance();
            this.addFilter(theFilter, true);
            return (T)theFilter;
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void addFilter(Filter filter) {
        this.addFilter(filter, false);
    }

    public void addFilter(Filter filter, boolean doInit) {
        if (doInit) {
            try {
                filter.init((FilterConfig)this.mockFactory.getMockFilterConfig());
            }
            catch (Exception exc) {
                throw new NestedApplicationException((Throwable)exc);
            }
        }
        this.mockFactory.getMockFilterChain().addFilter(filter);
    }

    public void releaseFilters() {
        this.mockFactory.getMockFilterChain().release();
        this.mockFactory.getMockFilterChain().setServlet((Servlet)this.servlet);
    }

    public void setDoChain(boolean doChain) {
        this.doChain = doChain;
    }

    public void doFilter() {
        try {
            this.mockFactory.getMockFilterChain().doFilter((ServletRequest)this.mockFactory.getWrappedRequest(), (ServletResponse)this.mockFactory.getWrappedResponse());
            this.mockFactory.getMockFilterChain().reset();
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void init() {
        try {
            this.servlet.init((ServletConfig)this.mockFactory.getMockServletConfig());
        }
        catch (ServletException exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }

    public void doDelete() {
        this.mockFactory.getMockRequest().setMethod("DELETE");
        this.callService();
    }

    public void doGet() {
        this.mockFactory.getMockRequest().setMethod("GET");
        this.callService();
    }

    public void doOptions() {
        this.mockFactory.getMockRequest().setMethod("OPTIONS");
        this.callService();
    }

    public void doPost() {
        this.mockFactory.getMockRequest().setMethod("POST");
        this.callService();
    }

    public void doPut() {
        this.mockFactory.getMockRequest().setMethod("PUT");
        this.callService();
    }

    public void doTrace() {
        this.mockFactory.getMockRequest().setMethod("TRACE");
        this.callService();
    }

    public void doHead() {
        this.mockFactory.getMockRequest().setMethod("HEAD");
        this.callService();
    }

    public void service() {
        this.callService();
    }

    public ServletRequest getFilteredRequest() {
        return this.mockFactory.getMockFilterChain().getLastRequest();
    }

    public ServletResponse getFilteredResponse() {
        return this.mockFactory.getMockFilterChain().getLastResponse();
    }

    @Override
    public String getOutput() {
        try {
            this.mockFactory.getMockResponse().getWriter().flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this.mockFactory.getMockResponse().getOutputStreamContent();
    }

    public void clearOutput() {
        this.mockFactory.getMockResponse().resetBuffer();
    }

    private void callService() {
        try {
            if (this.doChain) {
                this.doFilter();
            } else {
                this.servlet.service((ServletRequest)this.mockFactory.getWrappedRequest(), (ServletResponse)this.mockFactory.getWrappedResponse());
            }
        }
        catch (Exception exc) {
            throw new NestedApplicationException((Throwable)exc);
        }
    }
}

