/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.apt;

import com.mysema.commons.lang.Assert;
import com.mysema.query.annotations.Config;
import com.mysema.query.annotations.QueryProjection;
import com.mysema.query.annotations.QueryType;
import com.mysema.query.apt.Configuration;
import com.mysema.query.apt.VisitorConfig;
import com.mysema.query.codegen.EmbeddableSerializer;
import com.mysema.query.codegen.EntitySerializer;
import com.mysema.query.codegen.EntityType;
import com.mysema.query.codegen.ProjectionSerializer;
import com.mysema.query.codegen.Serializer;
import com.mysema.query.codegen.SerializerConfig;
import com.mysema.query.codegen.SimpleSerializerConfig;
import com.mysema.query.codegen.SupertypeSerializer;
import com.mysema.query.codegen.TypeMappings;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;

public class DefaultConfiguration
implements Configuration {
    private static final String QUERYDSL_CREATE_DEFAULT_VARIABLE = "querydsl.createDefaultVariable";
    private static final String QUERYDSL_MAP_ACCESSORS = "querydsl.mapAccessors";
    private static final String QUERYDSL_LIST_ACCESSORS = "querydsl.listAccessors";
    private static final String QUERYDSL_ENTITY_ACCESSORS = "querydsl.entityAccessors";
    private static final String DEFAULT_OVERWRITE = "defaultOverwrite";
    private final Collection<String> keywords;
    private final TypeMappings typeMappings = new TypeMappings();
    private final SerializerConfig defaultSerializerConfig;
    private final Serializer dtoSerializer;
    private final Serializer embeddableSerializer;
    private final Serializer entitySerializer;
    private final Serializer supertypeSerializer;
    private String namePrefix = "Q";
    private String nameSuffix = "";
    private final Map<String, SerializerConfig> packageToConfig = new HashMap<String, SerializerConfig>();
    protected final Class<? extends Annotation> entityAnn;
    @Nullable
    protected final Class<? extends Annotation> entitiesAnn;
    @Nullable
    protected final Class<? extends Annotation> superTypeAnn;
    @Nullable
    protected final Class<? extends Annotation> embeddedAnn;
    @Nullable
    protected final Class<? extends Annotation> embeddableAnn;
    @Nullable
    protected final Class<? extends Annotation> skipAnn;
    private final Map<String, SerializerConfig> typeToConfig = new HashMap<String, SerializerConfig>();
    private boolean useFields = true;
    private boolean useGetters = true;
    private boolean defaultOverwrite = false;

    public DefaultConfiguration(RoundEnvironment roundEnv, Map<String, String> options, Collection<String> keywords, @Nullable Class<? extends Annotation> entitiesAnn, Class<? extends Annotation> entityAnn, @Nullable Class<? extends Annotation> superTypeAnn, @Nullable Class<? extends Annotation> embeddableAnn, @Nullable Class<? extends Annotation> embeddedAnn, @Nullable Class<? extends Annotation> skipAnn) {
        boolean bl;
        this.keywords = keywords;
        this.dtoSerializer = new ProjectionSerializer(this.typeMappings);
        this.embeddableSerializer = new EmbeddableSerializer(this.typeMappings, keywords);
        this.entitySerializer = new EntitySerializer(this.typeMappings, keywords);
        this.supertypeSerializer = new SupertypeSerializer(this.typeMappings, keywords);
        this.entitiesAnn = entitiesAnn;
        this.entityAnn = (Class)Assert.notNull(entityAnn, (String)"entityAnn");
        this.superTypeAnn = superTypeAnn;
        this.embeddableAnn = embeddableAnn;
        this.embeddedAnn = embeddedAnn;
        this.skipAnn = skipAnn;
        for (Element element : roundEnv.getElementsAnnotatedWith(Config.class)) {
            Config querydslConfig = element.getAnnotation(Config.class);
            SerializerConfig config = SimpleSerializerConfig.getConfig((Config)querydslConfig);
            if (element instanceof PackageElement) {
                PackageElement packageElement = (PackageElement)element;
                this.packageToConfig.put(packageElement.getQualifiedName().toString(), config);
                continue;
            }
            if (!(element instanceof TypeElement)) continue;
            TypeElement typeElement = (TypeElement)element;
            this.typeToConfig.put(typeElement.getQualifiedName().toString(), config);
        }
        boolean entityAccessors = false;
        boolean bl2 = false;
        boolean mapAccessors = false;
        boolean createDefaultVariable = true;
        if (options.containsKey(QUERYDSL_ENTITY_ACCESSORS)) {
            entityAccessors = Boolean.valueOf(options.get(QUERYDSL_ENTITY_ACCESSORS));
        }
        if (options.containsKey(QUERYDSL_LIST_ACCESSORS)) {
            bl = Boolean.valueOf(options.get(QUERYDSL_LIST_ACCESSORS));
        }
        if (options.containsKey(QUERYDSL_MAP_ACCESSORS)) {
            mapAccessors = Boolean.valueOf(options.get(QUERYDSL_MAP_ACCESSORS));
        }
        if (options.containsKey(QUERYDSL_CREATE_DEFAULT_VARIABLE)) {
            createDefaultVariable = Boolean.valueOf(options.get(QUERYDSL_CREATE_DEFAULT_VARIABLE));
        }
        if (options.containsKey(DEFAULT_OVERWRITE)) {
            this.defaultOverwrite = Boolean.valueOf(options.get(DEFAULT_OVERWRITE));
        }
        this.defaultSerializerConfig = new SimpleSerializerConfig(entityAccessors, bl, mapAccessors, createDefaultVariable);
    }

    @Override
    public VisitorConfig getConfig(TypeElement e, List<? extends Element> elements) {
        if (this.useFields) {
            if (this.useGetters) {
                return VisitorConfig.ALL;
            }
            return VisitorConfig.FIELDS_ONLY;
        }
        if (this.useGetters) {
            return VisitorConfig.METHODS_ONLY;
        }
        return VisitorConfig.NONE;
    }

    @Override
    public Serializer getDTOSerializer() {
        return this.dtoSerializer;
    }

    @Override
    @Nullable
    public Class<? extends Annotation> getEntitiesAnnotation() {
        return this.entitiesAnn;
    }

    @Override
    @Nullable
    public Class<? extends Annotation> getEmbeddableAnnotation() {
        return this.embeddableAnn;
    }

    @Override
    public Serializer getEmbeddableSerializer() {
        return this.embeddableSerializer;
    }

    @Override
    public Class<? extends Annotation> getEntityAnnotation() {
        return this.entityAnn;
    }

    @Override
    @Nullable
    public Class<? extends Annotation> getEmbeddedAnnotation() {
        return this.embeddedAnn;
    }

    @Override
    public Serializer getEntitySerializer() {
        return this.entitySerializer;
    }

    @Override
    public String getNamePrefix() {
        return this.namePrefix;
    }

    @Override
    public SerializerConfig getSerializerConfig(EntityType entityType) {
        if (this.typeToConfig.containsKey(entityType.getFullName())) {
            return this.typeToConfig.get(entityType.getFullName());
        }
        if (this.packageToConfig.containsKey(entityType.getPackageName())) {
            return this.packageToConfig.get(entityType.getPackageName());
        }
        return this.defaultSerializerConfig;
    }

    @Override
    @Nullable
    public Class<? extends Annotation> getSkipAnnotation() {
        return this.skipAnn;
    }

    @Override
    @Nullable
    public Class<? extends Annotation> getSuperTypeAnnotation() {
        return this.superTypeAnn;
    }

    @Override
    public Serializer getSupertypeSerializer() {
        return this.supertypeSerializer;
    }

    @Override
    public boolean isBlockedField(VariableElement field) {
        if (field.getAnnotation(QueryType.class) != null) {
            return false;
        }
        return field.getAnnotation(this.skipAnn) != null || field.getModifiers().contains((Object)Modifier.TRANSIENT) || field.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isBlockedGetter(ExecutableElement getter) {
        if (getter.getAnnotation(QueryType.class) != null) {
            return false;
        }
        return getter.getAnnotation(this.skipAnn) != null || getter.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isDefaultOverwrite() {
        return this.defaultOverwrite;
    }

    @Override
    public boolean isUseFields() {
        return this.useFields;
    }

    @Override
    public boolean isUseGetters() {
        return this.useGetters;
    }

    @Override
    public boolean isValidConstructor(ExecutableElement constructor) {
        return constructor.getModifiers().contains((Object)Modifier.PUBLIC) && constructor.getAnnotation(QueryProjection.class) != null && !constructor.getParameters().isEmpty();
    }

    @Override
    public boolean isValidField(VariableElement field) {
        if (field.getAnnotation(QueryType.class) != null) {
            return true;
        }
        return field.getAnnotation(this.skipAnn) == null && !field.getModifiers().contains((Object)Modifier.TRANSIENT) && !field.getModifiers().contains((Object)Modifier.STATIC);
    }

    @Override
    public boolean isValidGetter(ExecutableElement getter) {
        if (getter.getAnnotation(QueryType.class) != null) {
            return true;
        }
        return getter.getAnnotation(this.skipAnn) == null && !getter.getModifiers().contains((Object)Modifier.STATIC);
    }

    public void setNamePrefix(String namePrefix) {
        this.namePrefix = namePrefix;
    }

    public void setUseFields(boolean b) {
        this.useFields = b;
    }

    public void setUseGetters(boolean b) {
        this.useGetters = b;
    }

    @Override
    public TypeMappings getTypeMappings() {
        return this.typeMappings;
    }

    @Override
    public Collection<String> getKeywords() {
        return this.keywords;
    }

    @Override
    public String getNameSuffix() {
        return this.nameSuffix;
    }

    public void setNameSuffix(String nameSuffix) {
        this.nameSuffix = nameSuffix;
    }
}

