/*
 * Decompiled with CFR 0.152.
 */
package com.mysema.query.mongodb.morphia;

import com.google.code.morphia.Datastore;
import com.google.code.morphia.Morphia;
import com.google.code.morphia.mapping.cache.DefaultEntityCache;
import com.google.code.morphia.mapping.cache.EntityCache;
import com.google.common.base.Function;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mysema.query.mongodb.MongodbQuery;
import com.mysema.query.mongodb.morphia.MorphiaSerializer;
import com.mysema.query.types.EntityPath;

public class MorphiaQuery<K>
extends MongodbQuery<K> {
    private final EntityCache cache;
    private final Datastore datastore;

    public MorphiaQuery(Morphia morphia, Datastore datastore, EntityPath<K> entityPath) {
        this(morphia, datastore, (EntityCache)new DefaultEntityCache(), entityPath);
    }

    public MorphiaQuery(final Morphia morphia, Datastore datastore, final EntityCache cache, final EntityPath<K> entityPath) {
        super(datastore.getCollection(entityPath.getType()), new Function<DBObject, K>(){

            public K apply(DBObject dbObject) {
                return morphia.fromDBObject(entityPath.getType(), dbObject, cache);
            }
        }, MorphiaSerializer.DEFAULT);
        this.datastore = datastore;
        this.cache = cache;
    }

    @Override
    protected DBCursor createCursor() {
        this.cache.flush();
        return super.createCursor();
    }

    @Override
    protected DBCollection getCollection(Class<?> type) {
        return this.datastore.getCollection(type);
    }
}

