/*
 * Decompiled with CFR 0.152.
 */
package com.nononsenseapps.filepicker;

import android.annotation.TargetApi;
import android.content.ClipData;
import android.content.Intent;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentManager;
import android.support.v7.app.AppCompatActivity;
import com.nononsenseapps.filepicker.AbstractFilePickerFragment;
import com.nononsenseapps.filepicker.R;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractFilePickerActivity<T>
extends AppCompatActivity
implements AbstractFilePickerFragment.OnFilePickedListener {
    public static final String EXTRA_START_PATH = "nononsense.intent.START_PATH";
    public static final String EXTRA_MODE = "nononsense.intent.MODE";
    public static final String EXTRA_ALLOW_CREATE_DIR = "nononsense.intent.ALLOW_CREATE_DIR";
    public static final String EXTRA_SINGLE_CLICK = "nononsense.intent.SINGLE_CLICK";
    public static final String EXTRA_ALLOW_MULTIPLE = "android.intent.extra.ALLOW_MULTIPLE";
    public static final String EXTRA_ALLOW_EXISTING_FILE = "android.intent.extra.ALLOW_EXISTING_FILE";
    public static final String EXTRA_PATHS = "nononsense.intent.PATHS";
    public static final int MODE_FILE = 0;
    public static final int MODE_FILE_AND_DIR = 2;
    public static final int MODE_NEW_FILE = 3;
    public static final int MODE_DIR = 1;
    protected static final String TAG = "filepicker_fragment";
    protected String startPath = null;
    protected int mode = 0;
    protected boolean allowCreateDir = false;
    protected boolean allowMultiple = false;
    private boolean allowExistingFile = true;
    protected boolean singleClick = false;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.nnf_activity_filepicker);
        Intent intent = this.getIntent();
        if (intent != null) {
            this.startPath = intent.getStringExtra(EXTRA_START_PATH);
            this.mode = intent.getIntExtra(EXTRA_MODE, this.mode);
            this.allowCreateDir = intent.getBooleanExtra(EXTRA_ALLOW_CREATE_DIR, this.allowCreateDir);
            this.allowMultiple = intent.getBooleanExtra(EXTRA_ALLOW_MULTIPLE, this.allowMultiple);
            this.allowExistingFile = intent.getBooleanExtra(EXTRA_ALLOW_EXISTING_FILE, this.allowExistingFile);
            this.singleClick = intent.getBooleanExtra(EXTRA_SINGLE_CLICK, this.singleClick);
        }
        this.setResult(0);
    }

    protected void onResume() {
        super.onResume();
        FragmentManager fm = this.getSupportFragmentManager();
        AbstractFilePickerFragment<T> fragment = fm.findFragmentByTag(TAG);
        if (fragment == null) {
            fragment = this.getFragment(this.startPath, this.mode, this.allowMultiple, this.allowCreateDir, this.allowExistingFile, this.singleClick);
        }
        if (fragment != null) {
            fm.beginTransaction().replace(R.id.fragment, (Fragment)fragment, TAG).commit();
        }
    }

    protected abstract AbstractFilePickerFragment<T> getFragment(@Nullable String var1, int var2, boolean var3, boolean var4, boolean var5, boolean var6);

    public void onSaveInstanceState(Bundle b) {
        b.putString("WORKAROUND_FOR_BUG_19917_KEY", "WORKAROUND_FOR_BUG_19917_VALUE");
        super.onSaveInstanceState(b);
    }

    @Override
    public void onFilePicked(@NonNull Uri file) {
        Intent i = new Intent();
        i.setData(file);
        this.setResult(-1, i);
        this.finish();
    }

    @Override
    @TargetApi(value=16)
    public void onFilesPicked(@NonNull List<Uri> files) {
        Intent i = new Intent();
        i.putExtra(EXTRA_ALLOW_MULTIPLE, true);
        ArrayList<String> paths = new ArrayList<String>();
        for (Uri file : files) {
            paths.add(file.toString());
        }
        i.putStringArrayListExtra(EXTRA_PATHS, paths);
        if (Build.VERSION.SDK_INT >= 16) {
            ClipData clip = null;
            for (Uri file : files) {
                if (clip == null) {
                    clip = new ClipData((CharSequence)"Paths", new String[0], new ClipData.Item(file));
                    continue;
                }
                clip.addItem(new ClipData.Item(file));
            }
            i.setClipData(clip);
        }
        this.setResult(-1, i);
        this.finish();
    }

    @Override
    public void onCancelled() {
        this.setResult(0);
        this.finish();
    }
}

