/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc;

import com.oceanbase.jdbc.OceanBaseConnection;
import com.oceanbase.jdbc.internal.com.read.dao.Results;
import com.oceanbase.jdbc.internal.com.read.resultset.SelectResultSet;
import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;
import com.oceanbase.jdbc.internal.protocol.Protocol;
import com.oceanbase.jdbc.internal.util.ResourceStatus;
import com.oceanbase.jdbc.internal.util.Utils;
import com.oceanbase.jdbc.internal.util.exceptions.ExceptionFactory;
import com.oceanbase.jdbc.internal.util.scheduler.SchedulerServiceProviderHolder;
import com.oceanbase.jdbc.util.Options;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.Charset;
import java.sql.BatchUpdateException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class OceanBaseStatement
implements Statement,
Cloneable {
    public static final int STMT_UNINITIALIZED = -1;
    public static final int STMT_UNKNOWN = 0;
    public static final int STMT_SELECT = 1;
    public static final int STMT_UPDATE = 2;
    public static final int STMT_DELETE = 3;
    public static final int STMT_INSERT = 4;
    public static final int STMT_CREATE = 5;
    public static final int STMT_DROP = 6;
    public static final int STMT_ALTER = 7;
    public static final int STMT_BEGIN = 8;
    public static final int STMT_DECLARE = 9;
    public static final int STMT_CALL = 10;
    private static final Pattern identifierPattern = Pattern.compile("[0-9a-zA-Z\\$_\\u0080-\\uFFFF]*", 192);
    private static final Pattern escapePattern = Pattern.compile("[\u0000'\"\b\n\r\t\u001a\\\\]");
    private static final Map<String, String> mapper = new HashMap<String, String>();
    private static final Logger logger = LoggerFactory.getLogger(OceanBaseStatement.class);
    protected static final Logger lockLogger = LoggerFactory.getLogger("JDBC-COST-LOGGER");
    protected final ReentrantLock lock;
    protected final Options options;
    protected Protocol protocol;
    protected OceanBaseConnection connection;
    protected volatile ResourceStatus status = ResourceStatus.OPEN;
    protected Results results;
    PreparedStatement cursorFetchPstmt;
    private boolean isPoolable = true;
    protected boolean isInternal;
    protected volatile boolean executing;
    protected ExceptionFactory exceptionFactory;
    private boolean warningsCleared;
    private boolean mustCloseOnCompletion;
    protected List<String> batchQueries;
    protected int queryTimeout;
    private Future<?> timerTaskFuture;
    private ScheduledExecutorService timeoutScheduler;
    private boolean isTimeout;
    protected final boolean canUseServerTimeout;
    protected int resultSetScrollType;
    protected int resultSetConcurrency;
    private int maxFieldSize;
    protected long maxRows;
    protected int fetchSize;
    protected boolean isFetchSizeSet;
    private boolean escape = true;
    protected String originalSql;
    protected String actualSql;
    protected String simpleSql;
    protected String tableName;
    protected int sqlType;
    protected boolean addRowid;
    protected int selectEndPos = -1;
    protected int whereEndPos = -1;

    public OceanBaseStatement(OceanBaseConnection connection, int resultSetScrollType, int resultSetConcurrency, ExceptionFactory exceptionFactory) {
        this.protocol = connection.getProtocol();
        this.connection = connection;
        this.canUseServerTimeout = connection.canUseServerTimeout();
        this.resultSetScrollType = resultSetScrollType;
        this.resultSetConcurrency = resultSetConcurrency;
        this.lock = this.connection.lock;
        this.options = this.protocol.getOptions();
        this.exceptionFactory = exceptionFactory;
        this.fetchSize = this.protocol.isOracleMode() && this.options.defaultFetchSize == 0 ? 10 : this.options.defaultFetchSize;
        this.maxRows = this.options.maxRows;
        this.sqlType = -1;
    }

    public OceanBaseStatement clone(OceanBaseConnection connection) throws CloneNotSupportedException {
        OceanBaseStatement clone = (OceanBaseStatement)super.clone();
        clone.connection = connection;
        clone.protocol = connection.getProtocol();
        clone.timerTaskFuture = null;
        clone.batchQueries = new ArrayList<String>();
        clone.status = ResourceStatus.OPEN;
        clone.warningsCleared = true;
        clone.maxRows = 0L;
        clone.fetchSize = clone.protocol.isOracleMode() && this.options.defaultFetchSize == 0 ? 10 : this.options.defaultFetchSize;
        clone.exceptionFactory = ExceptionFactory.of(this.exceptionFactory.getThreadId(), this.exceptionFactory.getOptions());
        return clone;
    }

    protected void setTimerTask(boolean isBatch) {
        assert (this.timerTaskFuture == null);
        if (this.timeoutScheduler == null) {
            this.timeoutScheduler = SchedulerServiceProviderHolder.getTimeoutScheduler();
        }
        this.timerTaskFuture = this.timeoutScheduler.schedule(() -> {
            try {
                this.isTimeout = true;
                if (!isBatch) {
                    this.protocol.cancelCurrentQuery();
                }
                this.protocol.interrupt();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, (long)this.queryTimeout, TimeUnit.SECONDS);
    }

    protected void executeQueryPrologue(boolean isBatch) throws SQLException {
        this.executing = true;
        if (this.isClosed()) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("execute() is called on closed statement");
        }
        this.protocol.prolog(this.maxRows, this.protocol.getProxy() != null, this.connection, this);
        if (this.queryTimeout != 0 && (!this.canUseServerTimeout || isBatch) && this.options.enableQueryTimeouts) {
            this.setTimerTask(isBatch);
        }
    }

    private void stopTimeoutTask() {
        if (this.timerTaskFuture != null) {
            if (!this.timerTaskFuture.cancel(true)) {
                try {
                    this.timerTaskFuture.get();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
            this.timerTaskFuture = null;
        }
    }

    protected SQLException executeExceptionEpilogue(SQLException sqle) {
        if (sqle.getSQLState() != null && sqle.getSQLState().startsWith("08")) {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (sqle.getErrorCode() == 1148 && !this.options.allowLocalInfile) {
            return this.exceptionFactory.raiseStatementError(this.connection, this).create("Usage of LOCAL INFILE is disabled. To use it enable it via the connection property allowLocalInfile=true", "42000", 1148, sqle);
        }
        if (this.isTimeout) {
            return this.exceptionFactory.raiseStatementError(this.connection, this).create("Query timed out", "70100", 1317, sqle);
        }
        SQLException sqlException = this.exceptionFactory.raiseStatementError(this.connection, this).create(sqle);
        logger.error("error executing query", sqlException);
        return sqlException;
    }

    protected void executeEpilogue() {
        this.stopTimeoutTask();
        this.isTimeout = false;
        this.executing = false;
    }

    protected void executeBatchEpilogue() {
        this.executing = false;
        this.stopTimeoutTask();
        this.isTimeout = false;
        this.clearBatch();
    }

    private SQLException handleFailoverAndTimeout(SQLException sqle) {
        if (sqle.getSQLState() != null && sqle.getSQLState().startsWith("08")) {
            try {
                this.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        if (this.isTimeout) {
            return this.exceptionFactory.raiseStatementError(this.connection, this).create("Query timed out", "70100", 1317, sqle);
        }
        return sqle;
    }

    int[] buildArrayBindingUpdateCounts() {
        int[] ret = new int[]{};
        int sql_no = 0;
        int totoalRowsNum = 0;
        if (this.results == null && this.results.getExecutionResults() == null) {
            return ret;
        }
        try {
            SelectResultSet rs = null;
            int cur = 0;
            for (SelectResultSet curResultSet : this.results.getExecutionResults()) {
                int index = cur;
                int curRowsNum = this.results.getCmdInformation().getUpdateCounts()[index];
                if (curRowsNum > 0) {
                    totoalRowsNum += curRowsNum;
                } else {
                    rs = curResultSet;
                    if (rs != null) {
                        while (rs.next()) {
                            sql_no = rs.getInt(1);
                        }
                    }
                    totoalRowsNum += sql_no;
                }
                ++cur;
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        ret = new int[totoalRowsNum];
        Arrays.fill(ret, 1);
        return ret;
    }

    protected BatchUpdateException executeBatchExceptionEpilogue(SQLException initialSqlException, int size, boolean arrayBindingException) {
        int[] ret;
        SQLException sqle = this.handleFailoverAndTimeout(initialSqlException);
        if (arrayBindingException && this.results != null && this.results.getExecutionResults() != null) {
            int[] ret2 = this.buildArrayBindingUpdateCounts();
            sqle = this.exceptionFactory.raiseStatementError(this.connection, this).create(sqle);
            logger.error("error executing query", sqle);
            return new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), ret2, (Throwable)sqle);
        }
        if (this.results == null || !this.results.commandEnd()) {
            ret = new int[size];
            Arrays.fill(ret, -3);
        } else {
            ret = this.results.getCmdInformation().getUpdateCounts();
        }
        if (!this.protocol.isOracleMode() && this.results.isExecuteBatchStmt()) {
            if (!this.options.continueBatchOnError) {
                int end = ret.length - 1;
                int[] tmp = new int[end];
                System.arraycopy(ret, 0, tmp, 0, end);
                ret = tmp;
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = -3;
                }
            } else {
                for (int i = 0; i < ret.length; ++i) {
                    ret[i] = i == 0 ? -1 : -3;
                }
            }
        } else if (!this.options.continueBatchOnError) {
            int end = 0;
            if (!(!this.results.getCmdInformation().getRewrite() || this.protocol.isOracleMode() && this.options.rewriteInsertByMultiQueries)) {
                end = ret.length - 1;
            } else {
                for (int i = 0; i < ret.length; ++i) {
                    if (ret[i] != -3) continue;
                    end = i;
                    break;
                }
            }
            if (end != 0) {
                int[] tmp = new int[end];
                System.arraycopy(ret, 0, tmp, 0, end);
                ret = tmp;
            } else {
                ret = new int[]{};
            }
        }
        sqle = this.exceptionFactory.raiseStatementError(this.connection, this).create(sqle);
        logger.error("error executing query", sqle);
        return new BatchUpdateException(sqle.getMessage(), sqle.getSQLState(), sqle.getErrorCode(), ret, (Throwable)sqle);
    }

    protected BatchUpdateException executeBatchExceptionEpilogue(SQLException initialSqlException, int size) {
        return this.executeBatchExceptionEpilogue(initialSqlException, size, false);
    }

    /*
     * Loose catch block
     */
    private boolean executeInternal(String sql, int fetchSize, int autoGeneratedKeys) throws SQLException {
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        this.lock.lock();
        try {
            lockLogger.debug("OceanBaseStatement.executeInternal locked");
            try {
                this.executeQueryPrologue(false);
                this.results = new Results(this, fetchSize, false, 1, false, this.resultSetScrollType, this.resultSetConcurrency, autoGeneratedKeys, this.protocol.getAutoIncrementIncrement(), sql, null);
                this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.getTimeoutSql(this.nativeSql(sql, this.protocol)));
                this.results.commandEnd();
                boolean bl = this.results.getResultSet() != null;
                return bl;
            }
            catch (SQLException exception) {
                throw this.executeExceptionEpilogue(exception);
            }
            finally {
                this.executeEpilogue();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
            lockLogger.debug("OceanBaseStatement.executeInternal unlocked");
            if (this.protocol != null) {
                this.protocol.endCallInterface("OceanBaseStatement.executeInternal");
            }
        }
    }

    @Override
    public String enquoteLiteral(String val) throws SQLException {
        Matcher matcher = escapePattern.matcher(val);
        StringBuffer escapedVal = new StringBuffer("'");
        while (matcher.find()) {
            matcher.appendReplacement(escapedVal, mapper.get(matcher.group()));
        }
        matcher.appendTail(escapedVal);
        escapedVal.append("'");
        return escapedVal.toString();
    }

    @Override
    public String enquoteIdentifier(String identifier, boolean alwaysQuote) throws SQLException {
        if (this.isSimpleIdentifier(identifier)) {
            return alwaysQuote ? "`" + identifier + "`" : identifier;
        }
        if (identifier.contains("\u0000")) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Invalid name - containing u0000 character", "42000");
        }
        if (identifier.matches("^`.+`$")) {
            identifier = identifier.substring(1, identifier.length() - 1);
        }
        return "`" + identifier.replace("`", "``") + "`";
    }

    @Override
    public boolean isSimpleIdentifier(String identifier) throws SQLException {
        return identifier != null && !identifier.isEmpty() && identifierPattern.matcher(identifier).matches();
    }

    @Override
    public String enquoteNCharLiteral(String val) throws SQLException {
        return "N'" + val.replace("'", "''") + "'";
    }

    private String getTimeoutSql(String sql) {
        if (this.queryTimeout != 0 && this.canUseServerTimeout) {
            return "SET STATEMENT max_statement_time=" + this.queryTimeout + " FOR " + sql;
        }
        return sql;
    }

    private String nativeSql(String sql, Protocol protocol) throws SQLException {
        return this.escape ? Utils.nativeSql(sql, protocol) : sql;
    }

    /*
     * Loose catch block
     */
    public boolean testExecute(String sql, Charset charset) throws SQLException {
        this.lock.lock();
        try {
            lockLogger.debug("OceanBaseStatement.testExecute locked");
            try {
                this.executeQueryPrologue(false);
                this.results = new Results(this, this.fetchSize, false, 1, false, this.resultSetScrollType, this.resultSetConcurrency, 2, this.protocol.getAutoIncrementIncrement(), sql, null);
                this.protocol.executeQuery(this.protocol.isMasterConnection(), this.results, this.getTimeoutSql(this.nativeSql(sql, this.protocol)), charset);
                this.results.commandEnd();
                boolean bl = this.results.getResultSet() != null;
                return bl;
            }
            catch (SQLException exception) {
                throw this.executeExceptionEpilogue(exception);
            }
            finally {
                this.executeEpilogue();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
            lockLogger.debug("OceanBaseStatement.testExecute unlocked");
        }
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        return this.execute(sql, 2);
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        return this.executeInternal(sql, this.fetchSize, autoGeneratedKeys);
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        return this.execute(sql, 1);
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        return this.execute(sql, 1);
    }

    public boolean isCursorResultSet() throws SQLException {
        if (this.isClosed()) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("execute() is called on closed statement");
        }
        return !this.isInternal && this.options.useServerPrepStmts && this.getFetchSize() > 0 && (this.protocol.isOracleMode() || this.options.useCursorFetch && this.resultSetConcurrency == 1007 && this.resultSetScrollType == 1003);
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.cursorFetchPstmt = null;
        if (this.isCursorResultSet()) {
            PreparedStatement pstmt;
            this.cursorFetchPstmt = pstmt = this.connection.prepareStatement(sql, this.resultSetScrollType, this.resultSetConcurrency);
            pstmt.setFetchSize(this.fetchSize);
            pstmt.setMaxRows(this.getMaxRows());
            if (this.isCloseOnCompletion()) {
                pstmt.closeOnCompletion();
            }
            ResultSet rs = pstmt.executeQuery();
            this.results = ((OceanBaseStatement)((Object)pstmt)).results;
            return rs;
        }
        if (this.executeInternal(sql, this.fetchSize, 2)) {
            return this.results.getResultSet();
        }
        if (this.results.isReturning()) {
            return this.results.getResultSet();
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        return this.executeUpdate(sql, 2);
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize, autoGeneratedKeys)) {
            if (this.protocol.isOracleMode() && this.results.getResultSet() != null) {
                return (int)this.results.getResultSet().getProcessedRows();
            }
            return 0;
        }
        if (this.results.isReturning() && this.results.getResultSet() != null) {
            return (int)this.results.getResultSet().getProcessedRows();
        }
        return this.getUpdateCount();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeUpdate(sql, 1);
    }

    @Override
    public long executeLargeUpdate(String sql) throws SQLException {
        return this.executeLargeUpdate(sql, 2);
    }

    @Override
    public long executeLargeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        if (this.executeInternal(sql, this.fetchSize, autoGeneratedKeys)) {
            if (this.protocol.isOracleMode() && this.results.getResultSet() != null) {
                return (int)this.results.getResultSet().getProcessedRows();
            }
            return 0L;
        }
        if (this.results.isReturning() && this.results.getResultSet() != null) {
            return this.results.getResultSet().getProcessedRows();
        }
        return this.getLargeUpdateCount();
    }

    @Override
    public long executeLargeUpdate(String sql, int[] columnIndexes) throws SQLException {
        return this.executeLargeUpdate(sql, 1);
    }

    @Override
    public long executeLargeUpdate(String sql, String[] columnNames) throws SQLException {
        return this.executeLargeUpdate(sql, 1);
    }

    @Override
    public void close() throws SQLException {
        this.realClose(true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void realClose(boolean calledExplicitly, boolean closeOpenResults) throws SQLException {
        block36: {
            block34: {
                if (this.protocol != null) {
                    this.protocol.startCallInterface();
                }
                this.lock.lock();
                try {
                    lockLogger.debug("OceanBaseStatement.realClose locked");
                    if (this.status != ResourceStatus.CLOSING && this.status != ResourceStatus.CLOSED) break block34;
                }
                catch (Throwable throwable) {
                    try {
                        if (this.results != null) {
                            this.results.close();
                        }
                        this.status = ResourceStatus.CLOSED;
                        this.connection = null;
                        if (this.protocol != null) {
                            this.protocol.endCallInterface("OceanBaseStatement.realClose");
                        }
                        this.protocol = null;
                    }
                    catch (Exception exception) {
                    }
                    finally {
                        this.lock.unlock();
                        lockLogger.debug("OceanBaseStatement.realClose unlocked");
                    }
                    throw throwable;
                }
                try {
                    if (this.results != null) {
                        this.results.close();
                    }
                    this.status = ResourceStatus.CLOSED;
                    this.connection = null;
                    if (this.protocol != null) {
                        this.protocol.endCallInterface("OceanBaseStatement.realClose");
                    }
                    this.protocol = null;
                }
                catch (Exception exception) {
                }
                finally {
                    this.lock.unlock();
                    lockLogger.debug("OceanBaseStatement.realClose unlocked");
                }
                return;
            }
            this.status = ResourceStatus.CLOSING;
            if (closeOpenResults && this.results != null) {
                if (this.results.getFetchSize() != 0) {
                    this.skipMoreResults();
                }
                if (this.results.getResultSet() != null) {
                    this.results.getResultSet().close();
                }
                this.results.closeAllOpenResults();
            }
            if (this.cursorFetchPstmt != null) {
                this.cursorFetchPstmt.close();
                this.cursorFetchPstmt = null;
            }
            if (this.connection != null && this.connection.pooledConnection != null && !this.connection.pooledConnection.noStmtEventListeners()) break block36;
            try {
                if (this.results != null) {
                    this.results.close();
                }
                this.status = ResourceStatus.CLOSED;
                this.connection = null;
                if (this.protocol != null) {
                    this.protocol.endCallInterface("OceanBaseStatement.realClose");
                }
                this.protocol = null;
            }
            catch (Exception exception) {
            }
            finally {
                this.lock.unlock();
                lockLogger.debug("OceanBaseStatement.realClose unlocked");
            }
            return;
        }
        this.connection.pooledConnection.fireStatementClosed(this);
        try {
            if (this.results != null) {
                this.results.close();
            }
            this.status = ResourceStatus.CLOSED;
            this.connection = null;
            if (this.protocol != null) {
                this.protocol.endCallInterface("OceanBaseStatement.realClose");
            }
            this.protocol = null;
        }
        catch (Exception exception) {
        }
        finally {
            this.lock.unlock();
            lockLogger.debug("OceanBaseStatement.realClose unlocked");
        }
    }

    @Override
    public int getMaxFieldSize() {
        return this.maxFieldSize;
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        int maxAllowedPacketSize = this.protocol.getWriter().getMaxAllowedPacket();
        if (max < 0) {
            throw new SQLException("Illegal value for setMaxFieldSize().");
        }
        if (max > maxAllowedPacketSize) {
            MessageFormat messageFormat = new MessageFormat("Can not set max field size > max allowed packet of {0} bytes.");
            String message = messageFormat.format(new Object[]{(long)maxAllowedPacketSize});
            throw new SQLException(message);
        }
        this.maxFieldSize = max;
    }

    @Override
    public int getMaxRows() {
        return (int)this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max < 0) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("max rows cannot be negative : asked for " + max, "42000");
        }
        this.maxRows = max;
    }

    @Override
    public long getLargeMaxRows() {
        return this.maxRows;
    }

    @Override
    public void setLargeMaxRows(long max) throws SQLException {
        if (max < 0L) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("max rows cannot be negative : setLargeMaxRows value is " + max, "42000");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) {
        this.escape = enable;
    }

    @Override
    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        if (seconds < 0) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Query timeout cannot be negative : asked for " + seconds, "42000");
        }
        this.queryTimeout = seconds;
    }

    public void setLocalInfileInputStream(InputStream inputStream) throws SQLException {
        this.checkClose();
        this.protocol.setLocalInfileInputStream(inputStream);
    }

    @Override
    public void cancel() throws SQLException {
        block12: {
            this.checkClose();
            if (this.protocol != null) {
                this.protocol.startCallInterface();
            }
            boolean locked = this.lock.tryLock();
            try {
                if (locked) {
                    lockLogger.debug("OceanBaseStatement.cancel locked");
                }
                if (this.executing) {
                    this.protocol.cancelCurrentQuery();
                    break block12;
                }
                if (this.results == null || this.results.getFetchSize() == 0 || this.results.isFullyLoaded(this.protocol)) break block12;
                try {
                    this.protocol.cancelCurrentQuery();
                    this.skipMoreResults();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.results.removeFetchSize();
            }
            catch (SQLException e) {
                logger.error("error cancelling query", e);
                throw this.exceptionFactory.raiseStatementError(this.connection, this).create(e);
            }
            finally {
                if (locked) {
                    this.lock.unlock();
                    lockLogger.debug("OceanBaseStatement.cancel unlocked");
                }
                if (this.protocol != null) {
                    this.protocol.endCallInterface("OceanBaseStatement.cancel");
                }
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkClose();
        if (this.warningsCleared || this.isClosed() || !this.protocol.hasWarnings() && this.protocol.isOracleMode()) {
            return null;
        }
        if (this.protocol.isOracleMode()) {
            return new SQLWarning("The execution is complete, but with warnings");
        }
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        SQLWarning last = null;
        SQLWarning first = null;
        try (Statement st = this.connection.createStatement();
             ResultSet rs = st.executeQuery("show warnings");){
            while (rs.next()) {
                int code = rs.getInt(2);
                String message = rs.getString(3);
                SQLWarning warning = new SQLWarning(message, null, code);
                if (first == null) {
                    first = warning;
                    last = warning;
                    continue;
                }
                last.setNextWarning(warning);
                last = warning;
            }
        }
        if (this.protocol != null) {
            this.protocol.endCallInterface("OceanBaseConnection.getWarnings");
        }
        return first;
    }

    @Override
    public void clearWarnings() {
        this.warningsCleared = true;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        if (!this.protocol.isOracleMode()) {
            return;
        }
        throw this.exceptionFactory.raiseStatementError(this.connection, this).notSupported("Not supported feature");
    }

    @Override
    public OceanBaseConnection getConnection() {
        return this.connection;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        if (this.results != null) {
            return this.results.getGeneratedKeys(this.protocol);
        }
        return SelectResultSet.createEmptyResultSet();
    }

    @Override
    public int getResultSetHoldability() {
        return 1;
    }

    @Override
    public boolean isClosed() {
        return this.status == ResourceStatus.CLOSED;
    }

    @Override
    public boolean isPoolable() {
        return this.isPoolable;
    }

    @Override
    public void setPoolable(boolean poolable) {
        this.isPoolable = poolable;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkClose();
        return this.results != null && !this.results.isReturning() ? this.results.getResultSet() : null;
    }

    public String getServerInfo() {
        if (this.results != null && this.results.getCmdInformation() != null) {
            return this.results.getCmdInformation().getServerInfo();
        }
        return null;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        if (this.results != null && this.results.getCmdInformation() != null && !this.results.isBatch()) {
            if (this.results.isReturning() && this.results.getResultSet() != null) {
                return (int)this.results.getResultSet().getProcessedRows();
            }
            return this.results.getCmdInformation().getUpdateCount();
        }
        return -1;
    }

    @Override
    public long getLargeUpdateCount() {
        if (this.results != null && this.results.getCmdInformation() != null && !this.results.isBatch()) {
            if (this.results.isReturning() && this.results.getResultSet() != null) {
                return this.results.getResultSet().getProcessedRows();
            }
            return this.results.getCmdInformation().getLargeUpdateCount();
        }
        return -1L;
    }

    protected void skipMoreResults() throws SQLException {
        try {
            this.protocol.skip();
            this.warningsCleared = false;
            this.connection.reenableWarnings();
        }
        catch (SQLException e) {
            logger.debug("error skipMoreResults", e);
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create(e);
        }
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return this.getMoreResults(1);
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        this.checkClose();
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        try {
            boolean bl = this.results != null && this.results.getMoreResults(current, this.protocol);
            return bl;
        }
        finally {
            if (this.protocol != null) {
                this.protocol.endCallInterface("OceanBaseStatement.getMoreResults");
            }
        }
    }

    @Override
    public int getFetchDirection() {
        return 1000;
    }

    @Override
    public void setFetchDirection(int direction) {
    }

    @Override
    public int getFetchSize() {
        return this.fetchSize;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.maxRows > 0L && !this.protocol.isOracleMode() && (long)rows > this.maxRows || this.protocol.isOracleMode() && rows < 0 && (!this.options.extendOracleResultSetClass || rows != Integer.MIN_VALUE) || !this.protocol.isOracleMode() && rows < 0 && rows != Integer.MIN_VALUE) {
            if (!this.protocol.isOracleMode()) {
                throw this.exceptionFactory.raiseStatementError(this.connection, this).create("invalid fetch size ");
            }
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("invalid fetch size. in Oracle mode, extendOracleResultSetClass is ineffective if useOraclePrepareExecute is set to true or usePieceData is set to true");
        }
        if (this.protocol.isOracleMode() && rows != 0 || !this.protocol.isOracleMode()) {
            this.fetchSize = rows;
        }
        this.isFetchSizeSet = true;
    }

    @Override
    public int getResultSetConcurrency() {
        return this.resultSetConcurrency;
    }

    @Override
    public int getResultSetType() {
        return this.resultSetScrollType;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.lock.lock();
        try {
            if (this.batchQueries == null) {
                this.batchQueries = new ArrayList<String>();
            }
            if (sql == null) {
                throw this.exceptionFactory.raiseStatementError(this.connection, this).create("null cannot be set to addBatch( String sql)");
            }
            this.batchQueries.add(sql);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void clearBatch() {
        if (this.batchQueries != null) {
            this.batchQueries.clear();
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public int[] executeBatch() throws SQLException {
        int size;
        this.checkClose();
        if (this.batchQueries == null || (size = this.batchQueries.size()) == 0) {
            return new int[0];
        }
        this.lock.lock();
        try {
            lockLogger.debug("OceanBaseStatement.executeBatch locked");
            try {
                this.internalBatchExecution(size);
                int[] nArray = this.results.getCmdInformation().getUpdateCounts();
                return nArray;
            }
            catch (SQLException initialSqlEx) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                initialSqlEx.printStackTrace(pw);
                logger.error("--------------------------------------------------------------------------\n" + this.actualSql + "\n" + sw + "\n--------------------------------------------------------------------------\n");
                try {
                    throw this.executeBatchExceptionEpilogue(initialSqlEx, size);
                }
                catch (NullPointerException e) {
                    e.initCause(initialSqlEx);
                    throw e;
                }
            }
            finally {
                this.executeBatchEpilogue();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
            lockLogger.debug("OceanBaseStatement.executeBatch unlocked");
        }
    }

    /*
     * Loose catch block
     */
    @Override
    public long[] executeLargeBatch() throws SQLException {
        int size;
        this.checkClose();
        if (this.batchQueries == null || (size = this.batchQueries.size()) == 0) {
            return new long[0];
        }
        this.lock.lock();
        try {
            lockLogger.debug("OceanBaseStatement.executeLargeBatch locked");
            try {
                this.internalBatchExecution(size);
                long[] lArray = this.results.getCmdInformation().getLargeUpdateCounts();
                return lArray;
            }
            catch (SQLException initialSqlEx) {
                throw this.executeBatchExceptionEpilogue(initialSqlEx, size);
            }
            finally {
                this.executeBatchEpilogue();
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
        }
        finally {
            this.lock.unlock();
            lockLogger.debug("OceanBaseStatement.executeLargeBatch unlocked");
        }
    }

    private void internalBatchExecution(int size) throws SQLException {
        if (this.protocol != null) {
            this.protocol.startCallInterface();
        }
        this.executeQueryPrologue(true);
        this.results = new Results(this, 0, true, size, false, this.resultSetScrollType, this.resultSetConcurrency, 1, this.protocol.getAutoIncrementIncrement(), null, null);
        this.protocol.executeBatchStmt(this.protocol.isMasterConnection(), this.results, this.batchQueries);
        this.results.commandEnd();
        if (this.protocol != null) {
            this.protocol.endCallInterface("OceanBaseStatement.internalBatchExecution");
        }
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        try {
            if (this.isWrapperFor(iface)) {
                return (T)this;
            }
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("The receiver is not a wrapper and does not implement the interface " + iface.getName(), "42000");
        }
        catch (Exception e) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("The receiver is not a wrapper and does not implement the interface " + iface.getName(), "42000");
        }
    }

    @Override
    public boolean isWrapperFor(Class<?> interfaceOrWrapper) throws SQLException {
        return interfaceOrWrapper.isInstance(this);
    }

    @Override
    public void closeOnCompletion() {
        this.mustCloseOnCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() {
        return this.mustCloseOnCompletion;
    }

    public void checkCloseOnCompletion(ResultSet resultSet) throws SQLException {
        if (this.mustCloseOnCompletion && this.status == ResourceStatus.OPEN && this.results != null && resultSet.equals(this.results.getResultSet())) {
            this.close();
        }
    }

    protected void checkClose() throws SQLException {
        if (this.isClosed() || this.connection.isClosed()) {
            throw this.exceptionFactory.raiseStatementError(this.connection, this).create("Cannot do an operation on a closed statement");
        }
    }

    public Results getResults() {
        return this.results;
    }

    public String getActualSql() {
        return this.actualSql;
    }

    public int getSqlType() {
        return this.sqlType;
    }

    public int getSqlType(String Sql) {
        String simpleSql = Utils.trimSQLString(Sql, this.protocol.noBackslashEscapes(), this.protocol.isOracleMode(), false);
        return Utils.getStatementType(simpleSql);
    }

    protected boolean isDml(int sqlType) {
        switch (sqlType) {
            case 2: 
            case 3: 
            case 4: {
                return true;
            }
        }
        if (!this.protocol.isOracleMode()) {
            switch (sqlType) {
                case 5: 
                case 6: 
                case 7: {
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAddRowid() {
        return this.addRowid;
    }

    public int getWhereEndPos() {
        return this.whereEndPos;
    }

    public void setInternal() {
        this.isInternal = true;
    }

    public boolean isInternal() {
        return this.isInternal;
    }

    public String getOriginalSql() {
        return this.originalSql;
    }

    static {
        mapper.put("\u0000", "\\0");
        mapper.put("'", "\\\\'");
        mapper.put("\"", "\\\\\"");
        mapper.put("\b", "\\\\b");
        mapper.put("\n", "\\\\n");
        mapper.put("\r", "\\\\r");
        mapper.put("\t", "\\\\t");
        mapper.put("\u001a", "\\\\Z");
        mapper.put("\\", "\\\\");
    }
}

