/*
 * Decompiled with CFR 0.152.
 */
package com.oceanbase.jdbc.internal.protocol;

import com.oceanbase.jdbc.internal.logging.Logger;
import com.oceanbase.jdbc.internal.logging.LoggerFactory;

public class TimeTrace {
    private static final Logger logger = LoggerFactory.getLogger("JDBC-COST-LOGGER");
    private long serverThreadId;
    private int logTraceTimeMs;
    private long startCallInterface;
    private long endCallInterface;
    private long startSendRequest;
    private long endSendRequest;
    private long startReceiveResponse;
    private long endReceiveResponse;

    public TimeTrace(long serverThreadId, int logTraceTime) {
        this.serverThreadId = serverThreadId;
        this.logTraceTimeMs = logTraceTime;
    }

    public void startCallInterface() {
        try {
            this.startCallInterface = System.nanoTime();
        }
        catch (Exception e) {
            try {
                logger.warn("startCallInterface failed.", e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void endCallInterface(String interfaceName) {
        try {
            this.endCallInterface = System.nanoTime();
            long timeUs = this.getCallInterfaceElapsedTimeUs();
            if (this.logTraceTimeMs > 0 && (long)this.logTraceTimeMs > timeUs / 1000L) {
                return;
            }
            logger.info("[connectionId={}] {}: CallInterface costs {}us.", this.serverThreadId, interfaceName, timeUs);
        }
        catch (Exception e) {
            try {
                logger.warn("endCallInterface failed.", e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private long getCallInterfaceElapsedTimeUs() {
        return (this.endCallInterface - this.startCallInterface) / 1000L;
    }

    public void startSendRequest() {
        try {
            this.startSendRequest = System.nanoTime();
        }
        catch (Exception e) {
            try {
                logger.warn("startSendRequest failed.", e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void endSendRequest() {
        try {
            this.endSendRequest = System.nanoTime();
        }
        catch (Exception e) {
            try {
                logger.warn("endSendRequest failed.", e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private long getSendRequestElapsedTimeUs() {
        return (this.endSendRequest - this.startSendRequest) / 1000L;
    }

    public void startReceiveResponse() {
        try {
            this.startReceiveResponse = System.nanoTime();
        }
        catch (Exception e) {
            try {
                logger.warn("startReceiveResponse failed.", e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void endReceiveResponse(String protocol, String sql) {
        try {
            this.endReceiveResponse = System.nanoTime();
            long timeUs1 = this.getSendRequestElapsedTimeUs();
            long timeUs2 = this.getReceiveResponseElapsedTimeUs();
            if (this.logTraceTimeMs > 0 && (long)this.logTraceTimeMs > timeUs1 / 1000L && (long)this.logTraceTimeMs > timeUs2 / 1000L) {
                return;
            }
            if (sql == null) {
                sql = "";
            } else if (sql.length() > 100) {
                sql = sql.substring(0, 100) + "...";
            }
            logger.info("[connectionId={}] {}: SendRequest costs {}us, ReceiveResponse costs {}us. {}", this.serverThreadId, protocol, this.getSendRequestElapsedTimeUs(), this.getReceiveResponseElapsedTimeUs(), sql);
        }
        catch (Exception e) {
            try {
                logger.warn("endReceiveResponse failed.", e);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private long getReceiveResponseElapsedTimeUs() {
        return (this.endReceiveResponse - this.startReceiveResponse) / 1000L;
    }
}

