/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.accounts.Account;
import android.accounts.AccountManager;
import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.util.Base64;
import android.util.Log;
import android.util.Patterns;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.ActivityLifecycleListener;
import com.onesignal.ActivityLifecycleListenerCompat;
import com.onesignal.AdvertisingIdProviderFallback;
import com.onesignal.AdvertisingIdProviderGPS;
import com.onesignal.AdvertisingIdentifierProvider;
import com.onesignal.AndroidSupportV4Compat;
import com.onesignal.LocationGMS;
import com.onesignal.OSUtils;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.PushRegistrator;
import com.onesignal.PushRegistratorADM;
import com.onesignal.PushRegistratorGPS;
import com.onesignal.RootToolsInternalMethods;
import com.onesignal.SyncService;
import com.onesignal.TrackAmazonPurchase;
import com.onesignal.TrackGooglePurchase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import java.util.UUID;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OneSignal {
    static final long MIN_ON_FOCUS_TIME = 60L;
    static final String TAG = "OneSignal";
    static String appId;
    static String mGoogleProjectNumber;
    static Context appContext;
    private static boolean startedRegistration;
    private static LOG_LEVEL visualLogLevel;
    private static LOG_LEVEL logCatLevel;
    private static String userId;
    private static int subscribableStatus;
    private static NotificationOpenedHandler notificationOpenedHandler;
    static boolean initDone;
    private static boolean foreground;
    private static IdsAvailableHandler idsAvailableHandler;
    private static long lastTrackedTime;
    private static long unSentActiveTime;
    private static TrackGooglePurchase trackGooglePurchase;
    private static TrackAmazonPurchase trackAmazonPurchase;
    public static final String VERSION = "020401";
    private static AdvertisingIdentifierProvider mainAdIdProvider;
    private static int deviceType;
    public static String sdkType;
    private static OSUtils osUtils;
    private static boolean ranSessionInitThread;
    private static String lastRegistrationId;
    private static boolean registerForPushFired;
    private static boolean locationFired;
    private static Double lastLocLat;
    private static Double lastLocLong;
    private static Float lastLocAcc;
    private static Integer lastLocType;
    private static Builder mInitBuilder;
    static Collection<JSONArray> unprocessedOpenedNotifis;
    private static GetTagsHandler pendingGetTagsHandler;
    private static boolean getTagsCall;

    public static Builder startInit(Context context) {
        return new Builder(context);
    }

    private static void init(Builder inBuilder) {
        mInitBuilder = inBuilder;
        Context context = OneSignal.mInitBuilder.mContext;
        OneSignal.mInitBuilder.mContext = null;
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            OneSignal.init(context, bundle.getString("onesignal_google_project_number").substring(4), bundle.getString("onesignal_app_id"), OneSignal.mInitBuilder.mNotificationOpenedHandler);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void init(Context context, String googleProjectNumber, String oneSignalAppId) {
        OneSignal.init(context, googleProjectNumber, oneSignalAppId, null);
    }

    public static void init(Context context, String googleProjectNumber, String oneSignalAppId, NotificationOpenedHandler inNotificationOpenedHandler) {
        boolean contextIsActivity;
        if (mInitBuilder == null) {
            mInitBuilder = new Builder();
        }
        osUtils = new OSUtils();
        deviceType = osUtils.getDeviceType();
        try {
            UUID.fromString(oneSignalAppId);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.FATAL, "OneSignal AppId format is invalid.\nExample: 'b2f7f966-d8cc-11e4-bed1-df8f05be55ba'\n", t);
            return;
        }
        if ("b2f7f966-d8cc-11e4-bed1-df8f05be55ba".equals(oneSignalAppId) || "5eb5a37e-b458-11e3-ac11-000c2940e62c".equals(oneSignalAppId)) {
            OneSignal.Log(LOG_LEVEL.WARN, "OneSignal Example AppID detected, please update to your app's id found on OneSignal.com");
        }
        if (deviceType == 1) {
            try {
                Double.parseDouble(googleProjectNumber);
                if (googleProjectNumber.length() < 8 || googleProjectNumber.length() > 16) {
                    throw new IllegalArgumentException("Google Project number (Sender_ID) should be a 10 to 14 digit number in length.");
                }
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.FATAL, "Google Project number (Sender_ID) format is invalid. Please use the 10 to 14 digit number found in the Google Developer Console for your project.\nExample: '703322744261'\n", t);
                subscribableStatus = -6;
            }
            try {
                Class.forName("com.google.android.gms.gcm.GoogleCloudMessaging");
            }
            catch (ClassNotFoundException e) {
                OneSignal.Log(LOG_LEVEL.FATAL, "The GCM Google Play services client library was not found. Please make sure to include it in your project.", e);
                subscribableStatus = -4;
            }
        }
        mGoogleProjectNumber = googleProjectNumber;
        try {
            Class.forName("android.support.v4.view.MenuCompat");
            try {
                Class.forName("android.support.v4.content.WakefulBroadcastReceiver");
                Class.forName("android.support.v4.app.NotificationManagerCompat");
            }
            catch (ClassNotFoundException e) {
                OneSignal.Log(LOG_LEVEL.FATAL, "The included Android Support Library v4 is to old or incomplete. Please update your project's android-support-v4.jar to the latest revision.", e);
                subscribableStatus = -5;
            }
        }
        catch (ClassNotFoundException e) {
            OneSignal.Log(LOG_LEVEL.FATAL, "Could not find the Android Support Library v4. Please make sure android-support-v4.jar has been correctly added to your project.", e);
            subscribableStatus = -3;
        }
        if (initDone) {
            if (context != null) {
                appContext = context.getApplicationContext();
            }
            if (inNotificationOpenedHandler != null) {
                notificationOpenedHandler = inNotificationOpenedHandler;
            }
            if (notificationOpenedHandler != null) {
                OneSignal.fireCallbackForOpenedNotifications();
            }
            return;
        }
        foreground = contextIsActivity = context instanceof Activity;
        appId = oneSignalAppId;
        appContext = context.getApplicationContext();
        if (contextIsActivity) {
            ActivityLifecycleHandler.curActivity = (Activity)context;
        } else {
            ActivityLifecycleHandler.nextResumeIsFirstActivity = true;
        }
        notificationOpenedHandler = inNotificationOpenedHandler;
        lastTrackedTime = SystemClock.elapsedRealtime();
        OneSignalStateSynchronizer.initUserState(appContext);
        appContext.startService(new Intent(appContext, SyncService.class));
        if (Build.VERSION.SDK_INT > 13) {
            ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleListener());
        } else {
            ActivityLifecycleListenerCompat.startListener();
        }
        try {
            Class.forName("com.amazon.device.iap.PurchasingListener");
            trackAmazonPurchase = new TrackAmazonPurchase(appContext);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        String oldAppId = OneSignal.getSavedAppId();
        if (oldAppId != null) {
            if (!oldAppId.equals(appId)) {
                OneSignal.Log(LOG_LEVEL.DEBUG, "APP ID changed, clearing user id as it is no longer valid.");
                OneSignal.SaveAppId(appId);
                OneSignalStateSynchronizer.resetCurrentState();
            }
        } else {
            OneSignal.SaveAppId(appId);
        }
        if (foreground || OneSignal.getUserId() == null) {
            OneSignal.startRegistrationOrOnSession();
        }
        if (notificationOpenedHandler != null) {
            OneSignal.fireCallbackForOpenedNotifications();
        }
        if (TrackGooglePurchase.CanTrack(appContext)) {
            trackGooglePurchase = new TrackGooglePurchase(appContext);
        }
        initDone = true;
    }

    private static void startRegistrationOrOnSession() {
        if (startedRegistration) {
            return;
        }
        startedRegistration = true;
        PushRegistrator pushRegistrator = deviceType == 2 ? new PushRegistratorADM() : new PushRegistratorGPS();
        pushRegistrator.registerForPush(appContext, mGoogleProjectNumber, new PushRegistrator.RegisteredHandler(){

            @Override
            public void complete(String id) {
                lastRegistrationId = id;
                registerForPushFired = true;
                OneSignal.registerUser();
            }
        });
        LocationGMS.getLocation(appContext, OneSignal.mInitBuilder.mPromptLocation, new LocationGMS.LocationHandler(){

            @Override
            public void complete(Double lat, Double log, Float accuracy, Integer type) {
                lastLocLat = lat;
                lastLocLong = log;
                lastLocAcc = accuracy;
                lastLocType = type;
                locationFired = true;
                OneSignal.registerUser();
            }
        });
    }

    private static void fireCallbackForOpenedNotifications() {
        for (JSONArray dataArray : unprocessedOpenedNotifis) {
            OneSignal.runNotificationOpenedCallback(dataArray, false);
        }
        unprocessedOpenedNotifis.clear();
    }

    private static void updateRegistrationId() {
        String orgRegId = OneSignalStateSynchronizer.getRegistrationId();
        if (lastRegistrationId != null && !lastRegistrationId.equals(orgRegId)) {
            OneSignalStateSynchronizer.updateIdentifier(lastRegistrationId);
            OneSignal.fireIdsAvailableCallback();
        }
    }

    public static void setLogLevel(LOG_LEVEL inLogCatLevel, LOG_LEVEL inVisualLogLevel) {
        logCatLevel = inLogCatLevel;
        visualLogLevel = inVisualLogLevel;
    }

    public static void setLogLevel(int inLogCatLevel, int inVisualLogLevel) {
        OneSignal.setLogLevel(OneSignal.getLogLevel(inLogCatLevel), OneSignal.getLogLevel(inVisualLogLevel));
    }

    private static LOG_LEVEL getLogLevel(int level) {
        switch (level) {
            case 0: {
                return LOG_LEVEL.NONE;
            }
            case 1: {
                return LOG_LEVEL.FATAL;
            }
            case 2: {
                return LOG_LEVEL.ERROR;
            }
            case 3: {
                return LOG_LEVEL.WARN;
            }
            case 4: {
                return LOG_LEVEL.INFO;
            }
            case 5: {
                return LOG_LEVEL.DEBUG;
            }
            case 6: {
                return LOG_LEVEL.VERBOSE;
            }
        }
        if (level < 0) {
            return LOG_LEVEL.NONE;
        }
        return LOG_LEVEL.VERBOSE;
    }

    private static boolean atLogLevel(LOG_LEVEL level) {
        return level.compareTo(visualLogLevel) < 1 || level.compareTo(logCatLevel) < 1;
    }

    static void Log(LOG_LEVEL level, String message) {
        OneSignal.Log(level, message, null);
    }

    static void Log(final LOG_LEVEL level, String message, Throwable throwable) {
        if (level.compareTo(logCatLevel) < 1) {
            if (level == LOG_LEVEL.VERBOSE) {
                Log.v((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.DEBUG) {
                Log.d((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.INFO) {
                Log.i((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.WARN) {
                Log.w((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.ERROR || level == LOG_LEVEL.FATAL) {
                Log.e((String)TAG, (String)message, (Throwable)throwable);
            }
        }
        if (level.compareTo(visualLogLevel) < 1 && ActivityLifecycleHandler.curActivity != null) {
            try {
                String fullMessage = message + "\n";
                if (throwable != null) {
                    fullMessage = fullMessage + throwable.getMessage();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    fullMessage = fullMessage + sw.toString();
                }
                final String finalFullMessage = fullMessage;
                OneSignal.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (ActivityLifecycleHandler.curActivity != null) {
                            new AlertDialog.Builder((Context)ActivityLifecycleHandler.curActivity).setTitle((CharSequence)level.toString()).setMessage((CharSequence)finalFullMessage).show();
                        }
                    }
                });
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"Error showing logging message.", (Throwable)t);
            }
        }
    }

    private static void logHttpError(String errorString, int statusCode, Throwable throwable, String errorResponse) {
        String jsonError = "";
        if (errorResponse != null && OneSignal.atLogLevel(LOG_LEVEL.INFO)) {
            jsonError = "\n" + errorResponse + "\n";
        }
        OneSignal.Log(LOG_LEVEL.WARN, "HTTP code: " + statusCode + " " + errorString + jsonError, throwable);
    }

    public static void onPaused() {
        OneSignal.Log(LOG_LEVEL.INFO, "Deprecated! onPaused is now tracked automatically, please remove calls to OneSignal.onPaused() and OneSignal.onResume().");
    }

    static void onAppLostFocus(boolean onlySave) {
        foreground = false;
        if (!initDone) {
            return;
        }
        if (trackAmazonPurchase != null) {
            trackAmazonPurchase.checkListener();
        }
        if (lastTrackedTime == -1L) {
            return;
        }
        long time_elapsed = (long)((double)(SystemClock.elapsedRealtime() - lastTrackedTime) / 1000.0 + 0.5);
        lastTrackedTime = SystemClock.elapsedRealtime();
        if (time_elapsed < 0L || time_elapsed > 604800L) {
            return;
        }
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Android Context not found, please call OneSignal.init when your app starts.");
            return;
        }
        long unSentActiveTime = OneSignal.GetUnsentActiveTime();
        long totalTimeActive = unSentActiveTime + time_elapsed;
        if (onlySave || totalTimeActive < 60L || OneSignal.getUserId() == null) {
            OneSignal.SaveUnsentActiveTime(totalTimeActive);
            return;
        }
        OneSignal.sendOnFocus(totalTimeActive, true);
    }

    static void sendOnFocus(long totalTimeActive, boolean synchronous) {
        JSONObject jsonBody = new JSONObject();
        try {
            jsonBody.put("app_id", (Object)appId);
            jsonBody.put("state", (Object)"ping");
            jsonBody.put("active_time", totalTimeActive);
            OneSignal.addNetType(jsonBody);
            String url = "players/" + OneSignal.getUserId() + "/on_focus";
            OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OneSignal.logHttpError("sending on_focus Failed", statusCode, throwable, response);
                }

                @Override
                void onSuccess(String response) {
                    OneSignal.SaveUnsentActiveTime(0L);
                }
            };
            if (synchronous) {
                OneSignalRestClient.postSync(url, jsonBody, responseHandler);
            } else {
                OneSignalRestClient.post(url, jsonBody, responseHandler);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating on_focus:JSON Failed.", t);
        }
    }

    public static void onResumed() {
        OneSignal.Log(LOG_LEVEL.INFO, "Deprecated! onResumed is now tracked automatically, please remove calls to OneSignal.onPaused() and OneSignal.onResume().");
    }

    static void onAppFocus() {
        foreground = true;
        lastTrackedTime = SystemClock.elapsedRealtime();
        OneSignal.startRegistrationOrOnSession();
        if (trackGooglePurchase != null) {
            trackGooglePurchase.trackIAP();
        }
    }

    static boolean isForeground() {
        return foreground;
    }

    private static void addNetType(JSONObject jsonObj) {
        try {
            jsonObj.put("net_type", (Object)osUtils.getNetType());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int getTimeZoneOffset() {
        TimeZone timezone = Calendar.getInstance().getTimeZone();
        int offset = timezone.getRawOffset();
        if (timezone.inDaylightTime(new Date())) {
            offset += timezone.getDSTSavings();
        }
        return offset / 1000;
    }

    private static void registerUser() {
        OneSignal.Log(LOG_LEVEL.DEBUG, "registerUser: registerForPushFired:" + registerForPushFired + ", locationFired: " + locationFired);
        if (!registerForPushFired || !locationFired) {
            return;
        }
        if (ranSessionInitThread) {
            OneSignal.updateRegistrationId();
            return;
        }
        ranSessionInitThread = true;
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalStateSynchronizer.UserState userState = OneSignalStateSynchronizer.getNewUserState();
                String packageName = appContext.getPackageName();
                PackageManager packageManager = appContext.getPackageManager();
                userState.set("app_id", appId);
                userState.set("identifier", lastRegistrationId);
                String adId = mainAdIdProvider.getIdentifier(appContext);
                if (adId == null) {
                    adId = new AdvertisingIdProviderFallback().getIdentifier(appContext);
                }
                userState.set("ad_id", adId);
                userState.set("device_os", Build.VERSION.RELEASE);
                userState.set("timezone", OneSignal.getTimeZoneOffset());
                userState.set("language", Locale.getDefault().getLanguage());
                userState.set("sdk", OneSignal.VERSION);
                userState.set("sdk_type", sdkType);
                userState.set("android_package", packageName);
                userState.set("device_model", Build.MODEL);
                userState.set("device_type", deviceType);
                userState.setState("subscribableStatus", subscribableStatus);
                try {
                    userState.set("game_version", packageManager.getPackageInfo((String)packageName, (int)0).versionCode);
                }
                catch (PackageManager.NameNotFoundException e) {
                    // empty catch block
                }
                try {
                    List packList = packageManager.getInstalledPackages(0);
                    JSONArray pkgs = new JSONArray();
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    for (int i = 0; i < packList.size(); ++i) {
                        if ((((PackageInfo)packList.get((int)i)).applicationInfo.flags & 1) != 0 || packageName.equals(((PackageInfo)packList.get((int)i)).packageName)) continue;
                        md.update(((PackageInfo)packList.get((int)i)).packageName.getBytes());
                        pkgs.put((Object)Base64.encodeToString((byte[])md.digest(), (int)2));
                    }
                    userState.set("pkgs", pkgs);
                }
                catch (Throwable t) {
                    // empty catch block
                }
                SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
                String email = prefs.getString("OS_USER_EMAIL", null);
                if (email != null) {
                    userState.set("email", email);
                } else if (AndroidSupportV4Compat.ContextCompat.checkSelfPermission(appContext, "android.permission.GET_ACCOUNTS") == 0) {
                    Account[] accounts;
                    for (Account account : accounts = AccountManager.get((Context)appContext).getAccounts()) {
                        if (!Patterns.EMAIL_ADDRESS.matcher(account.name).matches()) continue;
                        userState.set("email", account.name);
                        break;
                    }
                }
                userState.set("net_type", osUtils.getNetType());
                userState.set("carrier", osUtils.getCarrierName());
                userState.set("rooted", RootToolsInternalMethods.isRooted());
                userState.set("lat", lastLocLat);
                userState.set("long", lastLocLong);
                userState.set("loc_acc", lastLocAcc);
                userState.set("loc_type", lastLocType);
                OneSignalStateSynchronizer.postSession(userState);
            }
        }).start();
    }

    public static void setEmail(String email) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You must initialize OneSignal before setting email! Omitting this operation.");
            return;
        }
        if (email != null && !"".equals(email)) {
            SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
            SharedPreferences.Editor editor = prefs.edit();
            editor.putString("OS_USER_EMAIL", email);
            editor.commit();
            OneSignalStateSynchronizer.setEmail(email);
        }
    }

    public static void sendTag(String key, String value) {
        try {
            OneSignal.sendTags(new JSONObject().put(key, (Object)value));
        }
        catch (JSONException t) {
            t.printStackTrace();
        }
    }

    public static void sendTags(String jsonString) {
        try {
            OneSignal.sendTags(new JSONObject(jsonString));
        }
        catch (JSONException t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating JSONObject for sendTags failed!", t);
        }
    }

    public static void sendTags(JSONObject keyValues) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You must initialize OneSignal before modifying tags! Omitting this tag operation.");
            return;
        }
        if (keyValues == null) {
            return;
        }
        JSONObject existingKeys = OneSignalStateSynchronizer.getTags((boolean)false).result;
        JSONObject toSend = new JSONObject();
        Iterator keys = keyValues.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = keyValues.get(key);
                if (value instanceof JSONArray || value instanceof JSONObject) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "Omitting key '" + key + "'! sendTags DO NOT supported nested values!");
                    continue;
                }
                if (keyValues.isNull(key) || "".equals(value)) {
                    if (!existingKeys.has(key)) continue;
                    toSend.put(key, (Object)"");
                    continue;
                }
                toSend.put(key, (Object)value.toString());
            }
            catch (Throwable t) {}
        }
        if (!toSend.toString().equals("{}")) {
            OneSignalStateSynchronizer.sendTags(toSend);
        }
    }

    public static void postNotification(String json, PostNotificationResponseHandler handler) {
        try {
            OneSignal.postNotification(new JSONObject(json), handler);
        }
        catch (JSONException e) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Invalid postNotification JSON format: " + json);
        }
    }

    public static void postNotification(JSONObject json, final PostNotificationResponseHandler handler) {
        block4: {
            try {
                json.put("app_id", (Object)OneSignal.getSavedAppId());
                OneSignalRestClient.post("notifications/", json, new OneSignalRestClient.ResponseHandler(){

                    @Override
                    public void onSuccess(String response) {
                        OneSignal.Log(LOG_LEVEL.DEBUG, "HTTP create notification success: " + (response != null ? response : "null"));
                        if (handler != null) {
                            try {
                                JSONObject jsonObject = new JSONObject(response);
                                if (jsonObject.has("errors")) {
                                    handler.onFailure(jsonObject);
                                } else {
                                    handler.onSuccess(new JSONObject(response));
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    }

                    @Override
                    void onFailure(int statusCode, String response, Throwable throwable) {
                        OneSignal.logHttpError("create notification failed", statusCode, throwable, response);
                        if (statusCode == 0) {
                            response = "{'error': 'HTTP no response error'}";
                        }
                        if (handler != null) {
                            try {
                                handler.onFailure(new JSONObject(response));
                            }
                            catch (Throwable t) {
                                handler.onFailure(null);
                            }
                        }
                    }
                });
            }
            catch (JSONException e) {
                OneSignal.Log(LOG_LEVEL.ERROR, "HTTP create notification json exception!", e);
                if (handler == null) break block4;
                try {
                    handler.onFailure(new JSONObject("{'error': 'HTTP create notification json exception!'}"));
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void getTags(GetTagsHandler getTagsHandler) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You must initialize OneSignal before getting tags! Omitting this tag operation.");
            return;
        }
        if (getTagsHandler == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "getTagsHandler is null!");
            return;
        }
        if (OneSignal.getUserId() == null) {
            pendingGetTagsHandler = getTagsHandler;
            return;
        }
        OneSignal.internalFireGetTagsCallback(getTagsHandler);
    }

    private static void internalFireGetTagsCallback(final GetTagsHandler getTagsHandler) {
        if (getTagsHandler == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalStateSynchronizer.GetTagsResult tags = OneSignalStateSynchronizer.getTags(!getTagsCall);
                if (tags.serverSuccess) {
                    getTagsCall = true;
                }
                if (tags.result == null || tags.toString().equals("{}")) {
                    getTagsHandler.tagsAvailable(null);
                } else {
                    getTagsHandler.tagsAvailable(tags.result);
                }
            }
        }).start();
    }

    public static void deleteTag(String key) {
        ArrayList<String> tempList = new ArrayList<String>(1);
        tempList.add(key);
        OneSignal.deleteTags(tempList);
    }

    public static void deleteTags(Collection<String> keys) {
        try {
            JSONObject jsonTags = new JSONObject();
            for (String key : keys) {
                jsonTags.put(key, (Object)"");
            }
            OneSignal.sendTags(jsonTags);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void deleteTags(String jsonArrayString) {
        try {
            JSONObject jsonTags = new JSONObject();
            JSONArray jsonArray = new JSONArray(jsonArrayString);
            for (int i = 0; i < jsonArray.length(); ++i) {
                jsonTags.put(jsonArray.getString(i), (Object)"");
            }
            OneSignal.sendTags(jsonTags);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void idsAvailable(IdsAvailableHandler inIdsAvailableHandler) {
        idsAvailableHandler = inIdsAvailableHandler;
        if (OneSignal.getUserId() != null) {
            OneSignal.internalFireIdsAvailableCallback();
        }
    }

    static void fireIdsAvailableCallback() {
        if (idsAvailableHandler != null) {
            OneSignal.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    OneSignal.internalFireIdsAvailableCallback();
                }
            });
        }
    }

    private static void internalFireIdsAvailableCallback() {
        String userId;
        if (idsAvailableHandler == null) {
            return;
        }
        String regId = OneSignalStateSynchronizer.getRegistrationId();
        if (!OneSignalStateSynchronizer.getSubscribed()) {
            regId = null;
        }
        if ((userId = OneSignal.getUserId()) == null) {
            return;
        }
        idsAvailableHandler.idsAvailable(userId, regId);
        if (regId != null) {
            idsAvailableHandler = null;
        }
    }

    static void sendPurchases(JSONArray purchases, boolean newAsExisting, OneSignalRestClient.ResponseHandler responseHandler) {
        if (OneSignal.getUserId() == null) {
            return;
        }
        try {
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("app_id", (Object)appId);
            if (newAsExisting) {
                jsonBody.put("existing", true);
            }
            jsonBody.put("purchases", (Object)purchases);
            OneSignalRestClient.post("players/" + OneSignal.getUserId() + "/on_purchase", jsonBody, responseHandler);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for sendPurchases.", t);
        }
    }

    private static boolean openURLFromNotification(Context context, JSONArray dataArray) {
        int jsonArraySize = dataArray.length();
        boolean urlOpened = false;
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                JSONObject customJSON;
                JSONObject data = dataArray.getJSONObject(i);
                if (!data.has("custom") || !(customJSON = new JSONObject(data.getString("custom"))).has("u")) continue;
                String url = customJSON.getString("u");
                if (!url.contains("://")) {
                    url = "http://" + url;
                }
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                intent.addFlags(0x58080000);
                context.startActivity(intent);
                urlOpened = true;
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Error parsing JSON item " + i + "/" + jsonArraySize + " for launching a web URL.", t);
            }
        }
        return urlOpened;
    }

    private static void runNotificationOpenedCallback(JSONArray dataArray, boolean isActive) {
        if (notificationOpenedHandler == null) {
            unprocessedOpenedNotifis.add(dataArray);
            return;
        }
        int jsonArraySize = dataArray.length();
        JSONObject completeAdditionalData = null;
        String firstMessage = null;
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                JSONObject data = dataArray.getJSONObject(i);
                JSONObject additionalDataJSON = null;
                if (data.has("custom")) {
                    JSONObject customJSON = new JSONObject(data.getString("custom"));
                    additionalDataJSON = new JSONObject();
                    if (customJSON.has("a")) {
                        additionalDataJSON = customJSON.getJSONObject("a");
                    }
                    if (data.has("title")) {
                        additionalDataJSON.put("title", (Object)data.getString("title"));
                    }
                    if (customJSON.has("u")) {
                        additionalDataJSON.put("launchURL", (Object)customJSON.getString("u"));
                    }
                    if (data.has("sound")) {
                        additionalDataJSON.put("sound", (Object)data.getString("sound"));
                    }
                    if (data.has("sicon")) {
                        additionalDataJSON.put("smallIcon", (Object)data.getString("sicon"));
                    }
                    if (data.has("licon")) {
                        additionalDataJSON.put("largeIcon", (Object)data.getString("licon"));
                    }
                    if (data.has("bicon")) {
                        additionalDataJSON.put("bigPicture", (Object)data.getString("bicon"));
                    }
                    if (additionalDataJSON.equals(new JSONObject())) {
                        additionalDataJSON = null;
                    }
                }
                if (firstMessage == null) {
                    completeAdditionalData = additionalDataJSON;
                    firstMessage = data.getString("alert");
                    continue;
                }
                if (completeAdditionalData == null) {
                    completeAdditionalData = new JSONObject();
                }
                if (!completeAdditionalData.has("stacked_notifications")) {
                    completeAdditionalData.put("stacked_notifications", (Object)new JSONArray());
                }
                additionalDataJSON.put("message", (Object)data.getString("alert"));
                completeAdditionalData.getJSONArray("stacked_notifications").put((Object)additionalDataJSON);
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Error parsing JSON item " + i + "/" + jsonArraySize + " for callback.", t);
            }
        }
        OneSignal.fireNotificationOpenedHandler(firstMessage, completeAdditionalData, isActive);
    }

    private static void fireNotificationOpenedHandler(final String message, final JSONObject additionalDataJSON, final boolean isActive) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            notificationOpenedHandler.notificationOpened(message, additionalDataJSON, isActive);
        } else {
            OneSignal.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    notificationOpenedHandler.notificationOpened(message, additionalDataJSON, isActive);
                }
            });
        }
    }

    static void handleNotificationOpened(JSONArray data) {
        OneSignal.sendNotificationOpened(appContext, data);
        OneSignal.runNotificationOpenedCallback(data, true);
    }

    public static void handleNotificationOpened(Context inContext, JSONArray data, boolean fromAlert) {
        OneSignal.sendNotificationOpened(inContext, data);
        boolean urlOpened = false;
        boolean defaultOpenActionDisabled = "DISABLE".equals(OSUtils.getManifestMeta(inContext, "com.onesignal.NotificationOpened.DEFAULT"));
        if (!defaultOpenActionDisabled) {
            urlOpened = OneSignal.openURLFromNotification(inContext, data);
        }
        OneSignal.runNotificationOpenedCallback(data, false);
        if (!fromAlert && !urlOpened) {
            OneSignal.fireIntentFromNotificationOpen(inContext, data, defaultOpenActionDisabled);
        }
    }

    private static void fireIntentFromNotificationOpen(Context inContext, JSONArray data, boolean defaultOpenActionDisabled) {
        Intent launchIntent;
        PackageManager packageManager = inContext.getPackageManager();
        boolean isCustom = false;
        Intent intent = new Intent().setAction("com.onesignal.NotificationOpened.RECEIVE").setPackage(inContext.getPackageName());
        List resolveInfo = packageManager.queryBroadcastReceivers(intent, 32);
        if (resolveInfo.size() > 0) {
            intent.putExtra("onesignal_data", data.toString());
            inContext.sendBroadcast(intent);
            isCustom = true;
        }
        if ((resolveInfo = packageManager.queryIntentActivities(intent, 65536)).size() > 0) {
            if (!isCustom) {
                intent.putExtra("onesignal_data", data.toString());
            }
            isCustom = true;
            intent.setFlags(0x10020000);
            inContext.startActivity(intent);
        }
        if (!isCustom && !defaultOpenActionDisabled && (launchIntent = inContext.getPackageManager().getLaunchIntentForPackage(inContext.getPackageName())) != null) {
            launchIntent.setFlags(0x10020000);
            inContext.startActivity(launchIntent);
        }
    }

    private static void sendNotificationOpened(Context inContext, JSONArray dataArray) {
        for (int i = 0; i < dataArray.length(); ++i) {
            try {
                JSONObject customJson;
                JSONObject data = dataArray.getJSONObject(i);
                if (!data.has("custom") || !(customJson = new JSONObject(data.getString("custom"))).has("i")) continue;
                String notificationId = customJson.getString("i");
                JSONObject jsonBody = new JSONObject();
                jsonBody.put("app_id", (Object)OneSignal.getSavedAppId(inContext));
                jsonBody.put("player_id", (Object)OneSignal.getSavedUserId(inContext));
                jsonBody.put("opened", true);
                OneSignalRestClient.put("notifications/" + notificationId, jsonBody, new OneSignalRestClient.ResponseHandler(){

                    @Override
                    void onFailure(int statusCode, String response, Throwable throwable) {
                        OneSignal.logHttpError("sending Notification Opened Failed", statusCode, throwable, response);
                    }
                });
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON to send notification opened.", t);
            }
        }
    }

    private static void SaveAppId(String appId) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("GT_APP_ID", appId);
        editor.commit();
    }

    static String getSavedAppId() {
        return OneSignal.getSavedAppId(appContext);
    }

    private static String getSavedAppId(Context inContext) {
        if (inContext == null) {
            return "";
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(inContext);
        return prefs.getString("GT_APP_ID", null);
    }

    private static String getSavedUserId(Context inContext) {
        if (inContext == null) {
            return "";
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(inContext);
        return prefs.getString("GT_PLAYER_ID", null);
    }

    static String getUserId() {
        if (userId == null && appContext != null) {
            SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
            userId = prefs.getString("GT_PLAYER_ID", null);
        }
        return userId;
    }

    static void saveUserId(String inUserId) {
        userId = inUserId;
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("GT_PLAYER_ID", userId);
        editor.commit();
    }

    static void updateUserIdDependents(String userId) {
        OneSignal.saveUserId(userId);
        OneSignal.fireIdsAvailableCallback();
        OneSignal.internalFireGetTagsCallback(pendingGetTagsHandler);
    }

    public static void enableVibrate(boolean enable) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("GT_VIBRATE_ENABLED", enable);
        editor.commit();
    }

    static boolean getVibrate(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getBoolean("GT_VIBRATE_ENABLED", true);
    }

    public static void enableSound(boolean enable) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("GT_SOUND_ENABLED", enable);
        editor.commit();
    }

    static boolean getSoundEnabled(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getBoolean("GT_SOUND_ENABLED", true);
    }

    public static void enableNotificationsWhenActive(boolean enable) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("ONESIGNAL_ALWAYS_SHOW_NOTIF", enable);
        editor.commit();
    }

    static boolean getNotificationsWhenActiveEnabled(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getBoolean("ONESIGNAL_ALWAYS_SHOW_NOTIF", false);
    }

    public static void enableInAppAlertNotification(boolean enable) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("ONESIGNAL_INAPP_ALERT", enable);
        editor.commit();
    }

    static boolean getInAppAlertNotificationEnabled(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getBoolean("ONESIGNAL_INAPP_ALERT", false);
    }

    public static void setSubscription(boolean enable) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not set subscription.");
            return;
        }
        OneSignalStateSynchronizer.setSubscription(enable);
    }

    public static void promptLocation() {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not prompt for location.");
            return;
        }
        LocationGMS.getLocation(appContext, true, new LocationGMS.LocationHandler(){

            @Override
            public void complete(Double lat, Double log, Float accuracy, Integer type) {
                if (lat != null && log != null) {
                    OneSignalStateSynchronizer.updateLocation(lat, log, accuracy, type);
                }
            }
        });
    }

    public static void removeNotificationOpenedHandler() {
        notificationOpenedHandler = null;
    }

    static long GetUnsentActiveTime() {
        if (unSentActiveTime == -1L && appContext != null) {
            SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
            unSentActiveTime = prefs.getLong("GT_UNSENT_ACTIVE_TIME", 0L);
        }
        OneSignal.Log(LOG_LEVEL.INFO, "GetUnsentActiveTime: " + unSentActiveTime);
        return unSentActiveTime;
    }

    private static void SaveUnsentActiveTime(long time) {
        unSentActiveTime = time;
        if (appContext == null) {
            return;
        }
        OneSignal.Log(LOG_LEVEL.INFO, "SaveUnsentActiveTime: " + unSentActiveTime);
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong("GT_UNSENT_ACTIVE_TIME", time);
        editor.commit();
    }

    static SharedPreferences getGcmPreferences(Context context) {
        return context.getSharedPreferences(OneSignal.class.getSimpleName(), 0);
    }

    static boolean isDuplicateNotification(String id, Context context) {
        if (id == null || "".equals(id)) {
            return false;
        }
        OneSignalDbHelper dbHelper = new OneSignalDbHelper(context);
        SQLiteDatabase readableDb = dbHelper.getReadableDatabase();
        String[] retColumn = new String[]{"notification_id"};
        String[] whereArgs = new String[]{id};
        Cursor cursor = readableDb.query("notification", retColumn, "notification_id = ?", whereArgs, null, null, null);
        boolean exists = cursor.moveToFirst();
        cursor.close();
        readableDb.close();
        if (exists) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Duplicate GCM message received, skipping processing. " + id);
            return true;
        }
        return false;
    }

    static void runOnUiThread(Runnable action) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(action);
    }

    static boolean notValidOrDuplicated(Context context, Bundle bundle) {
        String id = OneSignal.getNotificationIdFromGCMBundle(bundle);
        return id == null || OneSignal.isDuplicateNotification(id, context);
    }

    static String getNotificationIdFromGCMBundle(Bundle bundle) {
        if (bundle.isEmpty()) {
            return null;
        }
        try {
            if (bundle.containsKey("custom")) {
                JSONObject customJSON = new JSONObject(bundle.getString("custom"));
                if (customJSON.has("i")) {
                    return customJSON.optString("i", null);
                }
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted GCM message. No 'i' field in custom.");
            } else {
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted GCM message. No 'custom' field in the bundle.");
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Could not parse bundle, probably not a OneSignal notification.", t);
        }
        return null;
    }

    static boolean isAppActive() {
        return initDone && OneSignal.isForeground();
    }

    static {
        visualLogLevel = LOG_LEVEL.NONE;
        logCatLevel = LOG_LEVEL.WARN;
        userId = null;
        subscribableStatus = 1;
        lastTrackedTime = 1L;
        unSentActiveTime = -1L;
        mainAdIdProvider = new AdvertisingIdProviderGPS();
        sdkType = "native";
        unprocessedOpenedNotifis = new ArrayList<JSONArray>();
    }

    public static class Builder {
        Context mContext;
        NotificationOpenedHandler mNotificationOpenedHandler;
        boolean mPromptLocation;

        private Builder() {
        }

        private Builder(Context context) {
            this.mContext = context;
        }

        public Builder setNotificationOpenedHandler(NotificationOpenedHandler handler) {
            this.mNotificationOpenedHandler = handler;
            return this;
        }

        public Builder setAutoPromptLocation(boolean enable) {
            this.mPromptLocation = enable;
            return this;
        }

        public void init() {
            OneSignal.init(this);
        }
    }

    public static interface PostNotificationResponseHandler {
        public void onSuccess(JSONObject var1);

        public void onFailure(JSONObject var1);
    }

    public static interface GetTagsHandler {
        public void tagsAvailable(JSONObject var1);
    }

    public static interface IdsAvailableHandler {
        public void idsAvailable(String var1, String var2);
    }

    public static interface NotificationOpenedHandler {
        public void notificationOpened(String var1, JSONObject var2, boolean var3);
    }

    public static enum LOG_LEVEL {
        NONE,
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        VERBOSE;

    }
}

