/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.support.v4.content.WakefulBroadcastReceiver;
import com.onesignal.BackgroundBroadcaster;
import com.onesignal.GcmIntentService;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationExtenderService;
import com.onesignal.OneSignal;

public class GcmBroadcastReceiver
extends WakefulBroadcastReceiver {
    private static final String GCM_RECEIVE = "com.google.android.c2dm.intent.RECEIVE";
    private static final String GCM_TYPE = "gcm";

    private static boolean isGcmMessage(Intent intent) {
        if (GCM_RECEIVE.equals(intent.getAction())) {
            String messageType = intent.getStringExtra("message_type");
            return messageType == null || GCM_TYPE.equals(messageType);
        }
        return false;
    }

    public void onReceive(Context context, Intent intent) {
        Bundle bundle = intent.getExtras();
        if (bundle == null || "google.com/iid".equals(bundle.getString("from"))) {
            return;
        }
        GcmBroadcastReceiver.processOrderBroadcast(context, intent, bundle);
        this.setResultCode(-1);
    }

    private static void processOrderBroadcast(Context context, Intent intent, Bundle bundle) {
        if (!GcmBroadcastReceiver.isGcmMessage(intent)) {
            return;
        }
        if (GcmBroadcastReceiver.processBundle(context, bundle)) {
            return;
        }
        Intent intentForService = new Intent();
        intentForService.putExtra("json_payload", NotificationBundleProcessor.bundleAsJSONObject(bundle).toString());
        intentForService.setComponent(new ComponentName(context.getPackageName(), GcmIntentService.class.getName()));
        GcmBroadcastReceiver.startWakefulService((Context)context, (Intent)intentForService);
    }

    static boolean processBundle(Context context, final Bundle bundle) {
        if (OneSignal.getNotificationIdFromGCMBundle(bundle) == null) {
            return true;
        }
        NotificationBundleProcessor.prepareBundle(bundle);
        boolean showAsAlert = OneSignal.getInAppAlertNotificationEnabled(context);
        boolean isActive = OneSignal.isAppActive();
        boolean display = OneSignal.getNotificationsWhenActiveEnabled(context) || showAsAlert || !isActive;
        BackgroundBroadcaster.Invoke(context, bundle, isActive);
        Intent overrideIntent = NotificationExtenderService.getIntent(context);
        if (overrideIntent != null) {
            overrideIntent.putExtra("json_payload", NotificationBundleProcessor.bundleAsJSONObject(bundle).toString());
            GcmBroadcastReceiver.startWakefulService((Context)context, (Intent)overrideIntent);
            return true;
        }
        if (bundle.getString("alert") == null || "".equals(bundle.getString("alert"))) {
            return true;
        }
        if (!display) {
            new Thread(new Runnable(){

                @Override
                public void run() {
                    OneSignal.handleNotificationOpened(NotificationBundleProcessor.bundleAsJsonArray(bundle));
                }
            }).start();
            NotificationBundleProcessor.saveNotification(context, bundle, true, -1);
            return true;
        }
        return false;
    }
}

