/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.PendingIntent;
import android.content.Context;
import android.content.DialogInterface;
import android.content.SharedPreferences;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import com.google.android.gms.common.GooglePlayServicesUtil;
import com.google.android.gms.gcm.GoogleCloudMessaging;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.PushRegistrator;
import java.io.IOException;

public class PushRegistratorGPS
implements PushRegistrator {
    private Context appContext;
    private PushRegistrator.RegisteredHandler registeredHandler;
    private static int GCM_RETRY_COUNT = 5;

    @Override
    public void registerForPush(Context context, String googleProjectNumber, PushRegistrator.RegisteredHandler callback) {
        this.appContext = context;
        this.registeredHandler = callback;
        try {
            if (this.isGMSInstalledAndEnabled()) {
                this.registerInBackground(googleProjectNumber);
            } else {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "'Google Play services' app not installed or disabled on the device.");
                this.registeredHandler.complete(null, -7);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Could not register with GCM due to an error with the AndroidManifest.xml file or with 'Google Play services'.", t);
            this.registeredHandler.complete(null, -8);
        }
    }

    private boolean isGooglePlayStoreInstalled() {
        try {
            PackageManager pm = this.appContext.getPackageManager();
            PackageInfo info = pm.getPackageInfo("com.android.vending", 1);
            String label = (String)info.applicationInfo.loadLabel(pm);
            return label != null && !label.equals("Market");
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private boolean isGMSInstalledAndEnabled() {
        try {
            PackageManager pm = this.appContext.getPackageManager();
            PackageInfo info = pm.getPackageInfo("com.google.android.gms", 1);
            if (!info.applicationInfo.enabled && this.isGooglePlayStoreInstalled()) {
                SharedPreferences prefs = OneSignal.getGcmPreferences(this.appContext);
                if (prefs.getBoolean("GT_DO_NOT_SHOW_MISSING_GPS", false)) {
                    return false;
                }
                try {
                    this.ShowUpdateGPSDialog();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            return info.applicationInfo.enabled;
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            return false;
        }
    }

    private void ShowUpdateGPSDialog() {
        OneSignal.runOnUiThread(new Runnable(){

            @Override
            public void run() {
                final Activity activity = ActivityLifecycleHandler.curActivity;
                if (activity == null || OneSignal.mInitBuilder.mDisableGmsMissingPrompt) {
                    return;
                }
                String alertBodyText = OSUtils.getResourceString((Context)activity, "onesignal_gms_missing_alert_text", "To receive push notifications please press 'Update' to enable 'Google Play services'.");
                String alertButtonUpdate = OSUtils.getResourceString((Context)activity, "onesignal_gms_missing_alert_button_update", "Update");
                String alertButtonSkip = OSUtils.getResourceString((Context)activity, "onesignal_gms_missing_alert_button_skip", "Skip");
                String alertButtonClose = OSUtils.getResourceString((Context)activity, "onesignal_gms_missing_alert_button_close", "Close");
                AlertDialog.Builder builder = new AlertDialog.Builder((Context)activity);
                builder.setMessage((CharSequence)alertBodyText).setPositiveButton((CharSequence)alertButtonUpdate, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        try {
                            int resultCode = GooglePlayServicesUtil.isGooglePlayServicesAvailable((Context)PushRegistratorGPS.this.appContext);
                            GooglePlayServicesUtil.getErrorPendingIntent((int)resultCode, (Context)activity, (int)0).send();
                        }
                        catch (PendingIntent.CanceledException resultCode) {
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }).setNegativeButton((CharSequence)alertButtonSkip, new DialogInterface.OnClickListener(){

                    public void onClick(DialogInterface dialog, int which) {
                        SharedPreferences prefs = OneSignal.getGcmPreferences((Context)activity);
                        SharedPreferences.Editor editor = prefs.edit();
                        editor.putBoolean("GT_DO_NOT_SHOW_MISSING_GPS", true);
                        editor.commit();
                    }
                }).setNeutralButton((CharSequence)alertButtonClose, null).create().show();
            }
        });
    }

    private void registerInBackground(final String googleProjectNumber) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                boolean firedComplete = false;
                for (int currentRetry = 0; currentRetry < GCM_RETRY_COUNT; ++currentRetry) {
                    try {
                        GoogleCloudMessaging gcm = GoogleCloudMessaging.getInstance((Context)PushRegistratorGPS.this.appContext);
                        String registrationId = gcm.register(new String[]{googleProjectNumber});
                        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Device registered, Google Registration ID = " + registrationId);
                        PushRegistratorGPS.this.registeredHandler.complete(registrationId, 1);
                        break;
                    }
                    catch (IOException e) {
                        if (!"SERVICE_NOT_AVAILABLE".equals(e.getMessage())) {
                            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error Getting Google Registration ID", e);
                            if (firedComplete) break;
                            PushRegistratorGPS.this.registeredHandler.complete(null, -11);
                            break;
                        }
                        if (currentRetry >= GCM_RETRY_COUNT - 1) {
                            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "GCM_RETRY_COUNT of " + GCM_RETRY_COUNT + " exceed! Could not get a Google Registration Id", e);
                            continue;
                        }
                        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Google Play services returned SERVICE_NOT_AVAILABLE error. Current retry count: " + currentRetry, e);
                        if (currentRetry == 2) {
                            PushRegistratorGPS.this.registeredHandler.complete(null, -9);
                            firedComplete = true;
                        }
                        try {
                            Thread.sleep(10000 * (currentRetry + 1));
                        }
                        catch (Throwable throwable) {}
                        continue;
                    }
                    catch (Throwable t) {
                        OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error Getting Google Registration ID", t);
                        PushRegistratorGPS.this.registeredHandler.complete(null, -12);
                        break;
                    }
                }
            }
        }).start();
    }
}

