/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public class OSNotificationPayload {
    public String notificationID;
    public String templateName;
    public String templateId;
    public String title;
    public String body;
    public JSONObject additionalData;
    public String smallIcon;
    public String largeIcon;
    public String bigPicture;
    public String smallIconAccentColor;
    public String launchURL;
    public String sound;
    public String ledColor;
    public int lockScreenVisibility = 1;
    public String groupKey;
    public String groupMessage;
    public List<ActionButton> actionButtons;
    public String fromProjectNumber;
    public BackgroundImageLayout backgroundImageLayout;
    public String collapseId;
    public int priority;
    public String rawPayload;

    public OSNotificationPayload() {
    }

    public OSNotificationPayload(JSONObject jsonObject) {
        this.notificationID = jsonObject.optString("notificationID");
        this.title = jsonObject.optString("title");
        this.body = jsonObject.optString("body");
        this.additionalData = jsonObject.optJSONObject("additionalData");
        this.smallIcon = jsonObject.optString("smallIcon");
        this.largeIcon = jsonObject.optString("largeIcon");
        this.bigPicture = jsonObject.optString("bigPicture");
        this.smallIconAccentColor = jsonObject.optString("smallIconAccentColor");
        this.launchURL = jsonObject.optString("launchURL");
        this.sound = jsonObject.optString("sound");
        this.ledColor = jsonObject.optString("ledColor");
        this.lockScreenVisibility = jsonObject.optInt("lockScreenVisibility");
        this.groupKey = jsonObject.optString("groupKey");
        this.groupMessage = jsonObject.optString("groupMessage");
        if (jsonObject.has("actionButtons")) {
            this.actionButtons = new ArrayList<ActionButton>();
            JSONArray jsonArray = jsonObject.optJSONArray("actionButtons");
            for (int i = 0; i < jsonArray.length(); ++i) {
                this.actionButtons.add(new ActionButton(jsonArray.optJSONObject(i)));
            }
        }
        this.fromProjectNumber = jsonObject.optString("fromProjectNumber");
        this.collapseId = jsonObject.optString("collapseId");
        this.priority = jsonObject.optInt("priority");
        this.rawPayload = jsonObject.optString("rawPayload");
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put("notificationID", (Object)this.notificationID);
            json.put("title", (Object)this.title);
            json.put("body", (Object)this.body);
            if (this.additionalData != null) {
                json.put("additionalData", (Object)this.additionalData);
            }
            json.put("smallIcon", (Object)this.smallIcon);
            json.put("largeIcon", (Object)this.largeIcon);
            json.put("bigPicture", (Object)this.bigPicture);
            json.put("smallIconAccentColor", (Object)this.smallIconAccentColor);
            json.put("launchURL", (Object)this.launchURL);
            json.put("sound", (Object)this.sound);
            json.put("ledColor", (Object)this.ledColor);
            json.put("lockScreenVisibility", this.lockScreenVisibility);
            json.put("groupKey", (Object)this.groupKey);
            json.put("groupMessage", (Object)this.groupMessage);
            if (this.actionButtons != null) {
                JSONArray actionButtonJsonArray = new JSONArray();
                for (ActionButton actionButton : this.actionButtons) {
                    actionButtonJsonArray.put((Object)actionButton.toJSONObject());
                }
                json.put("actionButtons", (Object)actionButtonJsonArray);
            }
            json.put("fromProjectNumber", (Object)this.fromProjectNumber);
            json.put("collapseId", (Object)this.collapseId);
            json.put("priority", this.priority);
            json.put("rawPayload", (Object)this.rawPayload);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return json;
    }

    public static class BackgroundImageLayout {
        public String image;
        public String titleTextColor;
        public String bodyTextColor;
    }

    public static class ActionButton {
        public String id;
        public String text;
        public String icon;

        public ActionButton() {
        }

        public ActionButton(JSONObject jsonObject) {
            this.id = jsonObject.optString("id");
            this.text = jsonObject.optString("text");
            this.icon = jsonObject.optString("icon");
        }

        public JSONObject toJSONObject() {
            JSONObject json = new JSONObject();
            try {
                json.put("id", (Object)this.id);
                json.put("text", (Object)this.text);
                json.put("icon", (Object)this.icon);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return json;
        }
    }
}

