/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ComponentName;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.customtabs.CustomTabsClient;
import android.support.customtabs.CustomTabsIntent;
import android.support.customtabs.CustomTabsServiceConnection;
import android.support.customtabs.CustomTabsSession;
import com.onesignal.OneSignal;

class OneSignalChromeTab {
    OneSignalChromeTab() {
    }

    private static boolean hasChromeTabLibrary() {
        try {
            return CustomTabsServiceConnection.class != null;
        }
        catch (Throwable e) {
            return false;
        }
    }

    protected static boolean open(String url, boolean openActivity) {
        if (!OneSignalChromeTab.hasChromeTabLibrary()) {
            return false;
        }
        OneSignalCustomTabsServiceConnection connection = new OneSignalCustomTabsServiceConnection(url, openActivity);
        return CustomTabsClient.bindCustomTabsService((Context)OneSignal.appContext, (String)"com.android.chrome", (CustomTabsServiceConnection)connection);
    }

    private static class OneSignalCustomTabsServiceConnection
    extends CustomTabsServiceConnection {
        private String url;
        private boolean openActivity;

        OneSignalCustomTabsServiceConnection(@NonNull String url, boolean openActivity) {
            this.url = url;
            this.openActivity = openActivity;
        }

        public void onCustomTabsServiceConnected(ComponentName componentName, CustomTabsClient customTabsClient) {
            if (customTabsClient == null) {
                return;
            }
            customTabsClient.warmup(0L);
            CustomTabsSession session = customTabsClient.newSession(null);
            if (session == null) {
                return;
            }
            Uri uri = Uri.parse((String)this.url);
            session.mayLaunchUrl(uri, null, null);
            if (this.openActivity) {
                CustomTabsIntent.Builder mBuilder = new CustomTabsIntent.Builder(session);
                CustomTabsIntent customTabsIntent = mBuilder.build();
                customTabsIntent.intent.setData(uri);
                customTabsIntent.intent.addFlags(0x10000000);
                if (Build.VERSION.SDK_INT >= 16) {
                    OneSignal.appContext.startActivity(customTabsIntent.intent, customTabsIntent.startAnimationBundle);
                } else {
                    OneSignal.appContext.startActivity(customTabsIntent.intent);
                }
            }
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    }
}

