/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.ComponentName;
import android.content.Context;
import android.content.pm.PackageManager;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.iid.FirebaseInstanceId;
import com.google.firebase.iid.FirebaseInstanceIdService;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.PushRegistratorAbstractGoogle;

class PushRegistratorFCM
extends PushRegistratorAbstractGoogle {
    private static final String FCM_APP_NAME = "ONESIGNAL_SDK_FCM_APP_NAME";
    private FirebaseApp firebaseApp;

    PushRegistratorFCM() {
    }

    static void disableFirebaseInstanceIdService(Context context) {
        String senderId = OSUtils.getResourceString(context, "gcm_defaultSenderId", null);
        int componentState = senderId == null ? 2 : 1;
        PackageManager pm = context.getPackageManager();
        try {
            ComponentName componentName = new ComponentName(context, FirebaseInstanceIdService.class);
            pm.setComponentEnabledSetting(componentName, componentState, 1);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Override
    String getProviderName() {
        return "FCM";
    }

    @Override
    String getToken(String senderId) throws Throwable {
        this.initFirebaseApp(senderId);
        FirebaseInstanceId instanceId = FirebaseInstanceId.getInstance((FirebaseApp)this.firebaseApp);
        return instanceId.getToken(senderId, "FCM");
    }

    private void initFirebaseApp(String senderId) {
        if (this.firebaseApp != null) {
            return;
        }
        FirebaseOptions firebaseOptions = new FirebaseOptions.Builder().setGcmSenderId(senderId).setApplicationId("OMIT_ID").setApiKey("OMIT_KEY").build();
        this.firebaseApp = FirebaseApp.initializeApp((Context)OneSignal.appContext, (FirebaseOptions)firebaseOptions, (String)FCM_APP_NAME);
    }
}

