/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.onesignal.OSSessionManager;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OneSignalSyncServiceUtils;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

class FocusTimeController {
    @Nullable
    private Long timeFocusedAtMs;
    private static FocusTimeController sInstance;
    private List<FocusTimeProcessorBase> focusTimeProcessors = Arrays.asList(new FocusTimeProcessorUnattributed(), new FocusTimeProcessorAttributed());

    private FocusTimeController() {
    }

    public static synchronized FocusTimeController getInstance() {
        if (sInstance == null) {
            sInstance = new FocusTimeController();
        }
        return sInstance;
    }

    void appForegrounded() {
        this.timeFocusedAtMs = SystemClock.elapsedRealtime();
    }

    void appBackgrounded() {
        this.giveProcessorsValidFocusTime(OneSignal.getSessionManager().getSessionResult(), FocusEventType.BACKGROUND);
        this.timeFocusedAtMs = null;
    }

    void onSessionEnded(@NonNull OSSessionManager.SessionResult lastSessionResult) {
        FocusEventType focusEventType = FocusEventType.END_SESSION;
        boolean hadValidTime = this.giveProcessorsValidFocusTime(lastSessionResult, focusEventType);
        if (!hadValidTime) {
            for (FocusTimeProcessorBase focusTimeProcessor : this.focusTimeProcessors) {
                focusTimeProcessor.sendUnsentTimeNow(focusEventType);
            }
        }
    }

    void doBlockingBackgroundSyncOfUnsentTime() {
        if (OneSignal.isForeground()) {
            return;
        }
        for (FocusTimeProcessorBase focusTimeProcessor : this.focusTimeProcessors) {
            focusTimeProcessor.syncUnsentTimeFromSyncJob();
        }
    }

    private boolean giveProcessorsValidFocusTime(@NonNull OSSessionManager.SessionResult lastSessionResult, @NonNull FocusEventType focusType) {
        Long timeElapsed = this.getTimeFocusedElapsed();
        if (timeElapsed == null) {
            return false;
        }
        for (FocusTimeProcessorBase focusTimeProcessor : this.focusTimeProcessors) {
            focusTimeProcessor.addTime(timeElapsed, lastSessionResult.session, focusType);
        }
        return true;
    }

    @Nullable
    private Long getTimeFocusedElapsed() {
        if (this.timeFocusedAtMs == null) {
            return null;
        }
        long timeElapsed = (long)((double)(SystemClock.elapsedRealtime() - this.timeFocusedAtMs) / 1000.0 + 0.5);
        if (timeElapsed < 1L || timeElapsed > 86400L) {
            return null;
        }
        return timeElapsed;
    }

    private static abstract class FocusTimeProcessorBase {
        protected long MIN_ON_FOCUS_TIME_SEC;
        @NonNull
        protected String PREF_KEY_FOR_UNSENT_TIME;
        @Nullable
        private Long unsentActiveTime = null;
        @NonNull
        private final AtomicBoolean runningOnFocusTime = new AtomicBoolean();

        private FocusTimeProcessorBase() {
        }

        protected abstract boolean timeTypeApplies(@NonNull OSSessionManager.Session var1);

        protected abstract void sendTime(@NonNull FocusEventType var1);

        private long getUnsentActiveTime() {
            if (this.unsentActiveTime == null) {
                this.unsentActiveTime = OneSignalPrefs.getLong(OneSignalPrefs.PREFS_ONESIGNAL, this.PREF_KEY_FOR_UNSENT_TIME, 0L);
            }
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + ":getUnsentActiveTime: " + this.unsentActiveTime);
            return this.unsentActiveTime;
        }

        private void saveUnsentActiveTime(long time) {
            this.unsentActiveTime = time;
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + ":saveUnsentActiveTime: " + this.unsentActiveTime);
            OneSignalPrefs.saveLong(OneSignalPrefs.PREFS_ONESIGNAL, this.PREF_KEY_FOR_UNSENT_TIME, time);
        }

        private void addTime(long time, @NonNull OSSessionManager.Session session, @NonNull FocusEventType focusType) {
            if (!this.timeTypeApplies(session)) {
                return;
            }
            long totalTime = this.getUnsentActiveTime() + time;
            this.saveUnsentActiveTime(totalTime);
            this.sendUnsentTimeNow(focusType);
        }

        private void sendUnsentTimeNow(FocusEventType focusType) {
            if (!OneSignal.hasUserId()) {
                return;
            }
            this.sendTime(focusType);
        }

        private boolean hasMinSyncTime() {
            return this.getUnsentActiveTime() >= this.MIN_ON_FOCUS_TIME_SEC;
        }

        protected void syncUnsentTimeOnBackgroundEvent() {
            if (!this.hasMinSyncTime()) {
                return;
            }
            OneSignalSyncServiceUtils.scheduleSyncTask(OneSignal.appContext);
            this.syncOnFocusTime();
        }

        private void syncUnsentTimeFromSyncJob() {
            if (this.hasMinSyncTime()) {
                this.syncOnFocusTime();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        protected void syncOnFocusTime() {
            if (this.runningOnFocusTime.get()) {
                return;
            }
            AtomicBoolean atomicBoolean = this.runningOnFocusTime;
            synchronized (atomicBoolean) {
                this.runningOnFocusTime.set(true);
                if (this.hasMinSyncTime()) {
                    this.sendOnFocus(this.getUnsentActiveTime());
                }
                this.runningOnFocusTime.set(false);
            }
        }

        private void sendOnFocusToPlayer(@NonNull String userId, @NonNull JSONObject jsonBody) {
            OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OneSignal.logHttpError("sending on_focus Failed", statusCode, throwable, response);
                }

                @Override
                void onSuccess(String response) {
                    FocusTimeProcessorBase.this.saveUnsentActiveTime(0L);
                }
            };
            String url = "players/" + userId + "/on_focus";
            OneSignalRestClient.postSync(url, jsonBody, responseHandler);
        }

        protected void additionalFieldsToAddToOnFocusPayload(@NonNull JSONObject jsonBody) {
        }

        @NonNull
        private JSONObject generateOnFocusPayload(long totalTimeActive) throws JSONException {
            JSONObject jsonBody = new JSONObject().put("app_id", (Object)OneSignal.getSavedAppId()).put("type", 1).put("state", (Object)"ping").put("active_time", totalTimeActive).put("device_type", new OSUtils().getDeviceType());
            OneSignal.addNetType(jsonBody);
            return jsonBody;
        }

        private void sendOnFocus(long totalTimeActive) {
            try {
                JSONObject jsonBody = this.generateOnFocusPayload(totalTimeActive);
                this.additionalFieldsToAddToOnFocusPayload(jsonBody);
                this.sendOnFocusToPlayer(OneSignal.getUserId(), jsonBody);
                if (OneSignal.hasEmailId()) {
                    this.sendOnFocusToPlayer(OneSignal.getEmailId(), this.generateOnFocusPayload(totalTimeActive));
                }
            }
            catch (JSONException t) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating on_focus:JSON Failed.", t);
            }
        }
    }

    private static class FocusTimeProcessorAttributed
    extends FocusTimeProcessorBase {
        FocusTimeProcessorAttributed() {
            this.MIN_ON_FOCUS_TIME_SEC = 1L;
            this.PREF_KEY_FOR_UNSENT_TIME = "OS_UNSENT_ATTRIBUTED_ACTIVE_TIME";
        }

        @Override
        protected boolean timeTypeApplies(@NonNull OSSessionManager.Session session) {
            return session.isAttributed();
        }

        @Override
        protected void additionalFieldsToAddToOnFocusPayload(@NonNull JSONObject jsonBody) {
            OneSignal.getSessionManager().addSessionNotificationsIds(jsonBody);
        }

        @Override
        protected void sendTime(@NonNull FocusEventType focusType) {
            if (focusType.equals((Object)FocusEventType.END_SESSION)) {
                this.syncOnFocusTime();
            } else {
                OneSignalSyncServiceUtils.scheduleSyncTask(OneSignal.appContext);
            }
        }
    }

    private static class FocusTimeProcessorUnattributed
    extends FocusTimeProcessorBase {
        FocusTimeProcessorUnattributed() {
            this.MIN_ON_FOCUS_TIME_SEC = 60L;
            this.PREF_KEY_FOR_UNSENT_TIME = "GT_UNSENT_ACTIVE_TIME";
        }

        @Override
        protected boolean timeTypeApplies(@NonNull OSSessionManager.Session session) {
            return session.isUnattributed() || session.isDisabled();
        }

        @Override
        protected void sendTime(@NonNull FocusEventType focusType) {
            if (focusType.equals((Object)FocusEventType.END_SESSION)) {
                return;
            }
            this.syncUnsentTimeOnBackgroundEvent();
        }
    }

    private static enum FocusEventType {
        BACKGROUND,
        END_SESSION;

    }
}

