/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.OSDynamicTriggerController;
import com.onesignal.OSInAppMessage;
import com.onesignal.OSTrigger;
import com.onesignal.OneSignal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class OSTriggerController {
    OSDynamicTriggerController dynamicTriggerController;
    private final ConcurrentHashMap<String, Object> triggers = new ConcurrentHashMap();

    OSTriggerController(OSDynamicTriggerController.OSDynamicTriggerControllerObserver dynamicTriggerObserver) {
        this.dynamicTriggerController = new OSDynamicTriggerController(dynamicTriggerObserver);
    }

    boolean evaluateMessageTriggers(@NonNull OSInAppMessage message) {
        if (message.triggers.size() == 0) {
            return true;
        }
        for (ArrayList<OSTrigger> andConditions : message.triggers) {
            if (!this.evaluateAndTriggers(andConditions)) continue;
            return true;
        }
        return false;
    }

    private boolean evaluateAndTriggers(@NonNull ArrayList<OSTrigger> andConditions) {
        for (OSTrigger trigger : andConditions) {
            if (this.evaluateTrigger(trigger)) continue;
            return false;
        }
        return true;
    }

    private boolean evaluateTrigger(@NonNull OSTrigger trigger) {
        if (trigger.kind == OSTrigger.OSTriggerKind.UNKNOWN) {
            return false;
        }
        if (trigger.kind != OSTrigger.OSTriggerKind.CUSTOM) {
            return this.dynamicTriggerController.dynamicTriggerShouldFire(trigger);
        }
        OSTrigger.OSTriggerOperator operatorType = trigger.operatorType;
        Object deviceValue = this.triggers.get(trigger.property);
        if (deviceValue == null) {
            if (operatorType == OSTrigger.OSTriggerOperator.NOT_EXISTS) {
                return true;
            }
            return operatorType == OSTrigger.OSTriggerOperator.NOT_EQUAL_TO && trigger.value != null;
        }
        if (operatorType == OSTrigger.OSTriggerOperator.EXISTS) {
            return true;
        }
        if (operatorType == OSTrigger.OSTriggerOperator.NOT_EXISTS) {
            return false;
        }
        if (operatorType == OSTrigger.OSTriggerOperator.CONTAINS) {
            return deviceValue instanceof Collection && ((Collection)deviceValue).contains(trigger.value);
        }
        if (deviceValue instanceof String && trigger.value instanceof String && this.triggerMatchesStringValue((String)trigger.value, (String)deviceValue, operatorType)) {
            return true;
        }
        if (trigger.value instanceof Number && deviceValue instanceof Number && this.triggerMatchesNumericValue((Number)trigger.value, (Number)deviceValue, operatorType)) {
            return true;
        }
        return this.triggerMatchesFlex(trigger.value, deviceValue, operatorType);
    }

    private boolean triggerMatchesStringValue(@NonNull String triggerValue, @NonNull String deviceValue, @NonNull OSTrigger.OSTriggerOperator operator) {
        switch (operator) {
            case EQUAL_TO: {
                return triggerValue.equals(deviceValue);
            }
            case NOT_EQUAL_TO: {
                return !triggerValue.equals(deviceValue);
            }
        }
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Attempted to use an invalid operator for a string trigger comparison: " + operator.toString());
        return false;
    }

    private boolean triggerMatchesFlex(@Nullable Object triggerValue, @NonNull Object deviceValue, @NonNull OSTrigger.OSTriggerOperator operator) {
        if (triggerValue == null) {
            return false;
        }
        if (operator.checksEquality()) {
            return this.triggerMatchesStringValue(triggerValue.toString(), deviceValue.toString(), operator);
        }
        if (deviceValue instanceof String && triggerValue instanceof Number) {
            return this.triggerMatchesNumericValueFlex((Number)triggerValue, (String)deviceValue, operator);
        }
        return false;
    }

    private boolean triggerMatchesNumericValueFlex(@NonNull Number triggerValue, @NonNull String deviceValue, @NonNull OSTrigger.OSTriggerOperator operator) {
        double deviceDoubleValue;
        try {
            deviceDoubleValue = Double.parseDouble(deviceValue);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return this.triggerMatchesNumericValue(triggerValue.doubleValue(), deviceDoubleValue, operator);
    }

    private boolean triggerMatchesNumericValue(@NonNull Number triggerValue, @NonNull Number deviceValue, @NonNull OSTrigger.OSTriggerOperator operator) {
        double triggerDoubleValue = triggerValue.doubleValue();
        double deviceDoubleValue = deviceValue.doubleValue();
        switch (operator) {
            case EXISTS: 
            case CONTAINS: 
            case NOT_EXISTS: {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.ERROR, "Attempted to use an invalid operator with a numeric value: " + operator.toString());
                return false;
            }
            case EQUAL_TO: {
                return deviceDoubleValue == triggerDoubleValue;
            }
            case NOT_EQUAL_TO: {
                return deviceDoubleValue != triggerDoubleValue;
            }
            case LESS_THAN: {
                return deviceDoubleValue < triggerDoubleValue;
            }
            case GREATER_THAN: {
                return deviceDoubleValue > triggerDoubleValue;
            }
            case LESS_THAN_OR_EQUAL_TO: {
                return deviceDoubleValue < triggerDoubleValue || deviceDoubleValue == triggerDoubleValue;
            }
            case GREATER_THAN_OR_EQUAL_TO: {
                return deviceDoubleValue > triggerDoubleValue || deviceDoubleValue == triggerDoubleValue;
            }
        }
        return false;
    }

    boolean isTriggerOnMessage(OSInAppMessage message, Collection<String> newTriggersKeys) {
        for (String triggerKey : newTriggersKeys) {
            for (ArrayList<OSTrigger> andConditions : message.triggers) {
                for (OSTrigger trigger : andConditions) {
                    if (!triggerKey.equals(trigger.property)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addTriggers(Map<String, Object> newTriggers) {
        ConcurrentHashMap<String, Object> concurrentHashMap = this.triggers;
        synchronized (concurrentHashMap) {
            for (String key : newTriggers.keySet()) {
                Object value = newTriggers.get(key);
                this.triggers.put(key, value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeTriggersForKeys(Collection<String> keys) {
        ConcurrentHashMap<String, Object> concurrentHashMap = this.triggers;
        synchronized (concurrentHashMap) {
            for (String key : keys) {
                this.triggers.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    Object getTriggerValue(String key) {
        ConcurrentHashMap<String, Object> concurrentHashMap = this.triggers;
        synchronized (concurrentHashMap) {
            if (this.triggers.containsKey(key)) {
                return this.triggers.get(key);
            }
            return null;
        }
    }
}

