/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.support.annotation.Nullable;
import com.onesignal.JSONUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.UserState;
import com.onesignal.UserStatePush;
import com.onesignal.UserStateSynchronizer;
import org.json.JSONException;
import org.json.JSONObject;

class UserStatePushSynchronizer
extends UserStateSynchronizer {
    private static boolean serverSuccess;

    UserStatePushSynchronizer() {
        super(OneSignalStateSynchronizer.UserStateSynchronizerType.PUSH);
    }

    @Override
    protected UserState newUserState(String inPersistKey, boolean load) {
        return new UserStatePush(inPersistKey, load);
    }

    @Override
    protected OneSignal.LOG_LEVEL getLogLevel() {
        return OneSignal.LOG_LEVEL.ERROR;
    }

    @Override
    boolean getSubscribed() {
        return this.getToSyncUserState().isSubscribed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    UserStateSynchronizer.GetTagsResult getTags(boolean fromServer) {
        if (fromServer) {
            String userId = OneSignal.getUserId();
            String appId = OneSignal.getSavedAppId();
            OneSignalRestClient.getSync("players/" + userId + "?app_id=" + appId, new OneSignalRestClient.ResponseHandler(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                void onSuccess(String responseStr) {
                    block6: {
                        serverSuccess = true;
                        if (responseStr == null || responseStr.isEmpty()) {
                            responseStr = "{}";
                        }
                        try {
                            JSONObject lastGetTagsResponse = new JSONObject(responseStr);
                            if (!lastGetTagsResponse.has("tags")) break block6;
                            Object object = UserStatePushSynchronizer.this.LOCK;
                            synchronized (object) {
                                JSONObject dependDiff = UserStatePushSynchronizer.this.generateJsonDiff(UserStatePushSynchronizer.this.currentUserState.getSyncValues().optJSONObject("tags"), UserStatePushSynchronizer.this.getToSyncUserState().getSyncValues().optJSONObject("tags"), null, null);
                                UserStatePushSynchronizer.this.currentUserState.putOnSyncValues("tags", lastGetTagsResponse.optJSONObject("tags"));
                                UserStatePushSynchronizer.this.currentUserState.persistState();
                                UserStatePushSynchronizer.this.getToSyncUserState().mergeTags(lastGetTagsResponse, dependDiff);
                                UserStatePushSynchronizer.this.getToSyncUserState().persistState();
                            }
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }, "CACHE_KEY_GET_TAGS");
        }
        Object object = this.LOCK;
        synchronized (object) {
            return new UserStateSynchronizer.GetTagsResult(serverSuccess, JSONUtils.getJSONObjectWithoutBlankValues(this.toSyncUserState.getSyncValues(), "tags"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    String getExternalId(boolean fromServer) {
        Object object = this.LOCK;
        synchronized (object) {
            return this.toSyncUserState.getSyncValues().optString("external_user_id", null);
        }
    }

    @Override
    protected void scheduleSyncToServer() {
        this.getNetworkHandlerThread(0).runNewJobDelayed();
    }

    @Override
    void updateState(JSONObject pushState) {
        UserState userState;
        try {
            JSONObject syncUpdate = new JSONObject();
            syncUpdate.putOpt("identifier", (Object)pushState.optString("identifier", null));
            if (pushState.has("device_type")) {
                syncUpdate.put("device_type", pushState.optInt("device_type"));
            }
            syncUpdate.putOpt("parent_player_id", (Object)pushState.optString("parent_player_id", null));
            userState = this.getUserStateForModification();
            userState.generateJsonDiffFromIntoSyncValued(syncUpdate, null);
        }
        catch (JSONException t) {
            t.printStackTrace();
        }
        try {
            JSONObject dependUpdate = new JSONObject();
            if (pushState.has("subscribableStatus")) {
                dependUpdate.put("subscribableStatus", pushState.optInt("subscribableStatus"));
            }
            if (pushState.has("androidPermission")) {
                dependUpdate.put("androidPermission", pushState.optBoolean("androidPermission"));
            }
            userState = this.getUserStateForModification();
            userState.generateJsonDiffFromIntoDependValues(dependUpdate, null);
        }
        catch (JSONException t) {
            t.printStackTrace();
        }
    }

    void setEmail(String email, String emailAuthHash) {
        try {
            UserState userState = this.getUserStateForModification();
            userState.putOnDependValues("email_auth_hash", emailAuthHash);
            userState.generateJsonDiffFromIntoSyncValued(new JSONObject().put("email", (Object)email), null);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    void setSubscription(boolean enable) {
        try {
            this.getUserStateForModification().putOnDependValues("userSubscribePref", enable);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean getUserSubscribePreference() {
        return this.getToSyncUserState().getDependValues().optBoolean("userSubscribePref", true);
    }

    @Override
    public void setPermission(boolean enable) {
        try {
            this.getUserStateForModification().putOnDependValues("androidPermission", enable);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getId() {
        return OneSignal.getUserId();
    }

    @Override
    void updateIdDependents(String id2) {
        OneSignal.updateUserIdDependents(id2);
    }

    @Override
    protected void addOnSessionOrCreateExtras(JSONObject jsonBody) {
    }

    @Override
    void logoutEmail() {
        try {
            this.getUserStateForModification().putOnDependValues("logoutEmail", true);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected void fireEventsForUpdateFailure(JSONObject jsonFields) {
        if (jsonFields.has("email")) {
            OneSignal.fireEmailUpdateFailure();
        }
    }

    @Override
    protected void onSuccessfulSync(JSONObject jsonFields) {
        if (jsonFields.has("email")) {
            OneSignal.fireEmailUpdateSuccess();
        }
        if (jsonFields.has("identifier")) {
            OneSignal.fireIdsAvailableCallback();
        }
    }
}

