/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.Base64;
import android.webkit.JavascriptInterface;
import android.webkit.ValueCallback;
import android.webkit.WebView;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.InAppMessageView;
import com.onesignal.OSInAppMessage;
import com.onesignal.OSUtils;
import com.onesignal.OSViewUtils;
import com.onesignal.OSWebView;
import com.onesignal.OneSignal;
import java.io.UnsupportedEncodingException;
import org.json.JSONException;
import org.json.JSONObject;

@TargetApi(value=19)
class WebViewManager
extends ActivityLifecycleHandler.ActivityAvailableListener {
    private static final String TAG = WebViewManager.class.getCanonicalName();
    private static final int MARGIN_PX_SIZE = OSViewUtils.dpToPx(24);
    private static final int IN_APP_MESSAGE_INIT_DELAY = 200;
    @Nullable
    private OSWebView webView;
    @Nullable
    private InAppMessageView messageView;
    @Nullable
    protected static WebViewManager lastInstance = null;
    @NonNull
    private Activity activity;
    @NonNull
    private OSInAppMessage message;
    private boolean firstShow = true;

    protected WebViewManager(@NonNull OSInAppMessage message, @NonNull Activity activity) {
        this.message = message;
        this.activity = activity;
    }

    static void showHTMLString(final @NonNull OSInAppMessage message, final @NonNull String htmlStr) {
        final Activity currentActivity = ActivityLifecycleHandler.curActivity;
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "in app message showHTMLString on currentActivity: " + currentActivity);
        if (currentActivity != null) {
            if (lastInstance != null && message.isPreview) {
                lastInstance.dismissAndAwaitNextMessage(new OneSignalGenericCallback(){

                    @Override
                    public void onComplete() {
                        lastInstance = null;
                        WebViewManager.initInAppMessage(currentActivity, message, htmlStr);
                    }
                });
            } else {
                WebViewManager.initInAppMessage(currentActivity, message, htmlStr);
            }
            return;
        }
        Looper.prepare();
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                WebViewManager.showHTMLString(message, htmlStr);
            }
        }, 200L);
    }

    static void dismissCurrentInAppMessage() {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "WebViewManager IAM dismissAndAwaitNextMessage lastInstance: " + lastInstance);
        if (lastInstance != null) {
            lastInstance.dismissAndAwaitNextMessage(null);
        }
    }

    private static void initInAppMessage(final @NonNull Activity currentActivity, @NonNull OSInAppMessage message, @NonNull String htmlStr) {
        try {
            WebViewManager webViewManager;
            final String base64Str = Base64.encodeToString((byte[])htmlStr.getBytes("UTF-8"), (int)2);
            lastInstance = webViewManager = new WebViewManager(message, currentActivity);
            OSUtils.runOnMainUIThread(new Runnable(){

                @Override
                public void run() {
                    WebViewManager.this.setupWebView(currentActivity, base64Str);
                }
            });
        }
        catch (UnsupportedEncodingException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Catch on initInAppMessage: ", e);
            e.printStackTrace();
        }
    }

    private static int pageRectToViewHeight(@NonNull Activity activity, @NonNull JSONObject jsonObject) {
        try {
            int pageHeight = jsonObject.getJSONObject("rect").getInt("height");
            int pxHeight = OSViewUtils.dpToPx(pageHeight);
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "getPageHeightData:pxHeight: " + pxHeight);
            int maxPxHeight = WebViewManager.getWebViewMaxSizeY(activity);
            if (pxHeight > maxPxHeight) {
                pxHeight = maxPxHeight;
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "getPageHeightData:pxHeight is over screen max: " + maxPxHeight);
            }
            return pxHeight;
        }
        catch (JSONException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "pageRectToViewHeight could not get page height", e);
            return -1;
        }
    }

    private void calculateHeightAndShowWebViewAfterNewActivity() {
        if (this.messageView == null) {
            return;
        }
        if (this.messageView.getDisplayPosition() == Position.FULL_SCREEN) {
            this.showMessageView(null);
            return;
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "In app message new activity, calculate height and show ");
        OSViewUtils.decorViewReady(this.activity, new Runnable(){

            @Override
            public void run() {
                WebViewManager.this.setWebViewToMaxSize(WebViewManager.this.activity);
                WebViewManager.this.webView.evaluateJavascript("getPageMetaData()", (ValueCallback)new ValueCallback<String>(){

                    public void onReceiveValue(String value) {
                        try {
                            int pagePxHeight = WebViewManager.pageRectToViewHeight(WebViewManager.this.activity, new JSONObject(value));
                            WebViewManager.this.showMessageView(pagePxHeight);
                        }
                        catch (JSONException e) {
                            e.printStackTrace();
                        }
                    }
                });
            }
        });
    }

    @Override
    void available(@NonNull Activity activity) {
        this.activity = activity;
        if (this.firstShow) {
            this.showMessageView(null);
        } else {
            this.calculateHeightAndShowWebViewAfterNewActivity();
        }
    }

    @Override
    void stopped() {
        if (this.messageView != null) {
            this.messageView.removeAllViews();
        }
    }

    @Override
    void lostFocus() {
        OneSignal.getInAppMessageController().messageWasDismissedByBackPress(this.message);
        this.removeActivityListener();
        this.messageView = null;
    }

    private void showMessageView(@Nullable Integer newHeight) {
        if (this.messageView == null) {
            OneSignal.Log(OneSignal.LOG_LEVEL.WARN, "No messageView found to update a with a new height.");
            return;
        }
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "In app message, showing fist one with height: " + newHeight);
        this.messageView.setWebView(this.webView);
        if (newHeight != null) {
            this.messageView.updateHeight(newHeight);
        }
        this.messageView.showView(this.activity);
        this.messageView.checkIfShouldDismiss();
    }

    @SuppressLint(value={"SetJavaScriptEnabled", "AddJavascriptInterface"})
    private void setupWebView(final @NonNull Activity currentActivity, final @NonNull String base64Message) {
        WebViewManager.enableWebViewRemoteDebugging();
        this.webView = new OSWebView((Context)currentActivity);
        this.webView.setOverScrollMode(2);
        this.webView.setVerticalScrollBarEnabled(false);
        this.webView.setHorizontalScrollBarEnabled(false);
        this.webView.getSettings().setJavaScriptEnabled(true);
        this.webView.addJavascriptInterface(new OSJavaScriptInterface(), "OSAndroid");
        this.blurryRenderingWebViewForKitKatWorkAround(this.webView);
        OSViewUtils.decorViewReady(currentActivity, new Runnable(){

            @Override
            public void run() {
                WebViewManager.this.setWebViewToMaxSize(currentActivity);
                WebViewManager.this.webView.loadData(base64Message, "text/html; charset=utf-8", "base64");
            }
        });
    }

    private void blurryRenderingWebViewForKitKatWorkAround(@NonNull WebView webView) {
        if (Build.VERSION.SDK_INT == 19) {
            webView.setLayerType(1, null);
        }
    }

    private void setWebViewToMaxSize(Activity activity) {
        this.webView.layout(0, 0, WebViewManager.getWebViewMaxSizeX(activity), WebViewManager.getWebViewMaxSizeY(activity));
    }

    private void createNewInAppMessageView(@NonNull Position displayLocation, int pageHeight) {
        this.messageView = new InAppMessageView(this.webView, displayLocation, pageHeight, this.message.getDisplayDuration());
        this.messageView.setMessageController(new InAppMessageView.InAppMessageViewListener(){

            @Override
            public void onMessageWasShown() {
                WebViewManager.this.firstShow = false;
                OneSignal.getInAppMessageController().onMessageWasShown(WebViewManager.this.message);
            }

            @Override
            public void onMessageWasDismissed() {
                OneSignal.getInAppMessageController().messageWasDismissed(WebViewManager.this.message);
                WebViewManager.this.removeActivityListener();
            }
        });
        ActivityLifecycleHandler.setActivityAvailableListener(TAG + this.message.messageId, this);
    }

    private static void enableWebViewRemoteDebugging() {
        if (Build.VERSION.SDK_INT >= 19 && OneSignal.atLogLevel(OneSignal.LOG_LEVEL.DEBUG)) {
            WebView.setWebContentsDebuggingEnabled((boolean)true);
        }
    }

    private static int getWebViewMaxSizeX(Activity activity) {
        return OSViewUtils.getWindowWidth(activity) - MARGIN_PX_SIZE * 2;
    }

    private static int getWebViewMaxSizeY(Activity activity) {
        return OSViewUtils.getWindowHeight(activity) - MARGIN_PX_SIZE * 2;
    }

    private void removeActivityListener() {
        ActivityLifecycleHandler.removeActivityAvailableListener(TAG + this.message.messageId);
    }

    protected void dismissAndAwaitNextMessage(final @Nullable OneSignalGenericCallback callback) {
        if (this.messageView == null) {
            if (callback != null) {
                callback.onComplete();
            }
            return;
        }
        this.messageView.dismissAndAwaitNextMessage(new OneSignalGenericCallback(){

            @Override
            public void onComplete() {
                WebViewManager.this.messageView = null;
                if (callback != null) {
                    callback.onComplete();
                }
            }
        });
    }

    class OSJavaScriptInterface {
        static final String JS_OBJ_NAME = "OSAndroid";
        static final String GET_PAGE_META_DATA_JS_FUNCTION = "getPageMetaData()";
        static final String EVENT_TYPE_KEY = "type";
        static final String EVENT_TYPE_RENDERING_COMPLETE = "rendering_complete";
        static final String EVENT_TYPE_ACTION_TAKEN = "action_taken";
        static final String IAM_DISPLAY_LOCATION_KEY = "displayLocation";
        static final String IAM_PAGE_META_DATA_KEY = "pageMetaData";

        OSJavaScriptInterface() {
        }

        @JavascriptInterface
        public void postMessage(String message) {
            try {
                OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "OSJavaScriptInterface:postMessage: " + message);
                JSONObject jsonObject = new JSONObject(message);
                String messageType = jsonObject.getString(EVENT_TYPE_KEY);
                if (messageType.equals(EVENT_TYPE_RENDERING_COMPLETE)) {
                    this.handleRenderComplete(jsonObject);
                } else if (messageType.equals(EVENT_TYPE_ACTION_TAKEN) && !WebViewManager.this.messageView.isDragging()) {
                    this.handleActionTaken(jsonObject);
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }

        private void handleRenderComplete(JSONObject jsonObject) {
            Position displayType = this.getDisplayLocation(jsonObject);
            int pageHeight = displayType == Position.FULL_SCREEN ? -1 : this.getPageHeightData(jsonObject);
            WebViewManager.this.createNewInAppMessageView(displayType, pageHeight);
        }

        private int getPageHeightData(JSONObject jsonObject) {
            try {
                return WebViewManager.pageRectToViewHeight(WebViewManager.this.activity, jsonObject.getJSONObject(IAM_PAGE_META_DATA_KEY));
            }
            catch (JSONException e) {
                return -1;
            }
        }

        @NonNull
        private Position getDisplayLocation(JSONObject jsonObject) {
            Position displayLocation = Position.FULL_SCREEN;
            try {
                if (jsonObject.has(IAM_DISPLAY_LOCATION_KEY) && !jsonObject.get(IAM_DISPLAY_LOCATION_KEY).equals("")) {
                    displayLocation = Position.valueOf(jsonObject.optString(IAM_DISPLAY_LOCATION_KEY, "FULL_SCREEN").toUpperCase());
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            return displayLocation;
        }

        private void handleActionTaken(JSONObject jsonObject) throws JSONException {
            JSONObject body = jsonObject.getJSONObject("body");
            String id2 = body.optString("id", null);
            if (((WebViewManager)WebViewManager.this).message.isPreview) {
                OneSignal.getInAppMessageController().onMessageActionOccurredOnPreview(WebViewManager.this.message, body);
            } else if (id2 != null) {
                OneSignal.getInAppMessageController().onMessageActionOccurredOnMessage(WebViewManager.this.message, body);
            }
            boolean close = body.getBoolean("close");
            if (close) {
                WebViewManager.this.dismissAndAwaitNextMessage(null);
            }
        }
    }

    static interface OneSignalGenericCallback {
        public void onComplete();
    }

    static enum Position {
        TOP_BANNER,
        BOTTOM_BANNER,
        CENTER_MODAL,
        FULL_SCREEN;


        boolean isBanner() {
            switch (this) {
                case TOP_BANNER: 
                case BOTTOM_BANNER: {
                    return true;
                }
            }
            return false;
        }
    }
}

