/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.influence;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.OSLogger;
import com.onesignal.influence.OSInfluenceDataRepository;
import com.onesignal.influence.model.OSInfluence;
import com.onesignal.influence.model.OSInfluenceChannel;
import com.onesignal.influence.model.OSInfluenceType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public abstract class OSChannelTracker {
    private static final String TIME = "time";
    protected OSLogger logger;
    @NonNull
    OSInfluenceDataRepository dataRepository;
    @Nullable
    OSInfluenceType influenceType;
    @Nullable
    JSONArray indirectIds;
    @Nullable
    String directId;

    OSChannelTracker(@NonNull OSInfluenceDataRepository dataRepository, OSLogger logger) {
        this.dataRepository = dataRepository;
        this.logger = logger;
    }

    public abstract String getIdTag();

    abstract OSInfluenceChannel getChannelType();

    abstract JSONArray getLastChannelObjectsReceivedByNewId(String var1);

    abstract JSONArray getLastChannelObjects() throws JSONException;

    abstract int getChannelLimit();

    abstract int getIndirectAttributionWindow();

    abstract void saveChannelObjects(JSONArray var1);

    abstract void initInfluencedTypeFromCache();

    abstract void addSessionData(@NonNull JSONObject var1, OSInfluence var2);

    public abstract void cacheState();

    public void resetAndInitInfluence() {
        this.directId = null;
        this.indirectIds = this.getLastReceivedIds();
        this.influenceType = this.indirectIds.length() > 0 ? OSInfluenceType.INDIRECT : OSInfluenceType.UNATTRIBUTED;
        this.cacheState();
        this.logger.debug("OneSignal OSChannelTracker resetAndInitInfluence: " + this.getIdTag() + " finish with influenceType: " + (Object)((Object)this.influenceType));
    }

    public JSONArray getLastReceivedIds() {
        JSONArray ids = new JSONArray();
        try {
            JSONArray lastChannelObjectReceived = this.getLastChannelObjects();
            this.logger.debug("OneSignal ChannelTracker getLastReceivedIds lastChannelObjectReceived: " + lastChannelObjectReceived);
            long attributionWindow = (long)(this.getIndirectAttributionWindow() * 60) * 1000L;
            long currentTime = System.currentTimeMillis();
            for (int i = 0; i < lastChannelObjectReceived.length(); ++i) {
                JSONObject jsonObject = lastChannelObjectReceived.getJSONObject(i);
                long time = jsonObject.getLong(TIME);
                long difference = currentTime - time;
                if (difference > attributionWindow) continue;
                String id2 = jsonObject.getString(this.getIdTag());
                ids.put((Object)id2);
            }
        }
        catch (JSONException exception) {
            this.logger.error("Generating tracker getLastReceivedIds JSONObject ", exception);
        }
        return ids;
    }

    public void saveLastId(String id2) {
        this.logger.debug("OneSignal OSChannelTracker for: " + this.getIdTag() + " saveLastId: " + id2);
        if (id2 == null || id2.isEmpty()) {
            return;
        }
        JSONArray lastChannelObjectsReceived = this.getLastChannelObjectsReceivedByNewId(id2);
        this.logger.debug("OneSignal OSChannelTracker for: " + this.getIdTag() + " saveLastId with lastChannelObjectsReceived: " + lastChannelObjectsReceived);
        try {
            JSONObject newInfluenceId = new JSONObject().put(this.getIdTag(), (Object)id2).put(TIME, System.currentTimeMillis());
            lastChannelObjectsReceived.put((Object)newInfluenceId);
        }
        catch (JSONException exception) {
            this.logger.error("Generating tracker newInfluenceId JSONObject ", exception);
            return;
        }
        int channelLimit = this.getChannelLimit();
        JSONArray channelObjectToSave = lastChannelObjectsReceived;
        if (lastChannelObjectsReceived.length() > channelLimit) {
            int lengthDifference = lastChannelObjectsReceived.length() - channelLimit;
            channelObjectToSave = new JSONArray();
            for (int i = lengthDifference; i < lastChannelObjectsReceived.length(); ++i) {
                try {
                    channelObjectToSave.put(lastChannelObjectsReceived.get(i));
                    continue;
                }
                catch (JSONException exception) {
                    this.logger.error("Before KITKAT API, Generating tracker lastChannelObjectsReceived get JSONObject ", exception);
                }
            }
        }
        this.logger.debug("OneSignal OSChannelTracker for: " + this.getIdTag() + " with channelObjectToSave: " + channelObjectToSave);
        this.saveChannelObjects(channelObjectToSave);
    }

    @NonNull
    public OSInfluence getCurrentSessionInfluence() {
        OSInfluence.Builder sessionInfluenceBuilder = OSInfluence.Builder.newInstance().setInfluenceType(OSInfluenceType.DISABLED);
        if (this.influenceType == null) {
            this.initInfluencedTypeFromCache();
        }
        if (this.influenceType.isDirect()) {
            if (this.isDirectSessionEnabled()) {
                JSONArray directIds = new JSONArray().put((Object)this.directId);
                sessionInfluenceBuilder = OSInfluence.Builder.newInstance().setIds(directIds).setInfluenceType(OSInfluenceType.DIRECT);
            }
        } else if (this.influenceType.isIndirect()) {
            if (this.isIndirectSessionEnabled()) {
                sessionInfluenceBuilder = OSInfluence.Builder.newInstance().setIds(this.indirectIds).setInfluenceType(OSInfluenceType.INDIRECT);
            }
        } else if (this.isUnattributedSessionEnabled()) {
            sessionInfluenceBuilder = OSInfluence.Builder.newInstance().setInfluenceType(OSInfluenceType.UNATTRIBUTED);
        }
        return sessionInfluenceBuilder.setInfluenceChannel(this.getChannelType()).build();
    }

    private boolean isDirectSessionEnabled() {
        return this.dataRepository.isDirectInfluenceEnabled();
    }

    private boolean isIndirectSessionEnabled() {
        return this.dataRepository.isIndirectInfluenceEnabled();
    }

    private boolean isUnattributedSessionEnabled() {
        return this.dataRepository.isUnattributedInfluenceEnabled();
    }

    @Nullable
    public OSInfluenceType getInfluenceType() {
        return this.influenceType;
    }

    public void setInfluenceType(@NonNull OSInfluenceType influenceType) {
        this.influenceType = influenceType;
    }

    @Nullable
    public JSONArray getIndirectIds() {
        return this.indirectIds;
    }

    public void setIndirectIds(@Nullable JSONArray indirectIds) {
        this.indirectIds = indirectIds;
    }

    @Nullable
    public String getDirectId() {
        return this.directId;
    }

    public void setDirectId(@Nullable String directId) {
        this.directId = directId;
    }

    public String toString() {
        return "OSChannelTracker{tag=" + this.getIdTag() + ", influenceType=" + (Object)((Object)this.influenceType) + ", indirectIds=" + this.indirectIds + ", directId='" + this.directId + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OSChannelTracker tracker = (OSChannelTracker)o;
        return this.influenceType == tracker.influenceType && tracker.getIdTag().equals(this.getIdTag());
    }

    public int hashCode() {
        int result = this.influenceType.hashCode();
        result = 31 * result + this.getIdTag().hashCode();
        return result;
    }
}

