/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.outcomes.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.onesignal.outcomes.model.OSOutcomeSource;
import org.json.JSONException;
import org.json.JSONObject;

public class OSOutcomeEventParams {
    private static final String OUTCOME_ID = "id";
    private static final String OUTCOME_SOURCES = "sources";
    private static final String WEIGHT = "weight";
    private static final String TIMESTAMP = "timestamp";
    @NonNull
    private String outcomeId;
    @Nullable
    private OSOutcomeSource outcomeSource;
    private Float weight;
    private long timestamp;

    public OSOutcomeEventParams(@NonNull String outcomeId, @Nullable OSOutcomeSource outcomeSource, float weight) {
        this(outcomeId, outcomeSource, weight, 0L);
    }

    public OSOutcomeEventParams(@NonNull String outcomeId, @Nullable OSOutcomeSource outcomeSource, float weight, long timestamp) {
        this.outcomeId = outcomeId;
        this.outcomeSource = outcomeSource;
        this.weight = Float.valueOf(weight);
        this.timestamp = timestamp;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject json = new JSONObject();
        json.put(OUTCOME_ID, (Object)this.outcomeId);
        if (this.outcomeSource != null) {
            json.put(OUTCOME_SOURCES, (Object)this.outcomeSource.toJSONObject());
        }
        if (this.weight.floatValue() > 0.0f) {
            json.put(WEIGHT, (Object)this.weight);
        }
        if (this.timestamp > 0L) {
            json.put(TIMESTAMP, this.timestamp);
        }
        return json;
    }

    public String getOutcomeId() {
        return this.outcomeId;
    }

    public OSOutcomeSource getOutcomeSource() {
        return this.outcomeSource;
    }

    public Float getWeight() {
        return this.weight;
    }

    public void setWeight(float weight) {
        this.weight = Float.valueOf(weight);
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean isUnattributed() {
        return this.outcomeSource == null || this.outcomeSource.getDirectBody() == null && this.outcomeSource.getIndirectBody() == null;
    }

    public String toString() {
        return "OSOutcomeEventParams{outcomeId='" + this.outcomeId + '\'' + ", outcomeSource=" + this.outcomeSource + ", weight=" + this.weight + ", timestamp=" + this.timestamp + '}';
    }
}

