/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.app.AlertDialog;
import android.app.Application;
import android.app.NotificationManager;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import android.support.annotation.NonNull;
import android.util.Base64;
import android.util.Log;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.ActivityLifecycleListener;
import com.onesignal.ActivityLifecycleListenerCompat;
import com.onesignal.AdvertisingIdProviderGPS;
import com.onesignal.AdvertisingIdentifierProvider;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.LocationGMS;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.NotificationRestorer;
import com.onesignal.OSNotification;
import com.onesignal.OSNotificationAction;
import com.onesignal.OSNotificationOpenResult;
import com.onesignal.OSNotificationPayload;
import com.onesignal.OSUtils;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalRestClient;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.PushRegistrator;
import com.onesignal.PushRegistratorADM;
import com.onesignal.PushRegistratorGPS;
import com.onesignal.RootToolsInternalMethods;
import com.onesignal.SyncService;
import com.onesignal.TrackAmazonPurchase;
import com.onesignal.TrackGooglePurchase;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OneSignal {
    static final long MIN_ON_FOCUS_TIME = 60L;
    private static final long MIN_ON_SESSION_TIME = 30L;
    static final String TAG = "OneSignal";
    static String appId;
    static String mGoogleProjectNumber;
    static Context appContext;
    private static LOG_LEVEL visualLogLevel;
    private static LOG_LEVEL logCatLevel;
    private static String userId;
    private static int subscribableStatus;
    static boolean initDone;
    private static boolean foreground;
    private static IdsAvailableHandler idsAvailableHandler;
    private static long lastTrackedFocusTime;
    private static long unSentActiveTime;
    private static TrackGooglePurchase trackGooglePurchase;
    private static TrackAmazonPurchase trackAmazonPurchase;
    public static final String VERSION = "030400";
    private static AdvertisingIdentifierProvider mainAdIdProvider;
    private static int deviceType;
    public static String sdkType;
    private static OSUtils osUtils;
    private static String lastRegistrationId;
    private static boolean registerForPushFired;
    private static boolean locationFired;
    private static boolean awlFired;
    private static boolean promptedLocation;
    private static Double lastLocLat;
    private static Double lastLocLong;
    private static Float lastLocAcc;
    private static Integer lastLocType;
    private static boolean shareLocation;
    static Builder mInitBuilder;
    static Collection<JSONArray> unprocessedOpenedNotifis;
    private static GetTagsHandler pendingGetTagsHandler;
    private static boolean getTagsCall;
    private static boolean waitingToPostStateSync;
    private static boolean sendAsSession;
    private static JSONObject awl;
    private static int androidParamsReties;
    static boolean startedSyncService;

    public static Builder startInit(Context context) {
        return new Builder(context);
    }

    private static void init(Builder inBuilder) {
        mInitBuilder = inBuilder;
        Context context = OneSignal.mInitBuilder.mContext;
        OneSignal.mInitBuilder.mContext = null;
        try {
            ApplicationInfo ai = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Bundle bundle = ai.metaData;
            String sender_id = bundle.getString("onesignal_google_project_number");
            if (sender_id != null && sender_id.length() > 4) {
                sender_id = sender_id.substring(4);
            }
            OneSignal.init(context, sender_id, bundle.getString("onesignal_app_id"), OneSignal.mInitBuilder.mNotificationOpenedHandler, OneSignal.mInitBuilder.mNotificationReceivedHandler);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void init(Context context, String googleProjectNumber, String oneSignalAppId) {
        OneSignal.init(context, googleProjectNumber, oneSignalAppId, null, null);
    }

    public static void init(Context context, String googleProjectNumber, String oneSignalAppId, NotificationOpenedHandler notificationOpenedHandler) {
        OneSignal.init(context, googleProjectNumber, oneSignalAppId, notificationOpenedHandler, null);
    }

    public static void init(Context context, String googleProjectNumber, String oneSignalAppId, NotificationOpenedHandler notificationOpenedHandler, NotificationReceivedHandler notificationReceivedHandler) {
        boolean contextIsActivity;
        if (mInitBuilder == null) {
            mInitBuilder = new Builder();
        }
        OneSignal.mInitBuilder.mNotificationOpenedHandler = notificationOpenedHandler;
        OneSignal.mInitBuilder.mNotificationReceivedHandler = notificationReceivedHandler;
        mGoogleProjectNumber = googleProjectNumber;
        osUtils = new OSUtils();
        deviceType = osUtils.getDeviceType();
        subscribableStatus = osUtils.initializationChecker(deviceType, oneSignalAppId);
        if (subscribableStatus == -999) {
            return;
        }
        if (initDone) {
            if (context != null) {
                appContext = context.getApplicationContext();
            }
            if (OneSignal.mInitBuilder.mNotificationOpenedHandler != null) {
                OneSignal.fireCallbackForOpenedNotifications();
            }
            return;
        }
        foreground = contextIsActivity = context instanceof Activity;
        appId = oneSignalAppId;
        appContext = context.getApplicationContext();
        if (contextIsActivity) {
            ActivityLifecycleHandler.curActivity = (Activity)context;
            NotificationRestorer.asyncRestore(appContext);
            OneSignal.startSyncService();
        } else {
            ActivityLifecycleHandler.nextResumeIsFirstActivity = true;
        }
        lastTrackedFocusTime = SystemClock.elapsedRealtime();
        OneSignalStateSynchronizer.initUserState(appContext);
        if (Build.VERSION.SDK_INT > 13) {
            ((Application)appContext).registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new ActivityLifecycleListener());
        } else {
            ActivityLifecycleListenerCompat.startListener();
        }
        try {
            Class.forName("com.amazon.device.iap.PurchasingListener");
            trackAmazonPurchase = new TrackAmazonPurchase(appContext);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        String oldAppId = OneSignal.getSavedAppId();
        if (oldAppId != null) {
            if (!oldAppId.equals(appId)) {
                OneSignal.Log(LOG_LEVEL.DEBUG, "APP ID changed, clearing user id as it is no longer valid.");
                OneSignal.SaveAppId(appId);
                OneSignalStateSynchronizer.resetCurrentState();
            }
        } else {
            BadgeCountUpdater.updateCount(0, appContext);
            OneSignal.SaveAppId(appId);
        }
        if (foreground || OneSignal.getUserId() == null) {
            sendAsSession = OneSignal.isPastOnSessionTime();
            OneSignal.setLastSessionTime(System.currentTimeMillis());
            OneSignal.startRegistrationOrOnSession();
        }
        if (OneSignal.mInitBuilder.mNotificationOpenedHandler != null) {
            OneSignal.fireCallbackForOpenedNotifications();
        }
        if (TrackGooglePurchase.CanTrack(appContext)) {
            trackGooglePurchase = new TrackGooglePurchase(appContext);
        }
        initDone = true;
    }

    private static void startRegistrationOrOnSession() {
        if (waitingToPostStateSync) {
            return;
        }
        waitingToPostStateSync = true;
        registerForPushFired = false;
        if (sendAsSession) {
            locationFired = false;
        }
        OneSignal.startLocationUpdate();
        OneSignal.makeAndroidParamsRequest();
        promptedLocation = promptedLocation || OneSignal.mInitBuilder.mPromptLocation;
    }

    private static void startLocationUpdate() {
        if (shareLocation) {
            LocationGMS.getLocation(appContext, OneSignal.mInitBuilder.mPromptLocation && !promptedLocation, new LocationGMS.LocationHandler(){

                @Override
                public void complete(Double lat, Double log, Float accuracy, Integer type) {
                    lastLocLat = lat;
                    lastLocLong = log;
                    lastLocAcc = accuracy;
                    lastLocType = type;
                    locationFired = true;
                    OneSignal.registerUser();
                }
            });
        } else {
            locationFired = true;
            OneSignal.registerUser();
        }
    }

    private static void registerForPushToken() {
        PushRegistrator pushRegistrator = deviceType == 2 ? new PushRegistratorADM() : new PushRegistratorGPS();
        pushRegistrator.registerForPush(appContext, mGoogleProjectNumber, new PushRegistrator.RegisteredHandler(){

            @Override
            public void complete(String id2, int status) {
                if (status < 1) {
                    if (OneSignalStateSynchronizer.getRegistrationId() == null && (subscribableStatus == 1 || subscribableStatus < -6)) {
                        subscribableStatus = status;
                    }
                } else if (subscribableStatus < -6) {
                    subscribableStatus = status;
                }
                lastRegistrationId = id2;
                registerForPushFired = true;
                OneSignal.registerUser();
            }
        });
    }

    private static void makeAndroidParamsRequest() {
        if (awlFired) {
            OneSignal.registerForPushToken();
            return;
        }
        OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

            @Override
            void onFailure(int statusCode, String response, Throwable throwable) {
                new Thread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            Thread.sleep(30000 + androidParamsReties * 10000);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        androidParamsReties++;
                        OneSignal.makeAndroidParamsRequest();
                    }
                });
            }

            @Override
            void onSuccess(String response) {
                try {
                    JSONObject responseJson = new JSONObject(response);
                    if (responseJson.has("android_sender_id")) {
                        mGoogleProjectNumber = responseJson.getString("android_sender_id");
                    }
                    awl = responseJson.getJSONObject("awl_list");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                awlFired = true;
                OneSignal.registerForPushToken();
            }
        };
        String awl_url = "apps/" + appId + "/android_params.js";
        String userId = OneSignal.getUserId();
        if (userId != null) {
            awl_url = awl_url + "?player_id=" + userId;
        }
        OneSignalRestClient.get(awl_url, responseHandler);
    }

    private static void fireCallbackForOpenedNotifications() {
        for (JSONArray dataArray : unprocessedOpenedNotifis) {
            OneSignal.runNotificationOpenedCallback(dataArray, true, false);
        }
        unprocessedOpenedNotifis.clear();
    }

    public static void setLogLevel(LOG_LEVEL inLogCatLevel, LOG_LEVEL inVisualLogLevel) {
        logCatLevel = inLogCatLevel;
        visualLogLevel = inVisualLogLevel;
    }

    public static void setLogLevel(int inLogCatLevel, int inVisualLogLevel) {
        OneSignal.setLogLevel(OneSignal.getLogLevel(inLogCatLevel), OneSignal.getLogLevel(inVisualLogLevel));
    }

    private static LOG_LEVEL getLogLevel(int level) {
        switch (level) {
            case 0: {
                return LOG_LEVEL.NONE;
            }
            case 1: {
                return LOG_LEVEL.FATAL;
            }
            case 2: {
                return LOG_LEVEL.ERROR;
            }
            case 3: {
                return LOG_LEVEL.WARN;
            }
            case 4: {
                return LOG_LEVEL.INFO;
            }
            case 5: {
                return LOG_LEVEL.DEBUG;
            }
            case 6: {
                return LOG_LEVEL.VERBOSE;
            }
        }
        if (level < 0) {
            return LOG_LEVEL.NONE;
        }
        return LOG_LEVEL.VERBOSE;
    }

    private static boolean atLogLevel(LOG_LEVEL level) {
        return level.compareTo(visualLogLevel) < 1 || level.compareTo(logCatLevel) < 1;
    }

    static void Log(LOG_LEVEL level, String message) {
        OneSignal.Log(level, message, null);
    }

    static void Log(final LOG_LEVEL level, String message, Throwable throwable) {
        if (level.compareTo(logCatLevel) < 1) {
            if (level == LOG_LEVEL.VERBOSE) {
                Log.v((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.DEBUG) {
                Log.d((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.INFO) {
                Log.i((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.WARN) {
                Log.w((String)TAG, (String)message, (Throwable)throwable);
            } else if (level == LOG_LEVEL.ERROR || level == LOG_LEVEL.FATAL) {
                Log.e((String)TAG, (String)message, (Throwable)throwable);
            }
        }
        if (level.compareTo(visualLogLevel) < 1 && ActivityLifecycleHandler.curActivity != null) {
            try {
                String fullMessage = message + "\n";
                if (throwable != null) {
                    fullMessage = fullMessage + throwable.getMessage();
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    throwable.printStackTrace(pw);
                    fullMessage = fullMessage + sw.toString();
                }
                final String finalFullMessage = fullMessage;
                OneSignal.runOnUiThread(new Runnable(){

                    @Override
                    public void run() {
                        if (ActivityLifecycleHandler.curActivity != null) {
                            new AlertDialog.Builder((Context)ActivityLifecycleHandler.curActivity).setTitle((CharSequence)level.toString()).setMessage((CharSequence)finalFullMessage).show();
                        }
                    }
                });
            }
            catch (Throwable t) {
                Log.e((String)TAG, (String)"Error showing logging message.", (Throwable)t);
            }
        }
    }

    private static void logHttpError(String errorString, int statusCode, Throwable throwable, String errorResponse) {
        String jsonError = "";
        if (errorResponse != null && OneSignal.atLogLevel(LOG_LEVEL.INFO)) {
            jsonError = "\n" + errorResponse + "\n";
        }
        OneSignal.Log(LOG_LEVEL.WARN, "HTTP code: " + statusCode + " " + errorString + jsonError, throwable);
    }

    static void onAppLostFocus(boolean onlySave) {
        foreground = false;
        if (!initDone) {
            return;
        }
        if (trackAmazonPurchase != null) {
            trackAmazonPurchase.checkListener();
        }
        if (lastTrackedFocusTime == -1L) {
            return;
        }
        long time_elapsed = (long)((double)(SystemClock.elapsedRealtime() - lastTrackedFocusTime) / 1000.0 + 0.5);
        lastTrackedFocusTime = SystemClock.elapsedRealtime();
        if (time_elapsed < 0L || time_elapsed > 86400L) {
            return;
        }
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Android Context not found, please call OneSignal.init when your app starts.");
            return;
        }
        OneSignal.setLastSessionTime(System.currentTimeMillis());
        long unSentActiveTime = OneSignal.GetUnsentActiveTime();
        long totalTimeActive = unSentActiveTime + time_elapsed;
        if (onlySave || totalTimeActive < 60L || OneSignal.getUserId() == null) {
            OneSignal.SaveUnsentActiveTime(totalTimeActive);
            return;
        }
        OneSignal.sendOnFocus(totalTimeActive, true);
    }

    static void sendOnFocus(long totalTimeActive, boolean synchronous) {
        JSONObject jsonBody = new JSONObject();
        try {
            jsonBody.put("app_id", (Object)appId);
            jsonBody.put("type", 1);
            jsonBody.put("state", (Object)"ping");
            jsonBody.put("active_time", totalTimeActive);
            OneSignal.addNetType(jsonBody);
            String url = "players/" + OneSignal.getUserId() + "/on_focus";
            OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OneSignal.logHttpError("sending on_focus Failed", statusCode, throwable, response);
                }

                @Override
                void onSuccess(String response) {
                    OneSignal.SaveUnsentActiveTime(0L);
                }
            };
            if (synchronous) {
                OneSignalRestClient.postSync(url, jsonBody, responseHandler);
            } else {
                OneSignalRestClient.post(url, jsonBody, responseHandler);
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating on_focus:JSON Failed.", t);
        }
    }

    static void onAppFocus() {
        OneSignal.startSyncService();
        foreground = true;
        lastTrackedFocusTime = SystemClock.elapsedRealtime();
        sendAsSession = OneSignal.isPastOnSessionTime();
        OneSignal.setLastSessionTime(System.currentTimeMillis());
        OneSignal.startRegistrationOrOnSession();
        if (trackGooglePurchase != null) {
            trackGooglePurchase.trackIAP();
        }
        NotificationRestorer.asyncRestore(appContext);
    }

    static boolean isForeground() {
        return foreground;
    }

    private static void addNetType(JSONObject jsonObj) {
        try {
            jsonObj.put("net_type", (Object)osUtils.getNetType());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static int getTimeZoneOffset() {
        TimeZone timezone = Calendar.getInstance().getTimeZone();
        int offset = timezone.getRawOffset();
        if (timezone.inDaylightTime(new Date())) {
            offset += timezone.getDSTSavings();
        }
        return offset / 1000;
    }

    private static void registerUser() {
        OneSignal.Log(LOG_LEVEL.DEBUG, "registerUser: registerForPushFired:" + registerForPushFired + ", locationFired: " + locationFired + ", awlFired: " + awlFired);
        if (!(registerForPushFired && locationFired && awlFired)) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalStateSynchronizer.UserState userState = OneSignalStateSynchronizer.getNewUserState();
                String packageName = appContext.getPackageName();
                PackageManager packageManager = appContext.getPackageManager();
                userState.set("app_id", appId);
                userState.set("identifier", lastRegistrationId);
                String adId = mainAdIdProvider.getIdentifier(appContext);
                if (adId != null) {
                    userState.set("ad_id", adId);
                }
                userState.set("device_os", Build.VERSION.RELEASE);
                userState.set("timezone", OneSignal.getTimeZoneOffset());
                userState.set("language", OSUtils.getCorrectedLanguage());
                userState.set("sdk", OneSignal.VERSION);
                userState.set("sdk_type", sdkType);
                userState.set("android_package", packageName);
                userState.set("device_model", Build.MODEL);
                userState.set("device_type", deviceType);
                userState.setState("subscribableStatus", subscribableStatus);
                try {
                    userState.set("game_version", packageManager.getPackageInfo((String)packageName, (int)0).versionCode);
                }
                catch (PackageManager.NameNotFoundException nameNotFoundException) {
                    // empty catch block
                }
                try {
                    List packList = packageManager.getInstalledPackages(0);
                    JSONArray pkgs = new JSONArray();
                    MessageDigest md = MessageDigest.getInstance("SHA-256");
                    for (int i = 0; i < packList.size(); ++i) {
                        md.update(((PackageInfo)packList.get((int)i)).packageName.getBytes());
                        String pck = Base64.encodeToString((byte[])md.digest(), (int)2);
                        if (!awl.has(pck)) continue;
                        pkgs.put((Object)pck);
                    }
                    userState.set("pkgs", pkgs);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                userState.set("net_type", osUtils.getNetType());
                userState.set("carrier", osUtils.getCarrierName());
                userState.set("rooted", RootToolsInternalMethods.isRooted());
                userState.set("lat", lastLocLat);
                userState.set("long", lastLocLong);
                userState.set("loc_acc", lastLocAcc);
                userState.set("loc_type", lastLocType);
                OneSignalStateSynchronizer.postUpdate(userState, sendAsSession);
                waitingToPostStateSync = false;
            }
        }).start();
    }

    public static void syncHashedEmail(String email) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You must initialize OneSignal before calling syncHashedEmail! Omitting this operation.");
            return;
        }
        if (OSUtils.isValidEmail(email)) {
            email = email.trim();
            OneSignalStateSynchronizer.syncHashedEmail(email.toLowerCase());
        }
    }

    public static void sendTag(String key, String value) {
        try {
            OneSignal.sendTags(new JSONObject().put(key, (Object)value));
        }
        catch (JSONException t) {
            t.printStackTrace();
        }
    }

    public static void sendTags(String jsonString) {
        try {
            OneSignal.sendTags(new JSONObject(jsonString));
        }
        catch (JSONException t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Generating JSONObject for sendTags failed!", t);
        }
    }

    public static void sendTags(JSONObject keyValues) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You must initialize OneSignal before modifying tags! Omitting this tag operation.");
            return;
        }
        if (keyValues == null) {
            return;
        }
        JSONObject existingKeys = OneSignalStateSynchronizer.getTags((boolean)false).result;
        JSONObject toSend = new JSONObject();
        Iterator keys = keyValues.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = keyValues.get(key);
                if (value instanceof JSONArray || value instanceof JSONObject) {
                    OneSignal.Log(LOG_LEVEL.ERROR, "Omitting key '" + key + "'! sendTags DO NOT supported nested values!");
                    continue;
                }
                if (keyValues.isNull(key) || "".equals(value)) {
                    if (!existingKeys.has(key)) continue;
                    toSend.put(key, (Object)"");
                    continue;
                }
                toSend.put(key, (Object)value.toString());
            }
            catch (Throwable throwable) {}
        }
        if (!toSend.toString().equals("{}")) {
            OneSignalStateSynchronizer.sendTags(toSend);
        }
    }

    public static void postNotification(String json, PostNotificationResponseHandler handler) {
        try {
            OneSignal.postNotification(new JSONObject(json), handler);
        }
        catch (JSONException e) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Invalid postNotification JSON format: " + json);
        }
    }

    public static void postNotification(JSONObject json, final PostNotificationResponseHandler handler) {
        block5: {
            try {
                if (!json.has("app_id")) {
                    json.put("app_id", (Object)OneSignal.getSavedAppId());
                }
                OneSignalRestClient.post("notifications/", json, new OneSignalRestClient.ResponseHandler(){

                    @Override
                    public void onSuccess(String response) {
                        OneSignal.Log(LOG_LEVEL.DEBUG, "HTTP create notification success: " + (response != null ? response : "null"));
                        if (handler != null) {
                            try {
                                JSONObject jsonObject = new JSONObject(response);
                                if (jsonObject.has("errors")) {
                                    handler.onFailure(jsonObject);
                                } else {
                                    handler.onSuccess(new JSONObject(response));
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                    }

                    @Override
                    void onFailure(int statusCode, String response, Throwable throwable) {
                        OneSignal.logHttpError("create notification failed", statusCode, throwable, response);
                        if (handler != null) {
                            try {
                                if (statusCode == 0) {
                                    response = "{\"error\": \"HTTP no response error\"}";
                                }
                                handler.onFailure(new JSONObject(response));
                            }
                            catch (Throwable t) {
                                try {
                                    handler.onFailure(new JSONObject("{\"error\": \"Unknown response!\"}"));
                                }
                                catch (JSONException e) {
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                });
            }
            catch (JSONException e) {
                OneSignal.Log(LOG_LEVEL.ERROR, "HTTP create notification json exception!", e);
                if (handler == null) break block5;
                try {
                    handler.onFailure(new JSONObject("{'error': 'HTTP create notification json exception!'}"));
                }
                catch (JSONException e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    public static void getTags(GetTagsHandler getTagsHandler) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "You must initialize OneSignal before getting tags! Omitting this tag operation.");
            return;
        }
        if (getTagsHandler == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "getTagsHandler is null!");
            return;
        }
        if (OneSignal.getUserId() == null) {
            pendingGetTagsHandler = getTagsHandler;
            return;
        }
        OneSignal.internalFireGetTagsCallback(getTagsHandler);
    }

    private static void internalFireGetTagsCallback(final GetTagsHandler getTagsHandler) {
        if (getTagsHandler == null) {
            return;
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                OneSignalStateSynchronizer.GetTagsResult tags = OneSignalStateSynchronizer.getTags(!getTagsCall);
                if (tags.serverSuccess) {
                    getTagsCall = true;
                }
                if (tags.result == null || tags.toString().equals("{}")) {
                    getTagsHandler.tagsAvailable(null);
                } else {
                    getTagsHandler.tagsAvailable(tags.result);
                }
            }
        }).start();
    }

    public static void deleteTag(String key) {
        ArrayList<String> tempList = new ArrayList<String>(1);
        tempList.add(key);
        OneSignal.deleteTags(tempList);
    }

    public static void deleteTags(Collection<String> keys) {
        try {
            JSONObject jsonTags = new JSONObject();
            for (String key : keys) {
                jsonTags.put(key, (Object)"");
            }
            OneSignal.sendTags(jsonTags);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void deleteTags(String jsonArrayString) {
        try {
            JSONObject jsonTags = new JSONObject();
            JSONArray jsonArray = new JSONArray(jsonArrayString);
            for (int i = 0; i < jsonArray.length(); ++i) {
                jsonTags.put(jsonArray.getString(i), (Object)"");
            }
            OneSignal.sendTags(jsonTags);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for deleteTags.", t);
        }
    }

    public static void idsAvailable(IdsAvailableHandler inIdsAvailableHandler) {
        idsAvailableHandler = inIdsAvailableHandler;
        if (OneSignal.getUserId() != null) {
            OneSignal.internalFireIdsAvailableCallback();
        }
    }

    static void fireIdsAvailableCallback() {
        if (idsAvailableHandler != null) {
            OneSignal.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    OneSignal.internalFireIdsAvailableCallback();
                }
            });
        }
    }

    private static void internalFireIdsAvailableCallback() {
        String userId;
        if (idsAvailableHandler == null) {
            return;
        }
        String regId = OneSignalStateSynchronizer.getRegistrationId();
        if (!OneSignalStateSynchronizer.getSubscribed()) {
            regId = null;
        }
        if ((userId = OneSignal.getUserId()) == null) {
            return;
        }
        idsAvailableHandler.idsAvailable(userId, regId);
        if (regId != null) {
            idsAvailableHandler = null;
        }
    }

    static void sendPurchases(JSONArray purchases, boolean newAsExisting, OneSignalRestClient.ResponseHandler responseHandler) {
        if (OneSignal.getUserId() == null) {
            return;
        }
        try {
            JSONObject jsonBody = new JSONObject();
            jsonBody.put("app_id", (Object)appId);
            if (newAsExisting) {
                jsonBody.put("existing", true);
            }
            jsonBody.put("purchases", (Object)purchases);
            OneSignalRestClient.post("players/" + OneSignal.getUserId() + "/on_purchase", jsonBody, responseHandler);
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON for sendPurchases.", t);
        }
    }

    private static boolean openURLFromNotification(Context context, JSONArray dataArray) {
        int jsonArraySize = dataArray.length();
        boolean urlOpened = false;
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                JSONObject customJSON;
                JSONObject data = dataArray.getJSONObject(i);
                if (!data.has("custom") || !(customJSON = new JSONObject(data.optString("custom"))).has("u")) continue;
                String url = customJSON.optString("u", null);
                if (!url.contains("://")) {
                    url = "http://" + url;
                }
                Intent intent = new Intent("android.intent.action.VIEW", Uri.parse((String)url));
                intent.addFlags(0x58080000);
                context.startActivity(intent);
                urlOpened = true;
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Error parsing JSON item " + i + "/" + jsonArraySize + " for launching a web URL.", t);
            }
        }
        return urlOpened;
    }

    private static void runNotificationOpenedCallback(JSONArray dataArray, boolean shown, boolean fromAlert) {
        if (mInitBuilder == null || OneSignal.mInitBuilder.mNotificationOpenedHandler == null) {
            unprocessedOpenedNotifis.add(dataArray);
            return;
        }
        OneSignal.fireNotificationOpenedHandler(OneSignal.generateOsNotificationOpenResult(dataArray, shown, fromAlert));
    }

    @NonNull
    private static OSNotificationOpenResult generateOsNotificationOpenResult(JSONArray dataArray, boolean shown, boolean fromAlert) {
        int jsonArraySize = dataArray.length();
        boolean firstMessage = true;
        OSNotificationOpenResult openResult = new OSNotificationOpenResult();
        OSNotification notification = new OSNotification();
        notification.isAppInFocus = OneSignal.isAppActive();
        notification.shown = shown;
        notification.androidNotificationId = dataArray.optJSONObject(0).optInt("notificationId");
        String actionSelected = null;
        for (int i = 0; i < jsonArraySize; ++i) {
            try {
                JSONObject data = dataArray.getJSONObject(i);
                if (data.has("custom")) {
                    notification.payload = NotificationBundleProcessor.OSNotificationPayloadFrom(data);
                    if (actionSelected == null && data.has("actionSelected")) {
                        actionSelected = data.optString("actionSelected", null);
                    }
                }
                if (firstMessage) {
                    firstMessage = false;
                    continue;
                }
                if (notification.groupedNotifications == null) {
                    notification.groupedNotifications = new ArrayList<OSNotificationPayload>();
                }
                notification.groupedNotifications.add(notification.payload);
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Error parsing JSON item " + i + "/" + jsonArraySize + " for callback.", t);
            }
        }
        openResult.notification = notification;
        openResult.action = new OSNotificationAction();
        openResult.action.actionID = actionSelected;
        openResult.action.type = actionSelected != null ? OSNotificationAction.ActionType.ActionTaken : OSNotificationAction.ActionType.Opened;
        openResult.notification.displayType = fromAlert ? OSNotification.DisplayType.InAppAlert : OSNotification.DisplayType.Notification;
        return openResult;
    }

    private static void fireNotificationOpenedHandler(final OSNotificationOpenResult openedResult) {
        if (Looper.getMainLooper().getThread() == Thread.currentThread()) {
            OneSignal.mInitBuilder.mNotificationOpenedHandler.notificationOpened(openedResult);
        } else {
            OneSignal.runOnUiThread(new Runnable(){

                @Override
                public void run() {
                    OneSignal.mInitBuilder.mNotificationOpenedHandler.notificationOpened(openedResult);
                }
            });
        }
    }

    static void handleNotificationReceived(JSONArray data, boolean displayed, boolean fromAlert) {
        if (mInitBuilder == null || OneSignal.mInitBuilder.mNotificationReceivedHandler == null) {
            return;
        }
        OSNotificationOpenResult openResult = OneSignal.generateOsNotificationOpenResult(data, displayed, fromAlert);
        OneSignal.mInitBuilder.mNotificationReceivedHandler.notificationReceived(openResult.notification);
    }

    public static void handleNotificationOpen(Context inContext, JSONArray data, boolean fromAlert) {
        OneSignal.notificationOpenedRESTCall(inContext, data);
        boolean urlOpened = false;
        boolean defaultOpenActionDisabled = "DISABLE".equals(OSUtils.getManifestMeta(inContext, "com.onesignal.NotificationOpened.DEFAULT"));
        if (!defaultOpenActionDisabled) {
            urlOpened = OneSignal.openURLFromNotification(inContext, data);
        }
        OneSignal.runNotificationOpenedCallback(data, true, fromAlert);
        if (!(fromAlert || urlOpened || defaultOpenActionDisabled)) {
            OneSignal.fireIntentFromNotificationOpen(inContext);
        }
    }

    private static void fireIntentFromNotificationOpen(Context inContext) {
        Intent launchIntent = inContext.getPackageManager().getLaunchIntentForPackage(inContext.getPackageName());
        if (launchIntent != null) {
            launchIntent.setFlags(0x10020000);
            inContext.startActivity(launchIntent);
        }
    }

    private static void notificationOpenedRESTCall(Context inContext, JSONArray dataArray) {
        for (int i = 0; i < dataArray.length(); ++i) {
            try {
                JSONObject customJson;
                JSONObject data = dataArray.getJSONObject(i);
                if (!data.has("custom") || !(customJson = new JSONObject(data.optString("custom", null))).has("i")) continue;
                String notificationId = customJson.optString("i", null);
                JSONObject jsonBody = new JSONObject();
                jsonBody.put("app_id", (Object)OneSignal.getSavedAppId(inContext));
                jsonBody.put("player_id", (Object)OneSignal.getSavedUserId(inContext));
                jsonBody.put("opened", true);
                OneSignalRestClient.put("notifications/" + notificationId, jsonBody, new OneSignalRestClient.ResponseHandler(){

                    @Override
                    void onFailure(int statusCode, String response, Throwable throwable) {
                        OneSignal.logHttpError("sending Notification Opened Failed", statusCode, throwable, response);
                    }
                });
                continue;
            }
            catch (Throwable t) {
                OneSignal.Log(LOG_LEVEL.ERROR, "Failed to generate JSON to send notification opened.", t);
            }
        }
    }

    private static void SaveAppId(String appId) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("GT_APP_ID", appId);
        editor.commit();
    }

    static String getSavedAppId() {
        return OneSignal.getSavedAppId(appContext);
    }

    private static String getSavedAppId(Context inContext) {
        if (inContext == null) {
            return "";
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(inContext);
        return prefs.getString("GT_APP_ID", null);
    }

    private static String getSavedUserId(Context inContext) {
        if (inContext == null) {
            return "";
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(inContext);
        return prefs.getString("GT_PLAYER_ID", null);
    }

    static String getUserId() {
        if (userId == null && appContext != null) {
            SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
            userId = prefs.getString("GT_PLAYER_ID", null);
        }
        return userId;
    }

    static void saveUserId(String inUserId) {
        userId = inUserId;
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putString("GT_PLAYER_ID", userId);
        editor.commit();
    }

    static void updateUserIdDependents(String userId) {
        OneSignal.saveUserId(userId);
        OneSignal.fireIdsAvailableCallback();
        OneSignal.internalFireGetTagsCallback(pendingGetTagsHandler);
    }

    public static void enableVibrate(boolean enable) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("GT_VIBRATE_ENABLED", enable);
        editor.apply();
    }

    static boolean getVibrate(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getBoolean("GT_VIBRATE_ENABLED", true);
    }

    public static void enableSound(boolean enable) {
        if (appContext == null) {
            return;
        }
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putBoolean("GT_SOUND_ENABLED", enable);
        editor.apply();
    }

    static boolean getSoundEnabled(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getBoolean("GT_SOUND_ENABLED", true);
    }

    static void setLastSessionTime(long time) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong("OS_LAST_SESSION_TIME", time);
        editor.apply();
    }

    static long getLastSessionTime(Context context) {
        SharedPreferences prefs = OneSignal.getGcmPreferences(context);
        return prefs.getLong("OS_LAST_SESSION_TIME", -31000L);
    }

    public static void setInFocusDisplaying(OSInFocusDisplayOption displayOption) {
        OneSignal.mInitBuilder.mDisplayOption = displayOption;
    }

    public static void setInFocusDisplaying(int displayOption) {
        OneSignal.mInitBuilder.mDisplayOption = OneSignal.getInFocusDisplaying(displayOption);
    }

    private static OSInFocusDisplayOption getInFocusDisplaying(int displayOption) {
        switch (displayOption) {
            case 0: {
                return OSInFocusDisplayOption.None;
            }
            case 1: {
                return OSInFocusDisplayOption.InAppAlert;
            }
            case 2: {
                return OSInFocusDisplayOption.Notification;
            }
        }
        if (displayOption < 0) {
            return OSInFocusDisplayOption.None;
        }
        return OSInFocusDisplayOption.Notification;
    }

    static boolean getNotificationsWhenActiveEnabled() {
        if (mInitBuilder == null) {
            return true;
        }
        return OneSignal.mInitBuilder.mDisplayOption == OSInFocusDisplayOption.Notification;
    }

    static boolean getInAppAlertNotificationEnabled() {
        if (mInitBuilder == null) {
            return false;
        }
        return OneSignal.mInitBuilder.mDisplayOption == OSInFocusDisplayOption.InAppAlert;
    }

    public static void setSubscription(boolean enable) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not set subscription.");
            return;
        }
        OneSignalStateSynchronizer.setSubscription(enable);
    }

    public static void setLocationShared(boolean enable) {
        shareLocation = enable;
        OneSignal.Log(LOG_LEVEL.DEBUG, "shareLocation:" + shareLocation);
    }

    public static void promptLocation() {
        if (!shareLocation) {
            return;
        }
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not prompt for location.");
            return;
        }
        LocationGMS.getLocation(appContext, true, new LocationGMS.LocationHandler(){

            @Override
            public void complete(Double lat, Double log, Float accuracy, Integer type) {
                if (lat != null && log != null) {
                    OneSignalStateSynchronizer.updateLocation(lat, log, accuracy, type);
                }
            }
        });
        promptedLocation = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearOneSignalNotifications() {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not clear notifications.");
            return;
        }
        NotificationManager notificationManager = (NotificationManager)appContext.getSystemService("notification");
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(appContext);
        SQLiteDatabase readableDb = dbHelper.getReadableDatabase();
        String[] retColumn = new String[]{"android_notification_id"};
        Cursor cursor = readableDb.query("notification", retColumn, "dismissed = 0 AND opened = 0", null, null, null, null);
        if (cursor.moveToFirst()) {
            do {
                int existingId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
                notificationManager.cancel(existingId);
            } while (cursor.moveToNext());
        }
        cursor.close();
        SQLiteDatabase writableDb = dbHelper.getWritableDatabase();
        writableDb.beginTransaction();
        try {
            String whereStr = "opened = 0";
            ContentValues values = new ContentValues();
            values.put("dismissed", Integer.valueOf(1));
            writableDb.update("notification", values, whereStr, null);
            writableDb.setTransactionSuccessful();
        }
        catch (Exception e) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Error marking all notifications as dismissed! ", e);
        }
        finally {
            writableDb.endTransaction();
        }
        BadgeCountUpdater.updateCount(0, appContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancelNotification(int id2) {
        if (appContext == null) {
            OneSignal.Log(LOG_LEVEL.ERROR, "OneSignal.init has not been called. Could not clear notification id: " + id2);
            return;
        }
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(appContext);
        SQLiteDatabase writableDb = dbHelper.getWritableDatabase();
        writableDb.beginTransaction();
        try {
            String whereStr = "opened = 0 AND android_notification_id = " + id2;
            ContentValues values = new ContentValues();
            values.put("dismissed", Integer.valueOf(1));
            writableDb.update("notification", values, whereStr, null);
            BadgeCountUpdater.update(writableDb, appContext);
            writableDb.setTransactionSuccessful();
        }
        catch (Exception e) {
            OneSignal.Log(LOG_LEVEL.ERROR, "Error marking a notification id " + id2 + " as dismissed! ", e);
        }
        finally {
            writableDb.endTransaction();
        }
        NotificationManager notificationManager = (NotificationManager)appContext.getSystemService("notification");
        notificationManager.cancel(id2);
    }

    public static void removeNotificationOpenedHandler() {
        OneSignal.mInitBuilder.mNotificationOpenedHandler = null;
    }

    public static void removeNotificationReceivedHandler() {
        OneSignal.mInitBuilder.mNotificationReceivedHandler = null;
    }

    static long GetUnsentActiveTime() {
        if (unSentActiveTime == -1L && appContext != null) {
            SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
            unSentActiveTime = prefs.getLong("GT_UNSENT_ACTIVE_TIME", 0L);
        }
        OneSignal.Log(LOG_LEVEL.INFO, "GetUnsentActiveTime: " + unSentActiveTime);
        return unSentActiveTime;
    }

    private static void SaveUnsentActiveTime(long time) {
        unSentActiveTime = time;
        if (appContext == null) {
            return;
        }
        OneSignal.Log(LOG_LEVEL.INFO, "SaveUnsentActiveTime: " + unSentActiveTime);
        SharedPreferences prefs = OneSignal.getGcmPreferences(appContext);
        SharedPreferences.Editor editor = prefs.edit();
        editor.putLong("GT_UNSENT_ACTIVE_TIME", time);
        editor.commit();
    }

    static SharedPreferences getGcmPreferences(Context context) {
        return context.getSharedPreferences(OneSignal.class.getSimpleName(), 0);
    }

    static boolean isDuplicateNotification(String id2, Context context) {
        if (id2 == null || "".equals(id2)) {
            return false;
        }
        OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
        SQLiteDatabase readableDb = dbHelper.getReadableDatabase();
        String[] retColumn = new String[]{"notification_id"};
        String[] whereArgs = new String[]{id2};
        Cursor cursor = readableDb.query("notification", retColumn, "notification_id = ?", whereArgs, null, null, null);
        boolean exists = cursor.moveToFirst();
        cursor.close();
        if (exists) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Duplicate GCM message received, skip processing of " + id2);
            return true;
        }
        return false;
    }

    static void runOnUiThread(Runnable action) {
        Handler handler = new Handler(Looper.getMainLooper());
        handler.post(action);
    }

    static boolean notValidOrDuplicated(Context context, JSONObject jsonPayload) {
        String id2 = OneSignal.getNotificationIdFromGCMJsonPayload(jsonPayload);
        return id2 == null || OneSignal.isDuplicateNotification(id2, context);
    }

    static String getNotificationIdFromGCMBundle(Bundle bundle) {
        if (bundle.isEmpty()) {
            return null;
        }
        try {
            if (bundle.containsKey("custom")) {
                JSONObject customJSON = new JSONObject(bundle.getString("custom"));
                if (customJSON.has("i")) {
                    return customJSON.optString("i", null);
                }
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted GCM message. No 'i' field in custom.");
            } else {
                OneSignal.Log(LOG_LEVEL.DEBUG, "Not a OneSignal formatted GCM message. No 'custom' field in the bundle.");
            }
        }
        catch (Throwable t) {
            OneSignal.Log(LOG_LEVEL.DEBUG, "Could not parse bundle, probably not a OneSignal notification.", t);
        }
        return null;
    }

    static String getNotificationIdFromGCMJsonPayload(JSONObject jsonPayload) {
        try {
            JSONObject customJSON = new JSONObject(jsonPayload.optString("custom"));
            return customJSON.optString("i", null);
        }
        catch (Throwable throwable) {
            return null;
        }
    }

    static boolean isAppActive() {
        return initDone && OneSignal.isForeground();
    }

    static void updateOnSessionDependents() {
        sendAsSession = false;
        OneSignal.setLastSessionTime(System.currentTimeMillis());
    }

    private static boolean isPastOnSessionTime() {
        return (System.currentTimeMillis() - OneSignal.getLastSessionTime(appContext)) / 1000L >= 30L;
    }

    private static void startSyncService() {
        if (startedSyncService) {
            return;
        }
        startedSyncService = true;
        appContext.startService(new Intent(appContext, SyncService.class));
    }

    static {
        visualLogLevel = LOG_LEVEL.NONE;
        logCatLevel = LOG_LEVEL.WARN;
        userId = null;
        lastTrackedFocusTime = 1L;
        unSentActiveTime = -1L;
        mainAdIdProvider = new AdvertisingIdProviderGPS();
        sdkType = "native";
        shareLocation = true;
        unprocessedOpenedNotifis = new ArrayList<JSONArray>();
        androidParamsReties = 0;
    }

    public static class Builder {
        Context mContext;
        NotificationOpenedHandler mNotificationOpenedHandler;
        NotificationReceivedHandler mNotificationReceivedHandler;
        boolean mPromptLocation;
        boolean mDisableGmsMissingPrompt;
        OSInFocusDisplayOption mDisplayOption = OSInFocusDisplayOption.InAppAlert;

        private Builder() {
        }

        private Builder(Context context) {
            this.mContext = context;
        }

        public Builder setNotificationOpenedHandler(NotificationOpenedHandler handler) {
            this.mNotificationOpenedHandler = handler;
            return this;
        }

        public Builder setNotificationReceivedHandler(NotificationReceivedHandler handler) {
            this.mNotificationReceivedHandler = handler;
            return this;
        }

        public Builder autoPromptLocation(boolean enable) {
            this.mPromptLocation = enable;
            return this;
        }

        public Builder disableGmsMissingPrompt(boolean disable) {
            this.mDisableGmsMissingPrompt = disable;
            return this;
        }

        public Builder inFocusDisplaying(OSInFocusDisplayOption displayOption) {
            this.mDisplayOption = displayOption;
            return this;
        }

        public void init() {
            OneSignal.init(this);
        }
    }

    public static interface PostNotificationResponseHandler {
        public void onSuccess(JSONObject var1);

        public void onFailure(JSONObject var1);
    }

    public static interface GetTagsHandler {
        public void tagsAvailable(JSONObject var1);
    }

    public static interface IdsAvailableHandler {
        public void idsAvailable(String var1, String var2);
    }

    public static interface NotificationReceivedHandler {
        public void notificationReceived(OSNotification var1);
    }

    public static interface NotificationOpenedHandler {
        public void notificationOpened(OSNotificationOpenResult var1);
    }

    public static enum OSInFocusDisplayOption {
        None,
        InAppAlert,
        Notification;

    }

    public static enum LOG_LEVEL {
        NONE,
        FATAL,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        VERBOSE;

    }
}

