/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.support.annotation.Nullable;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalStateSynchronizer;

public class SyncService
extends Service {
    private void checkOnFocusSync() {
        long unsentTime = OneSignal.GetUnsentActiveTime();
        if (unsentTime < 60L) {
            return;
        }
        OneSignal.sendOnFocus(unsentTime, true);
    }

    public void onCreate() {
        if (OneSignal.startedSyncService) {
            return;
        }
        OneSignal.appContext = this.getApplicationContext();
        new Thread(new Runnable(){

            @Override
            public void run() {
                if (OneSignal.getUserId() == null) {
                    SyncService.this.stopSelf();
                    return;
                }
                OneSignal.appId = OneSignal.getSavedAppId();
                OneSignalStateSynchronizer.initUserState(OneSignal.appContext);
                OneSignalStateSynchronizer.syncUserState(true);
                SyncService.this.checkOnFocusSync();
                SyncService.this.stopSelf();
            }
        }, "OS_SYNCSRV_ONCREATE").start();
    }

    public int onStartCommand(Intent intent, int flags, int startId) {
        return OneSignal.startedSyncService ? 1 : 2;
    }

    @Nullable
    public IBinder onBind(Intent intent) {
        return null;
    }

    public void onTaskRemoved(Intent rootIntent) {
        super.onTaskRemoved(rootIntent);
        SyncService.onTaskRemoved(this);
    }

    static void onTaskRemoved(Service service) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "Starting SyncService:onTaskRemoved.");
        ActivityLifecycleHandler.focusHandlerThread.stopScheduledRunnable();
        boolean scheduleServerRestart = OneSignalStateSynchronizer.stopAndPersist();
        scheduleServerRestart = OneSignal.onAppLostFocus(true) || scheduleServerRestart;
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "Completed SyncService:onTaskRemoved.");
        service.stopSelf();
        if (scheduleServerRestart) {
            SyncService.scheduleServiceRestart(service);
        }
    }

    static void scheduleServiceRestart(Service service) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleServiceRestart");
        Intent intent = new Intent((Context)service, SyncService.class);
        PendingIntent pendingIntent = PendingIntent.getService((Context)service, (int)0, (Intent)intent, (int)0x8000000);
        AlarmManager alarm = (AlarmManager)service.getSystemService("alarm");
        long timeInMillis = System.currentTimeMillis() + 10000L;
        alarm.set(0, timeInMillis, pendingIntent);
    }
}

