/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import com.amazon.device.iap.PurchasingListener;
import com.amazon.device.iap.PurchasingService;
import com.amazon.device.iap.model.Product;
import com.amazon.device.iap.model.ProductDataResponse;
import com.amazon.device.iap.model.PurchaseResponse;
import com.amazon.device.iap.model.PurchaseUpdatesResponse;
import com.amazon.device.iap.model.RequestId;
import com.amazon.device.iap.model.UserDataResponse;
import com.onesignal.OneSignal;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONObject;

class TrackAmazonPurchase {
    private Context context;
    private boolean canTrack = false;
    private OSPurchasingListener osPurchasingListener;
    private Object listenerHandlerObject;
    private Field listenerHandlerField;

    TrackAmazonPurchase(Context context) {
        this.context = context;
        try {
            Class<?> listenerHandlerClass = Class.forName("com.amazon.device.iap.internal.d");
            this.listenerHandlerObject = listenerHandlerClass.getMethod("d", new Class[0]).invoke(null, new Object[0]);
            this.listenerHandlerField = listenerHandlerClass.getDeclaredField("f");
            this.listenerHandlerField.setAccessible(true);
            this.osPurchasingListener = new OSPurchasingListener();
            this.osPurchasingListener.orgPurchasingListener = (PurchasingListener)this.listenerHandlerField.get(this.listenerHandlerObject);
            this.canTrack = true;
            this.setListener();
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error adding Amazon IAP listener.", t);
        }
    }

    private void setListener() {
        PurchasingService.registerListener((Context)this.context, (PurchasingListener)this.osPurchasingListener);
    }

    void checkListener() {
        if (!this.canTrack) {
            return;
        }
        try {
            PurchasingListener curPurchasingListener = (PurchasingListener)this.listenerHandlerField.get(this.listenerHandlerObject);
            if (curPurchasingListener != this.osPurchasingListener) {
                this.osPurchasingListener.orgPurchasingListener = curPurchasingListener;
                this.setListener();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private class OSPurchasingListener
    implements PurchasingListener {
        PurchasingListener orgPurchasingListener;
        private RequestId lastRequestId;
        private String currentMarket;

        private OSPurchasingListener() {
        }

        private String marketToCurrencyCode(String market) {
            switch (market) {
                case "US": {
                    return "USD";
                }
                case "GB": {
                    return "GBP";
                }
                case "DE": 
                case "FR": 
                case "ES": 
                case "IT": {
                    return "EUR";
                }
                case "JP": {
                    return "JPY";
                }
                case "CA": {
                    return "CDN";
                }
                case "BR": {
                    return "BRL";
                }
                case "AU": {
                    return "AUD";
                }
            }
            return "";
        }

        public void onProductDataResponse(ProductDataResponse response) {
            if (this.lastRequestId != null && this.lastRequestId.toString().equals(response.getRequestId().toString())) {
                try {
                    switch (response.getRequestStatus()) {
                        case SUCCESSFUL: {
                            JSONArray purchasesToReport = new JSONArray();
                            Map products = response.getProductData();
                            for (String key : products.keySet()) {
                                Product product = (Product)products.get(key);
                                JSONObject jsonItem = new JSONObject();
                                jsonItem.put("sku", (Object)product.getSku());
                                jsonItem.put("iso", (Object)this.marketToCurrencyCode(this.currentMarket));
                                String price = product.getPrice();
                                if (!price.matches("^[0-9]")) {
                                    price = price.substring(1);
                                }
                                jsonItem.put("amount", (Object)price);
                                purchasesToReport.put((Object)jsonItem);
                            }
                            OneSignal.sendPurchases(purchasesToReport, false, null);
                        }
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else if (this.orgPurchasingListener != null) {
                this.orgPurchasingListener.onProductDataResponse(response);
            }
        }

        public void onPurchaseResponse(PurchaseResponse response) {
            try {
                PurchaseResponse.RequestStatus status = response.getRequestStatus();
                if (status == PurchaseResponse.RequestStatus.SUCCESSFUL) {
                    this.currentMarket = response.getUserData().getMarketplace();
                    HashSet<String> productSkus = new HashSet<String>();
                    productSkus.add(response.getReceipt().getSku());
                    this.lastRequestId = PurchasingService.getProductData(productSkus);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            if (this.orgPurchasingListener != null) {
                this.orgPurchasingListener.onPurchaseResponse(response);
            }
        }

        public void onPurchaseUpdatesResponse(PurchaseUpdatesResponse response) {
            if (this.orgPurchasingListener != null) {
                this.orgPurchasingListener.onPurchaseUpdatesResponse(response);
            }
        }

        public void onUserDataResponse(UserDataResponse response) {
            if (this.orgPurchasingListener != null) {
                this.orgPurchasingListener.onUserDataResponse(response);
            }
        }
    }
}

