/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.Service;
import android.app.job.JobInfo;
import android.app.job.JobParameters;
import android.app.job.JobScheduler;
import android.app.job.JobService;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresApi;
import com.onesignal.LocationGMS;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.SyncJobService;
import com.onesignal.SyncService;
import java.util.concurrent.atomic.AtomicBoolean;

class OneSignalSyncServiceUtils {
    private static final int SYNC_TASK_ID = 2071862118;
    private static final int SYNC_AFTER_BG_DELAY_MS = 120000;
    private static Long nextScheduledSyncTime = 0L;
    private static AtomicBoolean runningOnFocusTime = new AtomicBoolean();
    private static Thread syncBgThread;

    OneSignalSyncServiceUtils() {
    }

    static void scheduleLocationUpdateTask(Context context, long delayMs) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleLocationUpdateTask:delayMs: " + delayMs);
        OneSignalSyncServiceUtils.scheduleSyncTask(context, delayMs);
    }

    static void scheduleSyncTask(Context context) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleSyncTask:SYNC_AFTER_BG_DELAY_MS: 120000");
        OneSignalSyncServiceUtils.scheduleSyncTask(context, 120000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void cancelSyncTask(Context context) {
        Long l = nextScheduledSyncTime;
        synchronized (l) {
            nextScheduledSyncTime = 0L;
            boolean didSchedule = LocationGMS.scheduleUpdate(context);
            if (didSchedule) {
                return;
            }
            if (OneSignalSyncServiceUtils.useJob()) {
                JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
                jobScheduler.cancel(2071862118);
            } else {
                AlarmManager alarmManager = (AlarmManager)context.getSystemService("alarm");
                alarmManager.cancel(OneSignalSyncServiceUtils.syncServicePendingIntent(context));
            }
        }
    }

    private static PendingIntent syncServicePendingIntent(Context context) {
        return PendingIntent.getService((Context)context, (int)2071862118, (Intent)new Intent(context, SyncService.class), (int)0x8000000);
    }

    private static boolean useJob() {
        return Build.VERSION.SDK_INT >= 21;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scheduleSyncTask(Context context, long delayMs) {
        Long l = nextScheduledSyncTime;
        synchronized (l) {
            if (nextScheduledSyncTime != 0L && System.currentTimeMillis() + delayMs > nextScheduledSyncTime) {
                return;
            }
            if (delayMs < 5000L) {
                delayMs = 5000L;
            }
            if (OneSignalSyncServiceUtils.useJob()) {
                OneSignalSyncServiceUtils.scheduleSyncServiceAsJob(context, delayMs);
            } else {
                OneSignalSyncServiceUtils.scheduleSyncServiceAsAlarm(context, delayMs);
            }
            nextScheduledSyncTime = System.currentTimeMillis() + delayMs;
        }
    }

    @RequiresApi(value=21)
    private static void scheduleSyncServiceAsJob(Context context, long delayMs) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleSyncServiceAsJob:atTime: " + delayMs);
        JobInfo.Builder jobBuilder = new JobInfo.Builder(2071862118, new ComponentName(context, SyncJobService.class));
        JobInfo job = jobBuilder.setMinimumLatency(delayMs).setRequiredNetworkType(1).setPersisted(true).build();
        JobScheduler jobScheduler = (JobScheduler)context.getSystemService("jobscheduler");
        try {
            int result = jobScheduler.schedule(job);
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "scheduleSyncServiceAsJob:result: " + result);
        }
        catch (NullPointerException e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "scheduleSyncServiceAsJob called JobScheduler.jobScheduler which triggered an internal null Android error. Skipping job.", e);
        }
    }

    private static void scheduleSyncServiceAsAlarm(Context context, long delayMs) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "scheduleServiceSyncTask:atTime: " + delayMs);
        PendingIntent pendingIntent = OneSignalSyncServiceUtils.syncServicePendingIntent(context);
        AlarmManager alarm = (AlarmManager)context.getSystemService("alarm");
        long triggerAtMs = System.currentTimeMillis() + delayMs;
        alarm.set(0, triggerAtMs + delayMs, pendingIntent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void syncOnFocusTime() {
        if (runningOnFocusTime.get()) {
            return;
        }
        AtomicBoolean atomicBoolean = runningOnFocusTime;
        synchronized (atomicBoolean) {
            runningOnFocusTime.set(true);
            OneSignalSyncServiceUtils.internalSyncOnFocusTime();
            runningOnFocusTime.set(false);
        }
    }

    private static void internalSyncOnFocusTime() {
        long unsentTime = OneSignal.GetUnsentActiveTime();
        if (unsentTime < 60L) {
            return;
        }
        OneSignal.sendOnFocus(unsentTime, true);
    }

    static void doBackgroundSync(Context context, SyncRunnable runnable) {
        OneSignal.setAppContext(context);
        syncBgThread = new Thread((Runnable)runnable, "OS_SYNCSRV_BG_SYNC");
        syncBgThread.start();
    }

    static boolean stopSyncBgThread() {
        if (syncBgThread == null) {
            return false;
        }
        if (!syncBgThread.isAlive()) {
            return false;
        }
        syncBgThread.interrupt();
        return true;
    }

    static class LegacySyncRunnable
    extends SyncRunnable {
        Service callerService;

        LegacySyncRunnable(Service caller) {
            this.callerService = caller;
        }

        @Override
        protected void stopSync() {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "LegacySyncRunnable:Stopped");
            this.callerService.stopSelf();
        }
    }

    @RequiresApi(api=21)
    static class LollipopSyncRunnable
    extends SyncRunnable {
        private JobService jobService;
        private JobParameters jobParameters;

        LollipopSyncRunnable(JobService caller, JobParameters jobParameters) {
            this.jobService = caller;
            this.jobParameters = jobParameters;
        }

        @Override
        protected void stopSync() {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "LollipopSyncRunnable:JobFinished");
            this.jobService.jobFinished(this.jobParameters, false);
        }
    }

    static abstract class SyncRunnable
    implements Runnable {
        SyncRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Long l = nextScheduledSyncTime;
            synchronized (l) {
                nextScheduledSyncTime = 0L;
            }
            if (OneSignal.getUserId() == null) {
                this.stopSync();
                return;
            }
            OneSignal.appId = OneSignal.getSavedAppId();
            OneSignalStateSynchronizer.initUserState();
            LocationGMS.LocationHandler locationHandler = new LocationGMS.LocationHandler(){

                @Override
                public LocationGMS.CALLBACK_TYPE getType() {
                    return LocationGMS.CALLBACK_TYPE.SYNC_SERVICE;
                }

                @Override
                public void complete(LocationGMS.LocationPoint point) {
                    if (point != null) {
                        OneSignalStateSynchronizer.updateLocation(point);
                    }
                    OneSignalStateSynchronizer.syncUserState(true);
                    OneSignalSyncServiceUtils.syncOnFocusTime();
                    SyncRunnable.this.stopSync();
                }
            };
            LocationGMS.getLocation(OneSignal.appContext, false, locationHandler);
        }

        protected abstract void stopSync();
    }
}

