/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.Nullable;
import com.onesignal.OSNotification;
import com.onesignal.OSNotificationController;
import com.onesignal.OSTimeoutHandler;
import com.onesignal.OneSignal;
import org.json.JSONException;
import org.json.JSONObject;

public class OSNotificationReceivedEvent {
    private static final long PROCESS_NOTIFICATION_TIMEOUT = 25000L;
    private final OSNotificationController controller;
    private final OSTimeoutHandler timeoutHandler;
    private final Runnable timeoutRunnable;
    private final OSNotification notification;
    private boolean isComplete = false;

    OSNotificationReceivedEvent(OSNotificationController controller, OSNotification notification) {
        this.notification = notification;
        this.controller = controller;
        this.timeoutHandler = OSTimeoutHandler.getTimeoutHandler();
        this.timeoutRunnable = new Runnable(){

            @Override
            public void run() {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "Running complete from OSNotificationReceivedEvent timeout runnable!");
                OSNotificationReceivedEvent.this.complete(OSNotificationReceivedEvent.this.getNotification());
            }
        };
        this.timeoutHandler.startTimeout(25000L, this.timeoutRunnable);
    }

    public synchronized void complete(@Nullable OSNotification notification) {
        this.timeoutHandler.destroyTimeout(this.timeoutRunnable);
        if (this.isComplete) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "OSNotificationReceivedEvent already completed");
            return;
        }
        this.isComplete = true;
        this.controller.processNotification(this.notification.copy(), notification != null ? notification.copy() : null);
    }

    public OSNotification getNotification() {
        return this.notification;
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put("notification", (Object)this.notification.toJSONObject());
            mainObj.put("isComplete", this.isComplete);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mainObj;
    }

    public String toString() {
        return "OSNotificationReceivedEvent{isComplete=" + this.isComplete + ", notification=" + this.notification + '}';
    }
}

