/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Service;
import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Context;
import androidx.annotation.RequiresApi;
import com.onesignal.LocationController;
import com.onesignal.OSBackgroundSync;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.SyncJobService;
import com.onesignal.SyncService;
import java.util.concurrent.ArrayBlockingQueue;

class OSSyncService
extends OSBackgroundSync {
    private static final Object INSTANCE_LOCK = new Object();
    private static final String SYNC_TASK_THREAD_ID = "OS_SYNCSRV_BG_SYNC";
    private static final int SYNC_TASK_ID = 2071862118;
    private static final long SYNC_AFTER_BG_DELAY_MS = 30000L;
    private static OSSyncService sInstance;
    private Long nextScheduledSyncTimeMs = 0L;

    OSSyncService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static OSSyncService getInstance() {
        if (sInstance == null) {
            Object object = INSTANCE_LOCK;
            synchronized (object) {
                if (sInstance == null) {
                    sInstance = new OSSyncService();
                }
            }
        }
        return sInstance;
    }

    @Override
    protected String getSyncTaskThreadId() {
        return SYNC_TASK_THREAD_ID;
    }

    @Override
    protected int getSyncTaskId() {
        return 2071862118;
    }

    @Override
    protected Class getSyncServiceJobClass() {
        return SyncJobService.class;
    }

    @Override
    protected Class getSyncServicePendingIntentClass() {
        return SyncService.class;
    }

    @Override
    protected void scheduleSyncTask(Context context) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "OSSyncService scheduleSyncTask:SYNC_AFTER_BG_DELAY_MS: 30000");
        this.scheduleSyncTask(context, 30000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scheduleSyncTask(Context context, long delayMs) {
        Object object = LOCK;
        synchronized (object) {
            if (this.nextScheduledSyncTimeMs != 0L && OneSignal.getTime().getCurrentTimeMillis() + delayMs > this.nextScheduledSyncTimeMs) {
                OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "OSSyncService scheduleSyncTask already update scheduled nextScheduledSyncTimeMs: " + this.nextScheduledSyncTimeMs);
                return;
            }
            if (delayMs < 5000L) {
                delayMs = 5000L;
            }
            this.scheduleBackgroundSyncTask(context, delayMs);
            this.nextScheduledSyncTimeMs = OneSignal.getTime().getCurrentTimeMillis() + delayMs;
        }
    }

    void scheduleLocationUpdateTask(Context context, long delayMs) {
        OneSignal.Log(OneSignal.LOG_LEVEL.VERBOSE, "OSSyncService scheduleLocationUpdateTask:delayMs: " + delayMs);
        this.scheduleSyncTask(context, delayMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelSyncTask(Context context) {
        Object object = LOCK;
        synchronized (object) {
            this.nextScheduledSyncTimeMs = 0L;
            boolean didSchedule = LocationController.scheduleUpdate(context);
            if (didSchedule) {
                return;
            }
            this.cancelBackgroundSyncTask(context);
        }
    }

    static class LegacySyncRunnable
    extends SyncRunnable {
        Service callerService;

        LegacySyncRunnable(Service caller) {
            this.callerService = caller;
        }

        @Override
        protected void stopSync() {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "LegacySyncRunnable:Stopped");
            this.callerService.stopSelf();
        }
    }

    @RequiresApi(api=21)
    static class LollipopSyncRunnable
    extends SyncRunnable {
        private JobService jobService;
        private JobParameters jobParameters;

        LollipopSyncRunnable(JobService caller, JobParameters jobParameters) {
            this.jobService = caller;
            this.jobParameters = jobParameters;
        }

        @Override
        protected void stopSync() {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "LollipopSyncRunnable:JobFinished needsJobReschedule: " + OSSyncService.getInstance().needsJobReschedule);
            boolean reschedule = OSSyncService.getInstance().needsJobReschedule;
            OSSyncService.getInstance().needsJobReschedule = false;
            this.jobService.jobFinished(this.jobParameters, reschedule);
        }
    }

    static abstract class SyncRunnable
    implements Runnable {
        SyncRunnable() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void run() {
            Object object = OSBackgroundSync.LOCK;
            synchronized (object) {
                OSSyncService.getInstance().nextScheduledSyncTimeMs = 0L;
            }
            if (OneSignal.getUserId() == null) {
                this.stopSync();
                return;
            }
            OneSignal.appId = OneSignal.getSavedAppId();
            OneSignalStateSynchronizer.initUserState();
            try {
                final ArrayBlockingQueue queue = new ArrayBlockingQueue(1);
                LocationController.LocationHandler locationHandler = new LocationController.LocationHandler(){

                    @Override
                    public LocationController.PermissionType getType() {
                        return LocationController.PermissionType.SYNC_SERVICE;
                    }

                    @Override
                    public void onComplete(LocationController.LocationPoint point) {
                        Object object = point != null ? point : new Object();
                        queue.offer(object);
                    }
                };
                LocationController.getLocation(OneSignal.appContext, false, false, locationHandler);
                Object point = queue.take();
                if (point instanceof LocationController.LocationPoint) {
                    OneSignalStateSynchronizer.updateLocation((LocationController.LocationPoint)point);
                }
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            OneSignalStateSynchronizer.syncUserState(true);
            OneSignal.getFocusTimeController().doBlockingBackgroundSyncOfUnsentTime();
            this.stopSync();
        }

        protected abstract void stopSync();
    }
}

