/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.huawei.agconnect.config.AGConnectServicesConfig;
import com.huawei.hms.aaid.HmsInstanceId;
import com.huawei.hms.common.ApiException;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.PushRegistrator;

class PushRegistratorHMS
implements PushRegistrator {
    static final String HMS_CLIENT_APP_ID = "client/app_id";
    private static final int NEW_TOKEN_TIMEOUT_MS = 30000;
    private static boolean callbackSuccessful;
    @Nullable
    private static PushRegistrator.RegisteredHandler registeredHandler;

    PushRegistratorHMS() {
    }

    static void fireCallback(String token) {
        if (registeredHandler == null) {
            return;
        }
        callbackSuccessful = true;
        registeredHandler.complete(token, 1);
    }

    @Override
    public void registerForPush(final @NonNull Context context, String senderId, final @NonNull PushRegistrator.RegisteredHandler callback) {
        registeredHandler = callback;
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    PushRegistratorHMS.this.getHMSTokenTask(context, callback);
                }
                catch (ApiException e) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "HMS ApiException getting Huawei push token!", e);
                    int pushStatus = e.getStatusCode() == 907135000 ? -26 : -27;
                    callback.complete(null, pushStatus);
                }
            }
        }, "OS_HMS_GET_TOKEN").start();
    }

    private synchronized void getHMSTokenTask(@NonNull Context context, @NonNull PushRegistrator.RegisteredHandler callback) throws ApiException {
        if (!OSUtils.hasAllHMSLibrariesForPushKit()) {
            callback.complete(null, -28);
            return;
        }
        String appId = AGConnectServicesConfig.fromContext((Context)context).getString(HMS_CLIENT_APP_ID);
        HmsInstanceId hmsInstanceId = HmsInstanceId.getInstance((Context)context);
        String pushToken = hmsInstanceId.getToken(appId, "HCM");
        if (!TextUtils.isEmpty((CharSequence)pushToken)) {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Device registered for HMS, push token = " + pushToken);
            callback.complete(pushToken, 1);
        } else {
            this.waitForOnNewPushTokenEvent(callback);
        }
    }

    private static void doTimeOutWait() {
        try {
            Thread.sleep(30000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    void waitForOnNewPushTokenEvent(@NonNull PushRegistrator.RegisteredHandler callback) {
        PushRegistratorHMS.doTimeOutWait();
        if (!callbackSuccessful) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "HmsMessageServiceOneSignal.onNewToken timed out.");
            callback.complete(null, -25);
        }
    }
}

