/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.Nullable;
import com.onesignal.ImmutableJSONObject;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalStateSynchronizer;
import com.onesignal.UserState;
import com.onesignal.UserStateEmail;
import com.onesignal.UserStateSynchronizer;
import java.util.ArrayList;
import org.json.JSONException;
import org.json.JSONObject;

class UserStateEmailSynchronizer
extends UserStateSynchronizer {
    UserStateEmailSynchronizer() {
        super(OneSignalStateSynchronizer.UserStateSynchronizerType.EMAIL);
    }

    @Override
    protected UserState newUserState(String inPersistKey, boolean load) {
        return new UserStateEmail(inPersistKey, load);
    }

    @Override
    protected OneSignal.LOG_LEVEL getLogLevel() {
        return OneSignal.LOG_LEVEL.INFO;
    }

    @Override
    boolean getSubscribed() {
        return false;
    }

    @Override
    UserStateSynchronizer.GetTagsResult getTags(boolean fromServer) {
        return null;
    }

    @Override
    @Nullable
    String getExternalId(boolean fromServer) {
        return null;
    }

    @Override
    void setSubscription(boolean enable) {
    }

    @Override
    public boolean getUserSubscribePreference() {
        return false;
    }

    @Override
    public void setPermission(boolean enable) {
    }

    @Override
    void updateState(JSONObject state) {
    }

    void refresh() {
        this.scheduleSyncToServer();
    }

    @Override
    protected void scheduleSyncToServer() {
        boolean neverEmail;
        boolean bl = neverEmail = this.getId() == null && this.getRegistrationId() == null;
        if (neverEmail || OneSignal.getUserId() == null) {
            return;
        }
        this.getNetworkHandlerThread(0).runNewJobDelayed();
    }

    void setEmail(String email, String emailAuthHash) {
        boolean noChange;
        UserState userState = this.getUserStateForModification();
        ImmutableJSONObject syncValues = userState.getSyncValues();
        boolean bl = email.equals(syncValues.optString("identifier")) && syncValues.optString("email_auth_hash").equals(emailAuthHash == null ? "" : emailAuthHash) ? true : (noChange = false);
        if (noChange) {
            OneSignal.fireEmailUpdateSuccess();
            return;
        }
        String existingEmail = syncValues.optString("identifier", null);
        if (existingEmail == null) {
            this.setNewSession();
        }
        try {
            JSONObject emailJSON = new JSONObject();
            emailJSON.put("identifier", (Object)email);
            if (emailAuthHash != null) {
                emailJSON.put("email_auth_hash", (Object)emailAuthHash);
            }
            if (emailAuthHash == null && existingEmail != null && !existingEmail.equals(email)) {
                OneSignal.saveEmailId("");
                this.resetCurrentState();
                this.setNewSession();
            }
            userState.generateJsonDiffFromIntoSyncValued(emailJSON, null);
            this.scheduleSyncToServer();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    protected String getId() {
        return OneSignal.getEmailId();
    }

    @Override
    void updateIdDependents(String id2) {
        OneSignal.updateEmailIdDependents(id2);
    }

    @Override
    protected void addOnSessionOrCreateExtras(JSONObject jsonBody) {
        try {
            jsonBody.put("device_type", 11);
            jsonBody.putOpt("device_player_id", (Object)OneSignal.getUserId());
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    @Override
    void logoutEmail() {
        OneSignal.saveEmailId("");
        this.resetCurrentState();
        this.getToSyncUserState().removeFromSyncValues("identifier");
        ArrayList<String> keysToRemove = new ArrayList<String>();
        keysToRemove.add("email_auth_hash");
        keysToRemove.add("device_player_id");
        keysToRemove.add("external_user_id");
        this.getToSyncUserState().removeFromSyncValues(keysToRemove);
        this.getToSyncUserState().persistState();
        OneSignal.getEmailSubscriptionState().clearEmailAndId();
    }

    @Override
    protected void fireEventsForUpdateFailure(JSONObject jsonFields) {
        if (jsonFields.has("identifier")) {
            OneSignal.fireEmailUpdateFailure();
        }
    }

    @Override
    protected void onSuccessfulSync(JSONObject jsonFields) {
        if (jsonFields.has("identifier")) {
            OneSignal.fireEmailUpdateSuccess();
        }
    }
}

