/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import com.onesignal.ImmutableJSONObject;
import com.onesignal.JSONUtils;
import com.onesignal.LocationController;
import com.onesignal.OneSignalPrefs;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

abstract class UserState {
    private static final Object LOCK = new Object();
    public static final String TAGS = "tags";
    public static final int DEVICE_TYPE_ANDROID = 1;
    public static final int DEVICE_TYPE_FIREOS = 2;
    public static final int DEVICE_TYPE_EMAIL = 11;
    public static final int DEVICE_TYPE_HUAWEI = 13;
    public static final int PUSH_STATUS_SUBSCRIBED = 1;
    static final int PUSH_STATUS_NO_PERMISSION = 0;
    static final int PUSH_STATUS_UNSUBSCRIBE = -2;
    static final int PUSH_STATUS_MISSING_ANDROID_SUPPORT_LIBRARY = -3;
    static final int PUSH_STATUS_MISSING_FIREBASE_FCM_LIBRARY = -4;
    static final int PUSH_STATUS_OUTDATED_ANDROID_SUPPORT_LIBRARY = -5;
    static final int PUSH_STATUS_INVALID_FCM_SENDER_ID = -6;
    static final int PUSH_STATUS_OUTDATED_GOOGLE_PLAY_SERVICES_APP = -7;
    static final int PUSH_STATUS_FIREBASE_FCM_INIT_ERROR = -8;
    static final int PUSH_STATUS_FIREBASE_FCM_ERROR_SERVICE_NOT_AVAILABLE = -9;
    static final int PUSH_STATUS_FIREBASE_FCM_ERROR_IOEXCEPTION = -11;
    static final int PUSH_STATUS_FIREBASE_FCM_ERROR_MISC_EXCEPTION = -12;
    public static final int PUSH_STATUS_HMS_TOKEN_TIMEOUT = -25;
    public static final int PUSH_STATUS_HMS_ARGUMENTS_INVALID = -26;
    public static final int PUSH_STATUS_HMS_API_EXCEPTION_OTHER = -27;
    public static final int PUSH_STATUS_MISSING_HMS_PUSHKIT_LIBRARY = -28;
    private static final String[] LOCATION_FIELDS = new String[]{"lat", "long", "loc_acc", "loc_type", "loc_bg", "loc_time_stamp", "ad_id"};
    private static final Set<String> LOCATION_FIELDS_SET = new HashSet<String>(Arrays.asList(LOCATION_FIELDS));
    private String persistKey;
    private JSONObject dependValues;
    private JSONObject syncValues;

    public ImmutableJSONObject getDependValues() {
        try {
            return new ImmutableJSONObject(this.getDependValuesCopy());
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new ImmutableJSONObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDependValues(JSONObject dependValues) {
        Object object = LOCK;
        synchronized (object) {
            this.dependValues = dependValues;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject getDependValuesCopy() throws JSONException {
        Object object = LOCK;
        synchronized (object) {
            return new JSONObject(this.dependValues.toString());
        }
    }

    public ImmutableJSONObject getSyncValues() {
        try {
            return new ImmutableJSONObject(this.getSyncValuesCopy());
        }
        catch (JSONException e) {
            e.printStackTrace();
            return new ImmutableJSONObject();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSONObject getSyncValuesCopy() throws JSONException {
        Object object = LOCK;
        synchronized (object) {
            return new JSONObject(this.syncValues.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSyncValues(JSONObject syncValues) {
        Object object = LOCK;
        synchronized (object) {
            this.syncValues = syncValues;
        }
    }

    UserState(String inPersistKey, boolean load) {
        this.persistKey = inPersistKey;
        if (load) {
            this.loadState();
        } else {
            this.dependValues = new JSONObject();
            this.syncValues = new JSONObject();
        }
    }

    abstract UserState newInstance(String var1);

    UserState deepClone(String persistKey) {
        UserState clonedUserState = this.newInstance(persistKey);
        try {
            clonedUserState.dependValues = this.getDependValuesCopy();
            clonedUserState.syncValues = this.getSyncValuesCopy();
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return clonedUserState;
    }

    protected abstract void addDependFields();

    abstract boolean isSubscribed();

    private Set<String> getGroupChangeFields(UserState changedTo) {
        try {
            if (this.dependValues.optLong("loc_time_stamp") != changedTo.dependValues.getLong("loc_time_stamp")) {
                HashMap<String, Object> syncValuesToPut = new HashMap<String, Object>();
                syncValuesToPut.put("loc_bg", changedTo.dependValues.opt("loc_bg"));
                syncValuesToPut.put("loc_time_stamp", changedTo.dependValues.opt("loc_time_stamp"));
                this.putValues(changedTo.syncValues, syncValuesToPut);
                return LOCATION_FIELDS_SET;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putOnSyncValues(String key, Object value) throws JSONException {
        Object object = LOCK;
        synchronized (object) {
            this.syncValues.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void putOnDependValues(String key, Object value) throws JSONException {
        Object object = LOCK;
        synchronized (object) {
            this.dependValues.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void putValues(JSONObject jsonObject, HashMap<String, Object> values) throws JSONException {
        Object object = LOCK;
        synchronized (object) {
            for (Map.Entry<String, Object> entry : values.entrySet()) {
                jsonObject.put(entry.getKey(), entry.getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromSyncValues(String key) {
        Object object = LOCK;
        synchronized (object) {
            this.syncValues.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromSyncValues(List<String> keys) {
        Object object = LOCK;
        synchronized (object) {
            for (String key : keys) {
                this.syncValues.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromDependValues(String key) {
        Object object = LOCK;
        synchronized (object) {
            this.dependValues.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromDependValues(List<String> keys) {
        Object object = LOCK;
        synchronized (object) {
            for (String key : keys) {
                this.dependValues.remove(key);
            }
        }
    }

    void setLocation(LocationController.LocationPoint point) {
        try {
            HashMap<String, Object> syncValuesToPut = new HashMap<String, Object>();
            syncValuesToPut.put("lat", point.lat);
            syncValuesToPut.put("long", point.log);
            syncValuesToPut.put("loc_acc", point.accuracy);
            syncValuesToPut.put("loc_type", point.type);
            this.putValues(this.syncValues, syncValuesToPut);
            HashMap<String, Object> dependValuesToPut = new HashMap<String, Object>();
            dependValuesToPut.put("loc_bg", point.bg);
            dependValuesToPut.put("loc_time_stamp", point.timeStamp);
            this.putValues(this.dependValues, dependValuesToPut);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    void clearLocation() {
        try {
            HashMap<String, Object> syncValuesToPut = new HashMap<String, Object>();
            syncValuesToPut.put("lat", null);
            syncValuesToPut.put("long", null);
            syncValuesToPut.put("loc_acc", null);
            syncValuesToPut.put("loc_type", null);
            syncValuesToPut.put("loc_bg", null);
            syncValuesToPut.put("loc_time_stamp", null);
            this.putValues(this.syncValues, syncValuesToPut);
            HashMap<String, Object> dependValuesToPut = new HashMap<String, Object>();
            dependValuesToPut.put("loc_bg", null);
            dependValuesToPut.put("loc_time_stamp", null);
            this.putValues(this.dependValues, dependValuesToPut);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    JSONObject generateJsonDiff(UserState newState, boolean isSessionCall) {
        this.addDependFields();
        newState.addDependFields();
        Set<String> includeFields = this.getGroupChangeFields(newState);
        JSONObject sendJson = UserState.generateJsonDiff(this.syncValues, newState.syncValues, null, includeFields);
        if (!isSessionCall && sendJson.toString().equals("{}")) {
            return null;
        }
        try {
            if (!sendJson.has("app_id")) {
                sendJson.put("app_id", (Object)this.syncValues.optString("app_id"));
            }
            if (this.syncValues.has("email_auth_hash")) {
                sendJson.put("email_auth_hash", (Object)this.syncValues.optString("email_auth_hash"));
            }
            if (this.syncValues.has("external_user_id_auth_hash")) {
                sendJson.put("external_user_id_auth_hash", (Object)this.syncValues.optString("external_user_id_auth_hash"));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return sendJson;
    }

    private void loadState() {
        String dependValuesStr = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_USERSTATE_DEPENDVALYES_" + this.persistKey, null);
        if (dependValuesStr == null) {
            this.setDependValues(new JSONObject());
            try {
                boolean userSubscribePref = true;
                int subscribableStatus = this.persistKey.equals("CURRENT_STATE") ? OneSignalPrefs.getInt(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_SUBSCRIPTION", 1) : OneSignalPrefs.getInt(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_SYNCED_SUBSCRIPTION", 1);
                if (subscribableStatus == -2) {
                    subscribableStatus = 1;
                    userSubscribePref = false;
                }
                HashMap<String, Object> dependValuesToPut = new HashMap<String, Object>();
                dependValuesToPut.put("subscribableStatus", subscribableStatus);
                dependValuesToPut.put("userSubscribePref", userSubscribePref);
                this.putValues(this.dependValues, dependValuesToPut);
            }
            catch (JSONException subscribableStatus) {}
        } else {
            try {
                JSONObject dependValues = new JSONObject(dependValuesStr);
                this.setDependValues(dependValues);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        String syncValuesStr = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_USERSTATE_SYNCVALYES_" + this.persistKey, null);
        try {
            JSONObject syncValues;
            if (syncValuesStr == null) {
                syncValues = new JSONObject();
                String gtRegistrationId = OneSignalPrefs.getString(OneSignalPrefs.PREFS_ONESIGNAL, "GT_REGISTRATION_ID", null);
                syncValues.put("identifier", (Object)gtRegistrationId);
            } else {
                syncValues = new JSONObject(syncValuesStr);
            }
            this.setSyncValues(syncValues);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void persistState() {
        Object object = LOCK;
        synchronized (object) {
            OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_USERSTATE_SYNCVALYES_" + this.persistKey, this.syncValues.toString());
            OneSignalPrefs.saveString(OneSignalPrefs.PREFS_ONESIGNAL, "ONESIGNAL_USERSTATE_DEPENDVALYES_" + this.persistKey, this.dependValues.toString());
        }
    }

    void persistStateAfterSync(JSONObject inDependValues, JSONObject inSyncValues) {
        if (inDependValues != null) {
            UserState.generateJsonDiff(this.dependValues, inDependValues, this.dependValues, null);
        }
        if (inSyncValues != null) {
            UserState.generateJsonDiff(this.syncValues, inSyncValues, this.syncValues, null);
            this.mergeTags(inSyncValues, null);
        }
        if (inDependValues != null || inSyncValues != null) {
            this.persistState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void mergeTags(JSONObject inSyncValues, JSONObject omitKeys) {
        if (!inSyncValues.has(TAGS)) {
            return;
        }
        try {
            JSONObject newTags;
            JSONObject syncValues = this.getSyncValuesCopy();
            if (syncValues.has(TAGS)) {
                try {
                    newTags = new JSONObject(syncValues.optString(TAGS));
                }
                catch (JSONException e) {
                    newTags = new JSONObject();
                }
            } else {
                newTags = new JSONObject();
            }
            JSONObject curTags = inSyncValues.optJSONObject(TAGS);
            Iterator keys = curTags.keys();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                if ("".equals(curTags.optString(key))) {
                    newTags.remove(key);
                    continue;
                }
                if (omitKeys != null && omitKeys.has(key)) continue;
                newTags.put(key, (Object)curTags.optString(key));
            }
            Object object = LOCK;
            synchronized (object) {
                if (newTags.toString().equals("{}")) {
                    this.syncValues.remove(TAGS);
                } else {
                    this.syncValues.put(TAGS, (Object)newTags);
                }
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject generateJsonDiffFromIntoSyncValued(JSONObject changedTo, Set<String> includeFields) {
        Object object = LOCK;
        synchronized (object) {
            return JSONUtils.generateJsonDiff(this.syncValues, changedTo, this.syncValues, includeFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject generateJsonDiffFromSyncValued(UserState changedTo, Set<String> includeFields) {
        Object object = LOCK;
        synchronized (object) {
            return JSONUtils.generateJsonDiff(this.syncValues, changedTo.syncValues, null, includeFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject generateJsonDiffFromIntoDependValues(JSONObject changedTo, Set<String> includeFields) {
        Object object = LOCK;
        synchronized (object) {
            return JSONUtils.generateJsonDiff(this.dependValues, changedTo, this.dependValues, includeFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JSONObject generateJsonDiffFromDependValues(UserState changedTo, Set<String> includeFields) {
        Object object = LOCK;
        synchronized (object) {
            return JSONUtils.generateJsonDiff(this.dependValues, changedTo.dependValues, null, includeFields);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static JSONObject generateJsonDiff(JSONObject cur, JSONObject changedTo, JSONObject baseOutput, Set<String> includeFields) {
        Object object = LOCK;
        synchronized (object) {
            return JSONUtils.generateJsonDiff(cur, changedTo, baseOutput, includeFields);
        }
    }

    public String toString() {
        return "UserState{persistKey='" + this.persistKey + '\'' + ", dependValues=" + this.dependValues + ", syncValues=" + this.syncValues + '}';
    }
}

