/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import org.json.JSONException;
import org.json.JSONObject;

class OSTrigger {
    @NonNull
    String triggerId;
    @NonNull
    public OSTriggerKind kind;
    @Nullable
    public String property;
    @NonNull
    public OSTriggerOperator operatorType;
    @Nullable
    public Object value;

    OSTrigger(JSONObject json) throws JSONException {
        this.triggerId = json.getString("id");
        this.kind = OSTriggerKind.fromString(json.getString("kind"));
        this.property = json.optString("property", null);
        this.operatorType = OSTriggerOperator.fromString(json.getString("operator"));
        this.value = json.opt("value");
    }

    public JSONObject toJSONObject() {
        JSONObject json = new JSONObject();
        try {
            json.put("id", (Object)this.triggerId);
            json.put("kind", (Object)this.kind);
            json.put("property", (Object)this.property);
            json.put("operator", (Object)this.operatorType.toString());
            json.put("value", this.value);
        }
        catch (JSONException exception) {
            exception.printStackTrace();
        }
        return json;
    }

    public String toString() {
        return "OSTrigger{triggerId='" + this.triggerId + '\'' + ", kind=" + (Object)((Object)this.kind) + ", property='" + this.property + '\'' + ", operatorType=" + (Object)((Object)this.operatorType) + ", value=" + this.value + '}';
    }

    public static enum OSTriggerKind {
        TIME_SINCE_LAST_IN_APP("min_time_since"),
        SESSION_TIME("session_time"),
        CUSTOM("custom"),
        UNKNOWN("unknown");

        private String value;

        private OSTriggerKind(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @NonNull
        public static OSTriggerKind fromString(String value) {
            for (OSTriggerKind type : OSTriggerKind.values()) {
                if (!type.value.equalsIgnoreCase(value)) continue;
                return type;
            }
            return UNKNOWN;
        }
    }

    public static enum OSTriggerOperator {
        GREATER_THAN("greater"),
        LESS_THAN("less"),
        EQUAL_TO("equal"),
        NOT_EQUAL_TO("not_equal"),
        LESS_THAN_OR_EQUAL_TO("less_or_equal"),
        GREATER_THAN_OR_EQUAL_TO("greater_or_equal"),
        EXISTS("exists"),
        NOT_EXISTS("not_exists"),
        CONTAINS("in");

        private String text;

        private OSTriggerOperator(String text) {
            this.text = text;
        }

        public String toString() {
            return this.text;
        }

        @NonNull
        public static OSTriggerOperator fromString(String text) {
            for (OSTriggerOperator type : OSTriggerOperator.values()) {
                if (!type.text.equalsIgnoreCase(text)) continue;
                return type;
            }
            return EQUAL_TO;
        }

        public boolean checksEquality() {
            return this == EQUAL_TO || this == NOT_EQUAL_TO;
        }
    }
}

