/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.app.NotificationCompat;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.OSMutableNotification;
import com.onesignal.OneSignal;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class OSNotification {
    private NotificationCompat.Extender notificationExtender;
    @Nullable
    private List<OSNotification> groupedNotifications;
    private int androidNotificationId;
    private String notificationId;
    private String templateName;
    private String templateId;
    private String title;
    private String body;
    private JSONObject additionalData;
    private String smallIcon;
    private String largeIcon;
    private String bigPicture;
    private String smallIconAccentColor;
    private String launchURL;
    private String sound;
    private String ledColor;
    private int lockScreenVisibility = 1;
    private String groupKey;
    private String groupMessage;
    private List<ActionButton> actionButtons;
    private String fromProjectNumber;
    private BackgroundImageLayout backgroundImageLayout;
    private String collapseId;
    private int priority;
    private String rawPayload;

    protected OSNotification() {
    }

    OSNotification(@NonNull JSONObject payload) {
        this(null, payload, 0);
    }

    OSNotification(@NonNull JSONObject payload, int androidNotificationId) {
        this(null, payload, androidNotificationId);
    }

    OSNotification(@Nullable List<OSNotification> groupedNotifications, @NonNull JSONObject payload) {
        this(groupedNotifications, payload, 0);
    }

    OSNotification(@Nullable List<OSNotification> groupedNotifications, @NonNull JSONObject jsonPayload, int androidNotificationId) {
        this.initPayloadData(jsonPayload);
        this.groupedNotifications = groupedNotifications;
        this.androidNotificationId = androidNotificationId;
    }

    protected OSNotification(OSNotification notification) {
        this.notificationExtender = notification.notificationExtender;
        this.groupedNotifications = notification.groupedNotifications;
        this.androidNotificationId = notification.androidNotificationId;
        this.notificationId = notification.notificationId;
        this.templateName = notification.templateName;
        this.templateId = notification.templateId;
        this.title = notification.title;
        this.body = notification.body;
        this.additionalData = notification.additionalData;
        this.largeIcon = notification.largeIcon;
        this.bigPicture = notification.bigPicture;
        this.smallIconAccentColor = notification.smallIconAccentColor;
        this.launchURL = notification.launchURL;
        this.sound = notification.sound;
        this.ledColor = notification.ledColor;
        this.lockScreenVisibility = notification.lockScreenVisibility;
        this.groupKey = notification.groupKey;
        this.groupMessage = notification.groupMessage;
        this.actionButtons = notification.actionButtons;
        this.fromProjectNumber = notification.fromProjectNumber;
        this.backgroundImageLayout = notification.backgroundImageLayout;
        this.collapseId = notification.collapseId;
        this.priority = notification.priority;
        this.rawPayload = notification.rawPayload;
    }

    private void initPayloadData(JSONObject currentJsonPayload) {
        JSONObject customJson;
        try {
            customJson = NotificationBundleProcessor.getCustomJSONObject(currentJsonPayload);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error assigning OSNotificationReceivedEvent payload values!", t);
            return;
        }
        this.notificationId = customJson.optString("i");
        this.templateId = customJson.optString("ti");
        this.templateName = customJson.optString("tn");
        this.rawPayload = currentJsonPayload.toString();
        this.additionalData = customJson.optJSONObject("a");
        this.launchURL = customJson.optString("u", null);
        this.body = currentJsonPayload.optString("alert", null);
        this.title = currentJsonPayload.optString("title", null);
        this.smallIcon = currentJsonPayload.optString("sicon", null);
        this.bigPicture = currentJsonPayload.optString("bicon", null);
        this.largeIcon = currentJsonPayload.optString("licon", null);
        this.sound = currentJsonPayload.optString("sound", null);
        this.groupKey = currentJsonPayload.optString("grp", null);
        this.groupMessage = currentJsonPayload.optString("grp_msg", null);
        this.smallIconAccentColor = currentJsonPayload.optString("bgac", null);
        this.ledColor = currentJsonPayload.optString("ledc", null);
        String visibility = currentJsonPayload.optString("vis", null);
        if (visibility != null) {
            this.lockScreenVisibility = Integer.parseInt(visibility);
        }
        this.fromProjectNumber = currentJsonPayload.optString("from", null);
        this.priority = currentJsonPayload.optInt("pri", 0);
        String collapseKey = currentJsonPayload.optString("collapse_key", null);
        if (!"do_not_collapse".equals(collapseKey)) {
            this.collapseId = collapseKey;
        }
        try {
            this.setActionButtons();
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error assigning OSNotificationReceivedEvent.actionButtons values!", t);
        }
        try {
            this.setBackgroundImageLayout(currentJsonPayload);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error assigning OSNotificationReceivedEvent.backgroundImageLayout values!", t);
        }
    }

    private void setActionButtons() throws Throwable {
        if (this.additionalData != null && this.additionalData.has("actionButtons")) {
            JSONArray jsonActionButtons = this.additionalData.getJSONArray("actionButtons");
            this.actionButtons = new ArrayList<ActionButton>();
            for (int i = 0; i < jsonActionButtons.length(); ++i) {
                JSONObject jsonActionButton = jsonActionButtons.getJSONObject(i);
                ActionButton actionButton = new ActionButton();
                actionButton.id = jsonActionButton.optString("id", null);
                actionButton.text = jsonActionButton.optString("text", null);
                actionButton.icon = jsonActionButton.optString("icon", null);
                this.actionButtons.add(actionButton);
            }
            this.additionalData.remove("actionId");
            this.additionalData.remove("actionButtons");
        }
    }

    private void setBackgroundImageLayout(JSONObject currentJsonPayload) throws Throwable {
        String jsonStrBgImage = currentJsonPayload.optString("bg_img", null);
        if (jsonStrBgImage != null) {
            JSONObject jsonBgImage = new JSONObject(jsonStrBgImage);
            this.backgroundImageLayout = new BackgroundImageLayout();
            this.backgroundImageLayout.image = jsonBgImage.optString("img");
            this.backgroundImageLayout.titleTextColor = jsonBgImage.optString("tc");
            this.backgroundImageLayout.bodyTextColor = jsonBgImage.optString("bc");
        }
    }

    public OSMutableNotification mutableCopy() {
        return new OSMutableNotification(this);
    }

    OSNotification copy() {
        return new OSNotificationBuilder().setNotificationExtender(this.notificationExtender).setGroupedNotifications(this.groupedNotifications).setAndroidNotificationId(this.androidNotificationId).setNotificationId(this.notificationId).setTemplateName(this.templateName).setTemplateId(this.templateId).setTitle(this.title).setBody(this.body).setAdditionalData(this.additionalData).setSmallIcon(this.smallIcon).setLargeIcon(this.largeIcon).setBigPicture(this.bigPicture).setSmallIconAccentColor(this.smallIconAccentColor).setLaunchURL(this.launchURL).setSound(this.sound).setLedColor(this.ledColor).setLockScreenVisibility(this.lockScreenVisibility).setGroupKey(this.groupKey).setGroupMessage(this.groupMessage).setActionButtons(this.actionButtons).setFromProjectNumber(this.fromProjectNumber).setBackgroundImageLayout(this.backgroundImageLayout).setCollapseId(this.collapseId).setPriority(this.priority).setRawPayload(this.rawPayload).build();
    }

    public NotificationCompat.Extender getNotificationExtender() {
        return this.notificationExtender;
    }

    protected void setNotificationExtender(NotificationCompat.Extender notificationExtender) {
        this.notificationExtender = notificationExtender;
    }

    boolean hasNotificationId() {
        return this.androidNotificationId != 0;
    }

    public int getAndroidNotificationId() {
        return this.androidNotificationId;
    }

    protected void setAndroidNotificationId(int androidNotificationId) {
        this.androidNotificationId = androidNotificationId;
    }

    @Nullable
    public List<OSNotification> getGroupedNotifications() {
        return this.groupedNotifications;
    }

    void setGroupedNotifications(@Nullable List<OSNotification> groupedNotifications) {
        this.groupedNotifications = groupedNotifications;
    }

    public String getNotificationId() {
        return this.notificationId;
    }

    void setNotificationId(String notificationId) {
        this.notificationId = notificationId;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    void setTemplateName(String templateName) {
        this.templateName = templateName;
    }

    public String getTemplateId() {
        return this.templateId;
    }

    void setTemplateId(String templateId) {
        this.templateId = templateId;
    }

    public String getTitle() {
        return this.title;
    }

    void setTitle(String title) {
        this.title = title;
    }

    public String getBody() {
        return this.body;
    }

    void setBody(String body) {
        this.body = body;
    }

    public JSONObject getAdditionalData() {
        return this.additionalData;
    }

    void setAdditionalData(JSONObject additionalData) {
        this.additionalData = additionalData;
    }

    public String getSmallIcon() {
        return this.smallIcon;
    }

    void setSmallIcon(String smallIcon) {
        this.smallIcon = smallIcon;
    }

    public String getLargeIcon() {
        return this.largeIcon;
    }

    void setLargeIcon(String largeIcon) {
        this.largeIcon = largeIcon;
    }

    public String getBigPicture() {
        return this.bigPicture;
    }

    void setBigPicture(String bigPicture) {
        this.bigPicture = bigPicture;
    }

    public String getSmallIconAccentColor() {
        return this.smallIconAccentColor;
    }

    void setSmallIconAccentColor(String smallIconAccentColor) {
        this.smallIconAccentColor = smallIconAccentColor;
    }

    public String getLaunchURL() {
        return this.launchURL;
    }

    void setLaunchURL(String launchURL) {
        this.launchURL = launchURL;
    }

    public String getSound() {
        return this.sound;
    }

    void setSound(String sound) {
        this.sound = sound;
    }

    public String getLedColor() {
        return this.ledColor;
    }

    void setLedColor(String ledColor) {
        this.ledColor = ledColor;
    }

    public int getLockScreenVisibility() {
        return this.lockScreenVisibility;
    }

    void setLockScreenVisibility(int lockScreenVisibility) {
        this.lockScreenVisibility = lockScreenVisibility;
    }

    public String getGroupKey() {
        return this.groupKey;
    }

    void setGroupKey(String groupKey) {
        this.groupKey = groupKey;
    }

    public String getGroupMessage() {
        return this.groupMessage;
    }

    void setGroupMessage(String groupMessage) {
        this.groupMessage = groupMessage;
    }

    public List<ActionButton> getActionButtons() {
        return this.actionButtons;
    }

    void setActionButtons(List<ActionButton> actionButtons) {
        this.actionButtons = actionButtons;
    }

    public String getFromProjectNumber() {
        return this.fromProjectNumber;
    }

    void setFromProjectNumber(String fromProjectNumber) {
        this.fromProjectNumber = fromProjectNumber;
    }

    public BackgroundImageLayout getBackgroundImageLayout() {
        return this.backgroundImageLayout;
    }

    void setBackgroundImageLayout(BackgroundImageLayout backgroundImageLayout) {
        this.backgroundImageLayout = backgroundImageLayout;
    }

    public String getCollapseId() {
        return this.collapseId;
    }

    void setCollapseId(String collapseId) {
        this.collapseId = collapseId;
    }

    public int getPriority() {
        return this.priority;
    }

    void setPriority(int priority) {
        this.priority = priority;
    }

    public String getRawPayload() {
        return this.rawPayload;
    }

    void setRawPayload(String rawPayload) {
        this.rawPayload = rawPayload;
    }

    public JSONObject toJSONObject() {
        JSONObject mainObj = new JSONObject();
        try {
            mainObj.put("androidNotificationId", this.androidNotificationId);
            JSONArray payloadJsonArray = new JSONArray();
            if (this.groupedNotifications != null) {
                for (OSNotification notification : this.groupedNotifications) {
                    payloadJsonArray.put((Object)notification.toJSONObject());
                }
            }
            mainObj.put("groupedNotifications", (Object)payloadJsonArray);
            mainObj.put("notificationId", (Object)this.notificationId);
            mainObj.put("templateName", (Object)this.templateName);
            mainObj.put("templateId", (Object)this.templateId);
            mainObj.put("title", (Object)this.title);
            mainObj.put("body", (Object)this.body);
            mainObj.put("smallIcon", (Object)this.smallIcon);
            mainObj.put("largeIcon", (Object)this.largeIcon);
            mainObj.put("bigPicture", (Object)this.bigPicture);
            mainObj.put("smallIconAccentColor", (Object)this.smallIconAccentColor);
            mainObj.put("launchURL", (Object)this.launchURL);
            mainObj.put("sound", (Object)this.sound);
            mainObj.put("ledColor", (Object)this.ledColor);
            mainObj.put("lockScreenVisibility", this.lockScreenVisibility);
            mainObj.put("groupKey", (Object)this.groupKey);
            mainObj.put("groupMessage", (Object)this.groupMessage);
            mainObj.put("fromProjectNumber", (Object)this.fromProjectNumber);
            mainObj.put("collapseId", (Object)this.collapseId);
            mainObj.put("priority", this.priority);
            if (this.additionalData != null) {
                mainObj.put("additionalData", (Object)this.additionalData);
            }
            if (this.actionButtons != null) {
                JSONArray actionButtonJsonArray = new JSONArray();
                for (ActionButton actionButton : this.actionButtons) {
                    actionButtonJsonArray.put((Object)actionButton.toJSONObject());
                }
                mainObj.put("actionButtons", (Object)actionButtonJsonArray);
            }
            mainObj.put("rawPayload", (Object)this.rawPayload);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        return mainObj;
    }

    public String toString() {
        return "OSNotification{notificationExtender=" + this.notificationExtender + ", groupedNotifications=" + this.groupedNotifications + ", androidNotificationId=" + this.androidNotificationId + ", notificationId='" + this.notificationId + '\'' + ", templateName='" + this.templateName + '\'' + ", templateId='" + this.templateId + '\'' + ", title='" + this.title + '\'' + ", body='" + this.body + '\'' + ", additionalData=" + this.additionalData + ", smallIcon='" + this.smallIcon + '\'' + ", largeIcon='" + this.largeIcon + '\'' + ", bigPicture='" + this.bigPicture + '\'' + ", smallIconAccentColor='" + this.smallIconAccentColor + '\'' + ", launchURL='" + this.launchURL + '\'' + ", sound='" + this.sound + '\'' + ", ledColor='" + this.ledColor + '\'' + ", lockScreenVisibility=" + this.lockScreenVisibility + ", groupKey='" + this.groupKey + '\'' + ", groupMessage='" + this.groupMessage + '\'' + ", actionButtons=" + this.actionButtons + ", fromProjectNumber='" + this.fromProjectNumber + '\'' + ", backgroundImageLayout=" + this.backgroundImageLayout + ", collapseId='" + this.collapseId + '\'' + ", priority=" + this.priority + ", rawPayload='" + this.rawPayload + '\'' + '}';
    }

    public static class OSNotificationBuilder {
        private NotificationCompat.Extender notificationExtender;
        private List<OSNotification> groupedNotifications;
        private int androidNotificationId;
        private String notificationId;
        private String templateName;
        private String templateId;
        private String title;
        private String body;
        private JSONObject additionalData;
        private String smallIcon;
        private String largeIcon;
        private String bigPicture;
        private String smallIconAccentColor;
        private String launchURL;
        private String sound;
        private String ledColor;
        private int lockScreenVisibility = 1;
        private String groupKey;
        private String groupMessage;
        private List<ActionButton> actionButtons;
        private String fromProjectNumber;
        private BackgroundImageLayout backgroundImageLayout;
        private String collapseId;
        private int priority;
        private String rawPayload;

        public OSNotificationBuilder setNotificationExtender(NotificationCompat.Extender notificationExtender) {
            this.notificationExtender = notificationExtender;
            return this;
        }

        public OSNotificationBuilder setGroupedNotifications(List<OSNotification> groupedNotifications) {
            this.groupedNotifications = groupedNotifications;
            return this;
        }

        public OSNotificationBuilder setAndroidNotificationId(int androidNotificationId) {
            this.androidNotificationId = androidNotificationId;
            return this;
        }

        public OSNotificationBuilder setNotificationId(String notificationId) {
            this.notificationId = notificationId;
            return this;
        }

        public OSNotificationBuilder setTemplateName(String templateName) {
            this.templateName = templateName;
            return this;
        }

        public OSNotificationBuilder setTemplateId(String templateId) {
            this.templateId = templateId;
            return this;
        }

        public OSNotificationBuilder setTitle(String title) {
            this.title = title;
            return this;
        }

        public OSNotificationBuilder setBody(String body) {
            this.body = body;
            return this;
        }

        public OSNotificationBuilder setAdditionalData(JSONObject additionalData) {
            this.additionalData = additionalData;
            return this;
        }

        public OSNotificationBuilder setSmallIcon(String smallIcon) {
            this.smallIcon = smallIcon;
            return this;
        }

        public OSNotificationBuilder setLargeIcon(String largeIcon) {
            this.largeIcon = largeIcon;
            return this;
        }

        public OSNotificationBuilder setBigPicture(String bigPicture) {
            this.bigPicture = bigPicture;
            return this;
        }

        public OSNotificationBuilder setSmallIconAccentColor(String smallIconAccentColor) {
            this.smallIconAccentColor = smallIconAccentColor;
            return this;
        }

        public OSNotificationBuilder setLaunchURL(String launchURL) {
            this.launchURL = launchURL;
            return this;
        }

        public OSNotificationBuilder setSound(String sound) {
            this.sound = sound;
            return this;
        }

        public OSNotificationBuilder setLedColor(String ledColor) {
            this.ledColor = ledColor;
            return this;
        }

        public OSNotificationBuilder setLockScreenVisibility(int lockScreenVisibility) {
            this.lockScreenVisibility = lockScreenVisibility;
            return this;
        }

        public OSNotificationBuilder setGroupKey(String groupKey) {
            this.groupKey = groupKey;
            return this;
        }

        public OSNotificationBuilder setGroupMessage(String groupMessage) {
            this.groupMessage = groupMessage;
            return this;
        }

        public OSNotificationBuilder setActionButtons(List<ActionButton> actionButtons) {
            this.actionButtons = actionButtons;
            return this;
        }

        public OSNotificationBuilder setFromProjectNumber(String fromProjectNumber) {
            this.fromProjectNumber = fromProjectNumber;
            return this;
        }

        public OSNotificationBuilder setBackgroundImageLayout(BackgroundImageLayout backgroundImageLayout) {
            this.backgroundImageLayout = backgroundImageLayout;
            return this;
        }

        public OSNotificationBuilder setCollapseId(String collapseId) {
            this.collapseId = collapseId;
            return this;
        }

        public OSNotificationBuilder setPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public OSNotificationBuilder setRawPayload(String rawPayload) {
            this.rawPayload = rawPayload;
            return this;
        }

        public OSNotification build() {
            OSNotification payload = new OSNotification();
            payload.setNotificationExtender(this.notificationExtender);
            payload.setGroupedNotifications(this.groupedNotifications);
            payload.setAndroidNotificationId(this.androidNotificationId);
            payload.setNotificationId(this.notificationId);
            payload.setTemplateName(this.templateName);
            payload.setTemplateId(this.templateId);
            payload.setTitle(this.title);
            payload.setBody(this.body);
            payload.setAdditionalData(this.additionalData);
            payload.setSmallIcon(this.smallIcon);
            payload.setLargeIcon(this.largeIcon);
            payload.setBigPicture(this.bigPicture);
            payload.setSmallIconAccentColor(this.smallIconAccentColor);
            payload.setLaunchURL(this.launchURL);
            payload.setSound(this.sound);
            payload.setLedColor(this.ledColor);
            payload.setLockScreenVisibility(this.lockScreenVisibility);
            payload.setGroupKey(this.groupKey);
            payload.setGroupMessage(this.groupMessage);
            payload.setActionButtons(this.actionButtons);
            payload.setFromProjectNumber(this.fromProjectNumber);
            payload.setBackgroundImageLayout(this.backgroundImageLayout);
            payload.setCollapseId(this.collapseId);
            payload.setPriority(this.priority);
            payload.setRawPayload(this.rawPayload);
            return payload;
        }
    }

    public static class BackgroundImageLayout {
        private String image;
        private String titleTextColor;
        private String bodyTextColor;

        public String getImage() {
            return this.image;
        }

        public String getTitleTextColor() {
            return this.titleTextColor;
        }

        public String getBodyTextColor() {
            return this.bodyTextColor;
        }
    }

    public static class ActionButton {
        private String id;
        private String text;
        private String icon;

        public ActionButton() {
        }

        public ActionButton(JSONObject jsonObject) {
            this.id = jsonObject.optString("id");
            this.text = jsonObject.optString("text");
            this.icon = jsonObject.optString("icon");
        }

        public ActionButton(String id2, String text, String icon) {
            this.id = id2;
            this.text = text;
            this.icon = icon;
        }

        public JSONObject toJSONObject() {
            JSONObject json = new JSONObject();
            try {
                json.put("id", (Object)this.id);
                json.put("text", (Object)this.text);
                json.put("icon", (Object)this.icon);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return json;
        }

        public String getId() {
            return this.id;
        }

        public String getText() {
            return this.text;
        }

        public String getIcon() {
            return this.icon;
        }
    }
}

