/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.NonNull;
import com.onesignal.OSLogger;
import com.onesignal.OneSignal;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicLong;

class OSTaskController {
    static final String OS_PENDING_EXECUTOR = "OS_PENDING_EXECUTOR_";
    private final ConcurrentLinkedQueue<Runnable> taskQueueWaitingForInit = new ConcurrentLinkedQueue();
    private final AtomicLong lastTaskId = new AtomicLong();
    private ExecutorService pendingTaskExecutor;
    protected final OSLogger logger;

    OSTaskController(OSLogger logger) {
        this.logger = logger;
    }

    boolean shouldRunTaskThroughQueue() {
        if (Thread.currentThread().getName().contains(OS_PENDING_EXECUTOR)) {
            return false;
        }
        if (OneSignal.isInitDone() && this.pendingTaskExecutor == null) {
            return false;
        }
        if (!OneSignal.isInitDone() && this.pendingTaskExecutor == null) {
            return true;
        }
        return !this.pendingTaskExecutor.isShutdown();
    }

    void addTaskToQueue(Runnable runnable) {
        this.addTaskToQueue(new PendingTaskRunnable(this, runnable));
    }

    private void addTaskToQueue(PendingTaskRunnable task) {
        task.taskId = this.lastTaskId.incrementAndGet();
        if (this.pendingTaskExecutor == null) {
            this.logger.debug("Adding a task to the pending queue with ID: " + task.taskId);
            this.taskQueueWaitingForInit.add(task);
        } else if (!this.pendingTaskExecutor.isShutdown()) {
            this.logger.debug("Executor is still running, add to the executor with ID: " + task.taskId);
            try {
                this.pendingTaskExecutor.submit(task);
            }
            catch (RejectedExecutionException e) {
                this.logger.info("Executor is shutdown, running task manually with ID: " + task.taskId);
                task.run();
                e.printStackTrace();
            }
        }
    }

    void startPendingTasks() {
        OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, "startPendingTasks with task queue quantity: " + this.taskQueueWaitingForInit.size());
        if (!this.taskQueueWaitingForInit.isEmpty()) {
            this.pendingTaskExecutor = Executors.newSingleThreadExecutor(new ThreadFactory(){

                @Override
                public Thread newThread(@NonNull Runnable runnable) {
                    Thread newThread = new Thread(runnable);
                    newThread.setName(OSTaskController.OS_PENDING_EXECUTOR + newThread.getId());
                    return newThread;
                }
            });
            while (!this.taskQueueWaitingForInit.isEmpty()) {
                this.pendingTaskExecutor.submit(this.taskQueueWaitingForInit.poll());
            }
        }
    }

    private void onTaskRan(long taskId) {
        if (this.lastTaskId.get() == taskId) {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Last Pending Task has ran, shutting down");
            this.pendingTaskExecutor.shutdown();
        }
    }

    ConcurrentLinkedQueue<Runnable> getTaskQueueWaitingForInit() {
        return this.taskQueueWaitingForInit;
    }

    void shutdownNow() {
        if (this.pendingTaskExecutor != null) {
            this.pendingTaskExecutor.shutdownNow();
        }
    }

    private static class PendingTaskRunnable
    implements Runnable {
        private OSTaskController controller;
        private Runnable innerTask;
        private long taskId;

        PendingTaskRunnable(OSTaskController controller, Runnable innerTask) {
            this.controller = controller;
            this.innerTask = innerTask;
        }

        @Override
        public void run() {
            this.innerTask.run();
            this.controller.onTaskRan(this.taskId);
        }

        public String toString() {
            return "PendingTaskRunnable{innerTask=" + this.innerTask + ", taskId=" + this.taskId + '}';
        }
    }
}

