/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.DisplayMetrics;
import android.view.DisplayCutout;
import android.view.View;
import android.view.Window;
import android.view.WindowInsets;
import androidx.annotation.NonNull;
import com.onesignal.ActivityLifecycleHandler;
import com.onesignal.ActivityLifecycleListener;
import java.lang.ref.WeakReference;

class OSViewUtils {
    private static final int MARGIN_ERROR_PX_SIZE = OSViewUtils.dpToPx(24);

    OSViewUtils() {
    }

    static boolean isKeyboardUp(WeakReference<Activity> activityWeakReference) {
        DisplayMetrics metrics = new DisplayMetrics();
        Rect visibleBounds = new Rect();
        View view = null;
        boolean isOpen = false;
        if (activityWeakReference.get() != null) {
            Window window = ((Activity)activityWeakReference.get()).getWindow();
            view = window.getDecorView();
            view.getWindowVisibleDisplayFrame(visibleBounds);
            window.getWindowManager().getDefaultDisplay().getMetrics(metrics);
        }
        if (view != null) {
            int heightDiff = metrics.heightPixels - visibleBounds.bottom;
            isOpen = heightDiff > MARGIN_ERROR_PX_SIZE;
        }
        return isOpen;
    }

    static void decorViewReady(@NonNull Activity activity, final @NonNull Runnable runnable) {
        final String listenerKey = "decorViewReady:" + runnable;
        activity.getWindow().getDecorView().post(new Runnable(){

            @Override
            public void run() {
                final ActivityLifecycleHandler activityLifecycleHandler = ActivityLifecycleListener.getActivityLifecycleHandler();
                if (activityLifecycleHandler != null) {
                    activityLifecycleHandler.addActivityAvailableListener(listenerKey, new ActivityLifecycleHandler.ActivityAvailableListener(){

                        @Override
                        void available(@NonNull Activity currentActivity) {
                            activityLifecycleHandler.removeActivityAvailableListener(listenerKey);
                            if (OSViewUtils.isActivityFullyReady(currentActivity)) {
                                runnable.run();
                            } else {
                                OSViewUtils.decorViewReady(currentActivity, runnable);
                            }
                        }
                    });
                }
            }
        });
    }

    @NonNull
    private static Rect getWindowVisibleDisplayFrame(@NonNull Activity activity) {
        Rect rect = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(rect);
        return rect;
    }

    static int[] getCutoutAndStatusBarInsets(@NonNull Activity activity) {
        DisplayCutout cutout;
        Rect frame = OSViewUtils.getWindowVisibleDisplayFrame(activity);
        View contentView = activity.getWindow().findViewById(0x1020002);
        float rightInset = 0.0f;
        float leftInset = 0.0f;
        float topInset = (float)(frame.top - contentView.getTop()) / Resources.getSystem().getDisplayMetrics().density;
        float bottomInset = (float)(contentView.getBottom() - frame.bottom) / Resources.getSystem().getDisplayMetrics().density;
        if (Build.VERSION.SDK_INT == 29 && (cutout = activity.getWindowManager().getDefaultDisplay().getCutout()) != null) {
            rightInset = (float)cutout.getSafeInsetRight() / Resources.getSystem().getDisplayMetrics().density;
            leftInset = (float)cutout.getSafeInsetLeft() / Resources.getSystem().getDisplayMetrics().density;
        }
        return new int[]{Math.round(topInset), Math.round(bottomInset), Math.round(rightInset), Math.round(leftInset)};
    }

    static int getFullbleedWindowWidth(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 23) {
            View decorView = activity.getWindow().getDecorView();
            return decorView.getWidth();
        }
        return OSViewUtils.getWindowWidth(activity);
    }

    static int getWindowWidth(@NonNull Activity activity) {
        return OSViewUtils.getWindowVisibleDisplayFrame(activity).width();
    }

    static int getWindowHeight(@NonNull Activity activity) {
        if (Build.VERSION.SDK_INT >= 23) {
            return OSViewUtils.getWindowHeightAPI23Plus(activity);
        }
        if (Build.VERSION.SDK_INT >= 21) {
            return OSViewUtils.getWindowHeightLollipop(activity);
        }
        return OSViewUtils.getDisplaySizeY(activity);
    }

    @TargetApi(value=23)
    private static int getWindowHeightAPI23Plus(@NonNull Activity activity) {
        View decorView = activity.getWindow().getDecorView();
        WindowInsets windowInsets = decorView.getRootWindowInsets();
        if (windowInsets == null) {
            return decorView.getHeight();
        }
        return decorView.getHeight() - windowInsets.getStableInsetBottom() - windowInsets.getStableInsetTop();
    }

    private static int getWindowHeightLollipop(@NonNull Activity activity) {
        if (activity.getResources().getConfiguration().orientation == 2) {
            return OSViewUtils.getWindowVisibleDisplayFrame(activity).height();
        }
        return OSViewUtils.getDisplaySizeY(activity);
    }

    private static int getDisplaySizeY(@NonNull Activity activity) {
        Point point = new Point();
        activity.getWindowManager().getDefaultDisplay().getSize(point);
        return point.y;
    }

    static int dpToPx(int dp) {
        return (int)((float)dp * Resources.getSystem().getDisplayMetrics().density);
    }

    static boolean isActivityFullyReady(@NonNull Activity activity) {
        boolean hasToken;
        boolean bl = hasToken = activity.getWindow().getDecorView().getApplicationWindowToken() != null;
        if (Build.VERSION.SDK_INT < 23) {
            return hasToken;
        }
        View decorView = activity.getWindow().getDecorView();
        boolean insetsAttached = decorView.getRootWindowInsets() != null;
        return hasToken && insetsAttached;
    }
}

