/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.onesignal.ImmutableJSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

class JSONUtils {
    JSONUtils() {
    }

    static JSONObject generateJsonDiff(JSONObject cur, JSONObject changedTo, JSONObject baseOutput, Set<String> includeFields) {
        if (cur == null) {
            return null;
        }
        if (changedTo == null) {
            return baseOutput;
        }
        Iterator keys = changedTo.keys();
        JSONObject output = baseOutput != null ? baseOutput : new JSONObject();
        while (keys.hasNext()) {
            try {
                String key = (String)keys.next();
                Object value = changedTo.get(key);
                if (cur.has(key)) {
                    Object curValue;
                    if (value instanceof JSONObject) {
                        JSONObject returnedJson;
                        String returnedJsonStr;
                        curValue = cur.getJSONObject(key);
                        JSONObject outValue = null;
                        if (baseOutput != null && baseOutput.has(key)) {
                            outValue = baseOutput.getJSONObject(key);
                        }
                        if ((returnedJsonStr = (returnedJson = JSONUtils.generateJsonDiff(curValue, (JSONObject)value, outValue, includeFields)).toString()).equals("{}")) continue;
                        output.put(key, (Object)new JSONObject(returnedJsonStr));
                        continue;
                    }
                    if (value instanceof JSONArray) {
                        JSONUtils.handleJsonArray(key, (JSONArray)value, cur.getJSONArray(key), output);
                        continue;
                    }
                    if (includeFields != null && includeFields.contains(key)) {
                        output.put(key, value);
                        continue;
                    }
                    curValue = cur.get(key);
                    if (value.equals(curValue)) continue;
                    if (curValue instanceof Number && value instanceof Number) {
                        if (((Number)curValue).doubleValue() == ((Number)value).doubleValue()) continue;
                        output.put(key, value);
                        continue;
                    }
                    output.put(key, value);
                    continue;
                }
                if (value instanceof JSONObject) {
                    output.put(key, (Object)new JSONObject(value.toString()));
                    continue;
                }
                if (value instanceof JSONArray) {
                    JSONUtils.handleJsonArray(key, (JSONArray)value, null, output);
                    continue;
                }
                output.put(key, value);
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        return output;
    }

    private static void handleJsonArray(String key, JSONArray newArray, JSONArray curArray, JSONObject output) throws JSONException {
        String arrayValue;
        int i;
        if (key.endsWith("_a") || key.endsWith("_d")) {
            output.put(key, (Object)newArray);
            return;
        }
        String arrayStr = JSONUtils.toStringNE(newArray);
        JSONArray newOutArray = new JSONArray();
        JSONArray remOutArray = new JSONArray();
        String curArrayStr = curArray == null ? null : JSONUtils.toStringNE(curArray);
        for (i = 0; i < newArray.length(); ++i) {
            arrayValue = (String)newArray.get(i);
            if (curArray != null && curArrayStr.contains(arrayValue)) continue;
            newOutArray.put((Object)arrayValue);
        }
        if (curArray != null) {
            for (i = 0; i < curArray.length(); ++i) {
                arrayValue = curArray.getString(i);
                if (arrayStr.contains(arrayValue)) continue;
                remOutArray.put((Object)arrayValue);
            }
        }
        if (!newOutArray.toString().equals("[]")) {
            output.put(key + "_a", (Object)newOutArray);
        }
        if (!remOutArray.toString().equals("[]")) {
            output.put(key + "_d", (Object)remOutArray);
        }
    }

    static String toStringNE(JSONArray jsonArray) {
        String strArray = "[";
        try {
            for (int i = 0; i < jsonArray.length(); ++i) {
                strArray = strArray + "\"" + jsonArray.getString(i) + "\"";
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return strArray + "]";
    }

    static String toUnescapedEUIDString(JSONObject json) {
        String matched;
        Pattern eidPattern;
        Matcher eidMatcher;
        String strJsonBody = json.toString();
        if (json.has("external_user_id") && (eidMatcher = (eidPattern = Pattern.compile("(?<=\"external_user_id\":\").*?(?=\")")).matcher(strJsonBody)).find() && (matched = eidMatcher.group(0)) != null) {
            String unescapedEID = matched.replace("\\/", "/");
            unescapedEID = Matcher.quoteReplacement(unescapedEID);
            strJsonBody = eidMatcher.replaceAll(unescapedEID);
        }
        return strJsonBody;
    }

    static JSONObject getJSONObjectWithoutBlankValues(ImmutableJSONObject jsonObject, String getKey) {
        if (!jsonObject.has(getKey)) {
            return null;
        }
        JSONObject toReturn = new JSONObject();
        JSONObject keyValues = jsonObject.optJSONObject(getKey);
        Iterator keys = keyValues.keys();
        while (keys.hasNext()) {
            String key = (String)keys.next();
            try {
                Object value = keyValues.get(key);
                if ("".equals(value)) continue;
                toReturn.put(key, value);
            }
            catch (JSONException jSONException) {}
        }
        return toReturn;
    }

    @Nullable
    static Map<String, Object> jsonObjectToMap(@Nullable JSONObject json) throws JSONException {
        if (json == null || json == JSONObject.NULL) {
            return null;
        }
        return JSONUtils.jsonObjectToMapNonNull(json);
    }

    @NonNull
    private static Map<String, Object> jsonObjectToMapNonNull(@NonNull JSONObject object) throws JSONException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Iterator keysItr = object.keys();
        while (keysItr.hasNext()) {
            String key = (String)keysItr.next();
            Object value = object.get(key);
            map.put(key, JSONUtils.convertNestedJSONType(value));
        }
        return map;
    }

    @Nullable
    static List<Object> jsonArrayToList(@Nullable JSONArray array) throws JSONException {
        if (array == null) {
            return null;
        }
        return JSONUtils.jsonArrayToListNonNull(array);
    }

    @NonNull
    private static List<Object> jsonArrayToListNonNull(@NonNull JSONArray array) throws JSONException {
        ArrayList<Object> list = new ArrayList<Object>();
        for (int i = 0; i < array.length(); ++i) {
            Object value = array.get(i);
            list.add(JSONUtils.convertNestedJSONType(value));
        }
        return list;
    }

    @NonNull
    private static Object convertNestedJSONType(@NonNull Object value) throws JSONException {
        if (value instanceof JSONObject) {
            return JSONUtils.jsonObjectToMapNonNull((JSONObject)value);
        }
        if (value instanceof JSONArray) {
            return JSONUtils.jsonArrayToListNonNull((JSONArray)value);
        }
        return value;
    }

    static boolean compareJSONArrays(JSONArray jsonArray1, JSONArray jsonArray2) {
        if (jsonArray1 == null && jsonArray2 == null) {
            return true;
        }
        if (jsonArray1 == null || jsonArray2 == null) {
            return false;
        }
        if (jsonArray1.length() != jsonArray2.length()) {
            return false;
        }
        try {
            block2: for (int i = 0; i < jsonArray1.length(); ++i) {
                for (int j = 0; j < jsonArray2.length(); ++j) {
                    Object obj2;
                    Object obj1 = JSONUtils.normalizeType(jsonArray1.get(i));
                    if (obj1.equals(obj2 = JSONUtils.normalizeType(jsonArray2.get(j)))) continue block2;
                }
                return false;
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Object normalizeType(Object object) {
        Class<?> clazz = object.getClass();
        if (clazz.equals(Integer.class)) {
            return (long)((Integer)object).intValue();
        }
        if (clazz.equals(Float.class)) {
            return (double)((Float)object).floatValue();
        }
        return object;
    }
}

