/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.app.Activity;
import android.content.Context;
import android.os.Build;
import androidx.annotation.ChecksSdkIntAtLeast;
import com.onesignal.AlertDialogPrepromptForAndroidSettings;
import com.onesignal.NavigateToAndroidSettingsForNotifications;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.PermissionsActivity;
import com.onesignal.R;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002J\b\u0010\u0010\u001a\u00020\nH\u0002J\b\u0010\u0011\u001a\u00020\u000eH\u0016J\u0006\u0010\u0012\u001a\u00020\u000eJ\u0010\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\nH\u0016J\u0018\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\bJ\b\u0010\u0017\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u00020\n8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lcom/onesignal/NotificationPermissionController;", "Lcom/onesignal/PermissionsActivity$PermissionCallback;", "()V", "ANDROID_PERMISSION_STRING", "", "PERMISSION_TYPE", "callbacks", "", "Lcom/onesignal/OneSignal$PromptForPushNotificationPermissionResponseHandler;", "supportsNativePrompt", "", "getSupportsNativePrompt", "()Z", "fireCallBacks", "", "accepted", "notificationsEnabled", "onAccept", "onAppForegrounded", "onReject", "fallbackToSettings", "prompt", "callback", "showFallbackAlertDialog", "onesignal_release"})
public final class NotificationPermissionController
implements PermissionsActivity.PermissionCallback {
    private static final String PERMISSION_TYPE = "NOTIFICATION";
    private static final String ANDROID_PERMISSION_STRING = "android.permission.POST_NOTIFICATIONS";
    private static final Set<OneSignal.PromptForPushNotificationPermissionResponseHandler> callbacks;
    @ChecksSdkIntAtLeast(api=33)
    private static final boolean supportsNativePrompt;
    @NotNull
    public static final NotificationPermissionController INSTANCE;

    public final boolean getSupportsNativePrompt() {
        return supportsNativePrompt;
    }

    public final void prompt(boolean fallbackToSettings, @Nullable OneSignal.PromptForPushNotificationPermissionResponseHandler callback) {
        if (callback != null) {
            callbacks.add(callback);
        }
        if (this.notificationsEnabled()) {
            this.fireCallBacks(true);
            return;
        }
        if (!supportsNativePrompt) {
            if (fallbackToSettings) {
                this.showFallbackAlertDialog();
            } else {
                this.fireCallBacks(false);
            }
            return;
        }
        PermissionsActivity.startPrompt(fallbackToSettings, PERMISSION_TYPE, ANDROID_PERMISSION_STRING, this.getClass());
    }

    @Override
    public void onAccept() {
        OneSignal.refreshNotificationPermissionState();
        this.fireCallBacks(true);
    }

    @Override
    public void onReject(boolean fallbackToSettings) {
        boolean fallbackShown;
        boolean bl = fallbackShown = fallbackToSettings ? this.showFallbackAlertDialog() : false;
        if (!fallbackShown) {
            this.fireCallBacks(false);
        }
    }

    private final boolean showFallbackAlertDialog() {
        Activity activity = OneSignal.getCurrentActivity();
        if (activity == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)activity, (String)"OneSignal.getCurrentActivity() ?: return false");
        Activity activity2 = activity;
        String string2 = activity2.getString(R.string.notification_permission_name_for_title);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"activity.getString(R.str\u2026ermission_name_for_title)");
        String string3 = activity2.getString(R.string.notification_permission_settings_message);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"activity.getString(R.str\u2026mission_settings_message)");
        AlertDialogPrepromptForAndroidSettings.INSTANCE.show(activity2, string2, string3, new AlertDialogPrepromptForAndroidSettings.Callback(activity2){
            final /* synthetic */ Activity $activity;

            public void onAccept() {
                NavigateToAndroidSettingsForNotifications.INSTANCE.show((Context)this.$activity);
            }

            public void onDecline() {
                NotificationPermissionController.access$fireCallBacks(NotificationPermissionController.INSTANCE, false);
            }
            {
                this.$activity = $captured_local_variable$0;
            }
        });
        return true;
    }

    private final void fireCallBacks(boolean accepted) {
        Iterable $this$forEach$iv = callbacks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OneSignal.PromptForPushNotificationPermissionResponseHandler it = (OneSignal.PromptForPushNotificationPermissionResponseHandler)element$iv;
            boolean bl = false;
            it.response(accepted);
        }
        callbacks.clear();
    }

    public final void onAppForegrounded() {
        this.fireCallBacks(this.notificationsEnabled());
    }

    private final boolean notificationsEnabled() {
        return OSUtils.areNotificationsEnabled(OneSignal.appContext);
    }

    private NotificationPermissionController() {
    }

    static {
        NotificationPermissionController notificationPermissionController;
        INSTANCE = notificationPermissionController = new NotificationPermissionController();
        callbacks = new HashSet();
        PermissionsActivity.registerAsCallback(PERMISSION_TYPE, notificationPermissionController);
        supportsNativePrompt = Build.VERSION.SDK_INT > 32 && OSUtils.getTargetSdkVersion(OneSignal.appContext) > 32;
    }

    public static final /* synthetic */ void access$fireCallBacks(NotificationPermissionController $this, boolean accepted) {
        $this.fireCallBacks(accepted);
    }
}

