/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.onesignal.OSFocusTimeProcessorFactory;
import com.onesignal.OSLogger;
import com.onesignal.OSSyncService;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalPrefs;
import com.onesignal.OneSignalRestClient;
import com.onesignal.influence.domain.OSInfluence;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.json.JSONException;
import org.json.JSONObject;

class FocusTimeController {
    @Nullable
    private Long timeFocusedAtMs;
    private Object timeFocusedAtMsLock = new Object();
    private OSFocusTimeProcessorFactory processorFactory;
    private OSLogger logger;

    FocusTimeController(OSFocusTimeProcessorFactory processorFactory, OSLogger logger) {
        this.processorFactory = processorFactory;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appForegrounded() {
        Object object = this.timeFocusedAtMsLock;
        synchronized (object) {
            this.timeFocusedAtMs = OneSignal.getTime().getElapsedRealtime();
            this.logger.debug("Application foregrounded focus time: " + this.timeFocusedAtMs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appStopped() {
        Long timeElapsed = this.getTimeFocusedElapsed();
        Object object = this.timeFocusedAtMsLock;
        synchronized (object) {
            this.logger.debug("Application stopped focus time: " + this.timeFocusedAtMs + " timeElapsed: " + timeElapsed);
        }
        if (timeElapsed == null) {
            return;
        }
        List<OSInfluence> influences = OneSignal.getSessionManager().getSessionInfluences();
        this.processorFactory.getTimeProcessorWithInfluences(influences).saveUnsentActiveData(timeElapsed, influences);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void appBackgrounded() {
        Object object = this.timeFocusedAtMsLock;
        synchronized (object) {
            this.logger.debug("Application backgrounded focus time: " + this.timeFocusedAtMs);
            this.processorFactory.getTimeProcessorSaved().sendUnsentTimeNow();
            this.timeFocusedAtMs = null;
        }
    }

    void doBlockingBackgroundSyncOfUnsentTime() {
        if (OneSignal.isInForeground()) {
            return;
        }
        this.processorFactory.getTimeProcessorSaved().syncUnsentTimeFromSyncJob();
    }

    void onSessionEnded(@NonNull List<OSInfluence> lastInfluences) {
        FocusEventType focusEventType = FocusEventType.END_SESSION;
        boolean hadValidTime = this.giveProcessorsValidFocusTime(lastInfluences, focusEventType);
        if (!hadValidTime) {
            this.processorFactory.getTimeProcessorWithInfluences(lastInfluences).sendUnsentTimeNow(focusEventType);
        }
    }

    private boolean giveProcessorsValidFocusTime(@NonNull List<OSInfluence> influences, @NonNull FocusEventType focusType) {
        Long timeElapsed = this.getTimeFocusedElapsed();
        if (timeElapsed == null) {
            return false;
        }
        this.processorFactory.getTimeProcessorWithInfluences(influences).addTime(timeElapsed, influences, focusType);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Long getTimeFocusedElapsed() {
        Object object = this.timeFocusedAtMsLock;
        synchronized (object) {
            if (this.timeFocusedAtMs == null) {
                return null;
            }
            long timeElapsed = (long)((double)(OneSignal.getTime().getElapsedRealtime() - this.timeFocusedAtMs) / 1000.0 + 0.5);
            if (timeElapsed < 1L || timeElapsed > 86400L) {
                return null;
            }
            return timeElapsed;
        }
    }

    static abstract class FocusTimeProcessorBase {
        protected long MIN_ON_FOCUS_TIME_SEC;
        @NonNull
        protected String PREF_KEY_FOR_UNSENT_TIME;
        @Nullable
        private Long unsentActiveTime = null;
        @NonNull
        private final AtomicBoolean runningOnFocusTime = new AtomicBoolean();

        FocusTimeProcessorBase() {
        }

        protected abstract void sendTime(@NonNull FocusEventType var1);

        protected abstract List<OSInfluence> getInfluences();

        protected abstract void saveInfluences(List<OSInfluence> var1);

        private void saveUnsentActiveData(long time, @NonNull List<OSInfluence> influences) {
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + ":saveUnsentActiveData with lastFocusTimeInfluences: " + influences.toString());
            long totalTime = this.getUnsentActiveTime() + time;
            this.saveInfluences(influences);
            this.saveUnsentActiveTime(totalTime);
        }

        private void saveUnsentActiveTime(long time) {
            this.unsentActiveTime = time;
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + ":saveUnsentActiveTime: " + this.unsentActiveTime);
            OneSignalPrefs.saveLong(OneSignalPrefs.PREFS_ONESIGNAL, this.PREF_KEY_FOR_UNSENT_TIME, time);
        }

        private long getUnsentActiveTime() {
            if (this.unsentActiveTime == null) {
                this.unsentActiveTime = OneSignalPrefs.getLong(OneSignalPrefs.PREFS_ONESIGNAL, this.PREF_KEY_FOR_UNSENT_TIME, 0L);
            }
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + ":getUnsentActiveTime: " + this.unsentActiveTime);
            return this.unsentActiveTime;
        }

        private void addTime(long time, @NonNull List<OSInfluence> influences, @NonNull FocusEventType focusType) {
            this.saveUnsentActiveData(time, influences);
            this.sendUnsentTimeNow(focusType);
        }

        private void sendUnsentTimeNow() {
            List<OSInfluence> influences = this.getInfluences();
            long unsentActiveTime = this.getUnsentActiveTime();
            OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + ":sendUnsentTimeNow with time: " + unsentActiveTime + " and influences: " + influences.toString());
            this.sendUnsentTimeNow(FocusEventType.BACKGROUND);
        }

        private void sendUnsentTimeNow(FocusEventType focusType) {
            if (!OneSignal.hasUserId()) {
                OneSignal.Log(OneSignal.LOG_LEVEL.WARN, this.getClass().getSimpleName() + ":sendUnsentTimeNow not possible due to user id null");
                return;
            }
            this.sendTime(focusType);
        }

        private boolean hasMinSyncTime() {
            return this.getUnsentActiveTime() >= this.MIN_ON_FOCUS_TIME_SEC;
        }

        protected void syncUnsentTimeOnBackgroundEvent() {
            if (!this.hasMinSyncTime()) {
                return;
            }
            OSSyncService.getInstance().scheduleSyncTask(OneSignal.appContext);
        }

        private void syncUnsentTimeFromSyncJob() {
            if (this.hasMinSyncTime()) {
                this.syncOnFocusTime();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @WorkerThread
        protected void syncOnFocusTime() {
            if (this.runningOnFocusTime.get()) {
                return;
            }
            AtomicBoolean atomicBoolean = this.runningOnFocusTime;
            synchronized (atomicBoolean) {
                this.runningOnFocusTime.set(true);
                if (this.hasMinSyncTime()) {
                    this.sendOnFocus(this.getUnsentActiveTime());
                }
                this.runningOnFocusTime.set(false);
            }
        }

        private void sendOnFocusToPlayer(@NonNull String userId, @NonNull JSONObject jsonBody) {
            OneSignalRestClient.ResponseHandler responseHandler = new OneSignalRestClient.ResponseHandler(){

                @Override
                void onFailure(int statusCode, String response, Throwable throwable) {
                    OneSignal.logHttpError("sending on_focus Failed", statusCode, throwable, response);
                }

                @Override
                void onSuccess(String response) {
                    this.saveUnsentActiveTime(0L);
                }
            };
            String url = "players/" + userId + "/on_focus";
            OneSignalRestClient.postSync(url, jsonBody, responseHandler);
        }

        protected void additionalFieldsToAddToOnFocusPayload(@NonNull JSONObject jsonBody) {
        }

        @NonNull
        private JSONObject generateOnFocusPayload(long totalTimeActive) throws JSONException {
            JSONObject jsonBody = new JSONObject().put("app_id", (Object)OneSignal.getSavedAppId()).put("type", 1).put("state", (Object)"ping").put("active_time", totalTimeActive).put("device_type", new OSUtils().getDeviceType());
            OneSignal.addNetType(jsonBody);
            return jsonBody;
        }

        private void sendOnFocus(long totalTimeActive) {
            try {
                OneSignal.Log(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + ":sendOnFocus with totalTimeActive: " + totalTimeActive);
                JSONObject jsonBody = this.generateOnFocusPayload(totalTimeActive);
                this.additionalFieldsToAddToOnFocusPayload(jsonBody);
                this.sendOnFocusToPlayer(OneSignal.getUserId(), jsonBody);
                if (OneSignal.hasEmailId()) {
                    this.sendOnFocusToPlayer(OneSignal.getEmailId(), this.generateOnFocusPayload(totalTimeActive));
                }
                if (OneSignal.hasSMSlId()) {
                    this.sendOnFocusToPlayer(OneSignal.getSMSId(), this.generateOnFocusPayload(totalTimeActive));
                }
                this.saveInfluences(new ArrayList<OSInfluence>());
            }
            catch (JSONException t) {
                OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Generating on_focus:JSON Failed.", t);
            }
        }
    }

    private static enum FocusEventType {
        BACKGROUND,
        END_SESSION;

    }

    static class FocusTimeProcessorAttributed
    extends FocusTimeProcessorBase {
        FocusTimeProcessorAttributed() {
            this.MIN_ON_FOCUS_TIME_SEC = 1L;
            this.PREF_KEY_FOR_UNSENT_TIME = "OS_UNSENT_ATTRIBUTED_ACTIVE_TIME";
        }

        @Override
        protected List<OSInfluence> getInfluences() {
            ArrayList<OSInfluence> influences = new ArrayList<OSInfluence>();
            Set<String> influenceJSONs = OneSignalPrefs.getStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_ATTRIBUTED_INFLUENCES", new HashSet<String>());
            for (String influenceJSON : influenceJSONs) {
                try {
                    influences.add(new OSInfluence(influenceJSON));
                }
                catch (JSONException exception) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, this.getClass().getSimpleName() + ": error generation OSInfluence from json object: " + (Object)((Object)exception));
                }
            }
            return influences;
        }

        @Override
        protected void saveInfluences(List<OSInfluence> influences) {
            HashSet<String> setInfluences = new HashSet<String>();
            for (OSInfluence influence : influences) {
                try {
                    setInfluences.add(influence.toJSONString());
                }
                catch (JSONException exception) {
                    OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, this.getClass().getSimpleName() + ": error generation json object OSInfluence: " + (Object)((Object)exception));
                }
            }
            OneSignalPrefs.saveStringSet(OneSignalPrefs.PREFS_ONESIGNAL, "PREFS_OS_ATTRIBUTED_INFLUENCES", setInfluences);
        }

        @Override
        protected void additionalFieldsToAddToOnFocusPayload(@NonNull JSONObject jsonBody) {
            OneSignal.getSessionManager().addSessionIds(jsonBody, this.getInfluences());
        }

        @Override
        protected void sendTime(@NonNull FocusEventType focusType) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + " sendTime with: " + (Object)((Object)focusType));
            if (focusType.equals((Object)FocusEventType.END_SESSION)) {
                this.syncOnFocusTime();
            } else {
                OSSyncService.getInstance().scheduleSyncTask(OneSignal.appContext);
            }
        }
    }

    static class FocusTimeProcessorUnattributed
    extends FocusTimeProcessorBase {
        FocusTimeProcessorUnattributed() {
            this.MIN_ON_FOCUS_TIME_SEC = 60L;
            this.PREF_KEY_FOR_UNSENT_TIME = "GT_UNSENT_ACTIVE_TIME";
        }

        @Override
        protected void sendTime(@NonNull FocusEventType focusType) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, this.getClass().getSimpleName() + " sendTime with: " + (Object)((Object)focusType));
            if (focusType.equals((Object)FocusEventType.END_SESSION)) {
                return;
            }
            this.syncUnsentTimeOnBackgroundEvent();
        }

        @Override
        protected void saveInfluences(List<OSInfluence> influences) {
        }

        @Override
        protected List<OSInfluence> getInfluences() {
            return new ArrayList<OSInfluence>();
        }
    }
}

