/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ValueAnimator;
import android.app.Activity;
import android.content.Context;
import android.graphics.Color;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Handler;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.webkit.WebView;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.cardview.widget.CardView;
import androidx.core.widget.PopupWindowCompat;
import com.onesignal.DraggableRelativeLayout;
import com.onesignal.OSInAppMessageContent;
import com.onesignal.OSUtils;
import com.onesignal.OSViewUtils;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalAnimate;
import com.onesignal.OneSignalBounceInterpolator;
import com.onesignal.WebViewManager;

class InAppMessageView {
    private static final String IN_APP_MESSAGE_CARD_VIEW_TAG = "IN_APP_MESSAGE_CARD_VIEW_TAG";
    private static final int ACTIVITY_BACKGROUND_COLOR_EMPTY = Color.parseColor((String)"#00000000");
    private static final int ACTIVITY_BACKGROUND_COLOR_FULL = Color.parseColor((String)"#BB000000");
    private static final int IN_APP_BANNER_ANIMATION_DURATION_MS = 1000;
    private static final int IN_APP_CENTER_ANIMATION_DURATION_MS = 1000;
    private static final int IN_APP_BACKGROUND_ANIMATION_DURATION_MS = 400;
    private static final int ACTIVITY_FINISH_AFTER_DISMISS_DELAY_MS = 600;
    private static final int ACTIVITY_INIT_DELAY = 200;
    private static final int DRAG_THRESHOLD_PX_SIZE = OSViewUtils.dpToPx(4);
    private PopupWindow popupWindow;
    private Activity currentActivity;
    private final Handler handler = new Handler();
    private int pageWidth;
    private int pageHeight;
    private int marginPxSizeLeft = OSViewUtils.dpToPx(24);
    private int marginPxSizeRight = OSViewUtils.dpToPx(24);
    private int marginPxSizeTop = OSViewUtils.dpToPx(24);
    private int marginPxSizeBottom = OSViewUtils.dpToPx(24);
    private double displayDuration;
    private boolean hasBackground;
    private boolean shouldDismissWhenActive = false;
    private boolean isDragging = false;
    private boolean disableDragDismiss = false;
    private OSInAppMessageContent messageContent;
    @NonNull
    private WebViewManager.Position displayLocation;
    private WebView webView;
    private RelativeLayout parentRelativeLayout;
    private DraggableRelativeLayout draggableRelativeLayout;
    private InAppMessageViewListener messageController;
    private Runnable scheduleDismissRunnable;

    InAppMessageView(@NonNull WebView webView, @NonNull OSInAppMessageContent content, boolean disableDragDismiss) {
        this.webView = webView;
        this.displayLocation = content.getDisplayLocation();
        this.pageHeight = content.getPageHeight();
        this.pageWidth = -1;
        this.displayDuration = content.getDisplayDuration() == null ? 0.0 : content.getDisplayDuration();
        this.hasBackground = !this.displayLocation.isBanner();
        this.disableDragDismiss = disableDragDismiss;
        this.messageContent = content;
        this.setMarginsFromContent(content);
    }

    private void setMarginsFromContent(OSInAppMessageContent content) {
        this.marginPxSizeTop = content.getUseHeightMargin() ? OSViewUtils.dpToPx(24) : 0;
        this.marginPxSizeBottom = content.getUseHeightMargin() ? OSViewUtils.dpToPx(24) : 0;
        this.marginPxSizeLeft = content.getUseWidthMargin() ? OSViewUtils.dpToPx(24) : 0;
        this.marginPxSizeRight = content.getUseWidthMargin() ? OSViewUtils.dpToPx(24) : 0;
    }

    void setWebView(WebView webView) {
        this.webView = webView;
        this.webView.setBackgroundColor(0);
    }

    void setMessageController(InAppMessageViewListener messageController) {
        this.messageController = messageController;
    }

    @NonNull
    WebViewManager.Position getDisplayPosition() {
        return this.displayLocation;
    }

    void showView(Activity activity) {
        this.delayShowUntilAvailable(activity);
    }

    void checkIfShouldDismiss() {
        if (this.shouldDismissWhenActive) {
            this.shouldDismissWhenActive = false;
            this.finishAfterDelay(null);
        }
    }

    void updateHeight(final int pageHeight) {
        this.pageHeight = pageHeight;
        OSUtils.runOnMainUIThread(new Runnable(){

            @Override
            public void run() {
                if (InAppMessageView.this.webView == null) {
                    OneSignal.onesignalLog(OneSignal.LOG_LEVEL.WARN, "WebView height update skipped, new height will be used once it is displayed.");
                    return;
                }
                ViewGroup.LayoutParams layoutParams = InAppMessageView.this.webView.getLayoutParams();
                if (layoutParams == null) {
                    OneSignal.onesignalLog(OneSignal.LOG_LEVEL.WARN, "WebView height update skipped because of null layoutParams, new height will be used once it is displayed.");
                    return;
                }
                layoutParams.height = pageHeight;
                InAppMessageView.this.webView.setLayoutParams(layoutParams);
                if (InAppMessageView.this.draggableRelativeLayout != null) {
                    InAppMessageView.this.draggableRelativeLayout.setParams(InAppMessageView.this.createDraggableLayoutParams(pageHeight, InAppMessageView.this.displayLocation, InAppMessageView.this.disableDragDismiss));
                }
            }
        });
    }

    void showInAppMessageView(Activity currentActivity) {
        this.currentActivity = currentActivity;
        RelativeLayout.LayoutParams webViewLayoutParams = new RelativeLayout.LayoutParams(-1, this.pageHeight);
        webViewLayoutParams.addRule(13);
        RelativeLayout.LayoutParams relativeLayoutParams = this.hasBackground ? this.createParentRelativeLayoutParams() : null;
        this.showDraggableView(this.displayLocation, webViewLayoutParams, relativeLayoutParams, this.createDraggableLayoutParams(this.pageHeight, this.displayLocation, this.disableDragDismiss));
    }

    private int getDisplayYSize() {
        return OSViewUtils.getWindowHeight(this.currentActivity);
    }

    private RelativeLayout.LayoutParams createParentRelativeLayoutParams() {
        RelativeLayout.LayoutParams relativeLayoutParams = new RelativeLayout.LayoutParams(this.pageWidth, -1);
        switch (this.displayLocation) {
            case TOP_BANNER: {
                relativeLayoutParams.addRule(10);
                relativeLayoutParams.addRule(14);
                break;
            }
            case BOTTOM_BANNER: {
                relativeLayoutParams.addRule(12);
                relativeLayoutParams.addRule(14);
                break;
            }
            case CENTER_MODAL: 
            case FULL_SCREEN: {
                relativeLayoutParams.addRule(13);
            }
        }
        return relativeLayoutParams;
    }

    private DraggableRelativeLayout.Params createDraggableLayoutParams(int pageHeight, WebViewManager.Position displayLocation, boolean disableDragging) {
        DraggableRelativeLayout.Params draggableParams = new DraggableRelativeLayout.Params();
        draggableParams.maxXPos = this.marginPxSizeRight;
        draggableParams.maxYPos = this.marginPxSizeTop;
        draggableParams.draggingDisabled = disableDragging;
        draggableParams.messageHeight = pageHeight;
        draggableParams.height = this.getDisplayYSize();
        switch (displayLocation) {
            case TOP_BANNER: {
                draggableParams.dragThresholdY = this.marginPxSizeTop - DRAG_THRESHOLD_PX_SIZE;
                break;
            }
            case BOTTOM_BANNER: {
                draggableParams.posY = this.getDisplayYSize() - pageHeight;
                draggableParams.dragThresholdY = this.marginPxSizeBottom + DRAG_THRESHOLD_PX_SIZE;
                break;
            }
            case FULL_SCREEN: {
                draggableParams.messageHeight = pageHeight = this.getDisplayYSize() - (this.marginPxSizeBottom + this.marginPxSizeTop);
            }
            case CENTER_MODAL: {
                int y = this.getDisplayYSize() / 2 - pageHeight / 2;
                draggableParams.dragThresholdY = y + DRAG_THRESHOLD_PX_SIZE;
                draggableParams.maxYPos = y;
                draggableParams.posY = y;
            }
        }
        draggableParams.dragDirection = displayLocation == WebViewManager.Position.TOP_BANNER ? 0 : 1;
        return draggableParams;
    }

    private void showDraggableView(final WebViewManager.Position displayLocation, final RelativeLayout.LayoutParams relativeLayoutParams, final RelativeLayout.LayoutParams draggableRelativeLayoutParams, final DraggableRelativeLayout.Params webViewLayoutParams) {
        OSUtils.runOnMainUIThread(new Runnable(){

            @Override
            public void run() {
                if (InAppMessageView.this.webView == null) {
                    return;
                }
                InAppMessageView.this.webView.setLayoutParams((ViewGroup.LayoutParams)relativeLayoutParams);
                Context context = InAppMessageView.this.currentActivity.getApplicationContext();
                InAppMessageView.this.setUpDraggableLayout(context, draggableRelativeLayoutParams, webViewLayoutParams);
                InAppMessageView.this.setUpParentRelativeLayout(context);
                InAppMessageView.this.createPopupWindow(InAppMessageView.this.parentRelativeLayout);
                if (InAppMessageView.this.messageController != null) {
                    InAppMessageView.this.animateInAppMessage(displayLocation, (View)InAppMessageView.this.draggableRelativeLayout, (View)InAppMessageView.this.parentRelativeLayout);
                }
                InAppMessageView.this.startDismissTimerIfNeeded();
            }
        });
    }

    private void createPopupWindow(@NonNull RelativeLayout parentRelativeLayout) {
        this.popupWindow = new PopupWindow((View)parentRelativeLayout, this.hasBackground ? -1 : this.pageWidth, this.hasBackground ? -1 : -2, true);
        this.popupWindow.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.popupWindow.setTouchable(true);
        this.popupWindow.setClippingEnabled(false);
        int gravity = 0;
        if (!this.hasBackground) {
            switch (this.displayLocation) {
                case TOP_BANNER: {
                    gravity = 49;
                    break;
                }
                case BOTTOM_BANNER: {
                    gravity = 81;
                    break;
                }
                case CENTER_MODAL: 
                case FULL_SCREEN: {
                    gravity = 1;
                }
            }
        }
        int displayType = this.messageContent.isFullBleed() ? 1000 : 1003;
        PopupWindowCompat.setWindowLayoutType((PopupWindow)this.popupWindow, (int)displayType);
        this.popupWindow.showAtLocation(this.currentActivity.getWindow().getDecorView().getRootView(), gravity, 0, 0);
    }

    private void setUpParentRelativeLayout(Context context) {
        this.parentRelativeLayout = new RelativeLayout(context);
        this.parentRelativeLayout.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.parentRelativeLayout.setClipChildren(false);
        this.parentRelativeLayout.setClipToPadding(false);
        this.parentRelativeLayout.addView((View)this.draggableRelativeLayout);
    }

    private void setUpDraggableLayout(Context context, RelativeLayout.LayoutParams relativeLayoutParams, DraggableRelativeLayout.Params draggableParams) {
        this.draggableRelativeLayout = new DraggableRelativeLayout(context);
        if (relativeLayoutParams != null) {
            this.draggableRelativeLayout.setLayoutParams((ViewGroup.LayoutParams)relativeLayoutParams);
        }
        this.draggableRelativeLayout.setParams(draggableParams);
        this.draggableRelativeLayout.setListener(new DraggableRelativeLayout.DraggableListener(){

            @Override
            public void onDismiss() {
                if (InAppMessageView.this.messageController != null) {
                    InAppMessageView.this.messageController.onMessageWillDismiss();
                }
                InAppMessageView.this.finishAfterDelay(null);
            }

            @Override
            public void onDragStart() {
                InAppMessageView.this.isDragging = true;
            }

            @Override
            public void onDragEnd() {
                InAppMessageView.this.isDragging = false;
            }
        });
        if (this.webView.getParent() != null) {
            ((ViewGroup)this.webView.getParent()).removeAllViews();
        }
        CardView cardView = this.createCardView(context);
        cardView.setTag((Object)IN_APP_MESSAGE_CARD_VIEW_TAG);
        cardView.addView((View)this.webView);
        this.draggableRelativeLayout.setPadding(this.marginPxSizeLeft, this.marginPxSizeTop, this.marginPxSizeRight, this.marginPxSizeBottom);
        this.draggableRelativeLayout.setClipChildren(false);
        this.draggableRelativeLayout.setClipToPadding(false);
        this.draggableRelativeLayout.addView((View)cardView);
    }

    boolean isDragging() {
        return this.isDragging;
    }

    private CardView createCardView(Context context) {
        CardView cardView = new CardView(context);
        int height = this.displayLocation == WebViewManager.Position.FULL_SCREEN ? -1 : -2;
        RelativeLayout.LayoutParams cardViewLayoutParams = new RelativeLayout.LayoutParams(-1, height);
        cardViewLayoutParams.addRule(13);
        cardView.setLayoutParams((ViewGroup.LayoutParams)cardViewLayoutParams);
        if (Build.VERSION.SDK_INT == 23) {
            cardView.setCardElevation(0.0f);
        } else {
            cardView.setCardElevation((float)OSViewUtils.dpToPx(5));
        }
        cardView.setRadius((float)OSViewUtils.dpToPx(8));
        cardView.setClipChildren(false);
        cardView.setClipToPadding(false);
        cardView.setPreventCornerOverlap(false);
        cardView.setCardBackgroundColor(0);
        return cardView;
    }

    private void startDismissTimerIfNeeded() {
        if (this.displayDuration <= 0.0) {
            return;
        }
        if (this.scheduleDismissRunnable != null) {
            return;
        }
        this.scheduleDismissRunnable = new Runnable(){

            @Override
            public void run() {
                if (InAppMessageView.this.messageController != null) {
                    InAppMessageView.this.messageController.onMessageWillDismiss();
                }
                if (InAppMessageView.this.currentActivity != null) {
                    InAppMessageView.this.dismissAndAwaitNextMessage(null);
                    InAppMessageView.this.scheduleDismissRunnable = null;
                } else {
                    InAppMessageView.this.shouldDismissWhenActive = true;
                }
            }
        };
        this.handler.postDelayed(this.scheduleDismissRunnable, (long)this.displayDuration * 1000L);
    }

    private void delayShowUntilAvailable(final Activity currentActivity) {
        if (OSViewUtils.isActivityFullyReady(currentActivity) && this.parentRelativeLayout == null) {
            this.showInAppMessageView(currentActivity);
            return;
        }
        new Handler().postDelayed(new Runnable(){

            @Override
            public void run() {
                InAppMessageView.this.delayShowUntilAvailable(currentActivity);
            }
        }, 200L);
    }

    void dismissAndAwaitNextMessage(@Nullable WebViewManager.OneSignalGenericCallback callback) {
        if (this.draggableRelativeLayout == null) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "No host presenter to trigger dismiss animation, counting as dismissed already", new Throwable());
            this.dereferenceViews();
            if (callback != null) {
                callback.onComplete();
            }
            return;
        }
        this.draggableRelativeLayout.dismiss();
        this.finishAfterDelay(callback);
    }

    private void finishAfterDelay(final WebViewManager.OneSignalGenericCallback callback) {
        OSUtils.runOnMainThreadDelayed(new Runnable(){

            @Override
            public void run() {
                if (InAppMessageView.this.hasBackground && InAppMessageView.this.parentRelativeLayout != null) {
                    InAppMessageView.this.animateAndDismissLayout((View)InAppMessageView.this.parentRelativeLayout, callback);
                } else {
                    InAppMessageView.this.cleanupViewsAfterDismiss();
                    if (callback != null) {
                        callback.onComplete();
                    }
                }
            }
        }, 600);
    }

    private void cleanupViewsAfterDismiss() {
        this.removeAllViews();
        if (this.messageController != null) {
            this.messageController.onMessageWasDismissed();
        }
    }

    void removeAllViews() {
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.DEBUG, "InAppMessageView removing views");
        if (this.scheduleDismissRunnable != null) {
            this.handler.removeCallbacks(this.scheduleDismissRunnable);
            this.scheduleDismissRunnable = null;
        }
        if (this.draggableRelativeLayout != null) {
            this.draggableRelativeLayout.removeAllViews();
        }
        if (this.popupWindow != null) {
            this.popupWindow.dismiss();
        }
        this.dereferenceViews();
    }

    private void dereferenceViews() {
        this.parentRelativeLayout = null;
        this.draggableRelativeLayout = null;
        this.webView = null;
    }

    private void animateInAppMessage(WebViewManager.Position displayLocation, View messageView, View backgroundView) {
        CardView messageViewCardView = (CardView)messageView.findViewWithTag((Object)IN_APP_MESSAGE_CARD_VIEW_TAG);
        Animation.AnimationListener cardViewAnimCallback = this.createAnimationListener(messageViewCardView);
        switch (displayLocation) {
            case TOP_BANNER: {
                this.animateTop((View)messageViewCardView, this.webView.getHeight(), cardViewAnimCallback);
                break;
            }
            case BOTTOM_BANNER: {
                this.animateBottom((View)messageViewCardView, this.webView.getHeight(), cardViewAnimCallback);
                break;
            }
            case CENTER_MODAL: 
            case FULL_SCREEN: {
                this.animateCenter(messageView, backgroundView, cardViewAnimCallback, null);
            }
        }
    }

    private Animation.AnimationListener createAnimationListener(final CardView messageViewCardView) {
        return new Animation.AnimationListener(){

            public void onAnimationStart(Animation animation) {
            }

            public void onAnimationEnd(Animation animation) {
                if (Build.VERSION.SDK_INT == 23) {
                    messageViewCardView.setCardElevation((float)OSViewUtils.dpToPx(5));
                }
                if (InAppMessageView.this.messageController != null) {
                    InAppMessageView.this.messageController.onMessageWasShown();
                }
            }

            public void onAnimationRepeat(Animation animation) {
            }
        };
    }

    private void animateTop(View messageView, int height, Animation.AnimationListener cardViewAnimCallback) {
        OneSignalAnimate.animateViewByTranslation(messageView, -height - this.marginPxSizeTop, 0.0f, 1000, new OneSignalBounceInterpolator(0.1, 8.0), cardViewAnimCallback).start();
    }

    private void animateBottom(View messageView, int height, Animation.AnimationListener cardViewAnimCallback) {
        OneSignalAnimate.animateViewByTranslation(messageView, height + this.marginPxSizeBottom, 0.0f, 1000, new OneSignalBounceInterpolator(0.1, 8.0), cardViewAnimCallback).start();
    }

    private void animateCenter(View messageView, View backgroundView, Animation.AnimationListener cardViewAnimCallback, Animator.AnimatorListener backgroundAnimCallback) {
        Animation messageAnimation = OneSignalAnimate.animateViewSmallToLarge(messageView, 1000, new OneSignalBounceInterpolator(0.1, 8.0), cardViewAnimCallback);
        ValueAnimator backgroundAnimation = this.animateBackgroundColor(backgroundView, 400, ACTIVITY_BACKGROUND_COLOR_EMPTY, ACTIVITY_BACKGROUND_COLOR_FULL, backgroundAnimCallback);
        messageAnimation.start();
        backgroundAnimation.start();
    }

    private void animateAndDismissLayout(View backgroundView, final WebViewManager.OneSignalGenericCallback callback) {
        AnimatorListenerAdapter animCallback = new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                InAppMessageView.this.cleanupViewsAfterDismiss();
                if (callback != null) {
                    callback.onComplete();
                }
            }
        };
        this.animateBackgroundColor(backgroundView, 400, ACTIVITY_BACKGROUND_COLOR_FULL, ACTIVITY_BACKGROUND_COLOR_EMPTY, (Animator.AnimatorListener)animCallback).start();
    }

    private ValueAnimator animateBackgroundColor(View backgroundView, int duration, int startColor, int endColor, Animator.AnimatorListener animCallback) {
        return OneSignalAnimate.animateViewColor(backgroundView, duration, startColor, endColor, animCallback);
    }

    public String toString() {
        return "InAppMessageView{currentActivity=" + this.currentActivity + ", pageWidth=" + this.pageWidth + ", pageHeight=" + this.pageHeight + ", displayDuration=" + this.displayDuration + ", hasBackground=" + this.hasBackground + ", shouldDismissWhenActive=" + this.shouldDismissWhenActive + ", isDragging=" + this.isDragging + ", disableDragDismiss=" + this.disableDragDismiss + ", displayLocation=" + (Object)((Object)this.displayLocation) + ", webView=" + this.webView + '}';
    }

    static interface InAppMessageViewListener {
        public void onMessageWasShown();

        public void onMessageWillDismiss();

        public void onMessageWasDismissed();
    }
}

