/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import androidx.annotation.Nullable;
import com.onesignal.NotificationBundleProcessor;
import com.onesignal.OSNotification;
import com.onesignal.OSNotificationGenerationJob;
import com.onesignal.OSNotificationReceivedEvent;
import com.onesignal.OSUtils;
import com.onesignal.OneSignal;
import org.json.JSONObject;

public class OSNotificationController {
    private static final String EXTENSION_SERVICE_META_DATA_TAG_NAME = "com.onesignal.NotificationServiceExtension";
    static final String GOOGLE_SENT_TIME_KEY = "google.sent_time";
    static final String GOOGLE_TTL_KEY = "google.ttl";
    private final OSNotificationGenerationJob notificationJob;
    private boolean restoring;
    private boolean fromBackgroundLogic;

    OSNotificationController(OSNotificationGenerationJob notificationJob, boolean restoring, boolean fromBackgroundLogic) {
        this.restoring = restoring;
        this.fromBackgroundLogic = fromBackgroundLogic;
        this.notificationJob = notificationJob;
    }

    OSNotificationController(Context context, OSNotification notification, JSONObject jsonPayload, boolean restoring, boolean fromBackgroundLogic, Long timestamp) {
        this.restoring = restoring;
        this.fromBackgroundLogic = fromBackgroundLogic;
        this.notificationJob = this.createNotificationJobFromCurrent(context, notification, jsonPayload, timestamp);
    }

    private OSNotificationGenerationJob createNotificationJobFromCurrent(Context context, OSNotification notification, JSONObject jsonPayload, Long timestamp) {
        OSNotificationGenerationJob notificationJob = new OSNotificationGenerationJob(context);
        notificationJob.setJsonPayload(jsonPayload);
        notificationJob.setShownTimeStamp(timestamp);
        notificationJob.setRestoring(this.restoring);
        notificationJob.setNotification(notification);
        return notificationJob;
    }

    void processNotification(OSNotification originalNotification, @Nullable OSNotification notification) {
        if (notification != null) {
            boolean display = OSUtils.isStringNotEmpty(notification.getBody());
            boolean withinTtl = this.isNotificationWithinTTL();
            if (display && withinTtl) {
                this.notificationJob.setNotification(notification);
                NotificationBundleProcessor.processJobForDisplay(this, this.fromBackgroundLogic);
            } else {
                this.notDisplayNotificationLogic(originalNotification);
            }
            if (this.restoring) {
                OSUtils.sleep(100);
            }
        } else {
            this.notDisplayNotificationLogic(originalNotification);
        }
    }

    private void notDisplayNotificationLogic(OSNotification originalNotification) {
        this.notificationJob.setNotification(originalNotification);
        if (this.restoring) {
            NotificationBundleProcessor.markNotificationAsDismissed(this.notificationJob);
        } else {
            this.notificationJob.setIsNotificationToDisplay(false);
            NotificationBundleProcessor.processNotification(this.notificationJob, true, false);
            OneSignal.handleNotificationReceived(this.notificationJob);
        }
    }

    public boolean isNotificationWithinTTL() {
        int ttl;
        boolean useTtl = OneSignal.getRemoteParamController().isRestoreTTLFilterActive();
        if (!useTtl) {
            return true;
        }
        long currentTimeInSeconds = OneSignal.getTime().getCurrentTimeMillis() / 1000L;
        long sentTime = this.notificationJob.getNotification().getSentTime();
        return sentTime + (long)(ttl = this.notificationJob.getNotification().getTtl()) > currentTimeInSeconds;
    }

    public OSNotificationGenerationJob getNotificationJob() {
        return this.notificationJob;
    }

    public OSNotificationReceivedEvent getNotificationReceivedEvent() {
        return new OSNotificationReceivedEvent(this, this.notificationJob.getNotification());
    }

    public boolean isRestoring() {
        return this.restoring;
    }

    public void setRestoring(boolean restoring) {
        this.restoring = restoring;
    }

    public boolean isFromBackgroundLogic() {
        return this.fromBackgroundLogic;
    }

    public void setFromBackgroundLogic(boolean fromBackgroundLogic) {
        this.fromBackgroundLogic = fromBackgroundLogic;
    }

    static void setupNotificationServiceExtension(Context context) {
        String className = OSUtils.getManifestMeta(context, EXTENSION_SERVICE_META_DATA_TAG_NAME);
        if (className == null) {
            OneSignal.onesignalLog(OneSignal.LOG_LEVEL.VERBOSE, "No class found, not setting up OSRemoteNotificationReceivedHandler");
            return;
        }
        OneSignal.onesignalLog(OneSignal.LOG_LEVEL.VERBOSE, "Found class: " + className + ", attempting to call constructor");
        try {
            Class<?> clazz = Class.forName(className);
            Object clazzInstance = clazz.newInstance();
            if (clazzInstance instanceof OneSignal.OSRemoteNotificationReceivedHandler && OneSignal.remoteNotificationReceivedHandler == null) {
                OneSignal.setRemoteNotificationReceivedHandler((OneSignal.OSRemoteNotificationReceivedHandler)clazzInstance);
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    public String toString() {
        return "OSNotificationController{notificationJob=" + this.notificationJob + ", isRestoring=" + this.restoring + ", isBackgroundLogic=" + this.fromBackgroundLogic + '}';
    }
}

