/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.database.Cursor;
import android.os.Build;
import android.service.notification.StatusBarNotification;
import android.text.TextUtils;
import androidx.annotation.NonNull;
import androidx.work.ExistingWorkPolicy;
import androidx.work.ListenableWorker;
import androidx.work.OneTimeWorkRequest;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import com.onesignal.BadgeCountUpdater;
import com.onesignal.NotificationLimitManager;
import com.onesignal.OSNotificationWorkManager;
import com.onesignal.OSUtils;
import com.onesignal.OSWorkManagerHelper;
import com.onesignal.OneSignal;
import com.onesignal.OneSignalDbHelper;
import com.onesignal.OneSignalNotificationManager;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

class OSNotificationRestoreWorkManager {
    static final String[] COLUMNS_FOR_RESTORE = new String[]{"notification_id", "android_notification_id", "full_data", "created_time"};
    private static final int DELAY_BETWEEN_NOTIFICATION_RESTORES_MS = 200;
    private static final String NOTIFICATION_RESTORE_WORKER_IDENTIFIER = NotificationRestoreWorker.class.getCanonicalName();
    static final int DEFAULT_TTL_IF_NOT_IN_PAYLOAD = 259200;
    public static boolean restored;

    OSNotificationRestoreWorkManager() {
    }

    public static void beginEnqueueingWork(Context context, boolean shouldDelay) {
        int restoreDelayInSeconds = shouldDelay ? 15 : 0;
        OneTimeWorkRequest workRequest = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(NotificationRestoreWorker.class).setInitialDelay((long)restoreDelayInSeconds, TimeUnit.SECONDS)).build();
        OSWorkManagerHelper.getInstance(context).enqueueUniqueWork(NOTIFICATION_RESTORE_WORKER_IDENTIFIER, ExistingWorkPolicy.KEEP, workRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void queryAndRestoreNotificationsAndBadgeCount(Context context, OneSignalDbHelper dbHelper, StringBuilder dbQuerySelection) {
        OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Querying DB for notifications to restore: " + dbQuerySelection.toString());
        Cursor cursor = null;
        try {
            cursor = dbHelper.query("notification", COLUMNS_FOR_RESTORE, dbQuerySelection.toString(), null, null, null, "_id DESC", NotificationLimitManager.MAX_NUMBER_OF_NOTIFICATIONS_STR);
            OSNotificationRestoreWorkManager.showNotificationsFromCursor(context, cursor, 200);
            BadgeCountUpdater.update(dbHelper, context);
        }
        catch (Throwable t) {
            OneSignal.Log(OneSignal.LOG_LEVEL.ERROR, "Error restoring notification records! ", t);
        }
        finally {
            if (cursor != null && !cursor.isClosed()) {
                cursor.close();
            }
        }
    }

    private static void skipVisibleNotifications(Context context, StringBuilder dbQuerySelection) {
        if (Build.VERSION.SDK_INT < 23) {
            return;
        }
        StatusBarNotification[] activeNotifs = OneSignalNotificationManager.getActiveNotifications(context);
        if (activeNotifs.length == 0) {
            return;
        }
        ArrayList<Integer> activeNotifIds = new ArrayList<Integer>();
        for (StatusBarNotification activeNotif : activeNotifs) {
            activeNotifIds.add(activeNotif.getId());
        }
        dbQuerySelection.append(" AND android_notification_id NOT IN (").append(TextUtils.join((CharSequence)",", activeNotifIds)).append(")");
    }

    static void showNotificationsFromCursor(Context context, Cursor cursor, int delay) {
        if (!cursor.moveToFirst()) {
            return;
        }
        do {
            String osNotificationId = cursor.getString(cursor.getColumnIndex("notification_id"));
            int existingId = cursor.getInt(cursor.getColumnIndex("android_notification_id"));
            String fullData = cursor.getString(cursor.getColumnIndex("full_data"));
            long dateTime = cursor.getLong(cursor.getColumnIndex("created_time"));
            OSNotificationWorkManager.beginEnqueueingWork(context, osNotificationId, existingId, fullData, dateTime, true, false);
            if (delay <= 0) continue;
            OSUtils.sleep(delay);
        } while (cursor.moveToNext());
    }

    public static class NotificationRestoreWorker
    extends Worker {
        public NotificationRestoreWorker(@NonNull Context context, @NonNull WorkerParameters workerParams) {
            super(context, workerParams);
        }

        @NonNull
        public ListenableWorker.Result doWork() {
            Context context = this.getApplicationContext();
            if (OneSignal.appContext == null) {
                OneSignal.initWithContext(context);
            }
            if (!OSUtils.areNotificationsEnabled(context)) {
                return ListenableWorker.Result.failure();
            }
            if (restored) {
                return ListenableWorker.Result.failure();
            }
            restored = true;
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "Restoring notifications");
            OneSignalDbHelper dbHelper = OneSignalDbHelper.getInstance(context);
            StringBuilder dbQuerySelection = OneSignalDbHelper.recentUninteractedWithNotificationsWhere();
            OSNotificationRestoreWorkManager.skipVisibleNotifications(context, dbQuerySelection);
            OSNotificationRestoreWorkManager.queryAndRestoreNotificationsAndBadgeCount(context, dbHelper, dbQuerySelection);
            return ListenableWorker.Result.success();
        }
    }
}

