/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal;

import android.content.Context;
import android.util.Base64;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.WorkerThread;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import com.google.firebase.FirebaseApp;
import com.google.firebase.FirebaseOptions;
import com.google.firebase.messaging.FirebaseMessaging;
import com.onesignal.OneSignal;
import com.onesignal.PushRegistratorAbstractGoogle;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.ExecutionException;

class PushRegistratorFCM
extends PushRegistratorAbstractGoogle {
    private static final String FCM_APP_NAME = "ONESIGNAL_SDK_FCM_APP_NAME";
    private FirebaseApp firebaseApp;
    @NonNull
    private final Context context;
    @NonNull
    private final Params params;

    PushRegistratorFCM(@NonNull Context context, @Nullable Params params) {
        this.context = context;
        this.params = params == null ? new Params() : params;
    }

    @Override
    String getProviderName() {
        return "FCM";
    }

    @Override
    @WorkerThread
    String getToken(String senderId) throws Exception {
        this.initFirebaseApp(senderId);
        try {
            return this.getTokenWithClassFirebaseMessaging();
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            OneSignal.Log(OneSignal.LOG_LEVEL.INFO, "FirebaseMessaging.getToken not found, attempting to use FirebaseInstanceId.getToken");
            return this.getTokenWithClassFirebaseInstanceId(senderId);
        }
    }

    @Deprecated
    @WorkerThread
    private String getTokenWithClassFirebaseInstanceId(String senderId) throws IOException {
        ReflectiveOperationException exception;
        try {
            Class<?> FirebaseInstanceIdClass = Class.forName("com.google.firebase.iid.FirebaseInstanceId");
            Method getInstanceMethod = FirebaseInstanceIdClass.getMethod("getInstance", FirebaseApp.class);
            Object instanceId = getInstanceMethod.invoke(null, this.firebaseApp);
            Method getTokenMethod = instanceId.getClass().getMethod("getToken", String.class, String.class);
            Object token = getTokenMethod.invoke(instanceId, senderId, "FCM");
            return (String)token;
        }
        catch (ClassNotFoundException e) {
            exception = e;
        }
        catch (NoSuchMethodException e) {
            exception = e;
        }
        catch (IllegalAccessException e) {
            exception = e;
        }
        catch (InvocationTargetException e) {
            exception = e;
        }
        throw new Error("Reflection error on FirebaseInstanceId.getInstance(firebaseApp).getToken(senderId, FirebaseMessaging.INSTANCE_ID_SCOPE)", exception);
    }

    @WorkerThread
    private String getTokenWithClassFirebaseMessaging() throws Exception {
        FirebaseMessaging fcmInstance = (FirebaseMessaging)this.firebaseApp.get(FirebaseMessaging.class);
        Task tokenTask = fcmInstance.getToken();
        try {
            return (String)Tasks.await((Task)tokenTask);
        }
        catch (ExecutionException e) {
            throw tokenTask.getException();
        }
    }

    private void initFirebaseApp(String senderId) {
        if (this.firebaseApp != null) {
            return;
        }
        FirebaseOptions firebaseOptions = new FirebaseOptions.Builder().setGcmSenderId(senderId).setApplicationId(this.params.appId).setApiKey(this.params.apiKey).setProjectId(this.params.projectId).build();
        this.firebaseApp = FirebaseApp.initializeApp((Context)this.context, (FirebaseOptions)firebaseOptions, (String)FCM_APP_NAME);
    }

    static class Params {
        private static final String FCM_DEFAULT_PROJECT_ID = "onesignal-shared-public";
        private static final String FCM_DEFAULT_APP_ID = "1:754795614042:android:c682b8144a8dd52bc1ad63";
        private static final String FCM_DEFAULT_API_KEY_BASE64 = "QUl6YVN5QW5UTG41LV80TWMyYTJQLWRLVWVFLWFCdGd5Q3JqbFlV";
        @NonNull
        private final String projectId;
        @NonNull
        private final String appId;
        @NonNull
        private final String apiKey;

        Params() {
            this(null, null, null);
        }

        Params(@Nullable String projectId, @Nullable String appId, @Nullable String apiKey) {
            this.projectId = projectId != null ? projectId : FCM_DEFAULT_PROJECT_ID;
            this.appId = appId != null ? appId : FCM_DEFAULT_APP_ID;
            String defaultApiKey = new String(Base64.decode((String)FCM_DEFAULT_API_KEY_BASE64, (int)0));
            this.apiKey = apiKey != null ? apiKey : defaultApiKey;
        }
    }
}

