/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common;

import android.app.Activity;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Looper;
import android.text.TextUtils;
import android.view.View;
import androidx.annotation.Keep;
import com.onesignal.common.AndroidSupportV4Compat;
import com.onesignal.core.internal.application.IApplicationService;
import com.onesignal.debug.internal.logging.Logging;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u0003\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001<B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\t\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000bJ\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u0013J$\u0010\u0016\u001a\u0004\u0018\u00010\u00052\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0017\u001a\u0004\u0018\u00010\u00052\b\u0010\u0018\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u001d\u001a\u00020\u001bJ\u000e\u0010\u001e\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\u001f\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0013J\u0006\u0010#\u001a\u00020\u000fJ\u0006\u0010$\u001a\u00020\u000fJ\u001e\u0010%\u001a\u00020\u000f2\u0006\u0010&\u001a\u00020\u00052\u0006\u0010'\u001a\u00020\u000f2\u0006\u0010\u0007\u001a\u00020\bJ\u0006\u0010(\u001a\u00020\u000fJ\u000e\u0010)\u001a\u00020\u000f2\u0006\u0010 \u001a\u00020!J\u0006\u0010*\u001a\u00020\u000fJ\u0010\u0010+\u001a\u00020\u000f2\b\u0010,\u001a\u0004\u0018\u00010\u0005J\u0010\u0010-\u001a\u00020\u000f2\b\u0010.\u001a\u0004\u0018\u00010\u0005J\u0014\u0010/\u001a\u00020\u000f2\n\u00100\u001a\u0006\u0012\u0002\b\u000301H\u0007J\u0016\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u000b2\u0006\u00105\u001a\u000206J\u0016\u00102\u001a\u0002032\u0006\u00104\u001a\u00020\u000b2\u0006\u00107\u001a\u00020\u0005J\u000e\u00108\u001a\u0002092\u0006\u00105\u001a\u000206J\u000e\u0010:\u001a\u0002032\u0006\u0010;\u001a\u00020\u0013\u00a8\u0006="}, d2={"Lcom/onesignal/common/AndroidUtils;", "", "()V", "filterManifestPermissions", "", "", "permissions", "applicationService", "Lcom/onesignal/core/internal/application/IApplicationService;", "getAppVersion", "context", "Landroid/content/Context;", "getManifestMeta", "metaName", "getManifestMetaBoolean", "", "getManifestMetaBundle", "Landroid/os/Bundle;", "getRandomDelay", "", "minDelay", "maxDelay", "getResourceString", "key", "defaultStr", "getRootCauseMessage", "throwable", "", "getRootCauseThrowable", "subjectThrowable", "getTargetSdkVersion", "hasConfigChangeFlag", "activity", "Landroid/app/Activity;", "configChangeFlag", "hasJobIntentService", "hasNotificationManagerCompat", "hasPermission", "permission", "isUserGranted", "hasWakefulBroadcastReceiver", "isActivityFullyReady", "isRunningOnMainThread", "isStringNotEmpty", "body", "isValidResourceName", "name", "opaqueHasClass", "_class", "Ljava/lang/Class;", "openURLInBrowser", "", "appContext", "uri", "Landroid/net/Uri;", "url", "openURLInBrowserIntent", "Landroid/content/Intent;", "sleep", "ms", "SchemaType", "core_release"})
public final class AndroidUtils {
    @NotNull
    public static final AndroidUtils INSTANCE = new AndroidUtils();

    private AndroidUtils() {
    }

    public final int getRandomDelay(int minDelay, int maxDelay) {
        return new Random().nextInt(maxDelay + 1 - minDelay) + minDelay;
    }

    public final boolean isStringNotEmpty(@Nullable String body) {
        return !TextUtils.isEmpty((CharSequence)body);
    }

    public final boolean isActivityFullyReady(@NotNull Activity activity) {
        boolean hasToken;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        boolean bl = hasToken = activity.getWindow().getDecorView().getApplicationWindowToken() != null;
        if (Build.VERSION.SDK_INT < 23) {
            return hasToken;
        }
        View view = activity.getWindow().getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view, (String)"activity.window.decorView");
        View decorView = view;
        boolean insetsAttached = decorView.getRootWindowInsets() != null;
        return hasToken && insetsAttached;
    }

    public final void sleep(int ms) {
        try {
            Thread.sleep(ms);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    public final boolean hasConfigChangeFlag(@NotNull Activity activity, int configChangeFlag) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        boolean hasFlag = false;
        try {
            int configChanges = activity.getPackageManager().getActivityInfo((ComponentName)activity.getComponentName(), (int)0).configChanges;
            int flagInt = configChanges & configChangeFlag;
            hasFlag = flagInt != 0;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
        }
        return hasFlag;
    }

    @Nullable
    public final String getAppVersion(@NotNull Context context) {
        Integer appVersion;
        Integer n;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            n = context.getPackageManager().getPackageInfo((String)context.getPackageName(), (int)0).versionCode;
        }
        catch (PackageManager.NameNotFoundException e) {
            n = null;
        }
        Integer n2 = appVersion = n;
        return n2 != null ? n2.toString() : null;
    }

    @Nullable
    public final String getManifestMeta(@NotNull Context context, @Nullable String metaName) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Bundle bundle2 = bundle = this.getManifestMetaBundle(context);
        return bundle2 != null ? bundle2.getString(metaName) : null;
    }

    public final boolean getManifestMetaBoolean(@NotNull Context context, @Nullable String metaName) {
        Bundle bundle;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Bundle bundle2 = bundle = this.getManifestMetaBundle(context);
        return bundle2 != null ? bundle2.getBoolean(metaName) : false;
    }

    @Nullable
    public final Bundle getManifestMetaBundle(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        ApplicationInfo ai = null;
        try {
            ApplicationInfo applicationInfo = context.getPackageManager().getApplicationInfo(context.getPackageName(), 128);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"context.packageManager.g\u2026_META_DATA,\n            )");
            ai = applicationInfo;
            return ai.metaData;
        }
        catch (PackageManager.NameNotFoundException e) {
            Logging.error("Manifest application info not found", e);
            return null;
        }
    }

    @Nullable
    public final String getResourceString(@NotNull Context context, @Nullable String key, @Nullable String defaultStr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Resources resources = context.getResources();
        int bodyResId = resources.getIdentifier(key, "string", context.getPackageName());
        return bodyResId != 0 ? resources.getString(bodyResId) : defaultStr;
    }

    public final boolean isValidResourceName(@Nullable String name) {
        CharSequence charSequence;
        return name != null && !new Regex("^[0-9]").matches(charSequence = (CharSequence)name);
    }

    @NotNull
    public final Throwable getRootCauseThrowable(@NotNull Throwable subjectThrowable) {
        Intrinsics.checkNotNullParameter((Object)subjectThrowable, (String)"subjectThrowable");
        Throwable throwable = subjectThrowable;
        while (throwable.getCause() != null && throwable.getCause() != throwable) {
            Intrinsics.checkNotNull((Object)throwable.getCause());
        }
        return throwable;
    }

    @Nullable
    public final String getRootCauseMessage(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        return this.getRootCauseThrowable(throwable).getMessage();
    }

    public final boolean isRunningOnMainThread() {
        return Intrinsics.areEqual((Object)Thread.currentThread(), (Object)Looper.getMainLooper().getThread());
    }

    public final int getTargetSdkVersion(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String packageName = context.getPackageName();
        PackageManager packageManager = context.getPackageManager();
        try {
            ApplicationInfo applicationInfo = packageManager.getApplicationInfo(packageName, 0);
            Intrinsics.checkNotNullExpressionValue((Object)applicationInfo, (String)"packageManager.getApplicationInfo(packageName, 0)");
            ApplicationInfo applicationInfo2 = applicationInfo;
            return applicationInfo2.targetSdkVersion;
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return 15;
        }
    }

    public final boolean hasJobIntentService() {
        boolean bl;
        try {
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    public final boolean hasWakefulBroadcastReceiver() {
        boolean bl;
        try {
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    public final boolean hasNotificationManagerCompat() {
        boolean bl;
        try {
            bl = true;
        }
        catch (Throwable e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final void openURLInBrowser(@NotNull Context appContext, @NotNull String url) {
        void $this$trim$iv;
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = url;
        Context context = appContext;
        AndroidUtils androidUtils = this;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
        Uri uri = Uri.parse((String)string2);
        Intrinsics.checkNotNullExpressionValue((Object)uri, (String)"parse(url.trim { it <= ' ' })");
        androidUtils.openURLInBrowser(context, uri);
    }

    public final void openURLInBrowser(@NotNull Context appContext, @NotNull Uri uri) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Intent intent = this.openURLInBrowserIntent(uri);
        appContext.startActivity(intent);
    }

    @NotNull
    public final Intent openURLInBrowserIntent(@NotNull Uri uri) {
        SchemaType type;
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Uri uri2 = uri;
        SchemaType schemaType = type = uri2.getScheme() != null ? SchemaType.Companion.fromString(uri2.getScheme()) : null;
        if (type == null) {
            type = SchemaType.HTTP;
            String string = uri2.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"uri.toString()");
            if (!StringsKt.contains$default((CharSequence)string, (CharSequence)"://", (boolean)false, (int)2, null)) {
                Uri uri3 = Uri.parse((String)("http://" + uri2));
                Intrinsics.checkNotNullExpressionValue((Object)uri3, (String)"parse(\"http://$uri\")");
                uri2 = uri3;
            }
        }
        Intent intent = null;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                Intent intent2 = Intent.makeMainSelectorActivity((String)"android.intent.action.MAIN", (String)"android.intent.category.APP_BROWSER");
                Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"makeMainSelectorActivity\u2026ent.CATEGORY_APP_BROWSER)");
                intent = intent2;
                intent.setData(uri2);
                break;
            }
            case 2: 
            case 3: {
                intent = new Intent("android.intent.action.VIEW", uri2);
                break;
            }
            default: {
                intent = new Intent("android.intent.action.VIEW", uri2);
            }
        }
        intent.addFlags(0x10000000);
        return intent;
    }

    public final boolean hasPermission(@NotNull String permission, boolean isUserGranted, @NotNull IApplicationService applicationService) {
        Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
        Intrinsics.checkNotNullParameter((Object)applicationService, (String)"applicationService");
        try {
            int permissionGrant;
            PackageInfo packageInfo = applicationService.getAppContext().getPackageManager().getPackageInfo(applicationService.getAppContext().getPackageName(), 4096);
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo, (String)"applicationService.appCo\u2026SSIONS,\n                )");
            PackageInfo packageInfo2 = packageInfo;
            Intrinsics.checkNotNullExpressionValue((Object)packageInfo2.requestedPermissions, (String)"packageInfo.requestedPermissions");
            String[] stringArray = packageInfo2.requestedPermissions;
            List permissionList = CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
            return !permissionList.contains(permission) ? false : (!isUserGranted ? true : (permissionGrant = AndroidSupportV4Compat.ContextCompat.INSTANCE.checkSelfPermission(applicationService.getAppContext(), permission)) != -1);
        }
        catch (PackageManager.NameNotFoundException e) {
            e.printStackTrace();
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<String> filterManifestPermissions(@NotNull List<String> permissions, @NotNull IApplicationService applicationService) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter(permissions, (String)"permissions");
        Intrinsics.checkNotNullParameter((Object)applicationService, (String)"applicationService");
        Object requestPermission = null;
        PackageInfo packageInfo = applicationService.getAppContext().getPackageManager().getPackageInfo(applicationService.getAppContext().getPackageName(), 4096);
        Intrinsics.checkNotNullExpressionValue((Object)packageInfo, (String)"applicationService.appCo\u2026eManager.GET_PERMISSIONS)");
        PackageInfo packageInfo2 = packageInfo;
        Intrinsics.checkNotNullExpressionValue((Object)packageInfo2.requestedPermissions, (String)"packageInfo.requestedPermissions");
        String[] stringArray = packageInfo2.requestedPermissions;
        List permissionList = CollectionsKt.listOf((Object[])Arrays.copyOf(stringArray, stringArray.length));
        Iterable $this$filter$iv = permissions;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String it = (String)element$iv$iv;
            boolean bl = false;
            if (!permissionList.contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Keep
    public final boolean opaqueHasClass(@NotNull Class<?> _class) {
        Intrinsics.checkNotNullParameter(_class, (String)"_class");
        return true;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0001\u0018\u0000 \b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\bB\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\t"}, d2={"Lcom/onesignal/common/AndroidUtils$SchemaType;", "", "text", "", "(Ljava/lang/String;ILjava/lang/String;)V", "DATA", "HTTPS", "HTTP", "Companion", "core_release"})
    public static final class SchemaType
    extends Enum<SchemaType> {
        @NotNull
        public static final Companion Companion;
        @NotNull
        private final String text;
        public static final /* enum */ SchemaType DATA;
        public static final /* enum */ SchemaType HTTPS;
        public static final /* enum */ SchemaType HTTP;
        private static final /* synthetic */ SchemaType[] $VALUES;

        private SchemaType(String text) {
            this.text = text;
        }

        public static SchemaType[] values() {
            return (SchemaType[])$VALUES.clone();
        }

        public static SchemaType valueOf(String value) {
            return Enum.valueOf(SchemaType.class, value);
        }

        static {
            DATA = new SchemaType("data");
            HTTPS = new SchemaType("https");
            HTTP = new SchemaType("http");
            $VALUES = schemaTypeArray = new SchemaType[]{SchemaType.DATA, SchemaType.HTTPS, SchemaType.HTTP};
            Companion = new Companion(null);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/onesignal/common/AndroidUtils$SchemaType$Companion;", "", "()V", "fromString", "Lcom/onesignal/common/AndroidUtils$SchemaType;", "text", "", "core_release"})
        public static final class Companion {
            private Companion() {
            }

            @Nullable
            public final SchemaType fromString(@Nullable String text) {
                for (SchemaType type : SchemaType.values()) {
                    if (!StringsKt.equals((String)type.text, (String)text, (boolean)true)) continue;
                    return type;
                }
                return null;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SchemaType.values().length];
            nArray[SchemaType.DATA.ordinal()] = 1;
            nArray[SchemaType.HTTPS.ordinal()] = 2;
            nArray[SchemaType.HTTP.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

