/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.core.internal.http.impl;

import android.net.TrafficStats;
import android.os.Build;
import com.onesignal.common.JSONUtils;
import com.onesignal.common.OneSignalWrapper;
import com.onesignal.core.internal.config.ConfigModel;
import com.onesignal.core.internal.config.ConfigModelStore;
import com.onesignal.core.internal.device.IInstallIdService;
import com.onesignal.core.internal.http.HttpResponse;
import com.onesignal.core.internal.http.IHttpClient;
import com.onesignal.core.internal.http.impl.HttpClient;
import com.onesignal.core.internal.http.impl.IHttpConnectionFactory;
import com.onesignal.core.internal.http.impl.TLS12SocketFactory;
import com.onesignal.core.internal.preferences.IPreferencesService;
import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.internal.logging.Logging;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import javax.net.ssl.HttpsURLConnection;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.TimeoutCancellationException;
import kotlinx.coroutines.TimeoutKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010 \n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 /2\u00020\u0001:\u0001/B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0019\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0013J#\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002J>\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0011\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0018\u0010 \u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\"0!H\u0002J?\u0010#\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J?\u0010%\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u001c\u001a\u0004\u0018\u00010\u00122\b\u0010\u001e\u001a\u0004\u0018\u00010\u001f2\u0006\u0010\u0019\u001a\u00020\u00182\b\u0010\u0015\u001a\u0004\u0018\u00010\u0012H\u0082@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010$J!\u0010&\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u001fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J!\u0010)\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u001fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J!\u0010*\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010'\u001a\u00020\u001fH\u0096@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010(J\u0017\u0010+\u001a\u0004\u0018\u00010\u00182\u0006\u0010,\u001a\u00020-H\u0002\u00a2\u0006\u0002\u0010.R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u00060"}, d2={"Lcom/onesignal/core/internal/http/impl/HttpClient;", "Lcom/onesignal/core/internal/http/IHttpClient;", "_connectionFactory", "Lcom/onesignal/core/internal/http/impl/IHttpConnectionFactory;", "_prefs", "Lcom/onesignal/core/internal/preferences/IPreferencesService;", "_configModelStore", "Lcom/onesignal/core/internal/config/ConfigModelStore;", "_time", "Lcom/onesignal/core/internal/time/ITime;", "_installIdService", "Lcom/onesignal/core/internal/device/IInstallIdService;", "(Lcom/onesignal/core/internal/http/impl/IHttpConnectionFactory;Lcom/onesignal/core/internal/preferences/IPreferencesService;Lcom/onesignal/core/internal/config/ConfigModelStore;Lcom/onesignal/core/internal/time/ITime;Lcom/onesignal/core/internal/device/IInstallIdService;)V", "delayNewRequestsUntil", "", "delete", "Lcom/onesignal/core/internal/http/HttpResponse;", "url", "", "(Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "get", "cacheKey", "(Ljava/lang/String;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getThreadTimeout", "", "timeout", "logHTTPSent", "", "method", "Ljava/net/URL;", "jsonBody", "Lorg/json/JSONObject;", "headers", "", "", "makeRequest", "(Ljava/lang/String;Ljava/lang/String;Lorg/json/JSONObject;ILjava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "makeRequestIODispatcher", "patch", "body", "(Ljava/lang/String;Lorg/json/JSONObject;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "post", "put", "retryAfterFromResponse", "con", "Ljava/net/HttpURLConnection;", "(Ljava/net/HttpURLConnection;)Ljava/lang/Integer;", "Companion", "com.onesignal.core"})
public final class HttpClient
implements IHttpClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final IHttpConnectionFactory _connectionFactory;
    @NotNull
    private final IPreferencesService _prefs;
    @NotNull
    private final ConfigModelStore _configModelStore;
    @NotNull
    private final ITime _time;
    @NotNull
    private final IInstallIdService _installIdService;
    private long delayNewRequestsUntil;
    @NotNull
    private static final String OS_API_VERSION = "1";
    @NotNull
    private static final String OS_ACCEPT_HEADER = "application/vnd.onesignal.v1+json";
    private static final int THREAD_ID = 10000;

    public HttpClient(@NotNull IHttpConnectionFactory _connectionFactory, @NotNull IPreferencesService _prefs, @NotNull ConfigModelStore _configModelStore, @NotNull ITime _time, @NotNull IInstallIdService _installIdService) {
        Intrinsics.checkNotNullParameter((Object)_connectionFactory, (String)"_connectionFactory");
        Intrinsics.checkNotNullParameter((Object)_prefs, (String)"_prefs");
        Intrinsics.checkNotNullParameter((Object)_configModelStore, (String)"_configModelStore");
        Intrinsics.checkNotNullParameter((Object)_time, (String)"_time");
        Intrinsics.checkNotNullParameter((Object)_installIdService, (String)"_installIdService");
        this._connectionFactory = _connectionFactory;
        this._prefs = _prefs;
        this._configModelStore = _configModelStore;
        this._time = _time;
        this._installIdService = _installIdService;
    }

    @Override
    @Nullable
    public Object post(@NotNull String url, @NotNull JSONObject body, @NotNull Continuation<? super HttpResponse> $completion) {
        return this.makeRequest(url, "POST", body, ((ConfigModel)this._configModelStore.getModel()).getHttpTimeout(), null, $completion);
    }

    @Override
    @Nullable
    public Object get(@NotNull String url, @Nullable String cacheKey, @NotNull Continuation<? super HttpResponse> $completion) {
        return this.makeRequest(url, null, null, ((ConfigModel)this._configModelStore.getModel()).getHttpGetTimeout(), cacheKey, $completion);
    }

    @Override
    @Nullable
    public Object put(@NotNull String url, @NotNull JSONObject body, @NotNull Continuation<? super HttpResponse> $completion) {
        return this.makeRequest(url, "PUT", body, ((ConfigModel)this._configModelStore.getModel()).getHttpTimeout(), null, $completion);
    }

    @Override
    @Nullable
    public Object patch(@NotNull String url, @NotNull JSONObject body, @NotNull Continuation<? super HttpResponse> $completion) {
        return this.makeRequest(url, "PATCH", body, ((ConfigModel)this._configModelStore.getModel()).getHttpTimeout(), null, $completion);
    }

    @Override
    @Nullable
    public Object delete(@NotNull String url, @NotNull Continuation<? super HttpResponse> $completion) {
        return this.makeRequest(url, "DELETE", null, ((ConfigModel)this._configModelStore.getModel()).getHttpTimeout(), null, $completion);
    }

    /*
     * Unable to fully structure code
     */
    private final Object makeRequest(String var1_1, String var2_2, JSONObject var3_3, int var4_4, String var5_5, Continuation<? super HttpResponse> var6_6) {
        if (!(var6_6 instanceof makeRequest.1)) ** GOTO lbl-1000
        var11_7 = var6_6;
        if ((var11_7.label & -2147483648) != 0) {
            var11_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_6){
                Object L$0;
                Object L$1;
                Object L$2;
                Object L$3;
                Object L$4;
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ HttpClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpClient.access$makeRequest(this.this$0, null, null, null, 0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var12_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (method != null && Intrinsics.areEqual((Object)((ConfigModel)this._configModelStore.getModel()).getConsentRequired(), (Object)Boxing.boxBoolean((boolean)true)) && !Intrinsics.areEqual((Object)((ConfigModel)this._configModelStore.getModel()).getConsentGiven(), (Object)Boxing.boxBoolean((boolean)true))) {
                    Logging.warn$default(method + " `" + url + "` was called before the user provided privacy consent. Your application is set to require the user's privacy consent before the OneSignal SDK can be initialized. Please ensure the user has provided consent before calling this method. You can check the latest OneSignal consent status by calling OneSignal.privacyConsent", null, 2, null);
                    return new HttpResponse(0, null, null, null, 8, null);
                }
                delayUntil = this.delayNewRequestsUntil - this._time.getCurrentTimeMillis();
                if (delayUntil > 0L) {
                    $continuation.L$0 = this;
                    $continuation.L$1 = url;
                    $continuation.L$2 = method;
                    $continuation.L$3 = jsonBody;
                    $continuation.L$4 = cacheKey;
                    $continuation.I$0 = timeout;
                    $continuation.label = 1;
                    v0 = DelayKt.delay((long)delayUntil, (Continuation)$continuation);
                    if (v0 == var12_9) {
                        return var12_9;
                    }
                }
                ** GOTO lbl38
            }
            case 1: {
                timeout = $continuation.I$0;
                cacheKey = (String)$continuation.L$4;
                jsonBody = (JSONObject)$continuation.L$3;
                method = (String)$continuation.L$2;
                url = (String)$continuation.L$1;
                this = (HttpClient)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl38:
                // 3 sources

                $continuation.L$0 = url;
                $continuation.L$1 = null;
                $continuation.L$2 = null;
                $continuation.L$3 = null;
                $continuation.L$4 = null;
                $continuation.label = 2;
                v1 = TimeoutKt.withTimeout((long)this.getThreadTimeout(timeout), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super HttpResponse>, Object>(this, url, method, jsonBody, timeout, cacheKey, null){
                    int label;
                    final /* synthetic */ HttpClient this$0;
                    final /* synthetic */ String $url;
                    final /* synthetic */ String $method;
                    final /* synthetic */ JSONObject $jsonBody;
                    final /* synthetic */ int $timeout;
                    final /* synthetic */ String $cacheKey;
                    {
                        this.this$0 = $receiver;
                        this.$url = $url;
                        this.$method = $method;
                        this.$jsonBody = $jsonBody;
                        this.$timeout = $timeout;
                        this.$cacheKey = $cacheKey;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = HttpClient.access$makeRequestIODispatcher(this.this$0, this.$url, this.$method, this.$jsonBody, this.$timeout, this.$cacheKey, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super HttpResponse> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                ** if (v1 != var12_9) goto lbl48
lbl47:
                // 1 sources

                return var12_9;
lbl48:
                // 1 sources

                ** GOTO lbl55
            }
            case 2: {
                url = (String)$continuation.L$0;
                try {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl55:
                    // 2 sources

                    return v1;
                }
                catch (TimeoutCancellationException e) {
                    Logging.error("HttpClient: Request timed out: " + url, e);
                    return new HttpResponse(0, null, e, null, 8, null);
                }
                catch (Throwable e) {
                    return new HttpResponse(0, null, e, null, 8, null);
                }
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * Unable to fully structure code
     */
    private final Object makeRequestIODispatcher(String var1_1, String var2_2, JSONObject var3_3, int var4_4, String var5_5, Continuation<? super HttpResponse> var6_6) {
        if (!(var6_6 instanceof makeRequestIODispatcher.1)) ** GOTO lbl-1000
        var10_7 = var6_6;
        if ((var10_7.label & -2147483648) != 0) {
            var10_7.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, var6_6){
                Object L$0;
                /* synthetic */ Object result;
                final /* synthetic */ HttpClient this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return HttpClient.access$makeRequestIODispatcher(this.this$0, null, null, null, 0, null, (Continuation)this);
                }
            };
        }
        $result = $continuation.result;
        var11_9 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                retVal = new Ref.ObjectRef();
                job = BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), (CoroutineContext)((CoroutineContext)Dispatchers.getIO()), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, (String)url, (int)timeout, (JSONObject)jsonBody, (String)method, (String)cacheKey, (Ref.ObjectRef<HttpResponse>)retVal, null){
                    int I$0;
                    Object L$0;
                    Object L$1;
                    Object L$2;
                    int label;
                    final /* synthetic */ HttpClient this$0;
                    final /* synthetic */ String $url;
                    final /* synthetic */ int $timeout;
                    final /* synthetic */ JSONObject $jsonBody;
                    final /* synthetic */ String $method;
                    final /* synthetic */ String $cacheKey;
                    final /* synthetic */ Ref.ObjectRef<HttpResponse> $retVal;
                    {
                        this.this$0 = $receiver;
                        this.$url = $url;
                        this.$timeout = $timeout;
                        this.$jsonBody = $jsonBody;
                        this.$method = $method;
                        this.$cacheKey = $cacheKey;
                        this.$retVal = $retVal;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     * Unable to fully structure code
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object var1_1) {
                        var15_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                httpResponse = -1;
                                con = null;
                                if (Build.VERSION.SDK_INT >= 26) {
                                    TrafficStats.setThreadStatsTag((int)10000);
                                }
                                con = HttpClient.access$get_connectionFactory$p(this.this$0).newHttpURLConnection(this.$url);
                                if (Build.VERSION.SDK_INT < 22 && con instanceof HttpsURLConnection) {
                                    conHttps = con;
                                    v0 = (HttpsURLConnection)conHttps;
                                    v1 = ((HttpsURLConnection)conHttps).getSSLSocketFactory();
                                    Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"conHttps.sslSocketFactory");
                                    v0.setSSLSocketFactory(new TLS12SocketFactory(v1));
                                }
                                con.setUseCaches(false);
                                con.setConnectTimeout(this.$timeout);
                                con.setReadTimeout(this.$timeout);
                                con.setRequestProperty("SDK-Version", "onesignal/android/050114");
                                if (OneSignalWrapper.getSdkType() != null && OneSignalWrapper.getSdkVersion() != null) {
                                    con.setRequestProperty("SDK-Wrapper", "onesignal/" + OneSignalWrapper.getSdkType() + '/' + OneSignalWrapper.getSdkVersion());
                                }
                                con.setRequestProperty("Accept", "application/vnd.onesignal.v1+json");
                                subscriptionId = ((ConfigModel)HttpClient.access$get_configModelStore$p(this.this$0).getModel()).getPushSubscriptionId();
                                if (subscriptionId != null && ((CharSequence)subscriptionId).length() > 0) {
                                    con.setRequestProperty("OneSignal-Subscription-Id", subscriptionId);
                                }
                                var13_8 = "OneSignal-Install-Id";
                                var12_9 = con;
                                this.L$0 = con;
                                this.L$1 = var12_9;
                                this.L$2 = var13_8;
                                this.I$0 = httpResponse;
                                this.label = 1;
                                v2 = HttpClient.access$get_installIdService$p(this.this$0).getId((Continuation<? super UUID>)((Continuation)this));
                                ** if (v2 != var15_2) goto lbl38
lbl37:
                                // 1 sources

                                return var15_2;
lbl38:
                                // 1 sources

                                ** GOTO lbl48
                            }
                            case 1: {
                                httpResponse = this.I$0;
                                var13_8 = (String)this.L$2;
                                var12_9 = (HttpURLConnection)this.L$1;
                                con = (HttpURLConnection)this.L$0;
                                try {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v2 = $result;
lbl48:
                                    // 2 sources

                                    var14_10 = v2;
                                    var12_9.setRequestProperty(var13_8, ((UUID)var14_10).toString());
                                    if (this.$jsonBody != null) {
                                        con.setDoInput(true);
                                    }
                                    if (this.$method != null) {
                                        con.setRequestProperty("Content-Type", "application/json; charset=UTF-8");
                                        con.setRequestMethod(this.$method);
                                        con.setDoOutput(true);
                                    }
                                    v3 = con.getRequestMethod();
                                    v4 = con.getURL();
                                    Intrinsics.checkNotNullExpressionValue((Object)v4, (String)"con.url");
                                    v5 = con.getRequestProperties();
                                    Intrinsics.checkNotNullExpressionValue(v5, (String)"con.requestProperties");
                                    HttpClient.access$logHTTPSent(this.this$0, v3, v4, this.$jsonBody, v5);
                                    if (this.$jsonBody != null) {
                                        strJsonBody = JSONUtils.INSTANCE.toUnescapedEUIDString(this.$jsonBody);
                                        v6 = Charset.forName("UTF-8");
                                        Intrinsics.checkNotNullExpressionValue((Object)v6, (String)"forName(charsetName)");
                                        v7 = strJsonBody.getBytes(v6);
                                        Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"this as java.lang.String).getBytes(charset)");
                                        sendBytes = v7;
                                        con.setFixedLengthStreamingMode(sendBytes.length);
                                        outputStream = con.getOutputStream();
                                        outputStream.write(sendBytes);
                                    }
                                    if (this.$cacheKey != null && (eTag = IPreferencesService.DefaultImpls.getString$default(HttpClient.access$get_prefs$p(this.this$0), "OneSignal", "PREFS_OS_ETAG_PREFIX_" + this.$cacheKey, null, 4, null)) != null) {
                                        con.setRequestProperty("if-none-match", eTag);
                                        Logging.debug$default("HttpClient: Adding header if-none-match: " + eTag, null, 2, null);
                                    }
                                    httpResponse = con.getResponseCode();
                                    retryAfter = HttpClient.access$retryAfterFromResponse(this.this$0, con);
                                    v8 = retryAfter;
                                    newDelayUntil = HttpClient.access$get_time$p(this.this$0).getCurrentTimeMillis() + (long)((v8 != null ? v8 : 0) * 1000);
                                    if (newDelayUntil > HttpClient.access$getDelayNewRequestsUntil$p(this.this$0)) {
                                        HttpClient.access$setDelayNewRequestsUntil$p(this.this$0, newDelayUntil);
                                    }
                                    switch (httpResponse) {
                                        case 304: {
                                            cachedResponse = IPreferencesService.DefaultImpls.getString$default(HttpClient.access$get_prefs$p(this.this$0), "OneSignal", "PREFS_OS_HTTP_CACHE_PREFIX_" + this.$cacheKey, null, 4, null);
                                            v9 = new StringBuilder().append("HttpClient: Got Response = ");
                                            v10 = this.$method;
                                            if (v10 == null) {
                                                v10 = "GET";
                                            }
                                            Logging.debug$default(v9.append(v10).append(' ').append(con.getURL()).append(" - Using Cached response due to 304: ").append(cachedResponse).toString(), null, 2, null);
                                            this.$retVal.element = new HttpResponse(httpResponse, cachedResponse, null, retryAfter, 4, null);
                                            break;
                                        }
                                        case 200: 
                                        case 201: 
                                        case 202: {
                                            inputStream = con.getInputStream();
                                            scanner = new Scanner(inputStream, "UTF-8");
                                            json = scanner.useDelimiter("\\A").hasNext() != false ? scanner.next() : "";
                                            scanner.close();
                                            v11 = new StringBuilder().append("HttpClient: Got Response = ");
                                            v12 = this.$method;
                                            if (v12 == null) {
                                                v12 = "GET";
                                            }
                                            Logging.debug$default(v11.append(v12).append(' ').append(con.getURL()).append(" - STATUS: ").append(httpResponse).append(" - Body: ").append(json).toString(), null, 2, null);
                                            if (this.$cacheKey != null && (eTag = con.getHeaderField("etag")) != null) {
                                                Logging.debug$default("HttpClient: Got Response = Response has etag of " + eTag + " so caching the response.", null, 2, null);
                                                HttpClient.access$get_prefs$p(this.this$0).saveString("OneSignal", "PREFS_OS_ETAG_PREFIX_" + this.$cacheKey, eTag);
                                                HttpClient.access$get_prefs$p(this.this$0).saveString("OneSignal", "PREFS_OS_HTTP_CACHE_PREFIX_" + this.$cacheKey, json);
                                            }
                                            this.$retVal.element = new HttpResponse(httpResponse, json, null, retryAfter, 4, null);
                                            break;
                                        }
                                        default: {
                                            v13 = new StringBuilder().append("HttpClient: Got Response = ");
                                            v14 = this.$method;
                                            if (v14 == null) {
                                                v14 = "GET";
                                            }
                                            Logging.debug$default(v13.append(v14).append(' ').append(con.getURL()).append(" - FAILED STATUS: ").append(httpResponse).toString(), null, 2, null);
                                            inputStream = con.getErrorStream();
                                            if (inputStream == null) {
                                                inputStream = con.getInputStream();
                                            }
                                            jsonResponse = null;
                                            if (inputStream != null) {
                                                scanner = new Scanner(inputStream, "UTF-8");
                                                jsonResponse = scanner.useDelimiter("\\A").hasNext() != false ? scanner.next() : "";
                                                scanner.close();
                                                Logging.warn$default("HttpClient: Got Response = " + this.$method + " - STATUS: " + httpResponse + " - Body: " + jsonResponse, null, 2, null);
                                            } else {
                                                Logging.warn$default("HttpClient: Got Response = " + this.$method + " - STATUS: " + httpResponse + " - No response body!", null, 2, null);
                                            }
                                            this.$retVal.element = new HttpResponse(httpResponse, jsonResponse, null, retryAfter, 4, null);
                                        }
                                    }
                                    v15 = con;
                                }
                                catch (Throwable t) {
                                    try {
                                        if (t instanceof ConnectException || t instanceof UnknownHostException) {
                                            Logging.info$default("HttpClient: Could not send last request, device is offline. Throwable: " + t.getClass().getName(), null, 2, null);
                                        } else {
                                            Logging.warn("HttpClient: " + this.$method + " Error thrown from network stack. ", t);
                                        }
                                        this.$retVal.element = new HttpResponse(httpResponse, null, t, null, 8, null);
                                        v16 = con;
                                    }
                                    catch (Throwable var4_7) {
                                        v17 = var3_4;
                                        if (v17 != null) {
                                            v17.disconnect();
                                        }
                                        throw var4_7;
                                    }
                                    if (v16 != null) {
                                        v16.disconnect();
                                    } else {
                                        ** GOTO lbl146
                                    }
                                }
                                if (v15 != null) {
                                    v15.disconnect();
                                }
lbl146:
                                // 4 sources

                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)2, null);
                $continuation.L$0 = retVal;
                $continuation.label = 1;
                v0 = job.join((Continuation)$continuation);
                if (v0 == var11_9) {
                    return var11_9;
                }
                ** GOTO lbl24
            }
            case 1: {
                retVal = (Ref.ObjectRef)$continuation.L$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl24:
                // 2 sources

                v1 = retVal.element;
                Intrinsics.checkNotNull((Object)v1);
                return v1;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    private final int getThreadTimeout(int timeout) {
        return timeout + 5000;
    }

    private final Integer retryAfterFromResponse(HttpURLConnection con) {
        Integer n;
        String retryAfterStr = con.getHeaderField("Retry-After");
        if (retryAfterStr != null) {
            Logging.debug$default("HttpClient: Response Retry-After: " + retryAfterStr, null, 2, null);
            Integer n2 = StringsKt.toIntOrNull((String)retryAfterStr);
            n = n2 != null ? n2.intValue() : ((ConfigModel)this._configModelStore.getModel()).getHttpRetryAfterParseFailFallback();
        } else {
            n = con.getResponseCode() == 429 ? Integer.valueOf(((ConfigModel)this._configModelStore.getModel()).getHttpRetryAfterParseFailFallback()) : (Integer)null;
        }
        return n;
    }

    private final void logHTTPSent(String method, URL url, JSONObject jsonBody, Map<String, ? extends List<String>> headers) {
        String headersStr = CollectionsKt.joinToString$default((Iterable)headers.entrySet(), null, null, null, (int)0, null, null, (int)63, null);
        String string = method;
        if (string == null) {
            string = "GET";
        }
        String methodStr = string;
        JSONObject jSONObject = jsonBody;
        String bodyStr = jSONObject != null ? JSONUtils.INSTANCE.toUnescapedEUIDString(jSONObject) : null;
        Logging.debug$default("HttpClient: Request Sent = " + methodStr + ' ' + url + " - Body: " + bodyStr + " - Headers: " + headersStr, null, 2, null);
    }

    public static final /* synthetic */ Object access$makeRequest(HttpClient $this, String url, String method, JSONObject jsonBody, int timeout, String cacheKey, Continuation $completion) {
        return $this.makeRequest(url, method, jsonBody, timeout, cacheKey, (Continuation<? super HttpResponse>)$completion);
    }

    public static final /* synthetic */ Object access$makeRequestIODispatcher(HttpClient $this, String url, String method, JSONObject jsonBody, int timeout, String cacheKey, Continuation $completion) {
        return $this.makeRequestIODispatcher(url, method, jsonBody, timeout, cacheKey, (Continuation<? super HttpResponse>)$completion);
    }

    public static final /* synthetic */ IHttpConnectionFactory access$get_connectionFactory$p(HttpClient $this) {
        return $this._connectionFactory;
    }

    public static final /* synthetic */ ConfigModelStore access$get_configModelStore$p(HttpClient $this) {
        return $this._configModelStore;
    }

    public static final /* synthetic */ IInstallIdService access$get_installIdService$p(HttpClient $this) {
        return $this._installIdService;
    }

    public static final /* synthetic */ void access$logHTTPSent(HttpClient $this, String method, URL url, JSONObject jsonBody, Map headers) {
        $this.logHTTPSent(method, url, jsonBody, headers);
    }

    public static final /* synthetic */ IPreferencesService access$get_prefs$p(HttpClient $this) {
        return $this._prefs;
    }

    public static final /* synthetic */ Integer access$retryAfterFromResponse(HttpClient $this, HttpURLConnection con) {
        return $this.retryAfterFromResponse(con);
    }

    public static final /* synthetic */ ITime access$get_time$p(HttpClient $this) {
        return $this._time;
    }

    public static final /* synthetic */ long access$getDelayNewRequestsUntil$p(HttpClient $this) {
        return $this.delayNewRequestsUntil;
    }

    public static final /* synthetic */ void access$setDelayNewRequestsUntil$p(HttpClient $this, long l) {
        $this.delayNewRequestsUntil = l;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lcom/onesignal/core/internal/http/impl/HttpClient$Companion;", "", "()V", "OS_ACCEPT_HEADER", "", "OS_API_VERSION", "THREAD_ID", "", "com.onesignal.core"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

