/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.os.Build;
import android.os.Process;
import android.util.Log;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lcom/onesignal/common/AndroidSupportV4Compat;", "", "()V", "ActivityCompat", "ActivityCompatApi23", "ContextCompat", "RequestPermissionsRequestCodeValidator", "com.onesignal.core"})
public final class AndroidSupportV4Compat {

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u0004\u00a8\u0006\u000b"}, d2={"Lcom/onesignal/common/AndroidSupportV4Compat$ContextCompat;", "", "()V", "checkSelfPermission", "", "context", "Landroid/content/Context;", "permission", "", "getColor", "id", "com.onesignal.core"})
    public static final class ContextCompat {
        @NotNull
        public static final ContextCompat INSTANCE = new ContextCompat();

        private ContextCompat() {
        }

        public final int checkSelfPermission(@NotNull Context context, @NotNull String permission) {
            int n;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            Intrinsics.checkNotNullParameter((Object)permission, (String)"permission");
            try {
                n = context.checkPermission(permission, Process.myPid(), Process.myUid());
            }
            catch (Throwable t) {
                Log.e((String)"OneSignal", (String)"checkSelfPermission failed, returning PERMISSION_DENIED");
                n = -1;
            }
            return n;
        }

        public final int getColor(@NotNull Context context, int id) {
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            return Build.VERSION.SDK_INT > 22 ? context.getColor(id) : context.getResources().getColor(id);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b`\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/onesignal/common/AndroidSupportV4Compat$RequestPermissionsRequestCodeValidator;", "", "validateRequestPermissionsRequestCode", "", "requestCode", "", "com.onesignal.core"})
    public static interface RequestPermissionsRequestCodeValidator {
        public void validateRequestPermissionsRequestCode(int var1);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J+\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\t0\b2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\t\u00a8\u0006\u0010"}, d2={"Lcom/onesignal/common/AndroidSupportV4Compat$ActivityCompat;", "", "()V", "requestPermissions", "", "activity", "Landroid/app/Activity;", "permissions", "", "", "requestCode", "", "(Landroid/app/Activity;[Ljava/lang/String;I)V", "shouldShowRequestPermissionRationale", "", "permission", "com.onesignal.core"})
    public static final class ActivityCompat {
        @NotNull
        public static final ActivityCompat INSTANCE = new ActivityCompat();

        private ActivityCompat() {
        }

        public final void requestPermissions(@NotNull Activity activity, @NotNull String[] permissions, int requestCode) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            Intrinsics.checkNotNullParameter((Object)permissions, (String)"permissions");
            ActivityCompatApi23.INSTANCE.requestPermissions(activity, permissions, requestCode);
        }

        public final boolean shouldShowRequestPermissionRationale(@Nullable Activity activity, @Nullable String permission) {
            return ActivityCompatApi23.INSTANCE.shouldShowRequestPermissionRationale(activity, permission);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c1\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J-\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0010\u0010\u0007\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\t\u0018\u00010\b2\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001a\u0010\r\u001a\u00020\u000e2\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\t\u00a8\u0006\u0010"}, d2={"Lcom/onesignal/common/AndroidSupportV4Compat$ActivityCompatApi23;", "", "()V", "requestPermissions", "", "activity", "Landroid/app/Activity;", "permissions", "", "", "requestCode", "", "(Landroid/app/Activity;[Ljava/lang/String;I)V", "shouldShowRequestPermissionRationale", "", "permission", "com.onesignal.core"})
    @TargetApi(value=23)
    public static final class ActivityCompatApi23 {
        @NotNull
        public static final ActivityCompatApi23 INSTANCE = new ActivityCompatApi23();

        private ActivityCompatApi23() {
        }

        public final void requestPermissions(@NotNull Activity activity, @Nullable String[] permissions, int requestCode) {
            Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
            if (activity instanceof RequestPermissionsRequestCodeValidator) {
                ((RequestPermissionsRequestCodeValidator)activity).validateRequestPermissionsRequestCode(requestCode);
            }
            Intrinsics.checkNotNull((Object)permissions);
            activity.requestPermissions(permissions, requestCode);
        }

        public final boolean shouldShowRequestPermissionRationale(@Nullable Activity activity, @Nullable String permission) {
            Activity activity2 = activity;
            Intrinsics.checkNotNull((Object)activity2);
            String string = permission;
            Intrinsics.checkNotNull((Object)string);
            return androidx.core.app.ActivityCompat.shouldShowRequestPermissionRationale((Activity)activity2, (String)string);
        }
    }
}

