/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.common;

import com.onesignal.common.OneSignalUtils;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u000bJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u0004J\u000e\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0004R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0011"}, d2={"Lcom/onesignal/common/OneSignalUtils;", "", "()V", "sdkVersion", "", "getSdkVersion", "()Ljava/lang/String;", "sdkVersion$delegate", "Lkotlin/Lazy;", "formatVersion", "version", "formatVersion$com_onesignal_core", "isValidEmail", "", "email", "isValidPhoneNumber", "number", "com.onesignal.core"})
public final class OneSignalUtils {
    @NotNull
    public static final OneSignalUtils INSTANCE = new OneSignalUtils();
    @NotNull
    private static final Lazy sdkVersion$delegate = LazyKt.lazy((Function0)sdkVersion.2.INSTANCE);

    private OneSignalUtils() {
    }

    @NotNull
    public final String getSdkVersion() {
        Lazy lazy = sdkVersion$delegate;
        return (String)lazy.getValue();
    }

    @NotNull
    public final String formatVersion$com_onesignal_core(@NotNull String version) {
        String string;
        String minor;
        String string2;
        String major;
        Intrinsics.checkNotNullParameter((Object)version, (String)"version");
        String[] stringArray = new String[]{"-"};
        List parts = StringsKt.split$default((CharSequence)version, (String[])stringArray, (boolean)false, (int)2, (int)2, null);
        String[] stringArray2 = new String[]{"."};
        List base = StringsKt.split$default((CharSequence)((CharSequence)parts.get(0)), (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
        String string3 = (String)CollectionsKt.getOrNull((List)base, (int)0);
        if (string3 == null || (string3 = StringsKt.padStart((String)string3, (int)2, (char)'0')) == null) {
            string3 = major = "00";
        }
        if ((string2 = (String)CollectionsKt.getOrNull((List)base, (int)1)) == null || (string2 = StringsKt.padStart((String)string2, (int)2, (char)'0')) == null) {
            string2 = minor = "00";
        }
        if ((string = (String)CollectionsKt.getOrNull((List)base, (int)2)) == null || (string = StringsKt.padStart((String)string, (int)2, (char)'0')) == null) {
            string = "00";
        }
        String patch = string;
        String formatted = major + minor + patch;
        return parts.size() > 1 ? formatted + '-' + (String)parts.get(1) : formatted;
    }

    public final boolean isValidEmail(@NotNull String email) {
        Intrinsics.checkNotNullParameter((Object)email, (String)"email");
        if (((CharSequence)email).length() == 0) {
            return false;
        }
        String emRegex = "^[a-zA-Z0-9.!#$%&'*+/=?^_`{|}~-]+@((\\[[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\.[0-9]{1,3}\\])|(([a-zA-Z\\-0-9]+\\.)+[a-zA-Z]{2,}))$";
        Pattern pattern = Pattern.compile(emRegex);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(emRegex)");
        Pattern pattern2 = pattern;
        return pattern2.matcher(email).matches();
    }

    public final boolean isValidPhoneNumber(@NotNull String number) {
        Intrinsics.checkNotNullParameter((Object)number, (String)"number");
        if (((CharSequence)number).length() == 0) {
            return false;
        }
        String emRegex = "^\\+?[1-9]\\d{1,14}$";
        Pattern pattern = Pattern.compile(emRegex);
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(emRegex)");
        Pattern pattern2 = pattern;
        return pattern2.matcher(number).matches();
    }
}

