/*
 * Decompiled with CFR 0.152.
 */
package com.onesignal.session.internal.influence.impl;

import com.onesignal.core.internal.time.ITime;
import com.onesignal.debug.internal.logging.Logging;
import com.onesignal.session.internal.influence.Influence;
import com.onesignal.session.internal.influence.InfluenceType;
import com.onesignal.session.internal.influence.impl.IChannelTracker;
import com.onesignal.session.internal.influence.impl.InfluenceDataRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0006\b \u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u00100\u001a\u00020(2\b\u00101\u001a\u0004\u0018\u000102H\u0096\u0002J\u0012\u00103\u001a\u00020\u001c2\b\u00104\u001a\u0004\u0018\u00010\u0014H&J\b\u00105\u001a\u00020\bH\u0016J\b\u00106\u001a\u000207H&J\b\u00108\u001a\u000207H\u0016J\u0010\u00109\u001a\u0002072\u0006\u0010:\u001a\u00020\u001cH&J\u0012\u0010;\u001a\u0002072\b\u00104\u001a\u0004\u0018\u00010\u0014H\u0016J\b\u0010<\u001a\u00020\u0014H\u0016R\u0012\u0010\u0007\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u0010\"\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R\u0012\u0010\u0019\u001a\u00020\bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\nR\u001c\u0010\u001b\u001a\u0004\u0018\u00010\u001cX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u001e\"\u0004\b\u001f\u0010 R\u001c\u0010!\u001a\u0004\u0018\u00010\"X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u0014\u0010'\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b'\u0010)R\u0014\u0010*\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010)R\u0014\u0010+\u001a\u00020(8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b+\u0010)R\u0014\u0010,\u001a\u00020\u001c8fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u001eR\u0014\u0010.\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001eR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006="}, d2={"Lcom/onesignal/session/internal/influence/impl/ChannelTracker;", "Lcom/onesignal/session/internal/influence/impl/IChannelTracker;", "dataRepository", "Lcom/onesignal/session/internal/influence/impl/InfluenceDataRepository;", "timeProvider", "Lcom/onesignal/core/internal/time/ITime;", "(Lcom/onesignal/session/internal/influence/impl/InfluenceDataRepository;Lcom/onesignal/core/internal/time/ITime;)V", "channelLimit", "", "getChannelLimit", "()I", "currentSessionInfluence", "Lcom/onesignal/session/internal/influence/Influence;", "getCurrentSessionInfluence", "()Lcom/onesignal/session/internal/influence/Influence;", "getDataRepository", "()Lcom/onesignal/session/internal/influence/impl/InfluenceDataRepository;", "setDataRepository", "(Lcom/onesignal/session/internal/influence/impl/InfluenceDataRepository;)V", "directId", "", "getDirectId", "()Ljava/lang/String;", "setDirectId", "(Ljava/lang/String;)V", "indirectAttributionWindow", "getIndirectAttributionWindow", "indirectIds", "Lorg/json/JSONArray;", "getIndirectIds", "()Lorg/json/JSONArray;", "setIndirectIds", "(Lorg/json/JSONArray;)V", "influenceType", "Lcom/onesignal/session/internal/influence/InfluenceType;", "getInfluenceType", "()Lcom/onesignal/session/internal/influence/InfluenceType;", "setInfluenceType", "(Lcom/onesignal/session/internal/influence/InfluenceType;)V", "isDirectSessionEnabled", "", "()Z", "isIndirectSessionEnabled", "isUnattributedSessionEnabled", "lastChannelObjects", "getLastChannelObjects", "lastReceivedIds", "getLastReceivedIds", "equals", "other", "", "getLastChannelObjectsReceivedByNewId", "id", "hashCode", "initInfluencedTypeFromCache", "", "resetAndInitInfluence", "saveChannelObjects", "channelObjects", "saveLastId", "toString", "com.onesignal.core"})
public abstract class ChannelTracker
implements IChannelTracker {
    @NotNull
    private InfluenceDataRepository dataRepository;
    @NotNull
    private ITime timeProvider;
    @Nullable
    private InfluenceType influenceType;
    @Nullable
    private JSONArray indirectIds;
    @Nullable
    private String directId;

    public ChannelTracker(@NotNull InfluenceDataRepository dataRepository, @NotNull ITime timeProvider) {
        Intrinsics.checkNotNullParameter((Object)dataRepository, (String)"dataRepository");
        Intrinsics.checkNotNullParameter((Object)timeProvider, (String)"timeProvider");
        this.dataRepository = dataRepository;
        this.timeProvider = timeProvider;
    }

    @NotNull
    protected final InfluenceDataRepository getDataRepository() {
        return this.dataRepository;
    }

    protected final void setDataRepository(@NotNull InfluenceDataRepository influenceDataRepository) {
        Intrinsics.checkNotNullParameter((Object)influenceDataRepository, (String)"<set-?>");
        this.dataRepository = influenceDataRepository;
    }

    @Override
    @Nullable
    public InfluenceType getInfluenceType() {
        return this.influenceType;
    }

    @Override
    public void setInfluenceType(@Nullable InfluenceType influenceType) {
        this.influenceType = influenceType;
    }

    @Override
    @Nullable
    public JSONArray getIndirectIds() {
        return this.indirectIds;
    }

    @Override
    public void setIndirectIds(@Nullable JSONArray jSONArray) {
        this.indirectIds = jSONArray;
    }

    @Override
    @Nullable
    public String getDirectId() {
        return this.directId;
    }

    @Override
    public void setDirectId(@Nullable String string2) {
        this.directId = string2;
    }

    @NotNull
    public abstract JSONArray getLastChannelObjects() throws JSONException;

    public abstract int getChannelLimit();

    public abstract int getIndirectAttributionWindow();

    @NotNull
    public abstract JSONArray getLastChannelObjectsReceivedByNewId(@Nullable String var1);

    public abstract void saveChannelObjects(@NotNull JSONArray var1);

    public abstract void initInfluencedTypeFromCache();

    private final boolean isDirectSessionEnabled() {
        return this.dataRepository.isDirectInfluenceEnabled();
    }

    private final boolean isIndirectSessionEnabled() {
        return this.dataRepository.isIndirectInfluenceEnabled();
    }

    private final boolean isUnattributedSessionEnabled() {
        return this.dataRepository.isUnattributedInfluenceEnabled();
    }

    @Override
    @NotNull
    public Influence getCurrentSessionInfluence() {
        InfluenceType currentInfluenceType;
        InfluenceType influenceType;
        Influence sessionInfluence = new Influence(this.getChannelType(), InfluenceType.DISABLED, null);
        if (this.getInfluenceType() == null) {
            this.initInfluencedTypeFromCache();
        }
        if ((influenceType = this.getInfluenceType()) == null) {
            influenceType = InfluenceType.DISABLED;
        }
        if ((currentInfluenceType = influenceType).isDirect()) {
            if (this.isDirectSessionEnabled()) {
                Influence influence;
                Influence $this$_get_currentSessionInfluence__u24lambda_u240 = influence = sessionInfluence;
                boolean bl = false;
                $this$_get_currentSessionInfluence__u24lambda_u240.setIds(new JSONArray().put((Object)this.getDirectId()));
                $this$_get_currentSessionInfluence__u24lambda_u240.setInfluenceType(InfluenceType.DIRECT);
            }
        } else if (currentInfluenceType.isIndirect()) {
            if (this.isIndirectSessionEnabled()) {
                Influence influence;
                Influence $this$_get_currentSessionInfluence__u24lambda_u241 = influence = sessionInfluence;
                boolean bl = false;
                $this$_get_currentSessionInfluence__u24lambda_u241.setIds(this.getIndirectIds());
                $this$_get_currentSessionInfluence__u24lambda_u241.setInfluenceType(InfluenceType.INDIRECT);
            }
        } else if (this.isUnattributedSessionEnabled()) {
            Influence influence;
            Influence $this$_get_currentSessionInfluence__u24lambda_u242 = influence = sessionInfluence;
            boolean bl = false;
            $this$_get_currentSessionInfluence__u24lambda_u242.setInfluenceType(InfluenceType.UNATTRIBUTED);
        }
        return sessionInfluence;
    }

    @Override
    @NotNull
    public JSONArray getLastReceivedIds() {
        JSONArray ids = new JSONArray();
        try {
            JSONArray lastChannelObjectReceived = this.getLastChannelObjects();
            Logging.debug$default("ChannelTracker.getLastReceivedIds: lastChannelObjectReceived: " + lastChannelObjectReceived, null, 2, null);
            long attributionWindow = (long)(this.getIndirectAttributionWindow() * 60) * 1000L;
            long currentTime = this.timeProvider.getCurrentTimeMillis();
            int n = lastChannelObjectReceived.length();
            for (int i = 0; i < n; ++i) {
                JSONObject jsonObject = lastChannelObjectReceived.getJSONObject(i);
                long time = jsonObject.getLong("time");
                long difference = currentTime - time;
                if (difference > attributionWindow) continue;
                String id = jsonObject.getString(this.getIdTag());
                ids.put((Object)id);
            }
        }
        catch (JSONException exception) {
            Logging.error("ChannelTracker.getLastReceivedIds: Generating tracker getLastReceivedIds JSONObject ", exception);
        }
        return ids;
    }

    @Override
    public void resetAndInitInfluence() {
        this.setDirectId(null);
        this.setIndirectIds(this.getLastReceivedIds());
        JSONArray jSONArray = this.getIndirectIds();
        this.setInfluenceType((jSONArray != null ? jSONArray.length() : 0) > 0 ? InfluenceType.INDIRECT : InfluenceType.UNATTRIBUTED);
        this.cacheState();
        Logging.debug$default("ChannelTracker.resetAndInitInfluence: " + this.getIdTag() + " finish with influenceType: " + (Object)((Object)this.getInfluenceType()), null, 2, null);
    }

    @Override
    public void saveLastId(@Nullable String id) {
        Logging.debug$default("ChannelTracker.saveLastId(id: " + id + "): idTag=" + this.getIdTag(), null, 2, null);
        if (id == null || ((CharSequence)id).length() == 0) {
            return;
        }
        JSONArray lastChannelObjectsReceived = this.getLastChannelObjectsReceivedByNewId(id);
        Logging.debug$default("ChannelTracker.saveLastId: for " + this.getIdTag() + " saveLastId with lastChannelObjectsReceived: " + lastChannelObjectsReceived, null, 2, null);
        try {
            JSONObject jSONObject;
            ITime $this$saveLastId_u24lambda_u243 = this.timeProvider;
            boolean bl = false;
            JSONObject newInfluenceId = jSONObject = new JSONObject().put(this.getIdTag(), (Object)id).put("time", $this$saveLastId_u24lambda_u243.getCurrentTimeMillis());
            boolean bl2 = false;
            lastChannelObjectsReceived.put((Object)newInfluenceId);
        }
        catch (JSONException exception) {
            Logging.error("ChannelTracker.saveLastId: Generating tracker newInfluenceId JSONObject ", exception);
            return;
        }
        JSONArray channelObjectToSave = lastChannelObjectsReceived;
        if (lastChannelObjectsReceived.length() > this.getChannelLimit()) {
            int lengthDifference = lastChannelObjectsReceived.length() - this.getChannelLimit();
            channelObjectToSave = new JSONArray();
            int n = lastChannelObjectsReceived.length();
            for (int i = lengthDifference; i < n; ++i) {
                try {
                    channelObjectToSave.put(lastChannelObjectsReceived.get(i));
                    continue;
                }
                catch (JSONException exception) {
                    Logging.error("ChannelTracker.saveLastId: Generating tracker lastChannelObjectsReceived get JSONObject ", exception);
                }
            }
        }
        Logging.debug$default("ChannelTracker.saveLastId: for " + this.getIdTag() + " with channelObjectToSave: " + channelObjectToSave, null, 2, null);
        this.saveChannelObjects(channelObjectToSave);
    }

    @NotNull
    public String toString() {
        return "ChannelTracker{tag=" + this.getIdTag() + ", influenceType=" + (Object)((Object)this.getInfluenceType()) + ", indirectIds=" + this.getIndirectIds() + ", directId=" + this.getDirectId() + '}';
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual(this.getClass(), other.getClass())) {
            return false;
        }
        ChannelTracker tracker = (ChannelTracker)other;
        return this.getInfluenceType() == tracker.getInfluenceType() && Intrinsics.areEqual((Object)tracker.getIdTag(), (Object)this.getIdTag());
    }

    public int hashCode() {
        InfluenceType influenceType = this.getInfluenceType();
        int result = influenceType != null ? ((Object)((Object)influenceType)).hashCode() : 0;
        result = 31 * result + this.getIdTag().hashCode();
        return result;
    }
}

