/*
 * Decompiled with CFR 0.152.
 */
package com.palantir.conjure.java.serialization;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.dataformat.cbor.CBORFactory;
import com.fasterxml.jackson.dataformat.smile.SmileFactory;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.joda.JodaModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import com.palantir.conjure.java.serialization.LenientLongModule;
import com.palantir.conjure.java.serialization.ShimJdk7Module;

public final class ObjectMappers {
    private ObjectMappers() {
    }

    public static ObjectMapper newClientObjectMapper() {
        return ObjectMappers.withDefaultModules(new ObjectMapper()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static ObjectMapper newCborClientObjectMapper() {
        return ObjectMappers.withDefaultModules(new ObjectMapper((JsonFactory)new CBORFactory())).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static ObjectMapper newSmileClientObjectMapper() {
        return ObjectMappers.withDefaultModules(new ObjectMapper((JsonFactory)new SmileFactory())).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static ObjectMapper newServerObjectMapper() {
        return ObjectMappers.withDefaultModules(new ObjectMapper()).enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static ObjectMapper newCborServerObjectMapper() {
        return ObjectMappers.withDefaultModules(new ObjectMapper((JsonFactory)new CBORFactory())).enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static ObjectMapper newSmileServerObjectMapper() {
        return ObjectMappers.withDefaultModules(new ObjectMapper((JsonFactory)new SmileFactory())).enable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    public static ObjectMapper withDefaultModules(ObjectMapper mapper) {
        return mapper.registerModule((Module)new GuavaModule()).registerModule((Module)new ShimJdk7Module()).registerModule((Module)new Jdk8Module().configureAbsentsAsNulls(true)).registerModule((Module)new AfterburnerModule()).registerModule((Module)new JavaTimeModule()).registerModule((Module)new LenientLongModule()).registerModule((Module)new JodaModule()).disable(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS).disable(SerializationFeature.WRITE_DURATIONS_AS_TIMESTAMPS).disable(DeserializationFeature.ADJUST_DATES_TO_CONTEXT_TIME_ZONE).disable(DeserializationFeature.WRAP_EXCEPTIONS).disable(SerializationFeature.FAIL_ON_EMPTY_BEANS).enable(DeserializationFeature.FAIL_ON_NULL_FOR_PRIMITIVES).disable(new MapperFeature[]{MapperFeature.ALLOW_COERCION_OF_SCALARS}).disable(DeserializationFeature.ACCEPT_FLOAT_AS_INT);
    }
}

