package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.Nulls;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.palantir.conjure.java.lib.internal.ConjureCollections;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

/**
 * Event produced after a cluster wait on a set of services have become healthy.
 */
@JsonDeserialize(builder = ClusterWaitEvent.Builder.class)
@Generated("com.palantir.conjure.java.types.BeanGenerator")
public final class ClusterWaitEvent {
    private final Task task;

    private final List<String> serviceNames;

    private final ClusterWaitType type;

    private int memoizedHashCode;

    private ClusterWaitEvent(Task task, List<String> serviceNames, ClusterWaitType type) {
        validateFields(task, serviceNames, type);
        this.task = task;
        this.serviceNames = Collections.unmodifiableList(serviceNames);
        this.type = type;
    }

    @JsonProperty("task")
    public Task getTask() {
        return this.task;
    }

    @JsonProperty("serviceNames")
    public List<String> getServiceNames() {
        return this.serviceNames;
    }

    @JsonProperty("type")
    public ClusterWaitType getType() {
        return this.type;
    }

    @Override
    public boolean equals(Object other) {
        return this == other || (other instanceof ClusterWaitEvent && equalTo((ClusterWaitEvent) other));
    }

    private boolean equalTo(ClusterWaitEvent other) {
        return this.task.equals(other.task)
                && this.serviceNames.equals(other.serviceNames)
                && this.type.equals(other.type);
    }

    @Override
    public int hashCode() {
        int result = memoizedHashCode;
        if (result == 0) {
            result = Objects.hash(this.task, this.serviceNames, this.type);
            memoizedHashCode = result;
        }
        return result;
    }

    @Override
    public String toString() {
        return "ClusterWaitEvent{task: " + task + ", serviceNames: " + serviceNames + ", type: " + type + '}';
    }

    public static ClusterWaitEvent of(Task task, List<String> serviceNames, ClusterWaitType type) {
        return builder().task(task).type(type).serviceNames(serviceNames).build();
    }

    private static void validateFields(Task task, List<String> serviceNames, ClusterWaitType type) {
        List<String> missingFields = null;
        missingFields = addFieldIfMissing(missingFields, task, "task");
        missingFields = addFieldIfMissing(missingFields, serviceNames, "serviceNames");
        missingFields = addFieldIfMissing(missingFields, type, "type");
        if (missingFields != null) {
            throw new SafeIllegalArgumentException(
                    "Some required fields have not been set", SafeArg.of("missingFields", missingFields));
        }
    }

    private static List<String> addFieldIfMissing(List<String> prev, Object fieldValue, String fieldName) {
        List<String> missingFields = prev;
        if (fieldValue == null) {
            if (missingFields == null) {
                missingFields = new ArrayList<>(3);
            }
            missingFields.add(fieldName);
        }
        return missingFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated("com.palantir.conjure.java.types.BeanBuilderGenerator")
    @JsonIgnoreProperties(ignoreUnknown = true)
    public static final class Builder {
        private Task task;

        private List<String> serviceNames = new ArrayList<>();

        private ClusterWaitType type;

        private Builder() {}

        public Builder from(ClusterWaitEvent other) {
            task(other.getTask());
            serviceNames(other.getServiceNames());
            type(other.getType());
            return this;
        }

        @JsonSetter("task")
        public Builder task(@Nonnull Task task) {
            this.task = Preconditions.checkNotNull(task, "task cannot be null");
            return this;
        }

        @JsonSetter(value = "serviceNames", nulls = Nulls.SKIP)
        public Builder serviceNames(@Nonnull Iterable<String> serviceNames) {
            this.serviceNames.clear();
            ConjureCollections.addAll(
                    this.serviceNames, Preconditions.checkNotNull(serviceNames, "serviceNames cannot be null"));
            return this;
        }

        public Builder addAllServiceNames(@Nonnull Iterable<String> serviceNames) {
            ConjureCollections.addAll(
                    this.serviceNames, Preconditions.checkNotNull(serviceNames, "serviceNames cannot be null"));
            return this;
        }

        public Builder serviceNames(String serviceNames) {
            this.serviceNames.add(serviceNames);
            return this;
        }

        @JsonSetter("type")
        public Builder type(@Nonnull ClusterWaitType type) {
            this.type = Preconditions.checkNotNull(type, "type cannot be null");
            return this;
        }

        public ClusterWaitEvent build() {
            return new ClusterWaitEvent(task, serviceNames, type);
        }
    }
}
