package com.palantir.docker.compose.events;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSetter;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.annotation.JsonValue;
import com.palantir.logsafe.Preconditions;
import com.palantir.logsafe.SafeArg;
import com.palantir.logsafe.exceptions.SafeIllegalArgumentException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Generated;
import javax.annotation.Nonnull;

@Generated("com.palantir.conjure.java.types.UnionGenerator")
public final class Event {
    private final Base value;

    @JsonCreator(mode = JsonCreator.Mode.DELEGATING)
    private Event(Base value) {
        this.value = value;
    }

    @JsonValue
    private Base getValue() {
        return value;
    }

    public static Event build(BuildEvent value) {
        return new Event(new BuildWrapper(value));
    }

    public static Event pull(PullEvent value) {
        return new Event(new PullWrapper(value));
    }

    public static Event up(UpEvent value) {
        return new Event(new UpWrapper(value));
    }

    public static Event waitForServices(WaitForServicesEvent value) {
        return new Event(new WaitForServicesWrapper(value));
    }

    public static Event clusterWait(ClusterWaitEvent value) {
        return new Event(new ClusterWaitWrapper(value));
    }

    public static Event shutdownStop(ShutdownStopEvent value) {
        return new Event(new ShutdownStopWrapper(value));
    }

    public static Event logCollection(LogCollectionEvent value) {
        return new Event(new LogCollectionWrapper(value));
    }

    public static Event shutdown(ShutdownEvent value) {
        return new Event(new ShutdownWrapper(value));
    }

    public <T> T accept(Visitor<T> visitor) {
        return value.accept(visitor);
    }

    @Override
    public boolean equals(Object other) {
        return this == other || (other instanceof Event && equalTo((Event) other));
    }

    private boolean equalTo(Event other) {
        return this.value.equals(other.value);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.value);
    }

    @Override
    public String toString() {
        return "Event{value: " + value + '}';
    }

    public interface Visitor<T> {
        T visitBuild(BuildEvent value);

        T visitPull(PullEvent value);

        T visitUp(UpEvent value);

        T visitWaitForServices(WaitForServicesEvent value);

        T visitClusterWait(ClusterWaitEvent value);

        T visitShutdownStop(ShutdownStopEvent value);

        T visitLogCollection(LogCollectionEvent value);

        T visitShutdown(ShutdownEvent value);

        T visitUnknown(String unknownType);

        static <T> BuildStageVisitorBuilder<T> builder() {
            return new VisitorBuilder<T>();
        }
    }

    private static final class VisitorBuilder<T>
            implements BuildStageVisitorBuilder<T>,
                    ClusterWaitStageVisitorBuilder<T>,
                    LogCollectionStageVisitorBuilder<T>,
                    PullStageVisitorBuilder<T>,
                    ShutdownStageVisitorBuilder<T>,
                    ShutdownStopStageVisitorBuilder<T>,
                    UpStageVisitorBuilder<T>,
                    WaitForServicesStageVisitorBuilder<T>,
                    UnknownStageVisitorBuilder<T>,
                    Completed_StageVisitorBuilder<T> {
        private Function<BuildEvent, T> buildVisitor;

        private Function<ClusterWaitEvent, T> clusterWaitVisitor;

        private Function<LogCollectionEvent, T> logCollectionVisitor;

        private Function<PullEvent, T> pullVisitor;

        private Function<ShutdownEvent, T> shutdownVisitor;

        private Function<ShutdownStopEvent, T> shutdownStopVisitor;

        private Function<UpEvent, T> upVisitor;

        private Function<WaitForServicesEvent, T> waitForServicesVisitor;

        private Function<String, T> unknownVisitor;

        @Override
        public ClusterWaitStageVisitorBuilder<T> build(@Nonnull Function<BuildEvent, T> buildVisitor) {
            Preconditions.checkNotNull(buildVisitor, "buildVisitor cannot be null");
            this.buildVisitor = buildVisitor;
            return this;
        }

        @Override
        public LogCollectionStageVisitorBuilder<T> clusterWait(
                @Nonnull Function<ClusterWaitEvent, T> clusterWaitVisitor) {
            Preconditions.checkNotNull(clusterWaitVisitor, "clusterWaitVisitor cannot be null");
            this.clusterWaitVisitor = clusterWaitVisitor;
            return this;
        }

        @Override
        public PullStageVisitorBuilder<T> logCollection(@Nonnull Function<LogCollectionEvent, T> logCollectionVisitor) {
            Preconditions.checkNotNull(logCollectionVisitor, "logCollectionVisitor cannot be null");
            this.logCollectionVisitor = logCollectionVisitor;
            return this;
        }

        @Override
        public ShutdownStageVisitorBuilder<T> pull(@Nonnull Function<PullEvent, T> pullVisitor) {
            Preconditions.checkNotNull(pullVisitor, "pullVisitor cannot be null");
            this.pullVisitor = pullVisitor;
            return this;
        }

        @Override
        public ShutdownStopStageVisitorBuilder<T> shutdown(@Nonnull Function<ShutdownEvent, T> shutdownVisitor) {
            Preconditions.checkNotNull(shutdownVisitor, "shutdownVisitor cannot be null");
            this.shutdownVisitor = shutdownVisitor;
            return this;
        }

        @Override
        public UpStageVisitorBuilder<T> shutdownStop(@Nonnull Function<ShutdownStopEvent, T> shutdownStopVisitor) {
            Preconditions.checkNotNull(shutdownStopVisitor, "shutdownStopVisitor cannot be null");
            this.shutdownStopVisitor = shutdownStopVisitor;
            return this;
        }

        @Override
        public WaitForServicesStageVisitorBuilder<T> up(@Nonnull Function<UpEvent, T> upVisitor) {
            Preconditions.checkNotNull(upVisitor, "upVisitor cannot be null");
            this.upVisitor = upVisitor;
            return this;
        }

        @Override
        public UnknownStageVisitorBuilder<T> waitForServices(
                @Nonnull Function<WaitForServicesEvent, T> waitForServicesVisitor) {
            Preconditions.checkNotNull(waitForServicesVisitor, "waitForServicesVisitor cannot be null");
            this.waitForServicesVisitor = waitForServicesVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> unknownVisitor) {
            Preconditions.checkNotNull(unknownVisitor, "unknownVisitor cannot be null");
            this.unknownVisitor = unknownVisitor;
            return this;
        }

        @Override
        public Completed_StageVisitorBuilder<T> throwOnUnknown() {
            this.unknownVisitor = unknownType -> {
                throw new SafeIllegalArgumentException(
                        "Unknown variant of the 'Event' union", SafeArg.of("unknownType", unknownType));
            };
            return this;
        }

        @Override
        public Visitor<T> build() {
            final Function<BuildEvent, T> buildVisitor = this.buildVisitor;
            final Function<ClusterWaitEvent, T> clusterWaitVisitor = this.clusterWaitVisitor;
            final Function<LogCollectionEvent, T> logCollectionVisitor = this.logCollectionVisitor;
            final Function<PullEvent, T> pullVisitor = this.pullVisitor;
            final Function<ShutdownEvent, T> shutdownVisitor = this.shutdownVisitor;
            final Function<ShutdownStopEvent, T> shutdownStopVisitor = this.shutdownStopVisitor;
            final Function<UpEvent, T> upVisitor = this.upVisitor;
            final Function<WaitForServicesEvent, T> waitForServicesVisitor = this.waitForServicesVisitor;
            final Function<String, T> unknownVisitor = this.unknownVisitor;
            return new Visitor<T>() {
                @Override
                public T visitBuild(BuildEvent value) {
                    return buildVisitor.apply(value);
                }

                @Override
                public T visitClusterWait(ClusterWaitEvent value) {
                    return clusterWaitVisitor.apply(value);
                }

                @Override
                public T visitLogCollection(LogCollectionEvent value) {
                    return logCollectionVisitor.apply(value);
                }

                @Override
                public T visitPull(PullEvent value) {
                    return pullVisitor.apply(value);
                }

                @Override
                public T visitShutdown(ShutdownEvent value) {
                    return shutdownVisitor.apply(value);
                }

                @Override
                public T visitShutdownStop(ShutdownStopEvent value) {
                    return shutdownStopVisitor.apply(value);
                }

                @Override
                public T visitUp(UpEvent value) {
                    return upVisitor.apply(value);
                }

                @Override
                public T visitWaitForServices(WaitForServicesEvent value) {
                    return waitForServicesVisitor.apply(value);
                }

                @Override
                public T visitUnknown(String value) {
                    return unknownVisitor.apply(value);
                }
            };
        }
    }

    public interface BuildStageVisitorBuilder<T> {
        ClusterWaitStageVisitorBuilder<T> build(@Nonnull Function<BuildEvent, T> buildVisitor);
    }

    public interface ClusterWaitStageVisitorBuilder<T> {
        LogCollectionStageVisitorBuilder<T> clusterWait(@Nonnull Function<ClusterWaitEvent, T> clusterWaitVisitor);
    }

    public interface LogCollectionStageVisitorBuilder<T> {
        PullStageVisitorBuilder<T> logCollection(@Nonnull Function<LogCollectionEvent, T> logCollectionVisitor);
    }

    public interface PullStageVisitorBuilder<T> {
        ShutdownStageVisitorBuilder<T> pull(@Nonnull Function<PullEvent, T> pullVisitor);
    }

    public interface ShutdownStageVisitorBuilder<T> {
        ShutdownStopStageVisitorBuilder<T> shutdown(@Nonnull Function<ShutdownEvent, T> shutdownVisitor);
    }

    public interface ShutdownStopStageVisitorBuilder<T> {
        UpStageVisitorBuilder<T> shutdownStop(@Nonnull Function<ShutdownStopEvent, T> shutdownStopVisitor);
    }

    public interface UpStageVisitorBuilder<T> {
        WaitForServicesStageVisitorBuilder<T> up(@Nonnull Function<UpEvent, T> upVisitor);
    }

    public interface WaitForServicesStageVisitorBuilder<T> {
        UnknownStageVisitorBuilder<T> waitForServices(
                @Nonnull Function<WaitForServicesEvent, T> waitForServicesVisitor);
    }

    public interface UnknownStageVisitorBuilder<T> {
        Completed_StageVisitorBuilder<T> unknown(@Nonnull Function<String, T> unknownVisitor);

        Completed_StageVisitorBuilder<T> throwOnUnknown();
    }

    public interface Completed_StageVisitorBuilder<T> {
        Visitor<T> build();
    }

    @JsonTypeInfo(
            use = JsonTypeInfo.Id.NAME,
            include = JsonTypeInfo.As.EXISTING_PROPERTY,
            property = "type",
            visible = true,
            defaultImpl = UnknownWrapper.class)
    @JsonSubTypes({
        @JsonSubTypes.Type(BuildWrapper.class),
        @JsonSubTypes.Type(PullWrapper.class),
        @JsonSubTypes.Type(UpWrapper.class),
        @JsonSubTypes.Type(WaitForServicesWrapper.class),
        @JsonSubTypes.Type(ClusterWaitWrapper.class),
        @JsonSubTypes.Type(ShutdownStopWrapper.class),
        @JsonSubTypes.Type(LogCollectionWrapper.class),
        @JsonSubTypes.Type(ShutdownWrapper.class)
    })
    @JsonIgnoreProperties(ignoreUnknown = true)
    private interface Base {
        <T> T accept(Visitor<T> visitor);
    }

    @JsonTypeName("build")
    private static final class BuildWrapper implements Base {
        private final BuildEvent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private BuildWrapper(@JsonSetter("build") @Nonnull BuildEvent value) {
            Preconditions.checkNotNull(value, "build cannot be null");
            this.value = value;
        }

        @JsonProperty(value = "type", index = 0)
        private String getType() {
            return "build";
        }

        @JsonProperty("build")
        private BuildEvent getValue() {
            return value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitBuild(value);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || (other instanceof BuildWrapper && equalTo((BuildWrapper) other));
        }

        private boolean equalTo(BuildWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public String toString() {
            return "BuildWrapper{value: " + value + '}';
        }
    }

    @JsonTypeName("pull")
    private static final class PullWrapper implements Base {
        private final PullEvent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private PullWrapper(@JsonSetter("pull") @Nonnull PullEvent value) {
            Preconditions.checkNotNull(value, "pull cannot be null");
            this.value = value;
        }

        @JsonProperty(value = "type", index = 0)
        private String getType() {
            return "pull";
        }

        @JsonProperty("pull")
        private PullEvent getValue() {
            return value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitPull(value);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || (other instanceof PullWrapper && equalTo((PullWrapper) other));
        }

        private boolean equalTo(PullWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public String toString() {
            return "PullWrapper{value: " + value + '}';
        }
    }

    @JsonTypeName("up")
    private static final class UpWrapper implements Base {
        private final UpEvent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private UpWrapper(@JsonSetter("up") @Nonnull UpEvent value) {
            Preconditions.checkNotNull(value, "up cannot be null");
            this.value = value;
        }

        @JsonProperty(value = "type", index = 0)
        private String getType() {
            return "up";
        }

        @JsonProperty("up")
        private UpEvent getValue() {
            return value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitUp(value);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || (other instanceof UpWrapper && equalTo((UpWrapper) other));
        }

        private boolean equalTo(UpWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public String toString() {
            return "UpWrapper{value: " + value + '}';
        }
    }

    @JsonTypeName("waitForServices")
    private static final class WaitForServicesWrapper implements Base {
        private final WaitForServicesEvent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private WaitForServicesWrapper(@JsonSetter("waitForServices") @Nonnull WaitForServicesEvent value) {
            Preconditions.checkNotNull(value, "waitForServices cannot be null");
            this.value = value;
        }

        @JsonProperty(value = "type", index = 0)
        private String getType() {
            return "waitForServices";
        }

        @JsonProperty("waitForServices")
        private WaitForServicesEvent getValue() {
            return value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitWaitForServices(value);
        }

        @Override
        public boolean equals(Object other) {
            return this == other
                    || (other instanceof WaitForServicesWrapper && equalTo((WaitForServicesWrapper) other));
        }

        private boolean equalTo(WaitForServicesWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public String toString() {
            return "WaitForServicesWrapper{value: " + value + '}';
        }
    }

    @JsonTypeName("clusterWait")
    private static final class ClusterWaitWrapper implements Base {
        private final ClusterWaitEvent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private ClusterWaitWrapper(@JsonSetter("clusterWait") @Nonnull ClusterWaitEvent value) {
            Preconditions.checkNotNull(value, "clusterWait cannot be null");
            this.value = value;
        }

        @JsonProperty(value = "type", index = 0)
        private String getType() {
            return "clusterWait";
        }

        @JsonProperty("clusterWait")
        private ClusterWaitEvent getValue() {
            return value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitClusterWait(value);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || (other instanceof ClusterWaitWrapper && equalTo((ClusterWaitWrapper) other));
        }

        private boolean equalTo(ClusterWaitWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public String toString() {
            return "ClusterWaitWrapper{value: " + value + '}';
        }
    }

    @JsonTypeName("shutdownStop")
    private static final class ShutdownStopWrapper implements Base {
        private final ShutdownStopEvent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private ShutdownStopWrapper(@JsonSetter("shutdownStop") @Nonnull ShutdownStopEvent value) {
            Preconditions.checkNotNull(value, "shutdownStop cannot be null");
            this.value = value;
        }

        @JsonProperty(value = "type", index = 0)
        private String getType() {
            return "shutdownStop";
        }

        @JsonProperty("shutdownStop")
        private ShutdownStopEvent getValue() {
            return value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitShutdownStop(value);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || (other instanceof ShutdownStopWrapper && equalTo((ShutdownStopWrapper) other));
        }

        private boolean equalTo(ShutdownStopWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public String toString() {
            return "ShutdownStopWrapper{value: " + value + '}';
        }
    }

    @JsonTypeName("logCollection")
    private static final class LogCollectionWrapper implements Base {
        private final LogCollectionEvent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private LogCollectionWrapper(@JsonSetter("logCollection") @Nonnull LogCollectionEvent value) {
            Preconditions.checkNotNull(value, "logCollection cannot be null");
            this.value = value;
        }

        @JsonProperty(value = "type", index = 0)
        private String getType() {
            return "logCollection";
        }

        @JsonProperty("logCollection")
        private LogCollectionEvent getValue() {
            return value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitLogCollection(value);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || (other instanceof LogCollectionWrapper && equalTo((LogCollectionWrapper) other));
        }

        private boolean equalTo(LogCollectionWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public String toString() {
            return "LogCollectionWrapper{value: " + value + '}';
        }
    }

    @JsonTypeName("shutdown")
    private static final class ShutdownWrapper implements Base {
        private final ShutdownEvent value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private ShutdownWrapper(@JsonSetter("shutdown") @Nonnull ShutdownEvent value) {
            Preconditions.checkNotNull(value, "shutdown cannot be null");
            this.value = value;
        }

        @JsonProperty(value = "type", index = 0)
        private String getType() {
            return "shutdown";
        }

        @JsonProperty("shutdown")
        private ShutdownEvent getValue() {
            return value;
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitShutdown(value);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || (other instanceof ShutdownWrapper && equalTo((ShutdownWrapper) other));
        }

        private boolean equalTo(ShutdownWrapper other) {
            return this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.value);
        }

        @Override
        public String toString() {
            return "ShutdownWrapper{value: " + value + '}';
        }
    }

    private static final class UnknownWrapper implements Base {
        private final String type;

        private final Map<String, Object> value;

        @JsonCreator(mode = JsonCreator.Mode.PROPERTIES)
        private UnknownWrapper(@JsonProperty("type") String type) {
            this(type, new HashMap<String, Object>());
        }

        private UnknownWrapper(@Nonnull String type, @Nonnull Map<String, Object> value) {
            Preconditions.checkNotNull(type, "type cannot be null");
            Preconditions.checkNotNull(value, "value cannot be null");
            this.type = type;
            this.value = value;
        }

        @JsonProperty
        private String getType() {
            return type;
        }

        @JsonAnyGetter
        private Map<String, Object> getValue() {
            return value;
        }

        @JsonAnySetter
        private void put(String key, Object val) {
            value.put(key, val);
        }

        @Override
        public <T> T accept(Visitor<T> visitor) {
            return visitor.visitUnknown(type);
        }

        @Override
        public boolean equals(Object other) {
            return this == other || (other instanceof UnknownWrapper && equalTo((UnknownWrapper) other));
        }

        private boolean equalTo(UnknownWrapper other) {
            return this.type.equals(other.type) && this.value.equals(other.value);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        @Override
        public String toString() {
            return "UnknownWrapper{type: " + type + ", value: " + value + '}';
        }
    }
}
