// Generated by delombok at Thu Nov 16 13:48:04 CST 2017
package com.paypal.api.payments;

import com.paypal.base.rest.*;
import java.util.List;

public class Authorization extends PayPalResource {
	/**
	 * ID of the authorization transaction.
	 */
	private String id;
	/**
	 * Amount being authorized.
	 */
	private Amount amount;
	/**
	 * Specifies the payment mode of the transaction.
	 */
	private String paymentMode;
	/**
	 * State of the authorization.
	 */
	private String state;
	/**
	 * Reason code, `AUTHORIZATION`, for a transaction state of `pending`.
	 */
	private String reasonCode;
	/**
	 * [DEPRECATED] Reason code for the transaction state being Pending.Obsolete. use reason_code field instead.
	 */
	private String pendingReason;
	/**
	 * The level of seller protection in force for the transaction. Only supported when the `payment_method` is set to `paypal`. Allowed values:<br>  `ELIGIBLE`- Merchant is protected by PayPal's Seller Protection Policy for Unauthorized Payments and Item Not Received.<br> `PARTIALLY_ELIGIBLE`- Merchant is protected by PayPal's Seller Protection Policy for Item Not Received or Unauthorized Payments. Refer to `protection_eligibility_type` for specifics. <br> `INELIGIBLE`- Merchant is not protected under the Seller Protection Policy.
	 */
	private String protectionEligibility;
	/**
	 * The kind of seller protection in force for the transaction. This property is returned only when the `protection_eligibility` property is set to `ELIGIBLE`or `PARTIALLY_ELIGIBLE`. Only supported when the `payment_method` is set to `paypal`. Allowed values:<br> `ITEM_NOT_RECEIVED_ELIGIBLE`- Sellers are protected against claims for items not received.<br> `UNAUTHORIZED_PAYMENT_ELIGIBLE`- Sellers are protected against claims for unauthorized payments.<br> One or both of the allowed values can be returned.
	 */
	private String protectionEligibilityType;
	/**
	 * Fraud Management Filter (FMF) details applied for the payment that could result in accept, deny, or pending action. Returned in a payment response only if the merchant has enabled FMF in the profile settings and one of the fraud filters was triggered based on those settings. See [Fraud Management Filters Summary](https://developer.paypal.com/docs/classic/fmf/integration-guide/FMFSummary/) for more information.
	 */
	private FmfDetails fmfDetails;
	/**
	 * ID of the Payment resource that this transaction is based on.
	 */
	private String parentPayment;
	/**
	 * Authorization expiration time and date as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6).
	 */
	private String validUntil;
	/**
	 * Time of authorization as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6).
	 */
	private String createTime;
	/**
	 * Time that the resource was last updated.
	 */
	private String updateTime;
	/**
	 * Identifier to the purchase or transaction unit corresponding to this authorization transaction.
	 */
	private String referenceId;
	/**
	 * Receipt id is 16 digit number payment identification number returned for guest users to identify the payment.
	 */
	private String receiptId;
	/**
	 */
	private List<Links> links;

	/**
	 * Default Constructor
	 */
	public Authorization() {
	}

	/**
	 * Parameterized Constructor
	 */
	public Authorization(Amount amount) {
		this.amount = amount;
	}

	/**
	 * Shows details for an authorization, by ID.
	 * @deprecated Please use {@link #get(APIContext, String)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param authorizationId
	 * String
	 * @return Authorization
	 * @throws PayPalRESTException
	 */
	public static Authorization get(String accessToken, String authorizationId) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return get(apiContext, authorizationId);
	}

	/**
	 * Shows details for an authorization, by ID.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param authorizationId
	 * String
	 * @return Authorization
	 * @throws PayPalRESTException
	 */
	public static Authorization get(APIContext apiContext, String authorizationId) throws PayPalRESTException {
		if (authorizationId == null) {
			throw new IllegalArgumentException("authorizationId cannot be null");
		}
		Object[] parameters = new Object[] {authorizationId};
		String pattern = "v1/payments/authorization/{0}";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		return configureAndExecute(apiContext, HttpMethod.GET, resourcePath, payLoad, Authorization.class);
	}

	/**
	 * Captures and processes an authorization, by ID. To use this call, the original payment call must specify an intent of `authorize`.
	 * @deprecated Please use {@link #capture(APIContext, Capture)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @param capture
	 * Capture
	 * @return Capture
	 * @throws PayPalRESTException
	 */
	public Capture capture(String accessToken, Capture capture) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return capture(apiContext, capture);
	}

	/**
	 * Captures and processes an authorization, by ID. To use this call, the original payment call must specify an intent of `authorize`.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @param capture
	 * Capture
	 * @return Capture
	 * @throws PayPalRESTException
	 */
	public Capture capture(APIContext apiContext, Capture capture) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		if (capture == null) {
			throw new IllegalArgumentException("capture cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/payments/authorization/{0}/capture";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = capture.toJSON();
		return configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Capture.class);
	}

	/**
	 * Voids, or cancels, an authorization, by ID. You cannot void a fully captured authorization.
	 * @deprecated Please use {@link #doVoid(APIContext)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @return Authorization
	 * @throws PayPalRESTException
	 */
	public Authorization doVoid(String accessToken) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return doVoid(apiContext);
	}

	/**
	 * Voids, or cancels, an authorization, by ID. You cannot void a fully captured authorization.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @return Authorization
	 * @throws PayPalRESTException
	 */
	public Authorization doVoid(APIContext apiContext) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/payments/authorization/{0}/void";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = "";
		return configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Authorization.class);
	}

	/**
	 * Reauthorizes a PayPal account payment, by authorization ID. To ensure that funds are still available, reauthorize a payment after the initial three-day honor period. Supports only the `amount` request parameter.
	 * @deprecated Please use {@link #reauthorize(APIContext)} instead.
	 * @param accessToken
	 * Access Token used for the API call.
	 * @return Authorization
	 * @throws PayPalRESTException
	 */
	public Authorization reauthorize(String accessToken) throws PayPalRESTException {
		APIContext apiContext = new APIContext(accessToken);
		return reauthorize(apiContext);
	}

	/**
	 * Reauthorizes a PayPal account payment, by authorization ID. To ensure that funds are still available, reauthorize a payment after the initial three-day honor period. Supports only the `amount` request parameter.
	 * @param apiContext
	 * {@link APIContext} used for the API call.
	 * @return Authorization
	 * @throws PayPalRESTException
	 */
	public Authorization reauthorize(APIContext apiContext) throws PayPalRESTException {
		if (this.getId() == null) {
			throw new IllegalArgumentException("Id cannot be null");
		}
		Object[] parameters = new Object[] {this.getId()};
		String pattern = "v1/payments/authorization/{0}/reauthorize";
		String resourcePath = RESTUtil.formatURIPath(pattern, parameters);
		String payLoad = this.toJSON();
		return configureAndExecute(apiContext, HttpMethod.POST, resourcePath, payLoad, Authorization.class);
	}

	/**
	 * ID of the authorization transaction.
	 */
	@java.lang.SuppressWarnings("all")
	public String getId() {
		return this.id;
	}

	/**
	 * Amount being authorized.
	 */
	@java.lang.SuppressWarnings("all")
	public Amount getAmount() {
		return this.amount;
	}

	/**
	 * Specifies the payment mode of the transaction.
	 */
	@java.lang.SuppressWarnings("all")
	public String getPaymentMode() {
		return this.paymentMode;
	}

	/**
	 * State of the authorization.
	 */
	@java.lang.SuppressWarnings("all")
	public String getState() {
		return this.state;
	}

	/**
	 * Reason code, `AUTHORIZATION`, for a transaction state of `pending`.
	 */
	@java.lang.SuppressWarnings("all")
	public String getReasonCode() {
		return this.reasonCode;
	}

	/**
	 * [DEPRECATED] Reason code for the transaction state being Pending.Obsolete. use reason_code field instead.
	 */
	@java.lang.SuppressWarnings("all")
	public String getPendingReason() {
		return this.pendingReason;
	}

	/**
	 * The level of seller protection in force for the transaction. Only supported when the `payment_method` is set to `paypal`. Allowed values:<br>  `ELIGIBLE`- Merchant is protected by PayPal's Seller Protection Policy for Unauthorized Payments and Item Not Received.<br> `PARTIALLY_ELIGIBLE`- Merchant is protected by PayPal's Seller Protection Policy for Item Not Received or Unauthorized Payments. Refer to `protection_eligibility_type` for specifics. <br> `INELIGIBLE`- Merchant is not protected under the Seller Protection Policy.
	 */
	@java.lang.SuppressWarnings("all")
	public String getProtectionEligibility() {
		return this.protectionEligibility;
	}

	/**
	 * The kind of seller protection in force for the transaction. This property is returned only when the `protection_eligibility` property is set to `ELIGIBLE`or `PARTIALLY_ELIGIBLE`. Only supported when the `payment_method` is set to `paypal`. Allowed values:<br> `ITEM_NOT_RECEIVED_ELIGIBLE`- Sellers are protected against claims for items not received.<br> `UNAUTHORIZED_PAYMENT_ELIGIBLE`- Sellers are protected against claims for unauthorized payments.<br> One or both of the allowed values can be returned.
	 */
	@java.lang.SuppressWarnings("all")
	public String getProtectionEligibilityType() {
		return this.protectionEligibilityType;
	}

	/**
	 * Fraud Management Filter (FMF) details applied for the payment that could result in accept, deny, or pending action. Returned in a payment response only if the merchant has enabled FMF in the profile settings and one of the fraud filters was triggered based on those settings. See [Fraud Management Filters Summary](https://developer.paypal.com/docs/classic/fmf/integration-guide/FMFSummary/) for more information.
	 */
	@java.lang.SuppressWarnings("all")
	public FmfDetails getFmfDetails() {
		return this.fmfDetails;
	}

	/**
	 * ID of the Payment resource that this transaction is based on.
	 */
	@java.lang.SuppressWarnings("all")
	public String getParentPayment() {
		return this.parentPayment;
	}

	/**
	 * Authorization expiration time and date as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6).
	 */
	@java.lang.SuppressWarnings("all")
	public String getValidUntil() {
		return this.validUntil;
	}

	/**
	 * Time of authorization as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6).
	 */
	@java.lang.SuppressWarnings("all")
	public String getCreateTime() {
		return this.createTime;
	}

	/**
	 * Time that the resource was last updated.
	 */
	@java.lang.SuppressWarnings("all")
	public String getUpdateTime() {
		return this.updateTime;
	}

	/**
	 * Identifier to the purchase or transaction unit corresponding to this authorization transaction.
	 */
	@java.lang.SuppressWarnings("all")
	public String getReferenceId() {
		return this.referenceId;
	}

	/**
	 * Receipt id is 16 digit number payment identification number returned for guest users to identify the payment.
	 */
	@java.lang.SuppressWarnings("all")
	public String getReceiptId() {
		return this.receiptId;
	}

	/**
	 */
	@java.lang.SuppressWarnings("all")
	public List<Links> getLinks() {
		return this.links;
	}

	/**
	 * ID of the authorization transaction.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setId(final String id) {
		this.id = id;
		return this;
	}

	/**
	 * Amount being authorized.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setAmount(final Amount amount) {
		this.amount = amount;
		return this;
	}

	/**
	 * Specifies the payment mode of the transaction.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setPaymentMode(final String paymentMode) {
		this.paymentMode = paymentMode;
		return this;
	}

	/**
	 * State of the authorization.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setState(final String state) {
		this.state = state;
		return this;
	}

	/**
	 * Reason code, `AUTHORIZATION`, for a transaction state of `pending`.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setReasonCode(final String reasonCode) {
		this.reasonCode = reasonCode;
		return this;
	}

	/**
	 * [DEPRECATED] Reason code for the transaction state being Pending.Obsolete. use reason_code field instead.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setPendingReason(final String pendingReason) {
		this.pendingReason = pendingReason;
		return this;
	}

	/**
	 * The level of seller protection in force for the transaction. Only supported when the `payment_method` is set to `paypal`. Allowed values:<br>  `ELIGIBLE`- Merchant is protected by PayPal's Seller Protection Policy for Unauthorized Payments and Item Not Received.<br> `PARTIALLY_ELIGIBLE`- Merchant is protected by PayPal's Seller Protection Policy for Item Not Received or Unauthorized Payments. Refer to `protection_eligibility_type` for specifics. <br> `INELIGIBLE`- Merchant is not protected under the Seller Protection Policy.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setProtectionEligibility(final String protectionEligibility) {
		this.protectionEligibility = protectionEligibility;
		return this;
	}

	/**
	 * The kind of seller protection in force for the transaction. This property is returned only when the `protection_eligibility` property is set to `ELIGIBLE`or `PARTIALLY_ELIGIBLE`. Only supported when the `payment_method` is set to `paypal`. Allowed values:<br> `ITEM_NOT_RECEIVED_ELIGIBLE`- Sellers are protected against claims for items not received.<br> `UNAUTHORIZED_PAYMENT_ELIGIBLE`- Sellers are protected against claims for unauthorized payments.<br> One or both of the allowed values can be returned.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setProtectionEligibilityType(final String protectionEligibilityType) {
		this.protectionEligibilityType = protectionEligibilityType;
		return this;
	}

	/**
	 * Fraud Management Filter (FMF) details applied for the payment that could result in accept, deny, or pending action. Returned in a payment response only if the merchant has enabled FMF in the profile settings and one of the fraud filters was triggered based on those settings. See [Fraud Management Filters Summary](https://developer.paypal.com/docs/classic/fmf/integration-guide/FMFSummary/) for more information.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setFmfDetails(final FmfDetails fmfDetails) {
		this.fmfDetails = fmfDetails;
		return this;
	}

	/**
	 * ID of the Payment resource that this transaction is based on.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setParentPayment(final String parentPayment) {
		this.parentPayment = parentPayment;
		return this;
	}

	/**
	 * Authorization expiration time and date as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6).
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setValidUntil(final String validUntil) {
		this.validUntil = validUntil;
		return this;
	}

	/**
	 * Time of authorization as defined in [RFC 3339 Section 5.6](http://tools.ietf.org/html/rfc3339#section-5.6).
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setCreateTime(final String createTime) {
		this.createTime = createTime;
		return this;
	}

	/**
	 * Time that the resource was last updated.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setUpdateTime(final String updateTime) {
		this.updateTime = updateTime;
		return this;
	}

	/**
	 * Identifier to the purchase or transaction unit corresponding to this authorization transaction.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setReferenceId(final String referenceId) {
		this.referenceId = referenceId;
		return this;
	}

	/**
	 * Receipt id is 16 digit number payment identification number returned for guest users to identify the payment.
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setReceiptId(final String receiptId) {
		this.receiptId = receiptId;
		return this;
	}

	/**
	 *
	 * @return this
	 */
	@java.lang.SuppressWarnings("all")
	public Authorization setLinks(final List<Links> links) {
		this.links = links;
		return this;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public boolean equals(final java.lang.Object o) {
		if (o == this) return true;
		if (!(o instanceof Authorization)) return false;
		final Authorization other = (Authorization) o;
		if (!other.canEqual((java.lang.Object) this)) return false;
		if (!super.equals(o)) return false;
		final java.lang.Object this$id = this.getId();
		final java.lang.Object other$id = other.getId();
		if (this$id == null ? other$id != null : !this$id.equals(other$id)) return false;
		final java.lang.Object this$amount = this.getAmount();
		final java.lang.Object other$amount = other.getAmount();
		if (this$amount == null ? other$amount != null : !this$amount.equals(other$amount)) return false;
		final java.lang.Object this$paymentMode = this.getPaymentMode();
		final java.lang.Object other$paymentMode = other.getPaymentMode();
		if (this$paymentMode == null ? other$paymentMode != null : !this$paymentMode.equals(other$paymentMode)) return false;
		final java.lang.Object this$state = this.getState();
		final java.lang.Object other$state = other.getState();
		if (this$state == null ? other$state != null : !this$state.equals(other$state)) return false;
		final java.lang.Object this$reasonCode = this.getReasonCode();
		final java.lang.Object other$reasonCode = other.getReasonCode();
		if (this$reasonCode == null ? other$reasonCode != null : !this$reasonCode.equals(other$reasonCode)) return false;
		final java.lang.Object this$pendingReason = this.getPendingReason();
		final java.lang.Object other$pendingReason = other.getPendingReason();
		if (this$pendingReason == null ? other$pendingReason != null : !this$pendingReason.equals(other$pendingReason)) return false;
		final java.lang.Object this$protectionEligibility = this.getProtectionEligibility();
		final java.lang.Object other$protectionEligibility = other.getProtectionEligibility();
		if (this$protectionEligibility == null ? other$protectionEligibility != null : !this$protectionEligibility.equals(other$protectionEligibility)) return false;
		final java.lang.Object this$protectionEligibilityType = this.getProtectionEligibilityType();
		final java.lang.Object other$protectionEligibilityType = other.getProtectionEligibilityType();
		if (this$protectionEligibilityType == null ? other$protectionEligibilityType != null : !this$protectionEligibilityType.equals(other$protectionEligibilityType)) return false;
		final java.lang.Object this$fmfDetails = this.getFmfDetails();
		final java.lang.Object other$fmfDetails = other.getFmfDetails();
		if (this$fmfDetails == null ? other$fmfDetails != null : !this$fmfDetails.equals(other$fmfDetails)) return false;
		final java.lang.Object this$parentPayment = this.getParentPayment();
		final java.lang.Object other$parentPayment = other.getParentPayment();
		if (this$parentPayment == null ? other$parentPayment != null : !this$parentPayment.equals(other$parentPayment)) return false;
		final java.lang.Object this$validUntil = this.getValidUntil();
		final java.lang.Object other$validUntil = other.getValidUntil();
		if (this$validUntil == null ? other$validUntil != null : !this$validUntil.equals(other$validUntil)) return false;
		final java.lang.Object this$createTime = this.getCreateTime();
		final java.lang.Object other$createTime = other.getCreateTime();
		if (this$createTime == null ? other$createTime != null : !this$createTime.equals(other$createTime)) return false;
		final java.lang.Object this$updateTime = this.getUpdateTime();
		final java.lang.Object other$updateTime = other.getUpdateTime();
		if (this$updateTime == null ? other$updateTime != null : !this$updateTime.equals(other$updateTime)) return false;
		final java.lang.Object this$referenceId = this.getReferenceId();
		final java.lang.Object other$referenceId = other.getReferenceId();
		if (this$referenceId == null ? other$referenceId != null : !this$referenceId.equals(other$referenceId)) return false;
		final java.lang.Object this$receiptId = this.getReceiptId();
		final java.lang.Object other$receiptId = other.getReceiptId();
		if (this$receiptId == null ? other$receiptId != null : !this$receiptId.equals(other$receiptId)) return false;
		final java.lang.Object this$links = this.getLinks();
		final java.lang.Object other$links = other.getLinks();
		if (this$links == null ? other$links != null : !this$links.equals(other$links)) return false;
		return true;
	}

	@java.lang.SuppressWarnings("all")
	protected boolean canEqual(final java.lang.Object other) {
		return other instanceof Authorization;
	}

	@java.lang.Override
	@java.lang.SuppressWarnings("all")
	public int hashCode() {
		final int PRIME = 59;
		int result = 1;
		result = result * PRIME + super.hashCode();
		final java.lang.Object $id = this.getId();
		result = result * PRIME + ($id == null ? 43 : $id.hashCode());
		final java.lang.Object $amount = this.getAmount();
		result = result * PRIME + ($amount == null ? 43 : $amount.hashCode());
		final java.lang.Object $paymentMode = this.getPaymentMode();
		result = result * PRIME + ($paymentMode == null ? 43 : $paymentMode.hashCode());
		final java.lang.Object $state = this.getState();
		result = result * PRIME + ($state == null ? 43 : $state.hashCode());
		final java.lang.Object $reasonCode = this.getReasonCode();
		result = result * PRIME + ($reasonCode == null ? 43 : $reasonCode.hashCode());
		final java.lang.Object $pendingReason = this.getPendingReason();
		result = result * PRIME + ($pendingReason == null ? 43 : $pendingReason.hashCode());
		final java.lang.Object $protectionEligibility = this.getProtectionEligibility();
		result = result * PRIME + ($protectionEligibility == null ? 43 : $protectionEligibility.hashCode());
		final java.lang.Object $protectionEligibilityType = this.getProtectionEligibilityType();
		result = result * PRIME + ($protectionEligibilityType == null ? 43 : $protectionEligibilityType.hashCode());
		final java.lang.Object $fmfDetails = this.getFmfDetails();
		result = result * PRIME + ($fmfDetails == null ? 43 : $fmfDetails.hashCode());
		final java.lang.Object $parentPayment = this.getParentPayment();
		result = result * PRIME + ($parentPayment == null ? 43 : $parentPayment.hashCode());
		final java.lang.Object $validUntil = this.getValidUntil();
		result = result * PRIME + ($validUntil == null ? 43 : $validUntil.hashCode());
		final java.lang.Object $createTime = this.getCreateTime();
		result = result * PRIME + ($createTime == null ? 43 : $createTime.hashCode());
		final java.lang.Object $updateTime = this.getUpdateTime();
		result = result * PRIME + ($updateTime == null ? 43 : $updateTime.hashCode());
		final java.lang.Object $referenceId = this.getReferenceId();
		result = result * PRIME + ($referenceId == null ? 43 : $referenceId.hashCode());
		final java.lang.Object $receiptId = this.getReceiptId();
		result = result * PRIME + ($receiptId == null ? 43 : $receiptId.hashCode());
		final java.lang.Object $links = this.getLinks();
		result = result * PRIME + ($links == null ? 43 : $links.hashCode());
		return result;
	}
}
